import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { AppService } from '../shared/service/AppService.class';
import { environment } from 'src/environments/environment';
import { AnyARecord } from 'node:dns';
@Injectable({
  providedIn: 'root'
})
export class SubscriptionService extends AppService<any> {

  constructor(public http: HttpClient) { super(http) }

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });
  get_Subscription(): Observable<any> {
    return this.http.get('./assets/subscription.json')
  }

  @LoaderEnabled()
  get_Subscriptiondata(): Observable<any> {
    this.appmod = 'suscription'
    let result = super.getService()
    this.appmod = '';
    return result;
  }
  
 
  @LoaderEnabled()
  getUserSubscription(): Observable<any> {
    this.appmod = 'getsubscriptionuser'
    let result = super.getService()
    this.appmod = '';
    return result;
  }
  getSubsriptionterrif(): Observable<any> {
    this.appmod = 'getSubsriptionterriff'
    let result = super.getService()
    this.appmod = '';
    return result;
  }
  @LoaderEnabled()
  save_Subscription(data: any): Observable<any> {
    this.appmod = 'savesuscription'
    let result = super.saveService(data)
    this.appmod = '';
    return result;
  }

  @LoaderEnabled()
  editSubscription(data: any, id: any): Observable<any> {
    this.appmod = 'updatescription';
    let result = super.saveService(data, id);
    this.appmod = '';
    return result;
  }
  @LoaderEnabled()
  deleteSubscription(id: any): Observable<any> {
    this.appmod = 'deletesuscription';
    let result = super.updateService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyFilter(data?: any): Observable<any> {
    this.appmod = "getfiltersubscription";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  savesubscriptioncontrol(data?: any): Observable<any> {
    this.appmod = "savesuscriptioncontrol";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  updatesubscriptioncontrol(data?: any): Observable<any> {
    this.appmod = "updatesuscriptioncontrol";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }


  @LoaderEnabled()
  get_Subscriptionlist(): Observable<any> {
    this.appmod = 'suscriptioncontrol'
    let result = super.getService();
    this.appmod = '';
    return result;
  }

  @LoaderEnabled()
  SubscriptionControlById(data): Observable<any> {
    this.appmod = 'SubscriptionControlbyId'
    let result = super.getService(data);
    this.appmod = '';
    return result;
  }

  @LoaderEnabled()
  UpdateSubscriptionmap(data: any): Observable<any> {
    this.appmod = "updatesuscriptioncontrol";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

get_terrifmap() : Observable<any>{
this.appmod = 'getmappingcontrol'
let result = super.getService();
this.appmod = '';
return result;
}



getSubscriptionconnection(data): Observable<any> {
  this.appmod = 'getSubsriptionmappedbyidacc';
  let result = super.getService(data);
  this.appmod = '';
  return result;
}


getSubscription(data:any): Observable<any> {
  this.appmod = "getsubscriptiononid";
  let result = super.getService(data);
  this.appmod = "";
  return result;
}

@LoaderEnabled()
getsubscriptionbalance(data:any): Observable<any> {
  this.appmod = "checkBalanceforSubscription";
  let result = super.saveService(data);
  this.appmod = '';
  return result;
} 

proratecalculator(): Observable<any> {
  this.appmod = "proratecalculator";
  let result = super.getService();
  this.appmod = "";
  return result;
}
gettsPair(): Observable<any> {
  this.appmod = "gettsPair";
  let result = super.getService();
  this.appmod = "";
  return result;
}
}
