import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { UsermanagementService } from '../usermanagement.service';
import { MatDialog } from '@angular/material/dialog';
import { BillingService } from 'src/app/billing/billing.service';
import { ProfileService } from 'src/app/profile/profile.service';
import { SubscriptionService } from 'src/app/subscription/subscription.service';
import { BalanceComponent } from '../profile/balance/balance.component';

@Component({
  selector: 'app-account-action',
  templateUrl: './account-action.component.html',
  styleUrls: ['./account-action.component.css']
})
export class AccountActionComponent implements OnInit {
  userData: any;
  sesiduser: any;
  idaccount: any;
  iduser: any;
  userType: string;
  kyc_status: any;
  kyc_color: any;
  federal_status: any ="";
  federal_color: any ="";
  sessionType: any;
  newUserStatus: any;
  disabled: boolean = false;

  HideUserNonUs: boolean = false;
  Usercountrycode: any;
  showfedral: boolean = false;

  userdata: any;
  userinfo: any;
  selectedPlan: string | null = null;
  public userlist: any;
  public username: string;
  public email: any;
  san: any;
  profile_pic: any;
  billingAddress: any;
  balanceData: any;
  balance: any;
  responseMessage: any = "";
  errMessage: any = "";
  balancestatus: boolean = false;
  subscription: any = [];
  subscriptionamount: any;
  subscriptionPaymentStatus: boolean = false;
  viaonboarding:any;
  logdata:any=[];
  
  constructor(protected userSerive: UsermanagementService, private router: Router, protected billingService: BillingService, protected data: ProfileService, public dialog: MatDialog,
    protected subscriptionegment: SubscriptionService) { }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.sessionType = this.sesiduser.type;
    this.newUserStatus = this.sesiduser.newUser_status;
    this.viaonboarding=Number(sessionStorage.getItem('viaonboarding'))
    
    if(this.sesiduser.newUser_status==0)
    {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    if(this.sesiduser.newUser_status==1)
    {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true" && this.sesiduser.isCard == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    // code .......
    // this.subscriptionegment.get_terrifmap().subscribe((res) => {
    //   this.subscription = res.data;
    //   if(this.subscription && this.subscription.length>0){
    //     this.subscriptionamount = this.subscription.reduce((total, item) => {
    //       return total + (item.mrc * item.account_quantity);
    //     }, 0);
    //   }else{
    //     this.subscriptionegment.getUserSubscription().subscribe((res)=>{
    //       this.subscription = res.data;
    //       this.subscriptionamount = this.subscription.reduce((total, item) => {
    //         return total + (item.mrc * item.account_quantity);
    //       }, 0);
    //     })
    //   }
    // });
    this.subscriptionegment.get_terrifmap().subscribe((res) => {
      this.subscription = res.data;
      if(this.subscription && this.subscription.length>0){
      }else{
        this.subscriptionegment.getUserSubscription().subscribe((res)=>{
          this.subscription = res.data;
        })
      }
      this.billingService.proratecalculatoronbord1().subscribe((res)=>{
        this.subscriptionamount=res.data
        this.logdata=res.log
      })
    });
        

    this.data.getUsers("detail").subscribe(res => {
      if (res.data.length > 0) {
        this.userlist = res.data[0];
        this.username = this.userlist[0].user_name;
        const paymentStatus = Number(this.userlist[0].subscription_payment);
        if (paymentStatus == 1) {
          this.subscriptionPaymentStatus = true;
        } else {
          this.subscriptionPaymentStatus = false;
        }
        this.san = this.userlist[0].san;
        this.email = this.userlist[0].email;
        this.profile_pic = this.userlist[0].profile_pic;
        if (this.profile_pic == undefined) {
          this.profile_pic = './assets/img/profile.jpg';
        }
      }
    }, error => {
      console.log(error.message);
    });

    this.billingService.getBalance().subscribe(res => {
      if (res.data.length > 0) {
        this.balance = res.data[0].balance;
        
        this.balanceData = res.data[0];
        if (this.balance <= 0) {
          this.balancestatus = true;
        } else {
          this.balancestatus = false;
        }

        if (!this.balance) {
          this.balance = 0;
        }
        if (this.balance < this.balanceData.min_balance) {

        }

      }
      else {
        this.balance = 0;
      }

    });

    this.billingService.getBillingAddress().subscribe(res => {
      this.billingAddress = res.data;
    });

    this.getUserDetail();

   
    
  }
  getUserDetail(){
    this.userSerive.getSingleUsers().subscribe(res => {
      // To KYC Status
      this.kyc_status = res.data1[0].kyc_verify_status; 
      this.newUserStatus = res.data1[0].newUser_status; 
      const country = this.sesiduser.country || sessionStorage.getItem("country");
      /* if (this.sesiduser.type === 2 && ['US', 'CA', 'USA', 'United States', 'Canada', 'United States '].includes(country.trim())) {
        this.showfedral = true;
        this.HideUserNonUs = true;
      } else {
        this.HideUserNonUs = false;
        if (this.sesiduser.type === 2 && this.kyc_status!== 1) {
          this.showfedral = false;
        }else{
          this.showfedral = true;
        }
      } */
      if (this.sesiduser.type == 2 && ['US', 'CA', 'USA', 'United States', 'Canada', 'United States'].includes(country.trim())) {
        this.showfedral = true;
        this.HideUserNonUs = true;
      } else {
        this.HideUserNonUs = false;
        if (this.sesiduser.type == 2) {
          if (this.newUserStatus == 1 && this.kyc_status !== 1) {
            this.showfedral = false;
          } else {
            this.showfedral = true;
          }
        }
      }
      switch(this.kyc_status){
        case 0 : this.kyc_status = "Unverified"; this.kyc_color ="rgb(236 41 52)"; break;
        case 1 : this.kyc_status = "Verified"; this.kyc_color ="#2aab5b"; break;
        case 2 : this.kyc_status = "Verification Pending"; this.kyc_color ="#e6b125"; break;
        case 3 : this.kyc_status = "Reject"; this.kyc_color ="rgb(236 41 52)"; break;
        case 4 : this.kyc_status = "Cancel"; this.kyc_color ="rgb(236 41 52)"; break;
      }

      // To Federal Status
      this.federal_status = res.data1[0].federal_status;
      switch(this.federal_status){
        case 0 : this.federal_status = "Inactive"; this.federal_color ="rgb(236 41 52)"; break;
        case 1 : this.federal_status = "Active"; this.federal_color ="#2aab5b"; break;
        case 2 : this.federal_status = "Pending to Active"; this.federal_color ="#e6b125"; break;
        case 3 : this.federal_status = "Reject"; this.federal_color ="rgb(236 41 52)"; break;
        case 4 : this.federal_status = "Cancel"; this.federal_color ="rgb(236 41 52)"; break;

      }
    })
  }
  kycForm(): void {
    this.router.navigate(['/kyc/kyc']); 
  }
  FederalForm(): void {
    this.router.navigate(['/federal/federal']); 
  }

  makePayment(type:any) {
    let balance = ''
    if(type=='subscharge'){
      balance = this.subscriptionamount
    }
    let payLoad: any={
      type:type,
      balance:balance,
      loginfo:this.logdata
    }
    const dialogRef = this.dialog.open(BalanceComponent, {
      data: { balance: this.balanceData, userProfile: this.userlist, address: this.billingAddress,payLoad },
      disableClose: true
    });
    dialogRef.componentInstance.submitClicked.subscribe(result => {
      this.errMessage = result;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
    dialogRef.afterClosed().subscribe(result => {
      if (result.reload) {
        this.disabled = false;
        window.location.reload();
        this.responseMessage = result.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
  payment(type: any) {
      const payload = {
        amount: this.subscriptionamount,
        type: 'subscharge',
        idaccount: this.idaccount,
        iduser: this.iduser,
        loginfo:this.logdata
      };
      this.billingService.paysubscription(JSON.stringify(payload)).subscribe((res) => {
        if(res.status==200){
          this.responseMessage=res.message
          setTimeout(() => {
            this.responseMessage = "";
            window.location.reload();
          }, 3000);
        }
       else if (res.status== 502) {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
          this.makePayment(type); 
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
       
        }
      });
    // }
  }

}
