import { Component, OnInit } from '@angular/core';
import { UsermanagementService } from '../usermanagement.service';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup, FormControl, Validators, FormArray } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { itegratedsolutions, intgratedsolutionsForm } from '../user.class';
import { Base64 } from 'js-base64';
import { MatDialog } from '@angular/material/dialog';
import { AddParamsComponent } from '../usermanagement/addparams/addparams.component';

@Component({
	selector: 'app-itegratedsolutions',
	templateUrl: './itegratedsolutions.component.html',
	styleUrls: ['./itegratedsolutions.component.css']
})


export class ItegratedsolutionsComponent extends AppComponentClass<any, any> {

	p: number = 1;
	rowdata: any;
	listdata: any;
	modelform: FormGroup;
	public show: boolean = false;
	public buttonName: any = "Add";
	public intgratedsolutionsForm: FormGroup;
	public submitted: boolean = false;
	public loadfrm: boolean = false;
	filterTerm: string
	gToken: string = "";
	userType: any;
	enable: boolean = false;

	constructor(public data: UsermanagementService, public router: Router, public fb: FormBuilder, public dialog: MatDialog) {
		super(data, router, fb);
	}

	//console.log(localStorage.getItem('type')) ;


	ngOnInit(): void {

		this.data.solution.subscribe(res => {
			if (res != null) {
				this.cdata = new intgratedsolutionsForm(res);
				this.keyfield = res.id;
				this.intgratedsolutionsForm = this.cdata.makeform(this.fb);
			} else {
				this.cdata = new intgratedsolutionsForm(null);
				this.keyfield = -1;
				this.intgratedsolutionsForm = this.cdata.makeform(this.fb);
			}
		});

		this.data.getintegrated().subscribe((result) => {
			this.listdata = result;
		});

		this.data.getintegratedAPI().subscribe(res => {
			this.rowdata = res;
			let frm = {};
			res.forEach(element => {
				element.data.forEach(ele => {
					frm[ele.formControl] = [];
				});
			});

			this.modelform = this.fb.group(frm);
			this.loadfrm = true;
		})
	}

	getEncodedToken(token: string) {
		this.gToken = Base64.encode(token);
	}

	// @to save/update form data
	onSubmit() {
		this.userType = sessionStorage.getItem('type');
		this.submitted = true;

		if (this.intgratedsolutionsForm.invalid) {
			return false;
		} else {
			if (this.cdata.saveForm(this.intgratedsolutionsForm)) {
				this.cdata['supplierid'] = this.userType;
				this.data.api(this.cdata).subscribe(res => {
				}, error => {
					console.log(error);
				});

				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						this.ngOnInit();
					});
				}
			}
		}
	}

	onChange(event) {
		if (event.target.checked) {
			this.enable = true;
		}
		else {
			this.enable = false;
		}
	}

	addSetting(type) {
		let tmp: any = sessionStorage.getItem("isLoggedIn");
		tmp = JSON.parse(tmp);
		const dialogRef = this.dialog.open(AddParamsComponent, {
			width: '600px', disableClose: true,
			data: { iduser: tmp.iduser, type: type, idaccount: tmp.account, dialogtype: 1, savetype: 1 }
		});
	}
}