import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { MatDialog } from '@angular/material/dialog';
import { UsermanagementService } from '../usermanagement.service';
import { Router } from '@angular/router';
import { AbstractControl, FormBuilder, FormControl, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { TariffService } from 'src/app/tariff/tariff.service';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;
@Component({
  selector: 'app-pending-to-release',
  templateUrl: './pending-to-release.component.html',
  styleUrls: ['./pending-to-release.component.css']
})
export class PendingToReleaseComponent implements OnInit {
  @ViewChild('closeModal') closeModal: ElementRef
  @ViewChild('deletModal') deletModal: ElementRef
  userlistheader: any;
  userlist: any;
  PendingTodeleteUsers: any[];
  countUser: any;
  user_id: any;
  account_id: any;
  userlength: any;
  subCustomer: any;
  dids: any[];
  filterForm: any;
  campaigns: any;
  errMessage: any;
  balance: any;
  planname: string;
  ismonthly: boolean;
  price: string;
  checkdelete: boolean = false;
  sesiduser: any;
  data1: any;
  active = {
    style1: "cursor: pointer;",
    style2: "cursor: pointer;",
    style3: "cursor: pointer;",
  }
  returnsms: boolean;
  responseMessage: any;
  subuserlistheader: any;
  tmplist: any;
  invoicePdfDetails: any =[];
  pdfAvailable: boolean = true;
  showFilter: boolean = false;
  filterUser: FormGroup;
  preferenceServices: any = [];
  regTariffs: any = [];
  public submitted: boolean = false;
  public buttonName: any = "Add";
  backupPending:any = [];
  dropdownSetting: IDropdownSettings = {};
	dropdownSetting1: IDropdownSettings = {};
	dropdownSetting2: IDropdownSettings = {};
	closeDropdownSelection = true;
  constructor(

    public data: UsermanagementService, public router: Router,
    public dialog: MatDialog, private tariffService: TariffService, private route: ActivatedRoute,
    public fb: FormBuilder
  ) {
  }

  ngOnInit(): void {

    this.data.getuserheader().subscribe((result) => {
      this.userlistheader = result.PendingToReleaseHeader;
    });

    this.data.getInvoicePdfData().subscribe((res) => {
      this.invoicePdfDetails = res.data;
		})
    this.GetUsers()

    this.data.getuserheader().subscribe((result) => {
      this.subuserlistheader = result.headers_sub_details1;
    });
    this.filterUser = this.fb.group({
			to_date: [''],
			from_date: [''],
			service: [''],
			regTariff: [''],
			idaccount: [''],
			onboarding :['']
		});
    this.dropdownSetting = {
			singleSelection: true,
			idField: 'userdata',
			textField: 'reloaduserlist',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		  };

		this.dropdownSetting1 = {
			singleSelection: true,
			idField: 'regid',
			textField: 'regTariffs',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		  };

		this.dropdownSetting2 = {
			singleSelection: true,
			idField: 'preferid',
			textField: 'preferenceServices',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		  };

    this.tariffService.getPreferenceService().subscribe(res => {
			this.preferenceServices = res.data;
      this.preferenceServices = res.data.map(item => ({
				preferid: item.idservice,
				preferenceServices: `${item.name}`
			  }));
		}, err => {
			console.log(err.message);
		});

		// Get tariffs
		this.tariffService.getTariffs().subscribe(res => {
			this.regTariffs = res.data;
      this.regTariffs = res.data.map(item => ({
        regid: item.idtariff,
        regTariffs: `${item.name}`
        }));
		}, err => {
			console.log(err.message);
		});
  }
  // calledUsermanagement(){
  //   this.GetUsers();
  //   return;
  // }

  GetUsers(): void {
    this.data.getUsers("main").subscribe(res => {
      $('#basic-datatableuser').dataTable().fnClearTable();
      $('#basic-datatableuser').dataTable().fnDraw();
      $('#basic-datatableuser').dataTable().fnDestroy();
      this.userlist = res.data[0];
      this.PendingTodeleteUsers = [];
      this.userlist.forEach(element => {
        if (element.is_deleted == 1) {
          this.PendingTodeleteUsers.push(element);
          this.backupPending = this.PendingTodeleteUsers;
          this.backupPending = this.backupPending.map(item => ({
            userdata: item.idaccount,
            reloaduserlist: `${item.san} - ${item.first_name} ${item.last_name}`
            })).sort((a, b) => a.reloaduserlist.localeCompare(b.reloaduserlist));

          let invoicePDF = this.invoicePdfDetails.find(i => i.idaccount == element.idaccount);
          if(invoicePDF!=undefined)
          {
            element.invoice_pdf=invoicePDF.path
          }
          else{
            element.invoice_pdf =''
          }
        }
      });
      $.getScript('./assets/tollfree.js');
      this.countUser = res.data[0];
    });
  }

  showAllCampData(idaccount, iduser) {
    this.campaigns = '';
    let payLoad = JSON.stringify({
      idaccount: idaccount,
      iduser: iduser
    })

    this.data.getCampaignForReview(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.campaigns = result.data.length;
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  getSubscriptionPlan(idaccount, iduser) {
    this.planname = '';
    let payLoad = JSON.stringify({
      idaccount: idaccount,
      iduser: iduser
    })
    this.data.getSubscriptionPlan(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.tmplist = result.data[0];
        if (this.tmplist != undefined) {
          switch (this.tmplist.idtariff) {
            case 142:
            case "142":
              {
                this.planname = "LAUNCH PLAN";
                this.price = "Pay As You Go"
              }
              break;
            case 143:
            case "143":
              {
                this.planname = "GROWTH PLAN";
                this.price = "99";
                this.ismonthly = true;
              }
              break;
            case 145:
            case "145":
              {
                this.planname = "SCALE PLAN";
                this.price = "2499";
                this.ismonthly = true;
              }
              break;
            default:
              this.planname = "CUSTOM PLAN";
              break;
          }
        }

      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  showUserdata(idaccount, iduser) {
    this.checkdelete=false
    this.user_id = iduser;
    this.account_id = idaccount;
    this.dids = [];
    this.balance = '';
    this.userlength = '';

    this.filterForm = this.fb.group({
      selectedUser: this.user_id + '-' + this.account_id
    });
    this.dids[0] = 'comming...';
    this.data.custDidsCount(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        this.dids = res.data.length;
      }
    });

    this.data.getSubListUsers({ idaccount: idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
      this.userlist = result.data[0];
      this.userlength = result.data[0].length;
      this.subCustomer = result.data[0];
      $('#basic-datatables').dataTable().fnClearTable();
      $('#basic-datatables').dataTable().fnDraw();
      $('#basic-datatables').dataTable().fnDestroy();
      $.getScript('./assets/table.js');
    }, err => {
      console.log(err.message);
    });

    // this.data.getCampaign({ idaccount: idaccount, iduser: iduser }).subscribe((result: any) => {


    //   this.campaigns=result.data.length; 
    // })

    this.showAllCampData(idaccount, iduser)
    this.getSubscriptionPlan(idaccount, iduser)

    this.data.getcustBalance({ idaccount: idaccount, iduser: iduser }).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.balance = response.data[0].balance;
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  callCheck() {
    this.returnsms = false;
  }

  resetCheckbox() {
    this.checkdelete = false;
  }

  setOnYes(idaccount, iduser,invoicePdf){
    this.checkdelete = false;
    this.user_id = iduser;
    this.account_id = idaccount;
    this.invoicePdfDetails = invoicePdf;
    this.pdfAvailable = this.invoicePdfDetails != null && this.invoicePdfDetails !== undefined && this.invoicePdfDetails !== '';
  }
  onYes() {
    this.data1 = {
      sesiduser: this.user_id,
      sesidaccount: this.account_id,
      isDeleted: 2,
      checkvalue : this.checkdelete
    }
    if (!this.data1.sesiduser || !this.data1.isDeleted) {
      this.returnsms = true;
      return;
    }
    else {
      this.data.onFinalDeleteAccount(this.data1).subscribe((res) => { 
        if (res.status == 201) {
          this.GetUsers();
          this.closeModal.nativeElement.click();
          this.responseMessage = "You have successfully deleted this account!";
          window.location.reload();
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else{
          this.errMessage = res.message;
          this.checkdelete = false;
          this.closeModal.nativeElement.click();
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }
  }

  restoreUser(idaccount, iduser) {
    if (confirm("Are you sure you want Restore Account!")) {
      this.responseMessage = "Customer Account Restored Succussfully.";
      let payLoad = {
        sesidaccount: idaccount,
        iduser: iduser,
        isDeleted: 0
      }      
      this.data.deletependingaccount(payLoad).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = "Customer Account Restored Succussfully.";
          setTimeout(() => {
            this.responseMessage = "";
            window.location.reload();
          }, 3000);
        }
      });
    }
  }

  loginUser(data: any) {
    let userLogin = { username: data.user_name, typeCheck: 'admin_checking', sessionType: "MORPHING" };
    this.data.userMorphingLogin(userLogin).subscribe(res => {
      if (res.authkey) {
        let userData = res;
        this.router.navigate([], { state: { userData: userData } }).then(result => {
          window.open(window.location.origin + '/#/dashboards/dashboard/' + userData.authkey, '_blank');
        });
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
  showfilter() {
		if (this.showFilter == false) {
			this.showFilter = true;
		}
		else {
			this.showFilter = false;
		}
	}

	

	applyUserFilter(){
		if(this.filterUser.invalid){
			return
		}
		else {
      if (this.filterUser.value.to_date || this.filterUser.value.from_date ||
        (this.filterUser.value.service && this.filterUser.value.service.length > 0) || (this.filterUser.value.regTariff && this.filterUser.value.regTariff.length > 0) || (this.filterUser.value.idaccount && this.filterUser.value.idaccount.length > 0)) {
      const filterValues = Object.values(this.filterUser.value);
			const allFieldsEmpty = filterValues.every(value => value === "");
			this.data.UserFilter(JSON.stringify(this.filterUser.value)).subscribe((res) => {
				if (res.status == 201) {
					$('#basic-datatableuser').dataTable().fnClearTable();
					$('#basic-datatableuser').dataTable().fnDraw();
					$('#basic-datatableuser').dataTable().fnDestroy();
					this.userlist = res.data;
					this.PendingTodeleteUsers = [];
          this.userlist.forEach(element => {
            if (element.is_deleted == 1) {
              this.PendingTodeleteUsers.push(element);
            }
          });	
					$.getScript('./assets/tollfree.js');
          if(allFieldsEmpty){
						this.responseMessage = "";
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
					else {
						this.responseMessage = res.message;
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});	
    }else{
      this.errMessage ="Please Enter atleast 1 field!";
      setTimeout(() => {
        this.errMessage = "";
      }, 3000);
      }
		}
	}

  messageshow() {
		const from_date = this.filterUser.get('from_date').value;
		const to_date = this.filterUser.get('to_date').value;
		const currentDate = new Date();
		if ((!from_date && !to_date)) {
		} else if ((from_date == null || !from_date) && (to_date != null)) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((from_date != null) && (to_date == null || !to_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
		  return;
		} else if (to_date && new Date(to_date) > currentDate) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
		  return;
		} else if (from_date && new Date(from_date) > currentDate) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
		  return;
		} else {
		  this.filterUser.get('from_date').setErrors(null);
		  this.filterUser.get('to_date').setErrors(null);
		}
	}

	resetUserFilter() {
		this.filterUser.reset();
		this.router.navigate(['/user/user-details']);
		this.GetUsers();
	}
  // truncatenotification(subject: string, maxLength: number): string {
	// 	return subject.length > maxLength ? subject.substring(0, maxLength) + '...' : subject;
	//   }

  truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}
    
  ngOnDestroy(){
		this.deletModal.nativeElement.click();
  }
}
