import { Component, EventEmitter, Inject, OnInit, Output, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { Router } from '@angular/router';
import { BehaviorSubject } from 'rxjs';
import { BillingService } from 'src/app/billing/billing.service';
import { environment } from 'src/environments/environment';
import { UsermanagementService } from '../../usermanagement.service';

@Component({
  selector: 'app-balance',
  templateUrl: './balance.component.html',
  styleUrls: ['./balance.component.css']
})

export class BalanceComponent implements OnInit {
  @ViewChild('closemodal')closemodal;
  @Output() submitClicked = new EventEmitter<any>();
  billingAddressForm: FormGroup;
  amount: any = 20;
  submitted: boolean = false;
  address: any;
  userProfile: any;
  paymentHandler: any;
  errMessage: any = "";
  stripeCards: any = [];
  isCards: boolean = false;
  valMessage$ = new BehaviorSubject<string>('');
  valMessage = this.valMessage$.asObservable();
  isNewCard: Boolean = false;
  checked: boolean = false;
  stripeDefaultCards: any;
  stripeDefCard: any;
  public show: boolean = false;
  message: string;
  customerId: any ="";
  expireDefaultCard: boolean = false;
  notAuthorization: boolean = false;

  responseMessage:any
  balancetype: any;
  subs: any = 'false';
  isDisabled: any =[];
  inputamount:boolean = false;
  payableamount:any
  logdata:any=[]

  constructor(public dialogRef: MatDialogRef<BalanceComponent>,
    @Inject(MAT_DIALOG_DATA) public data: any = {}, private billingAddress: BillingService,public router: Router,
    private fb: FormBuilder, private userService: UsermanagementService) { }

  ngOnInit(): void {
    this.address = this.data.address[0] || {};    
    this.userProfile = this.data.userProfile[0] || {};    

    this.balancetype = this.data.payLoad || {};   
    if(this.balancetype.type == 'subscharge'){
      this.amount = parseFloat(this.balancetype.balance).toFixed(2)
      this.subs = 'true'
      this.payableamount=0
      this.logdata=this.balancetype.loginfo
    }else{
      this.payableamount=20
    }

    this.billingAddressForm = this.fb.group({
      amount: [this.amount, [Validators.required,
      Validators.min(this.payableamount),
      Validators.max(500000),
      Validators.pattern(/^\d*(?:[.,]\d{1,2})?$/),
      ]],
      customer_id: [''],
      first_name: [''],
      last_name: [''],
      contact: [''],
      email: [''],
      address1: [''],
      address2: [''],
      city: [''],
      state: [''],
      postal_code: [''],
      country: [''],
      currentDateTime: [],
      type:['']
    });

    this.billingAddressForm.patchValue({
      amount: this.amount || 0,
      first_name: this.userProfile.first_name,
      last_name: this.userProfile.last_name,
      contact: this.userProfile.contact_number,
      email: this.userProfile.email,
      address1: this.address.address1,
      address2: this.address.address2,
      city: this.address.city,
      state: this.address.state,
      postal_code: this.address.postal_code,
      country: this.address.country,
      type:this.balancetype.type
    });

    this.userService.stripeCards().subscribe(res => {
      if (res.status == 200) {
        if (res.data.length > 0) {
          this.stripeCards = res.data.filter((card) => card.isdeleted === 0);
            this.stripeCards.forEach((element:any,index:any)  => {
                if(element.card_pdf == null || element.card_pdf == "null" || element.card_pdf == undefined || element.card_pdf == "undefined" || element.card_pdf == '' || !element.card_pdf.includes('card_pdf')){
                  element.notAuthorization = false;
                }else{
                  element.notAuthorization = true;
                }
              
            });
          this.isCards = true;
          if (this.stripeCards.length >= 5) {
            this.isNewCard = false;
          }
          else {
            this.isNewCard = false;
          }
        }
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

    this.invokeStripe();
  }

  // getAmount(e) {
  //   this.amount = e.target.value;
  //   this.billingAddressForm.patchValue({
  //     amount: this.amount
  //   });
  // }

  authorizeCard(idstripecard){
    this.router.navigate(['/user/invoice-card-auth/' + idstripecard]);
    this.closemodal.nativeElement.click();
  }

  getAmount(e:any) { 
    this.expireDefaultCard = false;
    this.notAuthorization = false;
    this.billingAddressForm.patchValue({
      // amount: this.amount
      amount: e.target.value
    });
    let data = e.target.value;    
    this.submitted = false; 
    e.target.value = (data.indexOf(".") >= 0) ? (data.substr(0, data.indexOf(".")) + data.substr(data.indexOf("."), 3)) : data;
    return  this.amount = e.target.value;   
  }

  selectCard(customer_id) {
    this.expireDefaultCard = false;
    this.notAuthorization = false;
    this.stripeCards.find(res => {
      if (customer_id == res.customer_id) {
        this.billingAddressForm.patchValue({
          customer_id: res.customer_id
        })
        this.customerId = res.customer_id
      }
    });
  }

  addWithExisting() {
    let card: any;
    this.stripeCards.find(res => {
      if (res.customer_id == this.billingAddressForm.value.customer_id) {
        card = res.exp_month + '/' + res.exp_year + '**** ' + res.last4;
      }
    });
    if (this.billingAddressForm.value.customer_id) {
      if (confirm(`Please Confirm Card ${card}`)) {
        this.billingAddress.updateBalance(JSON.stringify({ pdata: this.billingAddressForm.value })).subscribe(response => {
          if (response.status == 201) {
            sessionStorage.setItem('viaonboarding', '0');
            this.dialogRef.close({ message: response.message, reload: true });
          }
          else {
            this.valMessage$.next(response.message);
            setTimeout(() => {
              this.valMessage$.next("");
            }, 5000);
          }
        });
      }
      else {
        return
      }
    }
    else {
      this.valMessage$.next("Please Select Card");
      setTimeout(() => {
        this.valMessage$.next("");
      }, 5000);
    }
  }

  addAmount() {   
    if (this.billingAddressForm.invalid) {
      this.submitted = true; 
      // this.valMessage$.next("Invalid Amount or Account Profile");
      // setTimeout(() => {
      //   this.valMessage$.next("");
      // }, 5000);
    }
    else {
      this.billingAddressForm.patchValue({
        amount: this.amount,
        currentDateTime: this.current_datetime(),
      });
      // if(this.billingAddressForm.value.customer_id){
      //     this.addWithExisting();
      // }
      // else{

      if (this.billingAddressForm.value.customer_id) {
        this.billingAddressForm.patchValue({
          customer_id: this.billingAddressForm.value.customer_id
        })
        this.openCheckout(this.billingAddressForm.value);

      }
      else {
        this.userService.stripeDefaultCards().subscribe(res => {
          if (res.status == 200) {
            this.stripeDefaultCards = res.data[0];
            this.isCards = true;
            this.customerId = this.stripeDefaultCards.customer_id;
            this.billingAddressForm.patchValue({
              customer_id: this.stripeDefaultCards.customer_id
            })
            this.openCheckout(this.billingAddressForm.value);

          }
          else {
            this.openCheckout(this.billingAddressForm.value);

          }
        });

      }

      // }
    }
  }

  async openCheckout(billingData: any) {
    if (billingData.customer_id != '' && billingData.customer_id) {
      let response: any = await this.checkExpiryCard();
      if(response.status == 201){
        await this.billingAddress.updateBalance(JSON.stringify({ pdata: billingData,lodinfo:this.logdata })).subscribe(response => {
          if (response.status == 201) {
            sessionStorage.setItem('viaonboarding', '0');
            this.dialogRef.close({ message: response.message, reload: true });
          }
          else {
            this.valMessage$.next(response.message);
            setTimeout(() => {
              this.valMessage$.next("");
            }, 5000);
          }
        });
      }
      else{
        return
      }
    }
    else {
      const paymentHandler = (<any>window).StripeCheckout.configure({
        key: environment.PublicKey,
        locale: 'auto',
        token: (stripeToken: any) => {
          this.billingAddress.addBalance(JSON.stringify({ pdata: billingData, token: stripeToken })).subscribe(response => {
            if (response.status == 201) {
              alert("We are adding this card as a Default Card!");
              this.dialogRef.close({ message: response.message, reload: true });
            }
            else {
              this.errMessage = response.message;
              setTimeout(() => {
                this.errMessage = "";
              }, 5000);
            }
          });
        }
      });
      paymentHandler.open({
        name: 'Signalmash Admin',
        // description: `Amount ${this.amount} Added For Your Signalmash Wallet`,
        amount: this.amount * 100,
        shippingAddress: false,
        billingAddress: true,
      });
    }
  }
  checkExpiryCard(){
    return new Promise((resolve, reject) => {
      let now = new Date();
      let year = Number("" + now.getFullYear());
      let month:any = Number("" + (now.getMonth() + 1)); if (month.length == 1) { month = "0" + month; }
      this.stripeCards.forEach((element:any,index:any)  => {
        if(element.customer_id == this.customerId){
          let DefaultCardMonth = Number(element.exp_month);
          let DefaultCardYear = Number(element.exp_year);
          if((DefaultCardMonth < month && DefaultCardYear < year) || (DefaultCardYear == year && DefaultCardMonth < month) || (DefaultCardMonth > month && DefaultCardYear < year) || (DefaultCardMonth == month && DefaultCardYear < year)){
            this.expireDefaultCard = true;
            this.errMessage ="Your Card Is Expired Please Change Your Card";
            this.submitClicked.emit(this.errMessage);
          }
          
          if(element.card_pdf == null || element.card_pdf == "null" || element.card_pdf == undefined || element.card_pdf == "undefined" || element.card_pdf == '' || !element.card_pdf.includes('card_pdf')){
            this.notAuthorization = true;
              this.errMessage ="You can not add balance using an unauthorized card. Please authorize the card first.";
              this.submitClicked.emit(this.errMessage);
          }
        }
        if(this.stripeCards.length-1 == index){
          if(this.notAuthorization == true || this.expireDefaultCard == true){
            resolve({ status: 502});
          }
          else{
            resolve({ status: 201});
          }
        }
      });
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });  
  }

  invokeStripe() {
    if (!window.document.getElementById('stripe-script')) {
      const script = window.document.createElement("script");
      script.id = "stripe-script";
      script.type = "text/javascript";
      script.src = "https://checkout.stripe.com/checkout.js";
      script.onload = () => {
        this.paymentHandler = (<any>window).StripeCheckout.configure({
          key: environment.PublicKey,
          locale: 'auto',
          token: (stripeToken: any) => {
            alert('Payment has been successfully!');
          }
        });
      }
      window.document.body.appendChild(script);
    }
  }

  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
  }

  onClose() {
    this.dialogRef.close({ data: this.data, reload: false });
  }
}
