import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatDialog } from '@angular/material/dialog';
import { MatSlideToggleChange } from '@angular/material/slide-toggle';
import { UsermanagementService } from '../../usermanagement.service';
import { AdddialogComponent } from '../../usermanagement/adddialog/adddialog.component';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
import { Router } from '@angular/router';

declare var $: any;

@Component({
  selector: 'app-usersetting',
  templateUrl: './usersetting.component.html',
  styleUrls: ['./usersetting.component.css']
})

export class UsersettingComponent implements OnInit {
  filtre: string;
  searchText = { count: 0 };
  label: any;
  managebillingForm: FormGroup;
  country: "";
  submitted: boolean;
  pShow = false;
  users: any;
  userlist: any;
  subAdminList: any;
  page = 1;
  count = 0;
  tableSize = 25;
  tableSizes = [25, 50, 100];
  filterTerm: string;
  userlistheader: any;
  sessData: any;
  defaultUser: string;
  show = true;
  userType: any;

  public status: boolean = false;
  public key: number;
  public ptype: number;
  header: any;
  paymentlist: any;
  public isapply: boolean = true;
  isLoggedIn: any;
  responseMessage: any;
  paymentSettingForm: FormGroup;
  subbmitted: boolean = false;
  isAutoPayment: Boolean = false;
  isAutoEmail: Boolean = false;
  isAutowebhook: Boolean = false;
  errMessage = "";

  roles_permissions: any = [];
  onlyRead: boolean = false;
  selectedUserId: number | null = null;

  @ViewChild('closebutton') closebutton: ElementRef;

  constructor(private data: UsermanagementService, public dialog: MatDialog, private fb: FormBuilder,private authService : AuthenticationService,public router: Router){}

  ngOnInit(): void {

    this.paymentSettingForm = this.fb.group({
      idwallet: [],
      defaultamt: ['', [Validators.required, Validators.min(200), Validators.max(500000)]],
      topup_amount: [''],
      webhook_url: ['']
    });

    this.data.getBalance().subscribe(response => {
      if (response.status == 200) {
        this.paymentSettingForm.patchValue({
          idwallet: response.data[0].idwallet,
          defaultamt: response.data[0].min_balance,
          topup_amount: response.data[0].topup_amount,
          webhook_url: response.data[0].webhook_url,
        });
        if (response.data[0].status == "true") {
          this.isAutoPayment = true;
        }
        else {
          this.isAutoPayment = false;
        }
        if (response.data[0].isEmail == "true") {
          this.isAutoEmail = true;
        }
        else {
          this.isAutoEmail = false;
        }
        if (response.data[0].isWebhook == "true") {
          this.isAutowebhook = true;
        }
        else {
          this.isAutowebhook = false;
        }
      }
      else {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });

    this.data.getpaymentsetting().subscribe(res => {
      this.header = res[0].headers_details;
      this.paymentlist = res[0].list;
    });

    this.sessData = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.defaultUser = this.sessData.username;
    this.userType = this.sessData.type;


    this.getUser();
    this.data.getuserheader().subscribe((result) => {
      let headers = result.headers_details.slice(0, -2);
      this.userlistheader = headers.slice(0, -1);
      if (this.userType =='2' || this.userType == '201' || this.userType == '1') {
        this.userlistheader.push("Action");
      }
    });

    this.getUserPermissions();
  }
  
  getUserPermissions() {
    this.data.getPermissions().subscribe((res) => {
      if (res.status == 200) {
        this.roles_permissions = res.data;
        this.roles_permissions.forEach((item) => {
          let user_type_name : any = item.id_user_type == '1' ? '201' :item.id_user_type == '2' ? '202' :item.id_user_type == '3' ? '203' : item.id_user_type == '4' ? '231' : item.id_user_type == '5' ? '232' : ''
          if (item.feature_id == 6 && item.read == 1 && item.write == 0) {
            this.onlyRead = true;
          }
          else if (item.feature_id == 4 && item.write == 1 && item.read == 0) {
            this.onlyRead = false;
          }
        });
        // this.getUserHeader();
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      }
      // console.log(res, "permissions");
    });
  }


  // getUser(){
  //   this.data.getUsers("profile").subscribe(res => {
  //     if (res.data[0]) {
  //       this.userlist = res.data[0];        
  //       this.userlist.forEach(element => {
  //         element.pShow = false;
  //         element.pswd = "password";
  //       });   
  //       $('#basic-datatables14').DataTable().clear();
  //       $('#basic-datatables14').DataTable().destroy();
  //       $.getScript('./assets/table.js');   
  //     }
  //   });
  // }

  getUser() {
    this.data.getUsers("profile").subscribe(res => {
      if (res.data[0]) {
        const uniqueUsers = [];
        this.userlist = res.data[0];
        
        this.userlist.forEach(element => {
          const existingUser = uniqueUsers.find(
            user =>
              user.idaccount === element.idaccount &&
              user.iduser === element.iduser
          );
          if (!existingUser) {
            // element.pShow = false;
            // element.pswd = "password";
            uniqueUsers.push(element);
          }
        });
        this.userlist = uniqueUsers; // Update the userlist with unique entries
        // this.subAdminList = this.userlist.filter(user => user.type === 12 || user.type === 22 || user.type === 201);
        this.subAdminList = this.userlist.filter(user => user.type === 12 || user.type === 22 || user.type === 201 || user.type === 202 || user.type === 203 || user.type === 231 || user.type === 232);
        $('#basic-datatablesFA').DataTable().clear();
        $('#basic-datatablesFA').DataTable().destroy();
        $.getScript('./assets/table.js');
      }
    });
  }

  onPaymentSetting() {
    this.subbmitted = true;
    if (this.paymentSettingForm.invalid) {
      return;
    }
    else {
      if (this.paymentSettingForm.value.idwallet == null || this.paymentSettingForm.value.idwallet == undefined) {
        this.responseMessage = "Add Amount in Your Wallet!";
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      }
      else {
        this.data.updatePaymentService(this.paymentSettingForm.value).subscribe(response => {
          if (response.status == 201) {
            this.responseMessage = response.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
            this.ngOnInit();
          }
          else {
            this.responseMessage = response.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          }
        }, err => {
          this.responseMessage = err;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        });
      }
    }
  }



  adduser() {
    let tmp: any = sessionStorage.getItem("isLoggedIn");
    tmp = JSON.parse(tmp);
    const dialogRef = this.dialog.open(AdddialogComponent, {
      width: '600px', disableClose: true,
      data: { iduser: tmp.iduser, type: tmp.type, idaccount: tmp.idaccount, dialogtype: 1, savetype: 0 }
    });

    dialogRef.afterClosed().subscribe(res => {
      if (res == 1){
        this.responseMessage = "Sub Customer Created Successfully!";
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        this.getUser();

      }
    })
  }
/*   keyToggle(id) {
    this.userlist.forEach(element => {
      if (element.iduser == id) {
        if (element.pswd == 'password') {
          element.pswd = 'text';
          element.pShow = true;
        } else {
          element.pswd = 'password';
          element.pShow = false;
        }
      }
    });
  } */

  editUser(data: any) {
    let tmp: any = sessionStorage.getItem("isLoggedIn");
    tmp = JSON.parse(tmp);
    data["dialogtype"] = 2;
    data["savetype"] = 0;
    const dialogRef = this.dialog.open(AdddialogComponent, {
      width: '600px', disableClose: true,
      data
    });

    dialogRef.afterClosed().subscribe(res => {
      if (res == 1){
        this.responseMessage = "Customer Updated Successfully.";
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        this.getUser();

      }      
    })
  }

  numberOnly(event): boolean {
    const charCode = (event.which) ? event.which : event.keyCode;
    if (charCode > 31 && (charCode < 48 || charCode > 57)) {
      return false;
    }
    return true;
  }

  DeleteUser() {
    if (this.selectedUserId != null) {
        this.data.deleteUserSingleData(this.selectedUserId).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
            this.ngOnInit(); 
            this.closebutton.nativeElement.click();
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      this.selectedUserId = null; 
    }
  }

  openDeleteModal(userId: number) {
    this.selectedUserId = userId;
  }

  onEmailStatus(e: MatSlideToggleChange) {
    this.data.updatePaymentService({ idwallet: this.paymentSettingForm.value.idwallet, isAutoEmail: e.checked }).subscribe(response => {
      if (response.status == 201) {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
        this.ngOnInit();
      }
      else {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      }
    }, err => {
      this.responseMessage = err;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });
  }

  onAutoPayment(e: MatSlideToggleChange) {
    this.data.updatePaymentService({ idwallet: this.paymentSettingForm.value.idwallet, isAutoPayment: e.checked }).subscribe(response => {
      if (response.status == 201) {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
        this.ngOnInit();
      }
      else {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      }
    }, err => {
      this.responseMessage = err;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });
  }

  onIsWebhook(e: MatSlideToggleChange) {
    this.data.updatePaymentService({ idwallet: this.paymentSettingForm.value.idwallet, isAutowebhook: e.checked }).subscribe(response => {
      if (response.status == 201) {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
        this.ngOnInit();
      }
      else {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      }
    }, err => {
      this.responseMessage = err;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });
  }

  resetPassword(email : any,username:any){
    let data = JSON.stringify({
      email:email,
      username:username
    })
    this.authService.sendMailForgot(data).subscribe(res => {
      if(res.status == 201){
        this.responseMessage = "Link sent to the registered email address!";
        setTimeout(() => {
            this.responseMessage = "";
        }, 5000);
      } else{
        this.errMessage = res.message;
        setTimeout(() => {
            this.errMessage = "";  
        }, 5000);
      }
    }); 
  }

  loginUser(data: any) {    
		let userLogin = { username: data.user_name, typeCheck: 'admin_checking', sessionType: "MORPHING"};
		this.data.userMorphingLogin(userLogin).subscribe(res => {
			if (res.authkey) {
				let userData = res;
				this.router.navigate([], { state: { userData: userData } }).then(result => {
					window.open(window.location.origin + '/#/userlogin/' + userData.authkey);
				});
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
  
  ngOnDestroy() {
		this.closebutton.nativeElement.click();

	}
  
}
