import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { UsermanagementService } from '../usermanagement.service';
import { AdddialogComponent } from '../usermanagement/adddialog/adddialog.component';
import { MatDialog } from '@angular/material/dialog';
import { AuthenticationService } from 'src/app/authentication/authentication.service';
declare var $: any;
@Component({
  selector: 'app-subusers',
  templateUrl: './subusers.component.html',
  styleUrls: ['./subusers.component.css']
})
export class SubusersComponent implements OnInit {
  page = 1;
  count = 0;
	tableSize = 25;
	tableSizes = [ 25,50 , 100];
	searchText = { count: 0 };
	filtre: string;
  responseMessage = "";
  userlistheader: any = [];
  userlist: any = [];
  iduser: string;
  idaccount: string;
  errMessage = "";

  constructor(private data: UsermanagementService, private route: ActivatedRoute, public dialog: MatDialog, private authService : AuthenticationService ) { }

  ngOnInit(): void {
    this.data.getuserheader().subscribe((result) => {
			this.userlistheader = result.headers_details1;
		});

    this.route.paramMap.subscribe((params: ParamMap) => {
        let userData = params.get('id');
        let splitUser = userData.split('-');
        this.iduser = splitUser[0];
        this.idaccount = splitUser[1];
        this.getuserlist();
      }); 
      
  }
  
  resetPassword(email : any,username:any){
    let data = JSON.stringify({
      email:email,
      username:username
    })
    this.authService.sendMailForgot(data).subscribe(res => {
      if(res.status == 201){
        this.responseMessage = "Link sent to the registered email address!";
        setTimeout(() => {
            this.responseMessage = "";
        }, 5000);
      } else{
        this.errMessage = res.message;
        setTimeout(() => {
            this.errMessage = "";  
        }, 5000);
      }
    }); 
  }
  
  getuserlist(){
    this.data.getSubListUsers({idaccount: this.idaccount, iduser: this.iduser, type: "profile"}).subscribe((result: any) => {
      this.userlist = result.data[0];
      $('#basic-datatablesaccount').dataTable().fnClearTable();
      $('#basic-datatablesaccount').dataTable().fnDraw();
      $('#basic-datatablesaccount').dataTable().fnDestroy();
      $.getScript('./assets/tollfree.js');
    }, err => {
      console.log(err.message);
    });
  }

  /* editUser(data: any) {
    let tmp: any = sessionStorage.getItem("isLoggedIn");
    tmp = JSON.parse(tmp);
    data["dialogtype"] = 2;
    data["savetype"] = 0;
    const dialogRef = this.dialog.open(AdddialogComponent, {
      width: '600px', disableClose: true,
      data
    });

    dialogRef.afterClosed().subscribe(res => {
      if (res == 1){
        this.responseMessage = "Sub Customer Updated Successfully!";
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        this.getuserlist();
        // this.getUser();
      }      
    })
  } */

  deleteUser(iduser, idaccount){
		let sdata = {"iduser": iduser, "idaccount": idaccount}
		if (confirm("Are you sure you want delete data!")) {
			this.data.deleteUser(JSON.stringify(sdata)).subscribe(result =>{
				this.responseMessage = result.message;
				setTimeout(()=>{
					this.responseMessage= "";
				}, 5000);
				 this.ngOnInit();
			})
		} else {
			"Cancel!";
		}	
	}

}
