import { Component, ViewChild, Input, ElementRef, TemplateRef, } from '@angular/core';
import { Validators, FormBuilder, FormControl, FormGroup, ValidatorFn, AbstractControl } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { AdddialogComponent } from '../usermanagement/adddialog/adddialog.component';
import { MatDialog } from '@angular/material/dialog';
import { usermanagement, usermanagementForm } from '../user.class';
import { UsermanagementService } from '../usermanagement.service'
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { BehaviorSubject, Observable } from 'rxjs';
import { environment } from 'src/environments/environment';
import { MatAccordion } from '@angular/material/expansion';
import { BillingService } from 'src/app/billing/billing.service';
import { NgbActiveModal } from '@ng-bootstrap/ng-bootstrap';
import { I } from '@angular/cdk/keycodes';
import { SuspendedServicesComponent } from '../suspended-services/suspended-services.component';
import { TariffService } from 'src/app/tariff/tariff.service';
import { DatePipe } from '@angular/common';
import * as pdfMake from 'pdfmake/build/pdfmake.js';
import * as pdfFonts from 'pdfmake/build/vfs_fonts.js';
import { HttpClient, HttpRequest } from '@angular/common/http';
pdfMake.vfs = pdfFonts.pdfMake.vfs;
(pdfMake as any).vfs = pdfFonts.pdfMake.vfs;
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { log } from 'console';
declare var $: any;

@Component({
	selector: 'app-usermanagement',
	templateUrl: './usermanagement.component.html',
	styleUrls: ['./usermanagement.component.css']
})

export class UsermanagementComponent extends AppComponentClass<usermanagement, usermanagementForm> {

	@ViewChild(MatAccordion) accordion: MatAccordion;
	@Input() usertype: Observable<boolean>;
	@Input() curuserid?: number = -1;
	@ViewChild('informationmodal') informationmodal: ElementRef;
	@ViewChild('addressTab') addressTab: ElementRef;
	@ViewChild('modalpdf') modalpdf: ElementRef;
	@ViewChild('addamountmodule') addamountmodule: ElementRef;
	@ViewChild('billingMessagemodal') billingMessagemodal: ElementRef;
	@ViewChild('accountreviwmodal') accountreviwmodal: ElementRef;
	@ViewChild('deleteaccountmodal') deleteaccountmodal: ElementRef;

	searchText = { count: 0 };
	filtre: string;
	p: number = 1;
	toggleValue = "Customer";

	private userlist$ = new BehaviorSubject<any>([{ iduser: -1, first_name: "", last_name: "", user_name: "", email: "", contact_number: "", profile_pic: ""}]);
	userlist: any = this.userlist$.asObservable();


	private billingaddr$ = new BehaviorSubject<any>([{ "idbilling_address": -1, "idaccount": -1, "first_name": "", "last_name": "", "contact": "", "email": "", "address1": "", "address2": "", "city": "", "state": "", "postal_code": "", "country": "" }]);
	billingaddr: any = this.billingaddr$.asObservable();

	//hedding = "Add User";
	rechargedata: any;
	list: any;
	list1: any;
	record: any;
	user_id: any;
	account_id: any;
	dids: any[];
	userlength: any;
	filterForm: any;
	campaigns: any;
	planname: string;
	tmplist: any;
	price: string;
	ismonthly: boolean;
	//userlist: any = [];
	userlistFull: any = [];
	//public supplier : boolean = false;
	public __supplier = new BehaviorSubject<boolean>(false);
	public supplier = this.__supplier.asObservable();
	listdata: any;
	ratemanagedata: any = [];
	rateData: any = [];
	// defaultSelect : any = 1;
	sessData: any;
	defaultUser: any;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	public show: boolean = false;
	public toggle_cust: boolean = true;
	public userlistheader: any;
	public subuserlistheader: any;
	public buttonName: any = "Add";
	public usermanagementForm: FormGroup;
	public submitted: boolean = false;
	filterTerm: string;
	public dis_toggle: boolean = false;
	fileToUpload: File = null;
	file: any;
	headers: any;
	newFeatures: Observable<any>;
	row: any;
	suppliers: any;
	ids: any = [];
	public show1: boolean = true;
	responseMessage = "";
	public DidUpload = environment.SERVER + "uploads/document_upload";
	groupID: any;
	countUser: any;
	pShow = false;
	rechargeForm: FormGroup;
	billingAddress: any;

	tab1$ = new BehaviorSubject<any>("");
	tab1 = this.tab1$.asObservable();
	tab1Value = "";
	tab2$ = new BehaviorSubject<any>("");
	tab2 = this.tab2$.asObservable();
	tab2Value = "";
	tab3$ = new BehaviorSubject<any>("");
	tab3 = this.tab3$.asObservable();
	tab3Value = "";
	tab4$ = new BehaviorSubject<any>("");
	tab4 = this.tab4$.asObservable();
	tab4Value = "";
	tab5$ = new BehaviorSubject<any>("");

	inboundForm: FormGroup;
	outboundForm: FormGroup;

	public __hedding = new BehaviorSubject<string>("Users List");
	public hedding = this.__hedding.asObservable();
	filteredItems: any;
	errMessage: any = "";
	userProfile: any = [];
	balance: any;
	balanceData: any;
	userPro: any = [];
	stylecls: string;
	styleclsmob: string;
	styleclseml: string;
	styleclspln: string;
	styleclsdid: string;
	styleclssms: string;
	styleclsvoice: string;
	subCustomer: any = [];
	onboardingstatus: string;
	vstspln: string;
	vstseml: string;
	vstsmob: string;
	tooltp: string;
	fullname: any;
	customerName: string;
	styleclsbadd: string;
	vstsbadd: string;
	isbilling: any;
	color: any;
	msg: any;
	BilValue: any;
	idaccount: any;
	iduser: any;
	isActiveEnable: any;
	isActiveDisable: any;
	is_billing: any;
	returnsms: boolean = false;
	data1: any;
	checkdelete: boolean = false;
	isDeleted: any = '2';

	@ViewChild('closebutton') closebutton;
	userdata: any;
	billingMessage: string = "";
	kycPdfDetails: any = [];
	showKycPdf: any;
	showcardPdf: any;
	kycStatus: any;
	KYCiduser: any;
	Kycidaccount: any;
	federalPdfDetails: any = [];
	showfederalPdf: any;
	cardPdfDetails: any = [];
	federalPDF: any;
	rejectFederalStatus: any;
	federalStatus: any;
	selectVal: boolean;
	noSelectVal: boolean;
	styleclscard: string;
	vstscard: string;
	featureServiceData: any;
	IDaccount: any;
	trustscore: any;
	Trust_Score: any;
	showFilter: boolean = false;
	filterUser: FormGroup;
	preferenceServices: any = [];
	regTariffs: any = [];
	Users: any = [];
	customer: any;
	id: any;
	isIdServiceRoute: boolean = false;
	isIdTariffRoute: boolean = false;
	public custoDfilter: FormGroup;
	reloaduserlist: any = [];
	selectedOption: string;
	sendMail: boolean = true;
	email: any;
	idinvoice: any;
	currentInvoice: any = [];
	invoiceData1_1: any = [];
	invoiceData1_2: any = [];
	invoiceData2_1: any = [];
	invoiceData2_2: any = [];
	invoiceData3_1: any = [];
	invoiceData3: any = [];
	invoiceData4: any = [];
	invoiceData5: any = [];
	invoiceData6: any = [];
	invoiceData7: any = [];
        invoiceData10: any = [];
	lastMonthInvoice: any = {};
	GrandTotal: number = 0;
	iNumber: any = "";
	calls: any;
	date: any = "";
	newFmt: any = [];
	body: any = [];
	body1: any = [];
	issueDate: any = "";
	status: boolean = false;
	invoiceDataForCount: any = [];
	invoiceData1: any = [];
	invoiceData2: any = [];
	totalamt: any = 0;
	totalDue: any;
	finalCharge: any;
	previousDue: any;
	remainingWallet: any;
	taxes: any;
	showModel: boolean = false;
	getextradidMrc: any = 0;
	totalAccSummary: any = "";
	getextradidMrcQty: any;
	Idinvoice: any;
	isLoading: boolean = false;
	dropdownSetting: IDropdownSettings = {};
	dropdownSetting1: IDropdownSettings = {};
	dropdownSetting2: IDropdownSettings = {};
	closeDropdownSelection = true;
	tariffName: any = "";
	tariffs: any = [];
	prefrseService:any=[];
	serviceName:any="";
	showAddNote: boolean = false;
	selectedIdUse!: string;
	selectedIdAccount!: string;
	
	id1:any = ''
	tabb: boolean;

	constructor(public data: UsermanagementService, public router: Router, private route: ActivatedRoute, private tariffService: TariffService,
		public fb: FormBuilder, public dialog: MatDialog, private billing: BillingService, private el: ElementRef, public _http: HttpClient, private datePipe: DatePipe
	) {
		super(data, router, fb);
	}

	ngOnInit(): void {

		this.rechargeForm = this.fb.group({
			// amount: new FormControl(null, [Validators.required, Validators.min(1),
			// 	 Validators.max(50000000), Validators.pattern(/^\d*(?:[.,]\d{1,2})?$/)]),
			amount: new FormControl(null, [Validators.required, Validators.min(1),
			Validators.max(50000000)]),
			idaccount: new FormControl(''),
			email: new FormControl(''),
			description: new FormControl('', [Validators.required, Validators.pattern(/^(?!.*\s{2})\s*\S.*$/m), Validators.minLength(10), Validators.maxLength(255)]),
			currentDateTime: new FormControl(this.current_datetime()),
			paymentType: new FormControl('2', [Validators.required])
		});

		this.filterUser = this.fb.group({
			to_date: [''],
			from_date: [''],
			service: [''],
			regTariff: [''],
			idaccount: [''],
			onboarding: ['']
		});
		
		// this.route.params.subscribe(params => {
		// 	this.id = +params['id'];
		// 	this.isIdServiceRoute = this.route.snapshot.routeConfig.path.includes('idservice');
		// 	this.isIdTariffRoute = this.route.snapshot.routeConfig.path.includes('idtariff');
		// 	this.tabb = this.route.snapshot.routeConfig.path.includes('tab');
		// 	if (this.isIdServiceRoute) {
		// 		this.id1 ='2'
		// 		this.showAccountfilter()
		// 		this.filterUser.get('service').setValue(this.id);
		// 		// this.applyUserFilter();
		// 		setTimeout(() => {
		// 			this.applyUserFilter();
		
		// 		}, 2000);

		// 	}
		// 	else if (this.isIdTariffRoute) {
		// 		this.id1 ='1'
		// 		this.showAccountfilter()
		// 	}
		// 	else {
		// 		if(this.tabb){
		// 			this.id1 = this.id
		// 		}else{
		// 			this.id1 =  '1'
		// 		}
		// 		this.GetUsers()
		// 	}
		// });

		this.route.params.subscribe(params => {
			this.id = +params['id'];
			this.isIdServiceRoute = this.route.snapshot.routeConfig.path.includes('idservice');
			this.isIdTariffRoute = this.route.snapshot.routeConfig.path.includes('idtariff');
			this.tabb = this.route.snapshot.routeConfig.path.includes('tab');
		
			if (this.isIdServiceRoute) {
				this.id1 = 2; // Number instead of string
				this.showAccountfilter();
				this.filterUser.get('service').setValue(this.id);
				setTimeout(() => {
					this.applyUserFilter();
				}, 2000);
			}
			else if (this.isIdTariffRoute) {
				this.id1 = 1;
				this.showAccountfilter();
			}
			else {
				this.id1 = this.tabb ? this.id : 1;
				this.GetUsers();
			}
		});
		
		this.sessData = JSON.parse(sessionStorage.getItem("isLoggedIn"));
		this.defaultUser = this.sessData.default;

		// @subscribing form group
		let curaccount: any = JSON.parse(sessionStorage.getItem("isLoggedIn"));

		this.supplier.subscribe(res => {
		});

		this.newFeatures = this.data.getFeature();

		this.data.getuserheader().subscribe((result) => {
			this.userlistheader = result.adminHeader;
		});

		// To load the users list
		// this.GetUsers()
		// To load the users this.down()

		this.data.getSuppliers().subscribe(supplier => {
			this.suppliers = supplier.data[0];
			//this.show=false;
		});


		this.data.solution.subscribe(res => {
			if (res != null) {
				this.cdata = new usermanagementForm(res);
				if (curaccount.type == 1) {
					this.cdata.idaccount = -1;
					this.cdata.iduser = -1;
				}
				if (curaccount.type == 2) {
					this.cdata.idaccount = curaccount.idaccount;
					this.cdata.iduser = -1;
				}
				if (curaccount.type == 3) {
					this.cdata.idaccount = curaccount.idaccount;
					this.cdata.iduser = -1;
				}
				this.keyfield = res.id;
				this.usermanagementForm = this.cdata.makeform(this.fb);
			} else {
				this.cdata = new usermanagementForm(null);
				this.keyfield = -1;
				this.usermanagementForm = this.cdata.makeform(this.fb);
			}
		});

		this.data.getrecord().subscribe((result) => {
			this.record = result[0].headers_details;
			this.list1 = result[0].profile_details;
		})

		this.data.gettier().subscribe((result) => {
			this.listdata = result[0].headers;
			this.row = result[0].invoice;
		});

		this.data.getrecord().subscribe((result) => {
			this.headers = result[0].headers_details;
			this.list = result[0].profile_details;
		});

		this.data.getKycPdfData().subscribe((res) => {
			this.kycPdfDetails = res.data;
		})

		this.data.getfederalPdfData().subscribe((res) => {
			this.federalPdfDetails = res.data;
		})

		this.data.getCardPdfForAdmin().subscribe((res) => {
			this.cardPdfDetails = res.data;
		})

		this.data.getFederalPDFAccount().subscribe(res => {
			this.federalPDF = res.data;
		});

		this.data.getfeatureService().subscribe((res) => {
			this.featureServiceData = res.data;
		});

		this.data.trustScore().subscribe((res) => {
			this.Trust_Score = res.data;
		});

		this.tariffService.getPreferenceService().subscribe(res => {
			this.preferenceServices = res.data;
			this.prefrseService=res.data;

			// -----------------------new code change----------------------------------
			this.preferenceServices = res.data.map(item => ({
				preferid: item.idservice,
				preferenceServices: `${item.name}`
				
			}));
			if(this.id){
				let serviceValue = this.prefrseService.filter((item)=> item.idservice == this.id);
				if (!this.isIdTariffRoute) {
					this.serviceName = [{ preferid: this.id, preferenceServices: serviceValue[0]?.name || '' }];
					this.filterUser.get('service').setValue(this.serviceName);
					this.applyUserFilter();
				}
			}

		}, err => {
			console.log(err.message);
		});

		// Get tariffs
		this.tariffService.getTariffs().subscribe(res => {
			this.regTariffs = res.data;
			this.tariffs = res.data;
			// -----------------------new code change----------------------------------
			this.regTariffs = res.data.map(item => ({
				regid: item.idtariff,
				regTariffs: `${item.name}`
			}));
			if(this.id){
				let tariffValue = this.tariffs.filter((item)=> item.idtariff == this.id);
				if (!this.isIdServiceRoute) {
					this.tariffName = [{ regid: this.id, regTariffs: tariffValue[0]?.name || '' }];
					this.filterUser.get('regTariff').setValue(this.tariffName);
					this.applyUserFilter();
				}
			}
		}, err => {
			console.log(err.message);
		});

		// this.tariffService.getPreferenceService().subscribe(res => {
		// 	this.preferenceServices = res.data;
		// 	// console.log("wefwrwerwerwrw", this.preferenceServices);

		// 	// -----------------------new code change----------------------------------
		// 	this.preferenceServices = res.data.map(item => ({
		// 		preferid: item.idservice,
		// 		preferenceServices: `${item.name}`
		// 	}));

		// }, err => {
		// 	console.log(err.message);
		// });

		// Get tariffs
		// this.tariffService.getTariffs().subscribe(res => {
		// 	this.regTariffs = res.data;
		// 	this.tariffs = res.data;
		// 	// console.log("dsgdfgdfgdfgdfgdfgdfgfd",this.regTariffs)
		// 	// -----------------------new code change----------------------------------
		// 	this.regTariffs = res.data.map(item => ({
		// 		regid: item.idtariff,
		// 		regTariffs: `${item.name}`
		// 	}));
		// 	if(this.id){
		// 		let tariffValue = this.tariffs.filter((item)=> item.idtariff == this.id);
		// 		this.tariffName = [{regid: this.id, regTariffs: tariffValue[0].name}]
		// 		this.filterUser.get('regTariff').setValue(this.tariffName);
		// 		this.applyUserFilter();
		// 	}

		// }, err => {
		// 	console.log(err.message);
		// });
		// this.route.params.subscribe(params => {
		// 	this.selectedIdTariff = +params['idtariff'];
		// 	console.log(this.selectedIdTariff,"idd");
		// 	this.filterUser.get('regTariff').setValue(this.selectedIdTariff);
		// });


		this.dropdownSetting = {
			singleSelection: true,
			idField: 'userdata',
			textField: 'reloaduserlist',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSetting1 = {
			singleSelection: true,
			idField: 'regid',
			textField: 'regTariffs',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

		this.dropdownSetting2 = {
			singleSelection: true,
			idField: 'preferid',
			textField: 'preferenceServices',
			itemsShowLimit: 1,
			allowSearchFilter: true,
			closeDropDownOnSelection: this.closeDropdownSelection
		};

	}

	sendMessage(): void {
		this.data.sendUpdate('updated service!');
	}

	/**
	 * It will load the user's list
	 */

	GetUsers(): void {
		$('#basic-datatablesUS').dataTable().fnClearTable();
		$('#basic-datatablesUS').dataTable().fnDraw();
		$('#basic-datatablesUS').dataTable().fnDestroy();
		this.data.getUsers("main").subscribe(res => {
			this.userlistFull = res.data[0]
				.filter(user => user.is_deleted === 0)
				.sort((a, b) => new Date(b.created).getTime() - new Date(a.created).getTime())
				.map(user => ({
					...user,
					reloaduserlist: `${user.san} - ${user.first_name} ${user.last_name}`,
					color: user.is_billing == '0' ? 'green' : 'red',
					msg: user.is_billing == '0' ? 'Billing is Enabled' : 'Billing is Disabled',
					onboardingstatus: this.getOnboardingStatus(user),
					tooltp: this.getOnboardingTooltip(user)
				})).filter((user, index, self) => 
					index == self.findIndex(u => u.san == user.san)
				);
			this.reloaduserlist = this.userlistFull
				.map(item => ({
					userdata: item.idaccount,
					reloaduserlist: item.reloaduserlist
				}))
				.sort((a, b) => a.reloaduserlist.localeCompare(b.reloaduserlist));
	
			$.getScript('./assets/table.js');
			this.countUser = res.data[0].length;
		});
	}
	getOnboardingStatus(user: any): string {
		return (user.isAddress === 'true' && user.isEmailVerify === 'true' && user.isMobileVerify === 'true' && user.isPlan === 'true' && !(user.newUser_status === 1 && user.isCard !== "true"))
			? "green" : "red";
	}
	getOnboardingTooltip(user: any): string {
		return this.getOnboardingStatus(user) === "green" ? "On-Boarding Complete" : "On-Boarding In Process";
	}


	/**
	 * Account Morphing
	 * It will make login into new tab of selected customer
	 */
	loginUser(data: any) {
		let userLogin = { username: data.user_name, typeCheck: 'admin_checking', sessionType: "MORPHING"};
		this.data.userMorphingLogin(userLogin).subscribe(res => {
			if (res.authkey) {
				let userData = res;
				this.router.navigate([], { state: { userData: userData } }).then(result => {
					window.open(window.location.origin + '/#/userlogin/' + userData.authkey);
				});
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	/* 	keyToggle(id) {
			this.userlist.forEach(element => {
				if (element.iduser == id) {
					if (element.pswd == 'password') {
						element.pswd = 'text';
						element.pShow = true;
					} else {
						element.pswd = 'password';
						element.pShow = false;
					}
				}
			});
		}
	*/
	textMessageFunc(msgText) {
		this.responseMessage = "Copied to Clipboard";
		setTimeout(() => {
			this.responseMessage = "";
		}, 5000);
	}

	CheckNULL(data) {
		if (data == null)
			return 0;
		else
			return data;
	}

	SaveRates(rdata: any) {
		let str = "";
		rdata.forEach(element => {
			str += element.key + "-" + this.CheckNULL(element.data.usage) + "-" + this.CheckNULL(element.data.recurringmrc) + "-" + this.CheckNULL(element.data.setup) + "-" + this.CheckNULL(element.data.portinnrc) + "-" + this.CheckNULL(element.data.portoutnrc) + "-" + this.CheckNULL(element.data.disconnect) + ",";
		});
		str = str.slice(0, -1);
		this.data.saveRates(str).subscribe(res => {
		});
	}


	/**
	 * To open the wallet recharge dialog
	 */
	adminRecharge(data: any): void {
		this.rechargedata = data;
		this.customerName = data.first_name + " " + data.last_name;
		this.rechargeForm.patchValue({
			idaccount: data.idaccount,
			email: data.email
		});
	}


	/**
	 * To recharge the custom'r wallet manually
	 */
	onRecharge(): any {
		this.submitted = true;
		if (this.rechargeForm.invalid) {
			return
		}
		else {
			if (confirm("Please Confirm Amount: $" + this.rechargeForm.value.amount)) {
				this.data.AdminRecharge(this.rechargeForm.value).subscribe(res => {
					this.submitted = false
					if (res.status == 201) {
						// To re-render the user's data		
						this.GetUsers()
						this.rechargeForm.reset();
						this.rechargeForm.patchValue({
							paymentType: 2
						})
						// this.closebutton.nativeElement.click();
						this.responseMessage = res.message;
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
					else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
					this.closeModal();
				});
			}
			else {
				return
			}
		}
	}

	resetFrm() {
		this.submitted = false
		this.rechargeForm.reset();
		this.rechargeForm.patchValue({
			paymentType: 2,
			idaccount: this.rechargedata.idaccount,
			email: this.rechargedata.email,
			currentDateTime: this.current_datetime()
		})
	}

	closeModal(): void {
		const modalElement: HTMLElement | null =
			this.el.nativeElement.querySelector('.recharge-modal-sm');
		if (modalElement) {
			modalElement.classList.remove('show');
			modalElement.style.display = 'none';
		}

		const modalBackdrop: HTMLElement | null =
			document.querySelector('.modal-backdrop');
		if (modalBackdrop) {
			modalBackdrop.remove();
		}
		document.body.classList.remove('modal-open');
	}


	editdata(tabs: any, iduser: any) {
		switch (tabs) {
			case 1: {
				this.tab1Value = "active";
				this.tab2Value = "";
				this.tab3Value = "";
				this.tab4Value = "";
				break;
			}
			case 2: {
				this.tab1Value = "";
				this.tab2Value = "active";
				this.tab3Value = "";
				this.tab4Value = "";
				break;
			}
			case 3: {
				this.tab1Value = "";
				this.tab2Value = "";
				this.tab3Value = "active";
				this.tab4Value = "";
				break;
			}
			case 4: {
				this.tab1Value = "";
				this.tab2Value = "";
				this.tab3Value = "";
				this.tab4Value = "active";
				break;
			}
		}
		this.data.getSingleUsersForAdmin(iduser).subscribe(res => {
			if (res.status == 200) {
				//this.userlist$.next(res.data[0]);
				this.userProfile = [];
				this.userProfile = res.data[0];
				this.userPro = res.data1[0];
				if (this.userPro.isMobileVerify == 'true') {
					this.styleclsmob = 'green fa fa-check';
					this.vstsmob = 'Verified';
				} else {
					this.styleclsmob = 'red fa fa-times';
					this.vstsmob = 'Not Verified';
				}
				if (this.userPro.isEmailVerify == 'true') {
					this.styleclseml = 'green fa fa-check';
					this.vstseml = 'Verified';
				} else {
					this.styleclseml = 'red fa fa-times';
					this.vstseml = 'Not Verified';
				}
				if (this.userPro.isPlan == 'true') {
					this.styleclspln = 'green fa fa-check';
					this.vstspln = 'Verified';
				} else {
					this.styleclspln = 'red fa fa-times';
					this.vstspln = 'Not Verified';
				}
				if (this.userPro.isAddress == 'true') {
					this.styleclsbadd = 'green fa fa-check';
					this.vstsbadd = 'Verified';
				} else {
					this.styleclsbadd = 'red fa fa-times';
					this.vstsbadd = 'Not Verified';
				}
				if (this.userPro.isCard == 'true') {
					this.styleclscard = 'green fa fa-check';
					this.vstscard = 'Verified';
				} else {
					this.styleclscard = 'red fa fa-times';
					this.vstscard = 'Not Verified';
				}

				if (this.userPro.did == 'yes') {
					this.styleclsdid = 'green fa fa-check';
				} else {
					this.styleclsdid = 'red fa fa-times';
				}
				if (this.userPro.sms == 'yes') {
					this.styleclssms = 'green fa fa-check';
				} else {
					this.styleclssms = 'red fa fa-times';
				}
				if (this.userPro.voice == 'yes') {
					this.styleclsvoice = 'green fa fa-check';
				} else {
					this.styleclsvoice = 'red fa fa-times';
				}
				this.data.getuserheader().subscribe((result) => {
					this.subuserlistheader = result.headers_sub_details1;
				});

				this.data.getCustSubListUsers({ idaccount: this.userProfile.idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
					//this.subCustomer = result.data[0];
					$('#basic-datatableses').dataTable().fnClearTable();
					$('#basic-datatableses').dataTable().fnDraw();
					$('#basic-datatableses').dataTable().fnDestroy();
					$.getScript('./assets/table.js');
					this.subCustomer = result.data[0];
				}, err => {
					console.log(err.message);
				});

			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}

	dismissModal() {
		this.show = false;
		this.addressTab.nativeElement.click();
		this.tab1Value = "active";
		//this.ngOnInit();
	}

	adduser(iduser, type, account, newUser_status) {
		const dialogRef = this.dialog.open(AdddialogComponent, {
			width: '600px', disableClose: true,
			data: { iduser: iduser, type: type, idaccount: account, newUser_status: newUser_status, dialogtype: 1, savetype: 1 }
		});

		dialogRef.afterClosed().subscribe(res => {
			if (res == 1) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
		})

	}

	deleteUser(iduser, idaccount) {
		let sdata = { "iduser": iduser, "sesidaccount": idaccount, "isDeleted": 1 }
		if (confirm("Are you sure you want delete data!")) {
			this.data.onDeleteAccount(sdata).subscribe(result => {
				this.responseMessage = result.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			})
		} else {
			"Cancel!";
		}
	}

	toggle() {
		this.show = !this.show;
		if (this.show) {
			this.buttonName = "Back";
			this.__hedding.next("Add Customer");
			this.ngOnInit();
		}
		else {
			this.buttonName = "Add";
			this.__hedding.next("User List");
			this.ngOnInit();
		}
	}

	ResetFrm() {
		// this.isActiveEnable = '';
		// this.isActiveDisable = '';
	}

	// to update the payment status
	onPaymentStatusChange(event: any, idaccount: any): void {
		this.IDaccount = idaccount;
		this.trustscore = event.target.value;

		this.sendpayment();
	}

	sendpayment() {
		let payLoad = JSON.stringify({
			idaccount: this.IDaccount,
			trustscore: this.trustscore
		})
		this.data.Sendpayment(payLoad).subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}

	BillingValue(val: any) {
		this.billingMessage = "";
		if (val == 0) {
			this.billingMessage = "Do you want to disable for billing";
		}
		if (val == 1) {
			this.billingMessage = "Do you want to enable for billing";
		}
		this.BilValue = val;
	}

	sendAccount(iduser: any, idaccount: any, is_billing: any) {
		this.iduser = iduser;
		this.idaccount = idaccount;
		this.is_billing = is_billing;
		setTimeout(() => {
			if (this.is_billing == '0') {
				// this.isActiveEnable = 'nav-link active show';
				// this.isActiveDisable = '';
				this.billingMessage = "Do you want to disable for billing"
				// this.selectVal = true;
				// this.noSelectVal = false;
				document.getElementById("enableId").click();
			} else {
				// this.isActiveEnable = '';
				// this.isActiveDisable = 'nav-link active show';
				this.billingMessage = "Do you want to enable for billing"
				// this.selectVal = false;
				// this.noSelectVal = true;
				document.getElementById("disableId").click();

			}
			console.log('selectVal', this.selectVal, 'noSelectVal=>', this.noSelectVal, 'isActiveEnable=>', this.isActiveEnable, 'isActiveDisable=>', this.isActiveDisable)
		}, 0);

	}

	downloadPdf(iduser: any, idaccount: any) {
		this.federalStatus = '';
		this.iduser = iduser;
		this.idaccount = idaccount;
		let findedData = this.kycPdfDetails.find(i => i.iduser == this.iduser && i.kyc_verify_status == '1');
		if (findedData != undefined) {
			this.showKycPdf = findedData.value
		}
		else {
			this.showKycPdf = false
		}
		// let findUserCardPdf = this.userlistFull.find(j => j.iduser == this.iduser);
		// if (findUserCardPdf != undefined) {
		// 	this.showcardPdf = findUserCardPdf.card_pdf
		// }
		// else {
		// 	this.showcardPdf = false
		// }
		let findCardData = this.cardPdfDetails.find(x => x.idaccount == this.idaccount && x.card_pdf !== '');
		if (findCardData != undefined) {
			this.showcardPdf = findCardData.card_pdf;
		}
		else {
			this.showcardPdf = false;
		}

		let findfederaldData = this.federalPDF.find(k => k.iduser == this.iduser && k.federal_status == '1');
		if (findfederaldData != undefined) {
			this.showfederalPdf = findfederaldData.pdf;
			this.federalStatus = findfederaldData.federal_status;

		}
		else {
			let findrejectfederaldData = this.federalPDF.find(j => j.iduser == this.iduser && j.federal_status == '4');
			if (findrejectfederaldData != undefined) {
				this.showfederalPdf = findrejectfederaldData.pdf;
				this.federalStatus = findrejectfederaldData.federal_status;

			}
			else {
				this.showfederalPdf = false;
			}
		}


	}

	billingEnable() {
		let bVal = this.BilValue
		let data = {
			bVal: bVal,
			idaccount: this.idaccount
		}
		this.data.billingEnable(data).subscribe((res) => {
			if (res.status == 201) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	// @to edit the record
	editRow(data: any): void {
		data["dialogtype"] = 2;
		data["savetype"] = 1;
		const dialogRef = this.dialog.open(AdddialogComponent, {
			width: '600px', disableClose: true,
			data
		});

		dialogRef.afterClosed().subscribe(res => {
			if (res == 1)
				this.data.getUsers("main").subscribe(res => {
					this.userlist = res.data[0];
				});
		});
	}

	change() {
		this.__supplier.next(this.toggle_cust);
		this.toggle_cust = !this.toggle_cust;
		if (this.toggle_cust) {
			this.toggleValue = "Customer";
			this.show1 = true;
		}
		else {
			this.toggleValue = "Supplier";
			this.show1 = false;
		}
		if (this.toggle_cust) {
			this.__hedding.next("Add Customer");
		}
		else {
			this.__hedding.next("Add Supplier");
		}
	}

	onUpload(event) {
	}

	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + "01";
	}

	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + "-" + month + "-" + day //+ " " + hour + ":" + minute + ":" + second;
	}

	showAllCampData(idaccount, iduser, email) {
		this.user_id = iduser;
		this.account_id = idaccount;
		this.email = email;
		this.checkdelete = false;
		this.returnsms = false;
		let payLoad = JSON.stringify({
			idaccount: idaccount,
			iduser: iduser
		})
		// get campaign
		this.campaigns = '';
		this.data.getCampaignForReview(payLoad).subscribe(result => {
			if (result.status == 200) {
				this.campaigns = result.data.length;
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		// get plan
		this.planname = '';
		this.data.getSubscriptionPlan(payLoad).subscribe(result => {
			if (result.status == 200) {
				this.tmplist = result.data[0];
				if (this.tmplist != undefined) {
					switch (this.tmplist.idtariff) {
						case 142:
						case "142":
							{
								this.planname = "LAUNCH PLAN";
								this.price = "Pay As You Go"
							}
							break;
						case 143:
						case "143":
							{
								this.planname = "GROWTH PLAN";
								this.price = "99";
								this.ismonthly = true;
							}
							break;
						case 145:
						case "145":
							{
								this.planname = "SCALE PLAN";
								this.price = "2499";
								this.ismonthly = true;
							}
							break;
						default:
							this.planname = "CUSTOM PLAN";
							break;
					}
				}
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});

		//Balance
		this.balance = '';
		this.data.getcustBalance({ idaccount: idaccount, iduser: iduser }).subscribe(response => {
			if (response.status == 200) {
				if (response.data.length > 0) {
					this.balance = response.data[0].balance;
				}
			}
			else {
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		//subCustomer
		this.userlength = '';
		this.data.getSubListUsers({ idaccount: idaccount, iduser: iduser, type: "profile" }).subscribe((result: any) => {
			if (result.status == 200) {
				this.userlength = result.data[0].length;
			}
		});

		// Dids
		this.dids = [];
		this.filterForm = this.fb.group({
			selectedUser: this.user_id + '-' + this.account_id
		});
		this.dids[0] = 'comming...';
		this.data.custDidsCount(this.filterForm.value).subscribe(res => {
			if (res.status == 200) {
				this.dids = res.data.length;
			}
		});

	}

	callCheck() {
		this.returnsms = false;
	}

	resetCheckbox() {
		this.checkdelete = false;
	}
	serviceSuspend(idaccount){
		this.data.suspendAllServices(idaccount).subscribe(res => {});
	}

	onYes() {
		if (!this.checkdelete) {
			this.returnsms = true;
			return;
		}
		else {
			this.data.getSingleUsersForAdmin(this.user_id).subscribe(res => {
				if (res.status == 200) {
					this.userdata = res.data1[0];
					this.isLoading = true;
					if ((this.userdata.isAddress == 'true' && this.userdata.isEmailVerify == 'true') && (this.userdata.isMobileVerify == 'true' && this.userdata.isPlan == 'true')) {
						this.isDeleted = 1;
						this.data1 = {
							sesiduser: this.user_id,
							sesidaccount: this.account_id,
							isDeleted: this.isDeleted,
							selectedoption: this.selectedOption,
							checkbox: this.sendMail,
							email: this.email
						}
						this.deleteCustomeAc();
					}
					else {
						this.isDeleted = 2;
						this.data1 = {
							sesiduser: this.user_id,
							sesidaccount: this.account_id,
							isDeleted: this.isDeleted,
							selectedoption: this.selectedOption,
							checkbox: this.sendMail,
							email: this.email
						}
						this.deleteFinalAc();
					}
					this.serviceSuspend(this.userdata.idaccount);
				}
			});
		}
	}
	deleteCustomeAc() {
		this.data.onDeleteAccount(this.data1).subscribe((res) => {
			if (res.status == 201) {
				document.getElementById("DeleteAccountModal").click();
				if (res.data && res.data[0].idinvoice) {
					this.PdfData(res);
					setTimeout(() => {
						window.location.reload();
					}, 5000);
				} else {
					window.location.reload();
				}
				// this.ngOnInit();
				this.responseMessage = res.message
				setTimeout(() => {
					this.responseMessage = "";
					// window.location.reload();
				}, 3000);
			}
			else {
				this.errMessage = res.message
				this.isLoading = false;
				setTimeout(() => {
					this.errMessage = "";
				}, 4000);
			}
		});
	}
	deleteFinalAc() {
		this.data.onFinalDeleteAccount(this.data1).subscribe((res) => {
			if (res.status == 201) {
				this.isLoading = false;
				// document.getElementById("DeleteAccountModal").click();
				this.deleteaccountmodal.nativeElement.click();
				// this.ngOnInit();
				window.location.reload();
				this.responseMessage = "You have successfully deleted this account!";
				setTimeout(() => {
					this.responseMessage = "";
				}, 3000);
			}
		});
	}

	getAmount(e: any) {
		this.amount = e.target.value;
		this.rechargeForm.patchValue({
			amount: this.amount
		});
		let data = e.target.value;
		e.target.value = (data.indexOf(".") >= 0) ? (data.substr(0, data.indexOf(".")) + data.substr(data.indexOf("."), 3)) : data;
		return;
	}

	getKycstatus(data: any, iduser, idaccount) {
		this.kycStatus = data;
		this.KYCiduser = iduser;
		this.Kycidaccount = idaccount;
	}


	pdfReview(iduser, idaccount) {
		this.router.navigate(['kyc/kyc-details', iduser + '-' + idaccount])
			.then(() => {
				location.reload();
			})
	}

	federalReview(iduser, idaccount) {
		this.router.navigate(['federal/federal-details', iduser + '-' + idaccount])
			.then(() => {
				location.reload();
			})
	}

	/*Kyc Verify function*/
	verifyKyc() {
		let data = {
			idaccount: this.Kycidaccount,
			iduser: this.KYCiduser
		}
		this.data.kycVerify(data).subscribe((res) => {
			if (res.status == 201) {
				this.kycStatus = 1;
				this.responseMessage = res.message;
				setTimeout(() => {
					document.getElementById("closeKycModal").click();
					this.responseMessage = "";
				}, 5000);
				window.location.reload();
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.responseMessage = err.message;
			setTimeout(() => {
				this.responseMessage = "";
			}, 5000);
		});
	}

	// To dawnload all pdf
	downloadPDF(e) {
		fetch(e).then(resp => resp.arrayBuffer()).then(resp => {
			// set the blog type to final pdf
			const file = new Blob([resp], { type: 'application/pdf' });
			// process to auto download it
			const fileURL = URL.createObjectURL(file);
			const link = document.createElement('a');
			link.href = fileURL;
			link.download = e.split('federal_pdf/')[1] || e.split('kyc_pdf/')[1] || e.split('card_pdf/')[1];
			link.click();
		});
	}
	suspendedDialog(featureServiceData, idaccount): void {
		const dialogRef = this.dialog.open(SuspendedServicesComponent, {
			width: '50px',
			data: { serviceData: featureServiceData, idaccount: idaccount }
		});
		dialogRef.afterClosed().subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
	filterByUser(e) {
		this.custoDfilter.patchValue({
			selectedUser: e.target.value
		});
	}
	showAccountfilter() {
		if (this.showFilter == false) {
			this.showFilter = true;
		}
		else {
			this.showFilter = false;
		}
	}
	OnchangeTab(id:any) {
		this.id1=id
	
		if (this.isIdTariffRoute || this.isIdServiceRoute || this.tabb) {
			this.router.navigate(['/user/user-details/tab/'+this.id1]);
		}
	}
	applyUserFilter() {
		this.submitted = true;
		if (this.filterUser.invalid) {
			return false;
		}
		else {
			if (this.filterUser.value.to_date || this.filterUser.value.from_date ||
				(this.filterUser.value.service && this.filterUser.value.service.length > 0) || (this.filterUser.value.regTariff && this.filterUser.value.regTariff.length > 0) || (this.filterUser.value.idaccount && this.filterUser.value.idaccount.length > 0)) {
				const filterValues = Object.values(this.filterUser.value);
				const allFieldsEmpty = filterValues.every(value => value === "");
				this.data.UserFilter(JSON.stringify(this.filterUser.value)).subscribe((res) => {
					if (res.status === 201) {
						$('#basic-datatablesUS').dataTable().fnClearTable();
						$('#basic-datatablesUS').dataTable().fnDraw();
						$('#basic-datatablesUS').dataTable().fnDestroy();
						$.getScript('./assets/table.js');
					  	this.userlistFull = res.data
						.filter(user => user.is_deleted === 0) 
						.sort((a, b) => new Date(b.created).getTime() - new Date(a.created).getTime()) 
						.map(user => ({
						  ...user,
						  reloaduserlist: `${user.san} - ${user.first_name} ${user.last_name}`,
						  color: user.is_billing == '0' ? 'green' : 'red',
						  msg: user.is_billing == '0' ? 'Billing is Enabled' : 'Billing is Disabled',
						  onboardingstatus: this.getOnboardingStatus(user),
						  tooltp: this.getOnboardingTooltip(user)
						})).filter((user, index, self) => 
							index == self.findIndex(u => u.san == user.san)
						);
				  
					 
				  
					  this.responseMessage = allFieldsEmpty ? "" : res.message;
					  setTimeout(() => (this.responseMessage = ""), 5000);
					} else {
					  this.errMessage = res.message;
					  setTimeout(() => (this.errMessage = ""), 5000);
					}
				  });
				  
			} else {
				this.errMessage = "Please Enter atleast 1 field!";
				setTimeout(() => {
					this.errMessage = "";
				}, 3000);
			}

		}
	}

	messageshow() {
		const from_date = this.filterUser.get('from_date').value;
		const to_date = this.filterUser.get('to_date').value;
		const currentDate = new Date();

		// Reset previous errors
		this.filterUser.get('from_date').setErrors(null);
		this.filterUser.get('to_date').setErrors(null);

		if (!to_date && !from_date) {
			// Both dates are not selected, no need to set any errors
			return;
		}

		if (to_date) {
			if (new Date(to_date) > currentDate) {
				this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
				return;
			}
		}

		if (from_date) {
			if (new Date(from_date) > currentDate) {
				this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
				return;
			}
		}

		if (!from_date && to_date) {
			this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please Select From Date' });
			return;
		}

		if (from_date && !to_date) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please Select To Date' });
			return;
		}

		if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
			this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		}
	}

	resetUserFilter() {
		this.filterUser.reset();
		Object.keys(this.filterUser.controls).forEach(key => {
			this.filterUser.get(key).setValue('');
		})
		this.router.navigate(['/user/user-details']);
		this.GetUsers();
	}

	truncatenotification(subject: string, maxLength: number): string {
		if (!subject) {
			return ''; // or any fallback string
		}
		return subject.length > maxLength ? subject.substring(0, maxLength) + '...' : subject;
	}



	truncatenotification1(subject: string, maxLength: number): string {
		if (!subject) {
			return ''; // or any fallback string
		}
		return subject.length > maxLength ? subject.substring(0, maxLength) + '...' : subject;
	}

	onRadioChange(value: string): void {
		this.selectedOption = value;
	}
	Resetradio() {
		if (!this.checkdelete) {
			this.returnsms = true;
			return;
		} else {
			this.accountreviwmodal.nativeElement.click();
			const deleteaccount = document.getElementById('deleteaccount');
			$(deleteaccount).modal('show');
			this.selectedOption = '';
			this.sendMail = true;

		}
	}
	onCheckboxChange(event: Event): void {
		const inputElement = event.target as HTMLInputElement;
		this.sendMail = inputElement.checked;
	}
	PdfData(res: any) {
		this.currentInvoice = res.data;
		this.billingAddress = res.billingAddress;
		this.Idinvoice = this.currentInvoice[0].idinvoice
		this.previousDue = res.previousDue;
		this.totalamt = res.totalamt && res.totalamt ? res.totalamt : 0;
		this.taxes = res.taxes && res.taxes != 'null' ? res.taxes : 0;
		this.remainingWallet = res.remainingWallet && res.remainingWallet != 'null' ? res.remainingWallet.toFixed(2) : '0.00';
		this.finalCharge = res.finalCharge && this.finalCharge != 'null' ? res.finalCharge : '0.00';
		this.totalDue = res.totaldue;
		this.getextradidMrc = res.getextradidMrc.cost ? res.getextradidMrc.cost : 0;
		this.getextradidMrcQty = res.getextradidMrc.did_qty ? res.getextradidMrc.did_qty : 0;
		this.totalAccSummary = (parseFloat(res.getextradidMrc.cost) || 0) + (parseFloat(this.taxes) || 0);
		this.status = true;
		this.body.push(
			[{ text: 'Item', style: 'header3' }, { text: 'Quantity', style: 'header3' }, { text: 'Total', style: 'header3' }],
			[{ text: 'Usage/Event Based Charges:\n\nCalling Activity:\n\nCalling/Inbound:', style: 'header3' }, '', ''],
		);
		this.currentInvoice.forEach(data => {
			if (data.category == 1 && data.subcategory == 1) {
				this.invoiceData1_1.push(data);
				this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
			}
		});
		this.body.push(
			[{ text: '\nCalling/Outbound:', style: 'header3' }, '', ''],
		);
		this.currentInvoice.forEach(data => {
			if (data.category == 1 && data.subcategory == 2) {
				this.invoiceData1_2.push(data);
				this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
			}
		});
		this.body.push([{ text: '\nMessaging Activity:\n\nSMS/Inbound:', style: 'header3' }, '', ''],);
		this.currentInvoice.forEach(data => {
			if (data.category == 2 && data.subcategory == 1) {
				this.invoiceData2_1.push(data);
				this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
			}
		});
		this.body.push([{ text: '\nSMS/Outbound:', style: 'header3' }, '', ''],);
		this.currentInvoice.forEach(data => {
			if (data.category == 2 && data.subcategory == 2) {
				this.invoiceData2_2.push(data);
				this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
			}
		});
		this.body.push([{ text: '\nInformation Services Activity:', style: 'header3' }, '', ''],);
		this.currentInvoice.forEach(data => {
			if (data.category == 8) {
			this.invoiceData3_1.push(data);
			this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}\n`],)
			}
		});
		this.body.push([{ text: '\nNew One-Time and Monthly Recurring Activity:\n Numbering and Campaign Activity:\n\nNumbers:', style: 'header3' }, '', ''],);

		this.currentInvoice.forEach(data => {
			if (data.category == 3 && data.subcategory == 1 || (data.category == 3 && data.subcategory == 0) || (data.category == 3 && data.subcategory == 4) || (data.category == 3 && data.subcategory == 5) || (data.category == 3 && data.subcategory == 6) || (data.category == 3 && data.subcategory == 7) || (data.category == 3 && data.subcategory == 8)) {
				this.invoiceData3.push(data);
				this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
			}
		});
		this.body.push([{ text: '\nA2P Campaign:', style: 'header3' }, '', ''],);
		this.currentInvoice.forEach(data => {
			if (data.category == 4) {
				this.invoiceData4.push(data);
				this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
			}
		})
		this.body.push([{ text: '\nSubscription:', style: 'header3' }, '', ''],);
		this.currentInvoice.forEach(data => {
			if (data.category == 10) {
				this.invoiceData10.push(data);
				this.body.push([{ text: `${data.label}`, style: 'subcategory' }, `${data.value && data.value != 'null' ? data.value : '0'}`, `${data.cost && data.cost != 'null' ? data.cost : '0.00'}`],)
			}
		})
		if (Array.isArray(res.data) && res.data.length > 0) {
			this.date = this.datePipe.transform(this.currentInvoice[0].created_at, "MM-dd-yyyy");
		}
		this.showModel = true;
		this.createPDf();
	}

	createPDf() {
		this.isLoading = false;
		this.deleteaccountmodal.nativeElement.click();
		var target = environment.SERVER + "sendInvoicePdf";
		var _http = this._http
		let payload = JSON.stringify({
			idaccount: this.account_id,
			iduser: this.user_id,
			invoice: this.Idinvoice,
			checkbox: this.sendMail,
		});
		const documentDefinition = {
			content: [
				{
					columns: [
					  {
						width: '45%',
						text: 'Final Invoice',
						style: 'mr'
					  },
					  {
						// if you specify both width and height - image will be stretched
						image: 'data:image/png;base64,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\n\n',
						width: 250,
						height: 65
					  },
					],
					// optional space between columns
					columnGap: 50
				  },
				  {
					columns: [
					  {
						// auto-sized columns have their widths based on their content
						width: '87%',
						text: 'Address',
						style: 'header1',
					  },
		  
					  {
						// auto-sized columns have their widths based on their content
						width: '13%',
						text: 'Invoice No',
						style: 'header1'
					  },
					],
				  },
				  {
					columns: [
					  {
						// auto-sized columns have their widths based on their content
						width: '75%',
						text: '3 Centerpointe Dr # 190',
		  
					  },
		  
					  {
						// auto-sized columns have their widths based on their content
						width: '25%',
						text: `${this.billingAddress.invoice_number}`,
						style: 'anotherStyle'
					  },
					],
				  },
				  {
					columns: [
					  {
						width: '100%',
						text: 'Lake Oswego, OR 97035\n\n'
					  }
					]
				  },
				  {
					columns: [
					  {
						// auto-sized columns have their widths based on their content
						width: '30%',
						text: 'Billed To',
						style: 'header1',
					  },
					  {
						// auto-sized columns have their widths based on their content
						width: '22%',
						text: 'SAN',
						style: 'header1',
					  },
					  {
						// auto-sized columns have their widths based on their content
						width: '28%',
						text: 'Customer Name',
						style: 'header1',
					  },
		  
					  {
						// auto-sized columns have their widths based on their content
						width: '20%',
						text: 'Invoice Date',
						style: 'header1'
					  },
					],
					// optional space between columns
					columnGap: 50
				  },
				  {
					columns: [
					  {
						// auto-sized columns have their widths based on their content
						width: '30%',
						text: `${this.billingAddress.address1}`,
		  
					  },
					  {
						// auto-sized columns have their widths based on their content
						width: '22%',
						text: `${this.billingAddress.san}`,
		  
					  },
					  {
						// auto-sized columns have their widths based on their content
						width: '28%',
						text: `${this.billingAddress.customer_name}`,
		  
					  },
		  
					  {
						// auto-sized columns have their widths based on their content
						width: '20%',
						text: `${this.date}`,
						style: 'anotherStyle',
					  },
					],
				  },
				  {
					columns: [
					  {
						width: '100%',
						text: `${this.billingAddress.city}`
					  }
					]
				  },
				  {
					columns: [
					  {
						width: '100%',
						text: `${this.billingAddress.country}, ${this.billingAddress.postal_code}`
					  }
					]
				  },
				  {
					columns: [
					  {
						width: '100%',
						text: `Phone : ${this.billingAddress.contact}`
					  }
					]
				  },
				  {
					columns: [
					  {
						width: '100%',
						text: `${this.billingAddress.email}\n\n`
					  }
					]
				  },
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
				{ text: '', style: 'space' },
				{ text: 'Final Account Summary', style: 'header2' },
				{ text: '', style: 'space' },
				{
					columns: [
						{
							width: '50%',
							text: 'Item',
							style: 'header',
						},

						{
							width: '30%',
							text: 'Quantity',
							style: 'header'
						},
						{
							width: '20%',
							text: 'Total',
							style: 'header'
						}
					],
				},
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
				{ text: '', style: 'space' },
				{
					columns: [
						{

							width: '50%',
							text: 'Previous Balance Due',
						},

						{
							width: '30%',
							text: ''
						},
						{
							width: '20%',
							text: `${this.previousDue !== undefined && this.previousDue !== null && this.previousDue ? this.previousDue : '0.00'}`
						}
					],
				},
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
				{ text: '', style: 'space' },
				{
					columns: [
						{

							width: '50%',
							text: 'Final Charges',
						},

						{
							width: '30%',
							text: `${this.getextradidMrcQty}`
						},
						{
							width: '20%',
							text: `${(this.getextradidMrc.toFixed(2))}`
						}
					],
				},
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
				{ text: '', style: 'space' },
				{
					columns: [
						{

							width: '50%',
							text: '',
						},

						{
							width: '30%',
							text: 'Taxes'
						},
						{
							width: '20%',
							text: `${this.taxes}`
						}
					],
				},
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
				{ text: '', style: 'space' },
				{
					columns: [
						{

							width: '50%',
							text: '',
						},

						{
							width: '30%',
							text: 'Total Due'
						},
						{
							width: '20%',
							text: `${(this.totalAccSummary).toFixed(2)}`
						}
					],
				},
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
				{ text: '', style: 'space1' },
				{ text: '\nFinal Recurring Charges', style: 'header2' },
				{ text: '', style: 'space' },
				{
					columns: [
						{
							width: '50%',
							text: 'Item',
							style: 'header',
						},

						{
							width: '30%',
							text: 'Quantity',
							style: 'header'
						},
						{
							width: '20%',
							text: 'Total',
							style: 'header'
						}
					],
				},
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 2, lineColor: 'black' }] },
				{ text: '', style: 'space' },
				{
					columns: [
						{

							width: '50%',
							text: 'Numbers:', style: 'number',
						},

						{
							width: '30%',
							text: ''
						},
						{
							width: '20%',
							text: ''
						}
					],
				},
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
				{
					columns: [
						{
							width: '50%',
							text: 'Remaining Wallet',
						},
						{
							width: '30%',
							text: '0'
						},
						{
							width: '20%',
							text: `${this.remainingWallet !== undefined && this.remainingWallet !== null && this.remainingWallet ? this.remainingWallet : '0.00'}`
						}
					]
				},
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
				{
					columns: [
						{
							width: '50%',
							text: 'Extra Did MRC',
						},
						{
							width: '30%',
							text: `${this.getextradidMrcQty}`
						},
						{
							width: '20%',
							text: `${(this.getextradidMrc).toFixed(2)}`
						}
					]
				},
				{ text: '', style: 'space' },
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.5, lineColor: '#b6b2b2' }] },
				{ text: '', style: 'space' },
				{
					columns: [
						{
							width: '80%',
							text: `\nPlatform Activity Charges\n\n`,
							style: 'header1',
						}
					]
				},
				{
					layout: 'lightHorizontalLines',
					table: {
						headerRows: 1,
						widths: ['50%', "30%", '20%'],

						body: this.body,
					}
				},
				{ canvas: [{ type: 'line', x1: 0, y1: 0, x2: 520, y2: 0, lineWidth: 0.1, lineColor: '#b6b2b2' }] },
				{
					columns: [
						{
							width: '80%',
							text: 'Total Amount(USD):',
							style: 'anotherStyle1'
						},
						{
							width: '20%',
							text: `$ ${(+this.totalamt + +this.totalAccSummary).toFixed(2)}\n\n`,
							style: 'anotherStyle1'
						}
					]
				},
				{
					columns: [
					  {
						width: '67%',
						text: 'Payment Information',
						style: 'header1'
					  },
					  {
						width: '33%',
						text: 'Questions regarding this note?\n\n',
						style: 'header2'
					  }
					]
				},
				  // { text: ' ' },
				{
					columns: [
					  {
						width: '45%',
						text: 'One-time credit card payments may be made via the Signalmash portal. Automated payment controls and account reminders can also be accessed in the My Profile section of the Signalmash portal.\nBank Wire / ACH payments - please contact us at billing@signalmash.com for ACH and/or Wire Transfer instructions.',
						style: 'payment'
					  },
		  
					  {
						width: '20%',
						text: ' ',
		  
					  },
					  {
						width: '35%',
						text: 'Contact: billing@signalmash.com',
						style: 'payment',
					  }
					]
				},
			],

			styles: {
				header: {
					fontSize: 12,
					bold: true,
					color: '#000000',
					padding: [5, 5, 5, 0]
				},
				header1: {
					fontSize: 13,
					bold: true,
					color: '#0339fc'
				},
				header2: {
					fontSize: 12,
					bold: true,
					color: '#0339fc'
				},
				column: {
					background: '#0339fc',

				},
				header3: {
					fontSize: 12,
					bold: true,
					padding: [5, 5, 5, 0]
				},
				subcategory: {
					margin: [18, 0, 0, 0],
				},
				note: {
					fontSize: 7,
				},
				date: {
					color: '#0339fc'
				},
				payment: {
					fontSize: 10,
				},
				mr: {
					fontSize: 18,
					bold: true,
					color: '#0339fc',
					margin: [0, 18, 0, 0],
				},
				anotherStyle: {
					alignment: 'right',
					bold: 'true'
				},
				anotherStyle1: {
					fontSize: 14,
					bold: 'true',
					color: '#0339fc',
					paddingTop: '20px',
				}
			}
		};
		const pdfDocGenerator = pdfMake.createPdf(documentDefinition);
		pdfDocGenerator.getBlob((blob) => {
			const pdfBlob = new Blob([blob], { type: 'application/pdf' });
			const fd = new FormData();
			fd.append("UPLOAD", pdfBlob, 'pdf');
			fd.append("data", payload);
			const req = new HttpRequest('POST', target, fd, {
				reportProgress: true
			});
			_http.request(req).subscribe((res: any) => {

			})
		});
	}

	addNote(data:any): void {
		this.router.navigate([`/user/addnote/${data.idaccount}/${data.iduser}`]);  
	}
	
	ngOnDestroy() {
		this.informationmodal.nativeElement.click();
		this.modalpdf.nativeElement.click();
		this.addamountmodule.nativeElement.click();
		this.billingMessagemodal.nativeElement.click();
		this.accountreviwmodal.nativeElement.click();
		this.deleteaccountmodal.nativeElement.click();
	}

}
