import { Component, OnInit } from '@angular/core';
import { Validators, FormBuilder, FormGroup } from '@angular/forms';
import { Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { WebhookService } from '../webhook.service';
import { IDropdownSettings, } from 'ng-multiselect-dropdown';
declare var $: any;
@Component({
  selector: 'app-webhook',
  templateUrl: './webhook.component.html',
  styleUrls: ['./webhook.component.css']
})
export class WebhookComponent extends AppComponentClass<any, any> {
  responseMessage: any;
  errMessage: any;
  webHookCategory: any;
  EventType: any;
  webhookForm: FormGroup;
  webHookdetails: any[];
  submitted: boolean = false;
  webhookid: any;
  userType: any;
  users: any = [];
  selectedUser: any;
  show: boolean = false;
  webHookText1: any = 'Webhook Endpoint';
  webHookText: any = 'Add Webhook Endpoint';
  webHookButton: any = 'Submit';
  showForm: boolean = true;
  message: boolean = true;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  selectedItem: any = [];
  name_with_iduser: any = [];
  userss: any = [];

  constructor(public fb: FormBuilder, public router: Router,
    public data: WebhookService, private userService: UsermanagementService,) {
    super(data, router, fb);
  }

  ngOnInit(): void {
    let isLoggedIn = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = isLoggedIn.type;


    this.webhookForm = this.fb.group({
      webhook_id: [''],
      webhookCategory: ['', Validators.required],
      eventType: [''],
      webhookUrl: ['', [Validators.required,
      Validators.pattern("^(?=.*?[a-z A-Z])(?=.*?[a-z A-Z])(?=.*?[0-9  !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~€£¥₩])(?=.*?[a-z A-Z 0-9]).{8,}$")]]
      // messageUrl:['']
    });

    this.data.getWebhookCategory().subscribe(res => {
      if (res.status == 200) {
        this.webHookCategory = res.data;
      }
    });
    this.getWebHookList('');

    // this.userService.getUsers("main").subscribe(res => {
    // 	if (res.status == 200) {
    // 		this.users = res.data[0];   
    //     this.users.sort((a, b) => {
    //       return a.san - b.san;
    //     });     
    // 	}
    // 	else {
    // 		this.errMessage = res.message;
    // 		setTimeout(() => {
    // 			this.errMessage = "";
    // 		}, 5000);
    // 	}
    // }, err => {
    // 	this.errMessage = err.message;
    // 	setTimeout(() => {
    // 		this.errMessage = "";
    // 	}, 5000);
    // });
    this.dropdownSettings = {
      singleSelection: true,
      idField: 'iduser',
      textField: 'Name_with_iduser',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };


    this.gettlistusers();
  }

  gettlistusers() {
    this.userService.getUsers("main").subscribe(res => {
      if (res.status == 200) {
        this.users = res.data[0];
        this.users.sort((a, b) => {
          return a.san - b.san;
        });
        this.users.forEach(element => {
          const fullName = `${element.first_name} ${element.last_name}`
          this.name_with_iduser.push({ iduser: element.iduser + '-' + element.idaccount, Name_with_iduser: fullName + '-' + element.san });
        })
        this.userss = this.name_with_iduser
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  onItemSelect(item: any) {
    console.log(item);
  }

  getWebHookList(data?: any) {
    this.data.getWebhook(data).subscribe(res => {
      if (res.status == 200) {
        $('#basic-datatablesRs').dataTable().fnClearTable();
        $('#basic-datatablesRs').dataTable().fnDraw();
        $('#basic-datatablesRs').dataTable().fnDestroy();
        $.getScript('./assets/table.js');
        this.webHookdetails = res.data;
      }
    });
  }

  showFilter() {
    if (this.show == false) {
      this.show = true;
    }
    else {
      this.show = false;
    }
  }

  filterByUser(ev: any) {
    this.selectedUser = ev.target.value;
  }

  Addfilter(){
    if (this.selectedItem.length > 0) {
      this.getWebHookList(this.selectedItem[0].iduser)
    }
    else{
      this.errMessage = "Please Select User";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
    }
  }

  onReset(){
    // this.ngOnInit();
    this.submitted = false;
    this.selectedUser = '';
    this.name_with_iduser = [];
    this.selectedItem = []
    this.getWebHookList('');
  }

  getEventType(data) {
    this.data.geteventType(data).subscribe(res => {
      if (res.status == 200) {
        this.EventType = res.data;
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }
  onSelectCategory(event: any) {
    let data = event.value;
    this.getEventType(data);
  }

  Onreset() {
    this.webHookText = 'Add Webhook Endpoint';
    this.webHookButton = 'Submit';
    this.webhookForm.patchValue({
      webhook_id: '',
      webhookCategory: '',
      eventType: '',
      webhookUrl: '',
    });
    this.webhookid = '';
    this.submitted = false;
    this.webhookForm.reset();
    this.webhookForm.get('webhookCategory').setValue('');
  }

  onSubmit() {
    if (this.webhookForm.invalid) {
      this.submitted = true;
    }
    else {
      if (this.webhookid && this.webhookid !== '') {
        this.webHookdetails = [];
        this.data.updateWebhook(this.webhookForm.value).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
          this.getWebHookList('');
        });
      }
      else {
        this.webHookButton = 'Submit';
        this.webHookdetails = [];
        this.data.addWebhook(this.webhookForm.value).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.submitted = false;
            this.onReset();
            this.showForm = false;
            setTimeout(() => this.showForm = true);
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
          this.getWebHookList('');
        });
      }
    }
  }

  Updatewebhook(id?: any) {
    this.webHookText = 'Edit Webhook Endpoint';
    this.webHookButton = 'Update';
    let singlewebHook = this.webHookdetails.find(el => el.webhook_id == id);
    this.getEventType(singlewebHook.webhookCategory);
    this.webhookForm.patchValue({
      webhook_id: singlewebHook.webhook_id,
      webhookCategory: singlewebHook.webhookCategory,
      eventType: singlewebHook.eventType,
      webhookUrl: singlewebHook.webhookUrl,
    });
    this.webhookid = singlewebHook.webhook_id;
  }

  deleteWebhook(data?: any) {
    if (confirm("Are you sure you want delete data!")) {
      this.data.deleteWebhook(data).subscribe(res => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          this.ngOnInit();
          this.webHookText = 'Add Webhook Endpoint';
          this.webHookButton = 'Submit';
          this.webhookid = '';
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    }

  }
  truncatenotification(subject: string, maxLength: number): string {
    if (subject && subject.length > maxLength) {
      return subject.substring(0, maxLength) + '...';
    } else {
      return subject;
    }
  }
}

