import { Component, OnInit } from '@angular/core';
import { AgentserviceService } from '../agentservice.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { FormBuilder, FormGroup } from '@angular/forms';
import { log } from 'console';
declare var $: any;

@Component({
  selector: 'app-channel-requests',
  templateUrl: './channel-requests.component.html',
  styleUrls: ['./channel-requests.component.css']
})
export class ChannelRequestsComponent implements OnInit {
  public ChannelForm: FormGroup;
  channelList: any =[];
  responseMessage: any = "";
  userType: any;
  show: boolean =false;
  users: any = [];
  errMessage: any;
  sesiduser: any;
  idaccount: any;
  iduser: any;
  channelID: any = " ";
  channelLists: any=[];
  selectedUser: any;
  channelStatus: any;
  channelApprove: boolean;
  channelReject: boolean;

  constructor(private data: AgentserviceService, private userService: UsermanagementService,public fb: FormBuilder) { }

  ngOnInit(): void {

    this.getUser();

    let isLoggedIn = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = isLoggedIn.type;      
    this.ChannelForm = this.fb.group({
      channel_id : [''],
      idaccount : [''],
      status : [''],
      current_in_channel_limit:[''],
      current_out_channel_limit:[''],
      request_in_channel_limit: [''], 
      request_out_channel_limit: [''],
    })  
    
    this.selectedUser = '';
    this.getChannelRequest(this.selectedUser);

  }
  getUser(){
    this.userService.getUsers("main").subscribe(res => {
			if (res.status == 200) {
				this.users = res.data[0];             
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
  }

  getChannelRequest(data?:any){

      this.data.getRequestChannelList(data).subscribe(res => {
        if (res.status == 200) {
          $('#basic-datatables13').dataTable().fnClearTable();
          $('#basic-datatables13').dataTable().fnDraw();
          $('#basic-datatables13').dataTable().fnDestroy();
          $.getScript('./assets/table.js');
          this.channelList = res.data;
          this.channelList.forEach(element => {
            if(element.status == 1){
              element.status_name = "Approved";
            }else if(element.status == 2){
              element.status_name = "Rejected"
            }
            else{
              element.status_name = "New Request"
            }
          });
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);      
        }
        else{
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      });
    
  }

  showFilter(){
    if(this.show==false){
      this.show=true;
    }
    else{
      this.show=false;
    }
  }  

  filterByUser(ev:any){
    let sUser:any = ev.target.value;
    this.selectedUser = sUser.split('-')[1];
  }
  applyFilter(){
    if (this.selectedUser !== '' && this.selectedUser !== undefined) {
    $('#basic-datatables13').dataTable().fnClearTable();
    $('#basic-datatables13').dataTable().fnDraw();
    $('#basic-datatables13').dataTable().fnDestroy();
    $.getScript('./assets/table.js'); 
    this.channelList =[];
    this.getChannelRequest(this.selectedUser);
  } else {
      this.errMessage = 'Please Select User';
      setTimeout(() => {
        this.errMessage = '';
      }, 5000);
    }
  }

  onReset(){
   // window.location.reload();
    this.ngOnInit();
    this.selectedUser = '';
    this.getChannelRequest(this.selectedUser);
  }

  showdata(data: any) {
    this.channelID = data.channel_id;
    if(data.status == 1){
      this.channelApprove = true;
      this.channelReject = false;
    }
    if(data.status == 2){
      this.channelApprove = false;
      this.channelReject = true;
    }
    if(data.status !== 1 && data.status !== 2){
      this.channelApprove = false;
      this.channelReject = false;
    }
    if (this.channelID) {
      this.ChannelForm.patchValue({
        channel_id : this.channelID,
        idaccount : data.idaccount,
        current_in_channel_limit : data.current_in_channel_limit,
        current_out_channel_limit : data.current_out_channel_limit,
        request_in_channel_limit : data.request_in_channel_limit,
        request_out_channel_limit : data.request_out_channel_limit, 
      });
    }
  }


   /*Approve and Reject Channel function // 1 => Approve and 2 => Reject*/
  approveAndRejectChannel(val:any) {
    this.ChannelForm.patchValue({
      status: val
    })
    if(this.ChannelForm.value.status){
      this.data.channelLimitStatus(this.ChannelForm.value).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          setTimeout(() => {
            document.getElementById("closeRequest").click();
            this.responseMessage = "";
            this.getChannelRequest(this.selectedUser);
          }, 3000);      
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      });
    }
    else{
      this.errMessage = "Action Not Performed!";
      setTimeout(() => {
        this.errMessage = "";
      }, 3000);
    }
  }
    
  truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}
}
