import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { Observable } from 'rxjs';
import { BillingService } from '../billing.service';

@Component({
  selector: 'app-billing-address',
  templateUrl: './billing-address.component.html',
  styleUrls: ['./billing-address.component.css']
})

export class BillingAddressComponent implements OnInit {
  
  formFields: any;
  editData: any;
  billingAddressForm: FormGroup;
  responseMessage: any;
  submitted: boolean = false;

  constructor(public data: BillingService, public fb: FormBuilder) { 
    this.billingAddressForm = this.fb.group({
      idbilling_address: [],
      first_name: ['', [Validators.required]],
      last_name: ['', [Validators.required]],
      contact: ['', [Validators.required]],
      email:['', [Validators.required,
				Validators.pattern("^[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,4}$")]],
      address1: ['', [Validators.required]],
      address2: ['', [Validators.required]],
      city: ['', [Validators.required]],
      state: ['', [Validators.required]],
      postal_code: ['', [Validators.required, Validators.minLength(5)] ],
      country: ['', [Validators.required]],
      currentDateTime: []
    });
  }

  ngOnInit(): void {
    this.data.getBillingAddress().subscribe(response => {
      const billData = response.data[0];
      if(billData){
        this.billingAddressForm.patchValue({
          idbilling_address: billData.idbilling_address,
          first_name: billData.first_name,
          last_name: billData.last_name,
          contact: billData.contact,
          email:  billData.email,
          address1: billData.address1,
          address2: billData.address2,
          city: billData.city,
          state: billData.state,
          postal_code: billData.postal_code,
          country: billData.country
        });
      }
    });
    
    this.formFields = this.data.getbillingaddress();
  }

  saveAddress(){

    this.submitted = true;
    if(this.billingAddressForm.invalid){
      return false;
    }
    else{
      if(this.billingAddressForm.value.idbilling_address == undefined){
        this.data.addBillingAddress(this.billingAddressForm.value).subscribe(response => {
          console.log(response);
          this.responseMessage = response.message;  
          setTimeout(()=>{
            this.responseMessage= "";
          }, 3000);
        },
        err => {
          console.log(err);
          this.responseMessage = err.message;  
          setTimeout(()=>{
            this.responseMessage= "";
          }, 3000);
        });
      }
      else{
          this.data.updateBillingAddress(this.billingAddressForm.value).subscribe(response => {
            console.log(response);
            this.responseMessage = response.message;  
            this.ngOnInit();
            setTimeout(()=>{
              this.responseMessage= "";
            }, 3000);
          },
          err => {
            this.responseMessage = err.message;  
          setTimeout(()=>{
            this.responseMessage= "";
          }, 3000);
          });
      }
    }
	}
}
