import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';

import { InvoicesComponent } from './invoices/invoices.component';
import { BillingprofileComponent } from './billingprofile/billingprofile.component';
import { CurrentusageComponent } from './currentusage/currentusage.component';
import { CdrftpComponent } from './cdrftp/cdrftp.component';
import { AccountledgerComponent } from './accountledger/accountledger.component';
import { PaymentsettingsComponent } from './paymentsettings/paymentsettings.component';
import { RatedecksComponent } from './ratedecks/ratedecks.component';
import { OutboundcdrftpComponent } from './outboundcdrftp/outboundcdrftp.component';
import { OrderhistoryComponent } from './orderhistory/orderhistory.component';
import { ViewbillingComponent } from './viewbilling/viewbilling.component';
import { StripeCardComponent } from './stripe-card/stripe-card.component';
import { DetailcustomercardComponent } from './detailcustomercard/detailcustomercard.component';

const routes: Routes = [
    {
        path: '',
        children: [
            {
                path: '',
                component: InvoicesComponent,
                data: {
                    title: 'Dashboard',
                    urls: [
                        {
                            title: 'Dashboard',
                            url: '/dashboards/dashboard'
                        },
                        {
                            title: 'Dashboard'
                        }
                    ]
                }
            },
            {
                path: 'invoice',
                component: InvoicesComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'Billing Invoice'
                        }
                    ]
                }
            },

            {
                path: 'view-billing/:id',
                component: ViewbillingComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'View Billing'
                        }
                    ]
                }
            },

            //   {
            //     path: 'payment',
            //     component: ListpaymentComponent,
            //     data: {
            //         title: 'Billing',
            //         urls: [
            //             {
            //                 title: 'Billing',

            //             },
            //             {
            //                 title: 'Payment'
            //             }
            //         ]
            //     }
            // },

            {
                path: 'billing-profile',
                component: BillingprofileComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'Billing Profile'
                        }
                    ]
                }
            },
            {
                path: 'payment-history',
                component: OrderhistoryComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',
                            //   url: '/dashboards/dashboard'
                        },
                        {
                            title: 'Payment History'
                        }
                    ]
                }
            },

            {
                path: 'current-usage',
                component: CurrentusageComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'Billing Current Usage'
                        }
                    ]
                }
            },


            {
                path: 'inbound-cdr-ftp',
                component: CdrftpComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'Billing CDR FTP'
                        }
                    ]
                }
            },

            {
                path: 'account-ledger',
                component: AccountledgerComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: ' Account Statement'
                        }
                    ]
                }
            },



            {
                path: 'payment-settings',
                component: PaymentsettingsComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'Billing  Payment Settings'
                        }
                    ]
                }
            },

            {
                path: 'rate-decks',
                component: RatedecksComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'Billing  Rate Decks'
                        }
                    ]
                }
            },
            {
                path: 'outbound-cdr-ftp',
                component: OutboundcdrftpComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',
                            //   url: '/billing/outbound-cdr-ftp'
                        },
                        {
                            title: 'Billing  Outbound CDR FTP'
                        }
                    ]
                }
            },
            {
                path: 'stripe-card',
                component: StripeCardComponent,
                data: {
                    title: 'Billing',
                    urls: [
                        {
                            title: 'Billing',

                        },
                        {
                            title: 'Stripe Cards'
                        }
                    ]
                }
            },
            {
                path: 'customer-details/:customer_id/:idstripecard',
                component: DetailcustomercardComponent,
                data: {
                    title: 'Details Customer',
                    urls: [
                        {
                            title: 'Details Customer',

                        },
                        {
                            title: 'Details Customer'
                        }
                    ]
                }
            }
        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class BillingRoutingModule { }
