import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
import {CapmaignserviceService } from '../capmaignservice.service';
import { Router } from '@angular/router';
import {MatDialog} from '@angular/material/dialog';
declare var $:any;
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';

declare var $: any;

@Component({
  selector: 'app-brand',
  templateUrl: './brand.component.html',
  styleUrls: ['./brand.component.css']
})

export class BrandComponent extends AppComponentClass<any, any> {
    /* p: number = 1;
	searchText = { count: 0 };
	filtre: string;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [ 50, 100, 150];
	filterTerm: string; */
	applyVettingForm: FormGroup;
	importVettingForm: FormGroup;
	campaign_id: 0;
	// public open: boolean = false;
	public show: boolean = false;
	public buttonName: any = "Add Brand";
	public campaignForm: FormGroup;
	public brandForm: FormGroup;
	public submitted : boolean = false;
	public submittedaply : boolean = false;
	public submittedimp : boolean = false;
	public collection : any;
	public heading = [];
	public main_heading = "";
	responseMessage = "";
	brands: any = [];
	brand: any = [];
	campaigns: any = [];
	brandRelationship: any = [];
	brandVertical: any = [];
	altBusinessIdType: any = [];
	brandType: any = [];
    errMessage: any ="";
	vettingClass: any = [];
	vettingProvider: any = [];
	vettingProviderOrPartner: any = [];
	vtngClass: any = [];
	vtngProvider: any = [];
	vetProvider: any[] = [];
	vettingText: any = '';
	brandId: any;
	brandsVetting: any = [];
	iduser: any;
	vettingData: any = [];
	entityType: any;

  constructor(public data: CapmaignserviceService, public dialog: MatDialog, public router: Router,public fb: FormBuilder) {
		super(data, router, fb);
	}

  ngOnInit(): void {
	this.vettingText = '';

	this.applyVettingForm = this.fb.group({
		brandId: ['', [Validators.required]],
		vettingClass: ['', [Validators.required]],
		evpId: ['', [Validators.required]],
		price: [''],
		additionalRequestPayload: [''],
	});

	this.importVettingForm = this.fb.group({
		brandId: ['', [Validators.required]],
		evpId: ['', [Validators.required]],
		vettingId: ['', [Validators.required]],
		vettingToken: ['']
	});

	this.data.brandRelationship().subscribe(res => {
		this.brandRelationship = res.data;
	})

	this.data.altBusinessIdType().subscribe(res => {
		this.altBusinessIdType = res.data.slice(1, 4);
	});

	this.data.brandVertical().subscribe(res => {
		let tmp:any=[];
		Object.entries(res.data).forEach((ele:any)=>{
			let t=ele[1];
			t["name"]=ele[0];
			tmp.push(t);
		});
		this.brandVertical = tmp;
	});

	this.data.brandEntityType().subscribe(res => {
		this.brandType = res.data;
	});




	this.data.brandVettingClass().subscribe(res => {
		this.vettingClass = res.data.slice().reverse();
		this.vettingClass.forEach(element => {
			this.vtngClass.push({"vettingClass":element.id,"displayName":element.displayName});
		});	   	
	});

	this.data.brandVettingProvider().subscribe(res => {
		this.vettingProvider = res.data;
	});

	
	this.brandForm = this.fb.group({
		companyName: ['',Validators.required],
		displayName: ['', Validators.required],
		entityType: ['', Validators.required],
		ein: ['', Validators.required],
		phone: ['', Validators.required],
		country: ['',Validators.required],
		email: ['', Validators.required],
		street: ['', Validators.required],
		city: ['', Validators.required],
		state: ['', Validators.required],
		postalCode: ['', Validators.required],
		website: ['', Validators.required],
		vertical: ['', Validators.required],
		brandRelationship: ['', Validators.required]
	});
	
	this.campaignForm = this.fb.group({
		idcampaign: ['', Validators.required],
		idbrand: [],
		brand_name: [],
		campaign_name: [],
		campaign_key: [],
		campaign_class: [],
		start_date: [],
		campaign_description: []
	});

	 this.data.getBrand().subscribe(result => {
		 if(result.status == 200){
			this.brands = result.data;
			$.getScript('./assets/table.js');
		 }
		 else{
			this.errMessage = result.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		 }
	 }, err => {
		 this.errMessage = err.message;
		 setTimeout(() => {
			this.errMessage = "";
		 }, 5000);
	 });

	this.data.onGetCampaign().subscribe(res => {
		if(res.status == 200){
			this.campaigns = res.data;
			$.getScript('./assets/table.js');
		}
		else{
			this.errMessage = res.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		}
	}, err => {
		this.errMessage = err.message;
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	});
  }
  
  setData(brandId,iduser){
	this.brandsVetting = [];
	this.brandId = brandId;
	this.iduser = iduser;
	let payLoad:any =  JSON.stringify({
		brandId:this.brandId,
		iduser:this.iduser
	});
	this.brandsVettingList(payLoad);
	this.applyVettingForm.patchValue({
		brandId:brandId,
		price:'',
		evpId:'',
		vettingClass:''
	})
	this.submittedaply = false;
		this.importVettingForm.patchValue({
		brandId:brandId,
		evpId: '',
		vettingId: '',
		vettingToken: ''
	})
	this.submittedimp = false;
	return true;
  }

  refreshVettingList(){
	let payLoad:any =  JSON.stringify({
		brandId:this.brandId,
		iduser:this.iduser
	});	
	this.brandVettingUpdateStatus(payLoad);
  }

  brandVettingUpdateStatus(payLoad){
	this.data.updateVetting(payLoad).subscribe(result => {
		this.brandsVetting = [];
		if(result.status = 200){
			this.brandsVettingList(payLoad);
		}else{
			this.brandsVettingList(payLoad);
		}
		
	});
  }

	brandsVettingList(payLoad){
		this.data.getBrandVetting(payLoad).subscribe(result => {
			if(result.status == 200){
			this.brandsVetting = result.data;
			}
			else{
			this.errMessage = result.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
			this.errMessage = "";
			}, 5000);
		});
	}
	getVettingCondition(entityType:any): any {
		this.entityType = entityType;
		let payLoad = JSON.stringify({
			entityType : entityType
		})
		this.data.getVettingClass(payLoad).subscribe(res => {
			if(res.status == 200){
				this.vettingData = res.data;
			}
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}
	/**
	* It will apply a new vetting
	*/
	applayVetting(): any {
		this.submittedaply = true;
		if(this.applyVettingForm.invalid){
			return false;
		}
		else{
			this.data.applyNewVetting(this.applyVettingForm.value).subscribe(res => {
				if (res.status == 200) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}
  	getVettingProvider(event){
		this.vetProvider.splice(0);
		this.vetProvider = [];
		this.applyVettingForm.patchValue({
			evpId:''
		});
		this.entityType = this.entityType;
		let payLoad = JSON.stringify({
			entityType : this.entityType,
			vettingClass : event.value
		})
		this.data.getVettingPartner(payLoad).subscribe(res => {
			if(res.status == 200){
				this.vettingProviderOrPartner = res.data;
			}
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
		this.vettingText = '';

		// this.vettingProvider.forEach(element => {
		// 	let VIN:string = element.vettingInstruction;
		// 	element.vettingClasses.find(res => {
		// 		if(event.value.toLowerCase() == res.toLowerCase()){
		// 			this.vetProvider.push({"evpId":element.evpId, "displayName":element.displayName, "tcrBillable":element.tcrBillable,"vettingInstruction":JSON.parse(VIN)});
		// 		}
		// 		if(event.value.toLowerCase() == 'political'){
		// 			this.applyVettingForm.patchValue({
		// 				additionalRequestPayload : "{\"requestorFirstName\":\"John\",\"requestorLastName\":\"Doe\",\"locale\":\"Federal\",\"fecCommitteeTypeCode\":\"Y\",\"committeeId\":\"00000\",\"candidateType\":\"City Mayor\",\"stateLocalCommitteeType\":\"State\",\"localCommitteeState\":\"NC\",\"localCommitteeMunicipality\":\"Some Locality\",\"tribalLocation\":\"US\",\"filingUrl\":\"https://sample.com\",\"filingRecordUrlInstructions\":\"Sample Instructions\",\"filingEmail\":\"contact@example.com\",\"electionDate\":\"2022-12-26\",\"pinPreference\":\"Express\"}"
		// 			});
		// 		}
		// 	});
		// 	this.vettingText = '';
		// });
	}

  	getVettingPDetail(event){
		this.vettingProviderOrPartner.find(element => {	
			if(element.evpId.toLowerCase() == event.value.toLowerCase()){
				this.vettingText ={"price":element.price,"time":element.waitTime};
				this.applyVettingForm.patchValue({
					price:this.vettingText.price
				});
			}
		});
		/*this.vettingProvider.find(element => {	
			if(element.evpId.toLowerCase() == event.value.toLowerCase()){
				let VIN:string = element.vettingInstruction;
				let vin = JSON.parse(VIN);
				this.vettingText ={"price":vin.newVet.price.STANDARD,"time":vin.newVet.waitTime};
				this.applyVettingForm.patchValue({
					price:this.vettingText.price
				});
			}
		});*/
	}
	/**
	 * It will import a vetting
	 */
	importVetting(): any {
		this.submittedimp = true;
		if(this.importVettingForm.invalid){
			return false;
		}
		else{
			this.data.importVetting(this.importVettingForm.value).subscribe(res => {
				if (res.status == 200) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

 

	onBrand(){
		this.submitted = true;
		if(this.brandForm.invalid){ 
			return
		}
		else{
			$('#basic-datatables').DataTable().clear();
			$('#basic-datatables').DataTable().destroy();
			this.data.onBrandRegister(this.brandForm.value).subscribe(response => {
				// this.ngOnInit();
			   if(response.status == 201){
					this.responseMessage = response.message;  
					setTimeout(()=>{
						this.responseMessage= "";
					}, 5000);
			   } 
			   else{
				   this.errMessage = response.message;
				   setTimeout(() => {
						this.errMessage = "";
				   }, 5000);
			   }
			});
		}
	}

	addCampaign(data){
		this.campaignForm.patchValue({
			idbrand: data.idbrand,
			brand_name: data.brand_name
		});
	}

	onSaveCampaign(){
		if(this.campaignForm.invalid) {
			return;
		}
		else{
			this.data.onAddCampaign(this.campaignForm.value).subscribe(res => {
				if(res.status == 201){
					this.ngOnInit();  
					this.responseMessage = res.message;
					setTimeout(()=>{
					this.responseMessage= "";
					}, 5000);
				}
				else{
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}


	/**
	 * It will delete a brand
	 */
	DeleteBrand(brandId: any): any {
		if (confirm("Are You Sure, You want delete this brand?")) {
			this.data.DeleteBrand(brandId).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					location.reload();
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
		else {
			return false
		}
	}

	// showdetails(){
	// 	if(this.open==false){
	// 		this.open=true;
	// 	}
	// 	else{
	// 		this.open=false;
	// 	}

	// }
	textMessageFunc(msgText) {
		this.responseMessage = "Copied to Clipboard";
		setTimeout(() => {
		  this.responseMessage = "";
		}, 5000);
	  }

}