import { AfterViewInit, Component, Input, OnInit, ViewChild } from '@angular/core';
import { FormArray, FormBuilder, FormGroup, Validators } from '@angular/forms';
import { MatAccordion } from '@angular/material/expansion';
import { Router } from '@angular/router';
import { NgbActiveModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { BehaviorSubject } from 'rxjs';
import { AgentserviceService } from 'src/app/agents/agentservice.service';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { ConnectionsService } from '../connections.service';

@Component({
  selector: 'app-edit-connection',
  templateUrl: './edit-connection.component.html',
  styleUrls: ['./edit-connection.component.css']
})

export class EditConnectionComponent implements OnInit, AfterViewInit {

  @Input() connectionKey: any;
  @ViewChild(MatAccordion) accordion: MatAccordion;
	show: boolean = false;
	outboundtab: boolean = false;
	header: any;
	connectionForm: FormGroup;
	IPForm: FormGroup;
	submitted: boolean = false;
	password = "password";
	pShow = false;
	IPArr: FormArray;
	ipShow: boolean = false;
	textMessage: any;
	msgHideAndShow: boolean = false;
	urlForm: FormGroup;
	FQDNForm: FormGroup;
	forwordForm: FormGroup;
	inboundForm: FormGroup;
	outboundForm: FormGroup;
	connection: any = [];
	connectionId: any;
	tech_prefix: any;
	connectionType: any;
	expertSettingForm: FormGroup;
	smsinboundForm: FormGroup;
	smsoutboundForm: FormGroup;
	idip_address: any;
	urls: any = [];
	sdata: any = [];
	hdata: any;
	type: any;
	connectionName: any;
	update_connection : any = {
		name: '',
		idendpoint: "",
		idaccount: ""
	}
	update_conn : any;
	rdata: any;
	ediConn: any;
	user: any;
	inbound: any;
	outbound: any;
	responseMessage = "";
	connection_key: any;
	inbound_key: any;
	outbound_key: any;
	formField1: any;
  Status: any;
	newarr: any[]=[];
	id_ipaddress: any;
	ipAddress: any;
	sms_inbound_key: any;
	sms_outbound_key: any;
	smsOutbound: any;
	smsInbound: any;
	brandData: any = [];
	campData: any = [];
	isSelected: boolean = false;
	tab1$ = new BehaviorSubject<any>("");
	tab1 = this.tab1$.asObservable();
    tab1Value = "";
	tab2$ = new BehaviorSubject<any>("");
	tab2 = this.tab1$.asObservable();
    tab2Value = "";
	tab3$ = new BehaviorSubject<any>("");
	tab3 = this.tab1$.asObservable();
    tab3Value = "";
	tab4$ = new BehaviorSubject<any>("");

	isSIP$ = new BehaviorSubject<string>("Number");
	isSip = this.isSIP$.asObservable();

	isSelect$ = new BehaviorSubject<boolean>(false);
	isSelect = this.isSelect$.asObservable();

	isDropdown$ = new BehaviorSubject<boolean>(false);
	isDropdown = this.isSelect$.asObservable();

	groups: any = [];
	agents: any = [];
	errMessage: any = "";
	userType: any = "";
  isLoaded: Boolean = false;

  constructor(public data: ConnectionsService, private campService: CapmaignserviceService, 
              private agentService: AgentserviceService, public router: Router, public fb: FormBuilder,
              public activeModal: NgbActiveModal, public config: NgbModalConfig ) {
             
                config.backdrop = 'static';
                config.keyboard = false;

                let session = JSON.parse(sessionStorage.getItem("isLoggedIn"));
                this.userType = session.type;
  }


  ngOnInit(): void {

		this.expertSettingForm = this.fb.group({
			idendpoint: [],
			Encode: [''],
			DTMF_type: [''],
			enable_on_net: [''],
			enable_comfort: ['']
		});

		this.connectionForm = this.fb.group({
			id: [''],
			idendpoint: [''],
			connection_key: [''],
			connectionName: ['', [Validators.required, Validators.maxLength(150)]],
			username: [''],
			password: [''],
			type: [''],
			tech_prefix: [''],
			forward_type: [''],
			forward: [''],
			brand: [''],
			campaign: ['']
		});

		this.FQDNForm = this.fb.group({
			idendpoint: [this.connectionId],
			type: [''],
			user: ['']
		});

		this.smsinboundForm = this.fb.group({
			idendpoint: [],
			type: ['sms_inbound'],
			url: ['']
		});

		this.smsoutboundForm = this.fb.group({
			idendpoint: [],
			type: ['sms_outbound'],
			delivery_url: ['']
		})

		this.inboundForm = this.fb.group({
			idendpoint: [],
			dnis: [],
			ani: [],
			ringback_timeout: [],
			answer_timeout: [],
			//channel_limit: [],
			sip_uri: [],
			media_type: [],
			enable_sip_compact: [],
			enable_privacy_zone: [],
			enable_prack: [],
			recording: []
		});

		this.outboundForm = this.fb.group({
			idendpoint: [],
			caller_id: [],
			custom: [],
			country: [],
			//channel_limit: [],
			initiated_by: [],
			voice_profile: [],
			media_type: [],
			ringback: [],
			tone: [],
			type: [],
			recording: [],
			uuid_detail: [],
			amd: [true]
		});

		this.IPForm = this.fb.group({
			IPArr: this.fb.array([this.addNewIPFormGroup()])
		});

		this.password = "password";

    this.addsip();

		this.data.getConnection().subscribe(response => {
			if(response.status == 200){
				if(response.data.length > 0){
					this.connection = response.data;
          let item = this.connection.filter(el => el.connection_key == this.connectionKey);
          // Call Edit Connection
          this.editdata(item[0], 1);
					this.connection.forEach(element => {
						element.pShow = false;
						element.pswd = "password";
					});
				}
			}
			else{
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.data.getRoutingConnection().subscribe(result=> {
			if(result.status == 200){
				this.rdata = typeof result.data != 'undefined' && result.data ? result.data : []
			}
			else{
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

		this.data.getconnectiondetails().subscribe((result) => {
			this.header = result[0].headers_details;
			if(this.userType == '2' || this.userType == '1'){
				this.header.splice(0, 0, "User")
			}
			this.formField1 = result[0].formControls;

			let tmp = [];
			this.formField1.forEach(element => {
				tmp["idhooksetting_"+element.ID] = []
				tmp["ID_"+element.ID] = [element.ID]
				tmp["type_"+ element.ID] = [element.type1]
				tmp["idendpoint_" + element.ID] = [this.connectionId],
				tmp["url_"+element.ID]=[]
			});
			this.urlForm = this.fb.group(tmp);
		});
  }

  ngAfterViewInit(): void {
      this.isLoaded = true;
  }

  onUpdateConnectionName(){
		this.submitted = true;
		if(this.connectionForm.invalid){
			return;
		}
		else{
			this.data.updateConnectionName(this.connectionForm.value).subscribe(response => {
				if(response.status == 201){
					this.show = true;
					this.submitted = false;
					this.responseMessage= response.message;
					setTimeout(()=>{
						this.responseMessage= "";
					}, 5000);
				}
				else{
					this.errMessage = response.message;
					setTimeout(()=>{
						this.errMessage= "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
	}

	onUpdateConnection() {
		this.submitted = true;
		if(this.connectionForm.invalid){
			return;
		}
		else{
			this.data.updateConnection(this.connectionForm.value).subscribe(response => {
				if(response.status == 201){
					this.show = true;
					// this.connectionForm.patchValue({
					// 	connectionName: response.data[0].name,
					// });
					// this.connectionName = response.data[0].name;
					// this.submitted = false;
					this.responseMessage = response.message;
					setTimeout(()=>{
						this.responseMessage= "";
					}, 5000);
				}
				else{
					this.errMessage = response.message;
					setTimeout(()=>{
						this.errMessage= "";
					}, 5000);
				}
			});
		}
	}

  onType(event) {
		this.connectionType = event.target.innerHTML;
	}

	updateInbound(){
		this.data.updateInbound(this.inboundForm.value).subscribe(response => {
			if (response.status == 201){
				this.responseMessage=response.message;
				setTimeout(()=>{
					this.responseMessage= "";
				}, 5000);
			}
			else{
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	updateOutbound(){
		this.data.updateOutbound(this.outboundForm.value).subscribe(response => {
			if(response.status == 201){
				this.responseMessage = response.message;
				setTimeout(()=>{
					this.responseMessage= "";
				}, 5000);
			}
			else{
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

  addsip(){
		this.update_conn = this.update_connection
		this.ediConn = {};
		this.type = "";
		this.user = "";
	}

  editdata(data: any, tabs) {

		switch (tabs) {
			case 1: {
				this.tab1Value = "active";
				this.tab2Value = "";
				this.tab3Value = "";
				break;
			}
			case 2: {
				this.tab1Value = "";
				this.tab2Value = "active";
				this.tab3Value = "";
				break;
			}
			case 3:{
				this.tab1Value = "";
				this.tab2Value = "";
				this.tab3Value = "active";
				break;
			}
 		 }

		  if(data != 'data'){
		// this.classs="active"
				this.update_conn = data;

				this.expertSettingForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.FQDNForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.connectionForm.patchValue({
					idendpoint: data.idendpoint,
					username: data.username,
					password: data.password,
					tech_prefix: data.tech_prefix,
				});

				this.smsinboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.smsoutboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.inboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.outboundForm.patchValue({
					idendpoint: data.idendpoint
				});

				this.ediConn = {}

				this.connectionId = data.idendpoint;

				this.data.getUrl(data.idendpoint).subscribe(res => {
					if(res.status == 200){
						let tmp = [];
						if(res.data.length > 0){
							res.data.forEach(element => {
								if(element.type == "sms-status"){
									this.sms_outbound_key = element.sms_key;
									this.smsOutbound = element.url;
								}
								if(element.type == "sms-received"){
									this.sms_inbound_key = element.sms_key;
									this.smsInbound = element.url;
								}
								tmp["idhooksetting_"+element.priority] = [element.idhooksetting]
								tmp["ID_"+element.priority] = [element.ID]
								tmp["type_"+ element.priority] = [element.type]
								tmp["idendpoint_" + element.priority] = [this.connectionId],
								tmp["url_"+element.priority]=[element.url]
							});
							this.urlForm = this.fb.group(tmp);
						}
						else{
							this.formField1.forEach(element => {
								tmp["idhooksetting_"+element.ID] = []
								tmp["ID_"+element.ID] = [element.ID],
								tmp["type_"+ element.ID] = [element.type1],
								tmp["idendpoint_" + element.ID] = [this.connectionId],
								tmp["url_"+element.ID]=[]
							});
							this.urlForm = this.fb.group(tmp);
						}
					}
					else{
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});


				this.data.getIP(data.idendpoint).subscribe(res => {
					console.log(res);
					if(res.status == 200){
						this.ipAddress = res.data;
						this.IPArr = this.IPForm.get('IPArr') as FormArray;
						this.ipAddress.forEach(element => {
							this.IPArr.push(this.fb.group(element));
						});
					}
					else{
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				})

				this.data.get_expertSetting(data.idendpoint).subscribe(result=> {
					if(result.status == 200){
						this.hdata = result.data[0];
						if(this.hdata){
							this.expertSettingForm.patchValue({
								Encode: this.hdata.encode_header,
								DTMF_type: this.hdata.DTMF_type,
								enable_on_net: this.hdata.enable_on_net,
								enable_comfort: this.hdata.comfort_noise
							});
						}
					}
					else{
						this.errMessage = result.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});

				this.data.getInbound(data.idendpoint).subscribe(response=>{
					if(response.status == 200){
						this.inbound = response.data[0];
						this.inbound_key = this.inbound.inbound_key;
						this.inboundForm.patchValue({
							dnis: this.inbound.dnis,
							ani: this.inbound.ani,
							ringback_timeout: this.inbound.ringback_timeout,
							answer_timeout: this.inbound.answer_timeout,
							//channel_limit: this.inbound.channel_limit,
							sip_uri: this.inbound.sip_uri,
							media_type: this.inbound.media_type,
							enable_sip_compact: this.inbound.enable_sip_compact,
							enable_privacy_zone: this.inbound.enable_privacy_zone,
							enable_prack: this.inbound.enable_prack,
							recording: this.inbound.recording
						});
					}
					else{
						this.errMessage = response.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});

				this.data.getOutbound(data.idendpoint).subscribe(response=>{
					if(response.status == 200){
						this.outbound = response.data[0];
						this.outbound_key = this.outbound.outbound_key;
						let enable_ringback: boolean = this.outbound.enable_ringback == 'true' ? true : false;
						this.outboundForm.patchValue({
							caller_id: this.outbound.caller_id,
							type: this.outbound.type,
							country: this.outbound.country,
							//channel_limit: this.outbound.channel_limit,
							initiated_by: this.outbound.initiated_by,
							voice_profile: this.outbound.voice_profile,
							media_type: this.outbound.media_type,
							ringback: enable_ringback,
							tone: this.outbound.tone,
							recording: this.outbound.recording,
							uuid_detail: this.outbound.uuid_detail,
							amd: this.outbound.amd
						});
					}
					else{
						this.errMessage = response.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});

				this.FQDNForm.patchValue({
					type: this.ediConn.FQDN_type,
					user: this.ediConn.FQDN_user
				});

				let editConn = this.connection.find(el =>
					el.idendpoint === data.idendpoint
				);
				this.connectionForm.patchValue({
					connectionName: editConn.name,
					forward: editConn.forward,
					forward_type: editConn.forward_type,
				});
			}
		// brand: editConn.brandId,
		// campaign: editConn.campaignId
	}

  onUpdateUrls() {
		let response: any = [];
		response[1]=[];
		response[2]=[];
		response[3]=[];
		response[4]=[];
		response[5]=[];
		response[6]=[];

		for(let key of Object.keys(this.urlForm.value)){
            let tmp=key.split('_');
            response[tmp[1]].push({field: tmp[0], value: this.urlForm.value[key]});
          }
		this.data.updateUrls(response).subscribe(response => {
			if(response.status == 201){
				this.responseMessage=response.message;
				setTimeout(()=>{
					this.responseMessage= "";
				  }, 5000);
			}
			else{
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	onExpertSetting() {
		this.data.update_expertSetting(this.expertSettingForm.value).subscribe(response => {
			if(response.status == 201){
				this.responseMessage=response.message;
				setTimeout(()=>{
					this.responseMessage= "";
				}, 5000);
				window.location.reload();
			}
			else{
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	onUpdateExpertSetting() {
		this.data.update_expertSetting(this.expertSettingForm.value).subscribe(response => {
			if(response.status == 201){
				this.responseMessage=response.message;
				setTimeout(()=>{
					this.responseMessage= "";
				  }, 5000);
				  this.ngOnInit();
			}
			else{
				this.errMessage=response.message;
				setTimeout(()=>{
					this.errMessage= "";
				  }, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	onUpdateFQDN() {
		this.data.updatefqdn(this.FQDNForm.value).subscribe(response => {
			if(response.status == 201){
				this.responseMessage=response.message;
				setTimeout(()=>{
					this.responseMessage= "";
				  }, 5000);
			}
			else{
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}

	saveForward() {
		this.data.updateConnection(this.connectionForm.value).subscribe(response=> {
			if(response.status == 201){
				this.responseMessage=response.message;
				setTimeout(()=>{
					this.responseMessage= "";
				  }, 5000);
			}
			else{
				this.errMessage = response.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}


  onForwardType(e){
		console.log(e.target.value);
		if(e.target.value == 1){
			this.isSIP$.next("Sip Uri");
			this.connectionForm.get("forward").reset();
			this.connectionForm.get("forward").setValidators([Validators.required, 
				Validators.pattern("(?:[A-Za-z][A-Za-z0-9+.-]*:\/{2})?(?:(?:[A-Za-z0-9-._~]|%[A-Fa-f0-9]{2})+(?::([A-Za-z0-9-._~]?|[%][A-Fa-f0-9]{2})+)?@)?(?:[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?\\.){1,126}[A-Za-z0-9](?:[A-Za-z0-9-]*[A-Za-z0-9])?(?::[0-9]+)?(?:\/(?:[A-Za-z0-9-._~]|%[A-Fa-f0-9]{2})*)*(?:\\?(?:[A-Za-z0-9-._~]+(?:=(?:[A-Za-z0-9-._~+]|%[A-Fa-f0-9]{2})+)?)(?:&|;[A-Za-z0-9-._~]+(?:=(?:[A-Za-z0-9-._~+]|%[A-Fa-f0-9]{2})+)?)*)?")])
		}
		else if(e.target.value == 2){
			this.isSIP$.next("Number");
			this.connectionForm.get("forward").reset();
			this.connectionForm.get("forward").setValidators([Validators.required, Validators.pattern("^((\\+91-?)|0)?[0-9]{10}$")])
		}
		else if(e.target.value == 3){
			this.isSIP$.next("IP Address");
			this.connectionForm.get("forward").reset();
			this.connectionForm.get("forward").setValidators([Validators.required, Validators.pattern("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)")]);
		}
		else if(e.target.value == 4){
			this.isSIP$.next("Group");
			this.connectionForm.get("forward").reset();
			this.connectionForm.get("forward").setValidators([Validators.required]);
		}
		else if(e.target.value == 5){
			this.isSIP$.next("Extension");
			this.connectionForm.get("forward").reset();
			this.connectionForm.get("forward").setValidators([Validators.required]);
		}
		else if(e.target.value == "A"){
			this.isSIP$.next("A");
			this.connectionForm.get("forward").reset();
			this.connectionForm.get("forward").setValidators([Validators.required]);
		}
		else if(e.target.value == "SRV"){
			this.isSIP$.next("SRV");
			this.connectionForm.get("forward").reset();
			this.connectionForm.get("forward").setValidators([Validators.required]);
		}
	}

	get f() {
		return this.connectionForm.controls;
	}

  onSaveIP() {
		this.submitted = true;
		if (this.IPForm.invalid) {
			return;
		}
		else {
			// console.log(this.IPForm.value)
			// if(!this.IPForm.value.IPArr[0].id_ipaddress){
			// 	console.log(this.IPForm.value.IPArr[0].id_ipaddress);
			// 	this.data.saveIp(this.IPForm.value).subscribe(response => {
			// 		console.log(response);
			// 	});
			// }
			// else{
				this.data.updateIP(this.IPForm.value).subscribe(result=>{
					if(result.status == 201){
						this.responseMessage=result.message;
						setTimeout(()=>{
							this.responseMessage= "";
						}, 5000);
					}		
					else{
						this.errMessage = result.message;
						setTimeout(()=>{ 
							this.errMessage= "";
						}, 5000);
					}
				}, err => {
					this.errMessage = err.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				});
			// }
		}
	}

  passwordToggle1(id) {
		this.connection.forEach(element => {
			if(element.idendpoint == id){
				if (element.pswd == 'password') {
					element.pswd = 'text';
					element.pShow = true;

				} else {
					element.pswd = 'password';
					element.pShow = false;
				 }
			}
		});
	}

  passwordToggle() {
		if (this.password === 'password') {
			this.password = 'text';
			this.pShow = true;
		} else {
			this.password = 'password';
			this.pShow = false;
		}
	}

	// Dynamic Form

	textMessageFunc(msgText) {
		this.responseMessage = msgText + "Copied to Clipboard";
		this.msgHideAndShow = true;
		setTimeout(() => {
			this.responseMessage = "";
			this.msgHideAndShow = false;
		}, 5000);
	}

	copyInputText(copyText) {
		copyText.select();
		document.execCommand('copy');
		copyText.setSelectionRange(0, 0);
		this.textMessageFunc('Text');
	}


	addNewIPFormGroup() {
			return this.fb.group({
				id_ipaddress: [],
				idendpoint: [this.connectionId],
				type: [this.connectionType],
				ip: ['', [Validators.required,
				Validators.pattern('(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)')]],
			})
	}

	addItem() {
		if(this.IPControls.invalid){
			return; 
		}
		else{
			this.IPArr = this.IPForm.get('IPArr') as FormArray;
			this.IPArr.push(this.addNewIPFormGroup());
		}
	}

	get IPControls(): FormArray {
		return this.IPForm.get('IPArr') as FormArray;
	}

	deleteIPFormGroup(index: number) {
			let add: any = this.IPForm.get('IPArr') as FormArray;
			add.removeAt(index);
	}

	deleteIPFormGroup1(index: number, ip) {

		let add: any = this.IPForm.get('IPArr') as FormArray;
		add.removeAt(index);

		let ips: any = this.ipAddress.find(el => el.ip == ip.value);

		this.data.deleteIP(ips.id_ipaddress).subscribe(res => {
			if(res.status == 201){
				this.responseMessage=res.message;
				setTimeout(()=>{
					this.responseMessage= "";
				}, 5000);
			}
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});
	}


  closeModal(){
      this.show = false;
      this.tab1Value = "";
      this.tab2Value = "";
      this.tab3Value = "";
      this.connectionName = "";
      this.smsoutboundForm.reset();
      this.connectionForm.reset()
      this.inboundForm.reset();
      this.outboundForm.reset();
      this.smsinboundForm.reset();
      // this.ngOnInit();
      this.activeModal.close({message: "", status: true});
  }

}
