import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { AppService } from '../shared/service/AppService.class';
import { Observable } from 'rxjs';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class GroupService extends AppService<any> {

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });

  constructor(public http: HttpClient) {super(http)}

  get_group(): Observable<any> {
   return this.http.get('./assets/group.json')
  }

  @LoaderEnabled()
  saveCustomerGroup(data: any): Observable<any> {
    this.appmod = "saveCustomerGroup";
    let tmp = this.saveService(data);
    this.appmod = "customerGroup";
    return tmp;
  }

  @LoaderEnabled()
  saveCustomerMapping(type: any): Observable<any> {
    this.appmod = "saveCustomerMapping";
    let tmp = this.saveService(type);
    this.appmod = "customerGroup";
    return tmp;
  }

  updateUserList(data: any): Observable<any> {
    this.appmod = "updateUserList";
    let tmp = this.updateService(data);
    this.appmod = "customerGroup";
    return tmp;
  }

  @LoaderEnabled()
  getCustomerGroups(): Observable<any> {
    this.appmod = "getCustomerGroups";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getCustomerGroup(cgID): Observable<any> {
    const endpoint = environment.SERVER + 'getCustomerGroup';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params :{ cgID: cgID } });
  }

  @LoaderEnabled()
  getSlaveAccount(masterID , cgID): Observable<any> {
    const endpoint = environment.SERVER + 'getSlaveAccount';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.get(endpoint, { headers: httpHeaders, params :{ masterID: masterID , cgID: cgID} });
  }

  @LoaderEnabled()
  deleteCustomerGroup(data: any): Observable<any> {
    this.appmod = "deleteCustomerGroup";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  applyGroupFilter(data?: any): Observable<any> {
    this.appmod = "applyGroupFilter";
    let result = super.saveService(data);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  updateCustomerGroup(data: any): Observable<any> {
    this.appmod = "updateCustomerGroup";
    let tmp = this.updateService(data);
    this.appmod = "customerGroup";
    return tmp;
  }

  @LoaderEnabled()
  updateCustomerMapping(data: any): Observable<any> {
    this.appmod = "updateCustomerMapping";
    let tmp = this.updateService(data);
    this.appmod = "customerGroup";
    return tmp;
  }
}
