import { Component, OnInit, ViewEncapsulation } from '@angular/core';
import { env } from 'process';
import { InboundService } from '../inbound.service';
declare var $: any;

@Component({
	selector: 'app-dis-did-restore',
	templateUrl: './dis-did-restore.component.html',
	styleUrls: ['./dis-did-restore.component.css'],
	// encapsulation: ViewEncapsulation.None,
})
export class DisDidRestoreComponent implements OnInit {
	selectedDid: any = [];
	dids: any = [];
	isSelected: Boolean = false;
	isChecked: Boolean = false;
	header: any;
	responseMessage: any = "";
	errMessage: any = "";
	// page: number = 1;
	count: number = 0;
	tableSize: number = 10;
	tableSizes: any = [10, 20, 50, 100, 1000];
	getDID: any;
	iselectAll: Boolean = false;
	selectedDIDCount: any;
	listedDid: any = [];
	sInfo: string;
	allUserDIDLen: any;
	shwoingEntry: number;
	didCount: any = [];
	SIZE: number = 10;
	// tableSizeN: number;
	dismiss: boolean = false;
	increse_stop: boolean = false;
	userType: any;

	constructor(public data: InboundService) {

	}

	ngOnInit(): void {
		this.selectedDIDCount = '';
		this.didCount = '';
		this.data.getdid().subscribe((result) => {
			this.header = result[0].headers_details;
		});

		let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type;

		this.data.getDisconnectedDid().subscribe(res => {
			$('#basic-datatables').DataTable().clear();
			$('#basic-datatables').DataTable().destroy();
			if (res.status == 200) {
				this.getDID = res.data.map(item => ({
					...item,
					account_id: parseInt(item.account_id)
				}));
				// this.onTableSizeChange(10);
				this.didCount = '(of ' + res.data.length + ' total)';
				$.getScript('./assets/table.js');
			} else {
				this.errMessage = "";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}

	onSelectAll(e) {
		if (e.target.checked) {
			this.selectedDid = [];
			this.getDID.forEach((ele: any) => {
				ele.isChecked = true;
				this.selectedDid.push(ele);
			});
		}
		else {
			this.iselectAll=false;
			this.selectedDid = [];
			this.getDID.forEach((ele: any) => {
				ele.isChecked = false;
			});
		}
		if (this.selectedDid.length == this.getDID.length) {
			this.iselectAll = true;
		}
		else {
			this.iselectAll = false;
		}
		this.selectedDIDCount = this.selectedDid.length;
	}

	onSelectDid(e, did, idx) {
		if (e.target.checked) {
			this.selectedDid.push(did);
		}
		else {
			this.selectedDid.forEach((value, index) => {
				if (value.iddid == did.iddid)
					this.selectedDid.splice(index, 1);
			});
		}

		if (this.selectedDid.length == this.getDID.length) {
			this.iselectAll = true;
		}
		else {
			this.iselectAll = false;
		}

		if (this.selectedDid.length > 0) {
			this.isSelected = true;
		}
		else {
			this.isSelected = false;
		}
		this.selectedDIDCount = this.selectedDid.length;

	}

	restoreDisconnectDID() {

		if (confirm("Please Confirm You Want To Restore Selected DIDs")) {
			this.data.restoreDisconnectDid(this.selectedDid).subscribe(res => {
				this.selectedDid = [];
				this.selectedDIDCount = '';
				if (res.status == 200) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					this.ngOnInit();
				} else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.selectedDIDCount = '';
				this.responseMessage = err.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			});
		}
		else {
			return
		}

		this.selectedDid = [];
		this.getDID.forEach((ele: any) => {
			ele.isChecked = false;
		});
	}

	// onTableSizeChange(event: number): void {
	// 	if (event[1] !== ":") {
	// 		this.tableSize = event
	// 		if (this.tableSize > 0) {
	// 			this.tableSize = this.tableSize;
	// 		} else {
	// 			if (this.tableSizeN) {
	// 				this.tableSize = this.tableSizeN;
	// 			} else {
	// 				this.tableSize = this.SIZE;
	// 			}
	// 		}
	// 	} else {
	// 		this.tableSize = this.SIZE;
	// 		this.dismiss = false;
	// 	}
	// 	this.selectedDIDCount = 0;
	// 	this.selectedDid.splice(0);
	// 	this.iselectAll = false;
	// 	this.page;
	// 	this.getDID;
	// 	this.listedDid = [];
	// 	if (this.tableSize == 100) {
	// 		this.listedDid = this.getDID
	// 	} else {
	// 		let c: any = this.tableSize * this.page == 10 ? 0 : this.tableSize * (this.page - 1);
	// 		let C: any = Math.floor(Math.floor(c) + Math.floor(this.tableSize));
	// 		for (let i = 0; i < this.getDID.length; i++) {
	// 			if (i >= c && i < C) {
	// 				this.listedDid.push(this.getDID[i]);
	// 			}
	// 		}
	// 	}
	// 	let count: any = '';
	// 	if (this.page <= 1)
	// 		count = this.page;
	// 	else
	// 		count = ((this.page - 1) * 10) + 1;
	// 	let tblEntry = 0
	// 	if (this.tableSize * this.page <= this.getDID.length) {
	// 		tblEntry = this.tableSize * this.page
	// 	} else {
	// 		tblEntry = this.getDID.length
	// 	}

	// 	this.shwoingEntry = count;
	// 	this.sInfo = "Showing " + count + " to " + tblEntry + " of " + this.getDID.length + " entries ";
	// 	this.listedDid.forEach((ele: any) => {
	// 		ele.isChecked = false;
	// 	});
	// }

	// onTableDataChange(event) {
	// 	this.page = event;
	// 	this.getDID;
	// 	this.onTableSizeChange(this.tableSize);
	// }

	// minus() {
	// 	this.tableSize = Math.floor(Math.floor(this.tableSize) - Math.floor(1));
	// 	this.onTableSizeChange(this.tableSize);
	// 	if (this.tableSize == 1) {
	// 		this.dismiss = true;
	// 	}
	// 	else {
	// 		this.dismiss = false;
	// 	}
	// 	if (this.tableSize < 1000) {
	// 		this.increse_stop = false;
	// 	}
	// 	else {
	// 		this.increse_stop = true;
	// 	}
	// }
	// plus() {
	// 	this.tableSize = Math.floor(Math.floor(this.tableSize) + Math.floor(1));
	// 	this.onTableSizeChange(this.tableSize);
	// 	if (this.tableSize > 1) {
	// 		this.dismiss = false;
	// 		if (this.tableSize > 999) {
	// 			this.increse_stop = true;
	// 		}
	// 		else {
	// 			this.increse_stop = false;
	// 		}
	// 	}
	// 	else {
	// 		this.dismiss = true;
	// 	}

	// }

}