import { Action } from '@ngrx/store';
import { Cart } from './inbound.class';
 
export const SET = 'SET Items In Cart';
export const ADD = 'ADD One More Item In Cart';
// export const ADDALL = 'ADDALL Items In Cart';
export const REMOVE = 'REMOVE Items from Cart';
export const RESET = 'RESET Cart';
export const REMOVE_ITEMS = "REMOVE SELECTED CART ITEMS";

 
export class Set implements Action {
  readonly type = SET;

  constructor(public payload: Cart[]){}
}

export class Add implements Action{
  readonly type = ADD;

  constructor(public payload: Cart[]){}
}

// export class AddAll implements Action{
//   readonly type = ADDALL;

//   constructor(public payload: Cart[]){}
// }
 
export class Remove implements Action {
  readonly type = REMOVE;

  constructor(public payload){}
}

export class RemoveItems implements Action {
  readonly type = REMOVE_ITEMS;

  constructor(public payload){}
}
 
export class Reset implements Action {
  readonly type = RESET;

  constructor(public payload: Cart[]){}
}



export type InboundActions =
  | Add
  | Set
  | Remove
  | Reset
  | RemoveItems