import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl } from '@angular/forms';
import { InboundService } from '../inbound.service';
import { loadnumber, LoadnumberForm} from '../inbound.class';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
@Component({
  selector: 'app-loadnumber',
  templateUrl: './loadnumber.component.html',
  styleUrls: ['./loadnumber.component.css']
})
export class LoadnumberComponent extends AppComponentClass<loadnumber, LoadnumberForm> {

	public LoadnumberForm: FormGroup;
	public submitted : boolean = false;


  constructor(public data: InboundService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}
  ngOnInit(): void {
    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new LoadnumberForm(res);
				this.keyfield = res.id;
				this.LoadnumberForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new LoadnumberForm(null);
				this.keyfield = -1;
				this.LoadnumberForm = this.cdata.makeform(this.fb);
			}
		});
  }


    // @to save/update form data
	onSubmit() {
		console.log("event task save");
		this.submitted = true;

		if (this.LoadnumberForm.invalid) {
			return false;
		} else {
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.LoadnumberForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

}
