import { Component, ElementRef, HostListener, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { NewCamapignService } from '../new-camapign.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { PlatformLocation } from '@angular/common';
declare var $: any;

@Component({
	selector: 'app-campaign-new',
	templateUrl: './campaign-new.component.html',
	styleUrls: ['./campaign-new.component.css']
})
export class CampaignNewComponent extends AppComponentClass<any, any> {
	// connectionsmodal
	@ViewChild('connectionsmodal') connectionsmodal: ElementRef;
	@ViewChild('editmodalspending') editmodalspending: ElementRef;
	@ViewChild('approveCampaignModal') approveCampaignModal: ElementRef;
	@ViewChild('closeDCAModal') closeDCAModal: ElementRef;
	@ViewChild('finalClosebutton') finalClosebutton: ElementRef;
	@ViewChild('verifyCloseBtn') verifyCloseBtn: ElementRef;
	@ViewChild('editpending') editpending: ElementRef;
	@ViewChild('editprovisioning') editprovisioning: ElementRef;
	@ViewChild('dcasubmit') dcasubmit: ElementRef;
	@ViewChild('brandSelectModal') brandSelectModal: ElementRef;
	@ViewChild('campaignSelectModal') campaignSelectModal: ElementRef;
	@ViewChild('connection') connection: ElementRef;
	@ViewChild('closeDID') closeDID: ElementRef;
	@ViewChild('closebutton') closebutton;
	@ViewChild('secondclosebutton') secondclosebutton;
	@ViewChild('copyCampaign') copyCampaign: ElementRef;
	@ViewChild('requestToRejectModal') requestToRejectModal: ElementRef;
	public show: boolean = false;
	brandId: any = null;
	/* searchText = { count: 0 };
	filtre: string; */
	campaigns: any = [];
	campaignsfilter: any = [];
	responseMessage = "";
	collection: any;
	heading: any;
	main_heading: any;
	isCampaign: boolean = false;
	errMessage: any = "";
	campaign_key: any;
	// referenceId: any;
	exportButton: any;
	iduser: any;
	idaccount: any;
	campDid: any = [];
	useCase: any = [];
	public filterCampaign: FormGroup;
	EXCEL_TYPE = 'application/csv';
	EXCEL_EXTENSION = '.csv';
	userType: any;
	messs: string = '';
	pending_review: any = [];
	shared_campaign: any = [];
	failed_campaign: any = [];
	completed_campaign: any = [];
	headingComplete: any;
	tabNm: any = "All";
	heading1: any;
	san: any;
	users: any = [];
	all_campaign: any = [];
	userlist: any = [];
	campaignsfilterCSV: any = [];
	customer_action_req: any = [];
	rejectForm: FormGroup
	failedForm: FormGroup
	campData: any = {};
	submitted: boolean = false;
	pending_profile: any = [];
	without_save: any[];
	without: any = [];
	redundant_campaign: any;
	campaign: any;
	allCustCampaign: any = [];
	headingRedundant: any;
	customer_redundant: any;
	approvedCampaign: any = [];
	disableReject: boolean = false;
	brandtype: any;
	campaigntype: any;
	copyCampData: any = [];
	smcKey: any;
	brandName: any;
	oldbrandId: any;
	upStreamId: any;
	c_key: any;
	idUser: any;
	selectedRedundent: any = [];
	selectedRedundent2: any = [];
	smsSupplier: any = [];
	selectedData: any = [];
	selectedOption: any;
	parent_campaign: any = [];
	dcaSubForm: FormGroup;
	sm_reference_no: string;
	parent_campaign_id: string;
	updatedCopyRedundantCampId: string;
	copyRedundantCampId: string;
	checkbox1Checked: boolean = false;
	checkbox2Checked: boolean = false;
	checkbox3Checked: boolean = false;
	checkbox4Checked: boolean = false;
	onchecktypefirst: any = '';
	onchecktypefinal: any;
	headerDCA: any;
	disableDCA: boolean = false;

	constructor(public data: NewCamapignService, public userService: UsermanagementService,
		public router: Router, public fb: FormBuilder,
		private route: ActivatedRoute,private platformlocation : PlatformLocation) {
		super(data, router, fb);
		history.pushState(null,'',location.href)
		this.platformlocation.onPopState(()=>{
			history.pushState(null,'',location.href)      
		})
	}

	ngOnInit(): void {
		let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type;
		this.iduser = session.iduser;
		this.idaccount = session.idaccount;

		this.exportButton = 'Download Campaign';
		this.data.getcampaign().subscribe((result) => {
			this.collection = result[1]
			$.getScript('./assets/table.js');
			this.heading = result[0].headers
			this.heading1 = result[0].headers1
			this.headingComplete = result[0].headersComplete
			this.headingRedundant = result[0].headersRedundant
			this.main_heading = result[0].users
			this.customer_redundant = result[0].CustomerRedundant
			this.headerDCA = result[0].headersDCA
		});

		this.filterCampaign = this.fb.group({
			brandId: [],
			brand_name: [],
			referenceId: [],
			usecase: [],
			campaign_key: [],
			sm_reference_no: [],
			parent_campaign_id: [],
			tcrStatus: [],
			filter_type: [],
			provisioning_status: [],
			idaccount: []
		});
		this.filterCampaign.patchValue({
			filter_type: this.userType == 1 ? "All" : 'All'
		})
		this.route.paramMap.subscribe((params: ParamMap) => {
			this.brandId = params.get('id');
			if (this.brandId) {
				$('#basic-datatables14').DataTable().clear();
				$('#basic-datatables14').DataTable().destroy();
				this.data.onGetNewCampaigns(this.brandId).subscribe(result => {
					if (result.status == 200) {
						if (result.data.length > 0) {
							this.campaigns = result.data;
							$.getScript('./assets/table.js');
							this.isCampaign = true;
						}
					}
					else {
						this.errMessage = result.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});
			}
		});

		/**See Usecases Records */
		this.data.getuseCases().subscribe(res => {
			this.useCase = res.data;
		});

		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
			this.userlist.sort((a, b) => {
				return a.san - b.san;
			});
		});

		this.campaignsList();

		this.rejectForm = this.fb.group({
			desc_details: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
		})
		this.failedForm = this.fb.group({
			desc_details: ['', Validators.required],
			mailCheck: []
		})
		this.dcaSubForm = this.fb.group({
			serviceName: ['', [Validators.required]]
		})

	}
	onInput(event: Event) {
		const inputElement = event.target as HTMLTextAreaElement;
		const trimmedValue = inputElement.value.replace(/^\s+/, '');
		this.failedForm.get('desc_details')?.setValue(trimmedValue, { emitEvent: false });
	}

	getCampRegDID(camp: any, userid: any) {
		this.campaign_key = camp
		this.campDid = [];
		this.data.getCampaignDID(camp, userid).subscribe((res) => {
			if (res.status == 200) {
				this.campDid = res.data;
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			} else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	campaignID(event: Event) {
		this.campaign_key = (event.target as HTMLInputElement).value.toUpperCase();
	}
	smCampaignID(event: Event) {
		this.sm_reference_no = (event.target as HTMLInputElement).value.toUpperCase();
	}

	parentCampaignID(event: Event) {
		this.parent_campaign_id = (event.target as HTMLInputElement).value.toUpperCase();
	}

	brandID(event: Event) {
		this.brandId = (event.target as HTMLInputElement).value.toUpperCase();
	}

	showfilter() {
		if (this.show == false) {
			this.show = true;
		}
		else {
			this.show = false;
		}

	}

	resetFilter() {
		this.messs = '';
		this.tabNm = this.tabNm;
		this.filterCampaign.reset({
			filter_type: this.tabNm
		});
		this.campaignsList();
		// this.ngOnInit();
	}
	tabName(e) {
		this.tabNm = e;
		this.filterCampaign.reset();
		this.filterCampaign.patchValue({
			filter_type: this.userType == 1 ? e : e
		})
	}


	campaignsList() {
		let payLoad = JSON.stringify({
			idaccount: this.idaccount,
			iduser: this.iduser
		});
		$('#basic-datatablessCus').DataTable().clear();
		$('#basic-datatablessCus').DataTable().destroy();
		$('#basic-datatables14a').DataTable().clear();
		$('#basic-datatables14a').DataTable().destroy();
		$('#basic-datatables14aa').DataTable().clear();
		$('#basic-datatables14aa').DataTable().destroy();
		$('#basic-datatables01').DataTable().clear();
		$('#basic-datatables01').DataTable().destroy();
		$('#basic-datatables02').DataTable().clear();
		$('#basic-datatables02').DataTable().destroy();
		$('#basic-datatables03').DataTable().clear();
		$('#basic-datatables03').DataTable().destroy();
		$('#basic-datatables14b').DataTable().clear();
		$('#basic-datatables14b').DataTable().destroy();
		$('#basic-datatablescampaign').DataTable().clear();
		$('#basic-datatablescampaign').DataTable().destroy();
		$('#basic-datatablesRed').DataTable().clear();
		$('#basic-datatablesRed').DataTable().destroy();
		$('#basic-datatablessPen').DataTable().clear();
		$('#basic-datatablessPen').DataTable().destroy();
		$('#basic-datatablesAC').DataTable().clear();
		$('#basic-datatablesAC').DataTable().destroy()

		this.data.GetCampaignsList(payLoad).subscribe(result => {
			if (result.status == 200) {
				var userID = this.data.iduser;
				this.campaigns = [];
				this.all_campaign = [];
				this.pending_review = [];
				this.shared_campaign = [];
				this.completed_campaign = [];
				this.failed_campaign = [];
				this.customer_action_req = [];
				this.pending_profile = [];
				this.campaign = [];
				this.redundant_campaign = [];
				this.without = [];
				this.without_save = [];
				this.allCustCampaign = [];

				if (result.data.length > 0) {
					this.campaigns = result.data;
					if (this.userType == 1) {
						this.campaigns.forEach(element => {
							if (element.provisioning_status == 0) {
								element.provisioning_status = 'Campaign Submission Pending';
								this.pending_review.push(element);
							}
							if (element.provisioning_status == 5 && element.deleted == 0) {
								element.provisioning_status = 'Customer Action Required'
								this.customer_action_req.push(element);
							}
							if (element.provisioning_status == 1 || element.provisioning_status == 2) {
								if (element.provisioning_status == 2) {
									element.provisioning_status = 'Provisioning pending'
								}
								else {
									element.provisioning_status = 'Campaign Shared'
								}
								this.shared_campaign.push(element);
							}
							if (element.provisioning_status == 3) {
								element.provisioning_status = 'Campaign Provisioned'
								this.completed_campaign.push(element);
							}
							if (element.provisioning_status == 4) {
								element.provisioning_status = 'Provisioning Failed'
								this.failed_campaign.push(element);
							}
							if (element.provisioning_status == 7 && element.deleted == 0 && element.status == 0) {
								element.provisioning_status = 'Pending for Profile Approval'
								this.pending_profile.push(element);
							}
							if (element.status == 2) {
								if (element) {
									if (element.parent_campaign_id) {
										let matchingCampaign = this.campaigns.find(
											campaign => campaign.campaign_key === element.parent_campaign_id && campaign.status === 0
										);
										if (matchingCampaign) {
											element.parent_dca = matchingCampaign.upstreamCnpId;
										}
									}
								}
								this.redundant_campaign.push(element)
								this.setStatus(this.redundant_campaign);
							}
						})
						this.redundant_campaign.forEach((campaign) => {
							if (campaign.provisioning_status !== 'Save' && campaign.provisioning_status === 'Pending for Profile Approval' && campaign.deleted == 0) {
								this.without_save.push(campaign);
							}
						})
						this.all_campaign = result.data;

						this.setStatus(this.all_campaign);
						this.all_campaign.forEach((campaign) => {
							if (campaign.provisioning_status !== 'Save') {
								this.without.push(campaign);
							}
						})
					}
					else if (this.userType == 2) {
						this.campaigns.forEach(element => {
							if (element.status == 0) {
								this.campaign.push(element);
								this.setStatus(this.campaign);
							}
							if (element.status == 2) {
								this.redundant_campaign.push(element);
								this.setStatus(this.redundant_campaign);
							}
							this.allCustCampaign = result.data;
							this.setStatus(this.allCustCampaign);
							$('#basic-datatablesAC').DataTable().clear();
							$('#basic-datatablesAC').DataTable().destroy();
						});
					}
					this.messs = '';
					this.isCampaign = true;

				}
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	setStatus(list) {
		list.forEach(element => {
			if (element.provisioning_status == 0) {
				element.provisioning_status = 'Campaign Submission Pending'
			}
			if (element.provisioning_status == 1) {
				element.provisioning_status = 'Campaign Shared'
			}
			if (element.provisioning_status == 2) {
				element.provisioning_status = 'Provisioning Pending'
			}
			if (element.provisioning_status == 3) {
				element.provisioning_status = 'Campaign Provisioned'
			}
			if (element.provisioning_status == 4) {
				element.provisioning_status = 'Provisioning Failed'
			}
			if (element.provisioning_status == 5) {
				element.provisioning_status = 'Customer Action Required'
			}
			if (element.provisioning_status == 6) {
				element.provisioning_status = 'Save'
			}
			if (element.provisioning_status == 7) {
				element.provisioning_status = 'Pending for Profile Approval'
			}
		})
	}
	applyCamFilter() {
		/* if(this.filterCampaign.value.campaign_key || this.filterCampaign.value.usecase || 
			this.filterCampaign.value.brandId || this.filterCampaign.value.brand_name || this.filterCampaign.value.tcrStatus )
			  { */
		// this.campaigns = [];
		// this.pending_review = [];
		// this.shared_campaign = [];
		// this.completed_campaign = [];
		// this.failed_campaign = [];
		// this.all_campaign =[];
		this.data.applyCampaignFilter(this.filterCampaign.value).subscribe(res => {
			if (res.status == 200) {
				this.messs = '';
				this.campaignsfilter = res.data;
				this.campaignsfilterCSV = res.data;

				if (this.userType == 1) {
					if (this.tabNm == "DCA Submission") {
						$('#basic-datatables14a').DataTable().clear();
						$('#basic-datatables14a').DataTable().destroy();
						this.pending_review = this.campaignsfilter;
						this.setStatus(this.pending_review);
					}
					if (this.tabNm == "Customer Action Required") {
						$('#basic-datatables14aa').DataTable().clear();
						$('#basic-datatables14aa').DataTable().destroy();
						this.customer_action_req = this.campaignsfilter;
						this.setStatus(this.customer_action_req);
					}
					if (this.tabNm == "Shared") {
						$('#basic-datatables01').DataTable().clear();
						$('#basic-datatables01').DataTable().destroy();
						this.shared_campaign = this.campaignsfilter;
						this.setStatus(this.shared_campaign);
					}
					if (this.tabNm == "Failed") {
						$('#basic-datatables02').DataTable().clear();
						$('#basic-datatables02').DataTable().destroy();
						this.failed_campaign = this.campaignsfilter;
						this.setStatus(this.failed_campaign);
					}
					if (this.tabNm == "Completed") {
						$('#basic-datatables03').DataTable().clear();
						$('#basic-datatables03').DataTable().destroy();
						this.completed_campaign = this.campaignsfilter;
						this.setStatus(this.completed_campaign);
					}
					if (this.tabNm == "Pending for Profile Approval") {
						$('#basic-datatablessPen').DataTable().clear();
						$('#basic-datatablessPen').DataTable().destroy();
						this.pending_profile = this.campaignsfilter;
						this.setStatus(this.pending_profile);
					}
					if (this.tabNm == "All") {
						$('#basic-datatables14b').DataTable().clear();
						$('#basic-datatables14b').DataTable().destroy();
						this.without = this.campaignsfilter.filter(campaign => campaign.provisioning_status !== 6);
						this.setStatus(this.without);
					}
					if (this.tabNm == "Redundant Campaign") {
						$('#basic-datatablesRed').DataTable().clear();
						$('#basic-datatablesRed').DataTable().destroy();
						this.without_save = this.campaignsfilter.filter(campaign => campaign.provisioning_status == 7 && campaign.status == 2);
						this.setStatus(this.without_save);
					}
				}
				else {
					if (this.tabNm == "All") {
						$('#basic-datatablesAC').DataTable().clear();
						$('#basic-datatablesAC').DataTable().destroy();
						this.allCustCampaign = this.campaignsfilter;
						this.setStatus(this.allCustCampaign);
					}
					if (this.tabNm == "AllCamp") {
						$('#basic-datatablessCus').DataTable().clear();
						$('#basic-datatablessCus').DataTable().destroy();
						this.campaign = this.campaignsfilter.filter((camp) => camp.status !== 2);
						this.setStatus(this.campaign);
					}
					if (this.tabNm == "Redundant Campaign") {
						$('#basic-datatablescampaign').DataTable().clear();
						$('#basic-datatablescampaign').DataTable().destroy();
						this.redundant_campaign = this.campaignsfilter.filter((camp) => camp.status == 2);
						this.setStatus(this.redundant_campaign);
					}
				}
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		})
		/* }
	else
	{
		this.messs="Please Enter atleast 1 field!";
	} */
	}

	dcaSubmit(campaign_key, iduser, idaccount, service) {
		let payload = JSON.stringify({
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
			service: service
		});
		this.data.dcaSubmit(payload).subscribe((res) => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				this.closeDCAModal.nativeElement.click();
				this.selectedData = [];
				this.dcaSubForm.get('serviceName').setValue('');
				this.submitted = false;
				setTimeout(() => {
					this.ngOnInit();
					this.responseMessage = "";
					this.disableDCA = false;
				}, 5000);
			}
			else {
				this.errMessage = res.message;
				this.disableDCA = false;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}

	downloadCSVFile() {
		this.applyCamFilter();
		setTimeout(() => {
			let dataToDownload = [];
			if (this.userType == 2) {
				if (this.tabNm == "Redundant Campaign") {
					dataToDownload = this.redundant_campaign;
				}
				else if (this.tabNm == "All") {
					dataToDownload = this.allCustCampaign;
				}
				else if (this.tabNm == "AllCamp") {
					dataToDownload = this.campaign;
				}
				dataToDownload = dataToDownload.map(item => ({
					...item,
					'TCR Status': item.deleted === 0 ? 'Active' : 'Deactivate'
				}));
			}
			else if (this.userType == 1) {
				if (this.tabNm == "All") {
					dataToDownload = this.without.map(item => {
						const { idaccount, ...rest } = item;
						return { ...rest, 'SAN': 100000000 + idaccount, 'TCR Status': item.deleted === 0 ? 'Active' : 'Deactivate' };
					});
				}
				else if (this.tabNm == "Redundant Campaign") {
					dataToDownload = this.without_save.map(item => {
						const { idaccount, ...rest } = item;
						return { ...rest, 'SAN': 100000000 + idaccount, 'TCR Status': item.deleted === 0 ? 'Active' : 'Deactivate', 'Parent DCA': item.parent_dca };
					});
				}
				else if (this.tabNm == "DCA Submission") {
					dataToDownload = this.pending_review.map(item => {
						const { idaccount, ...rest } = item;
						return { ...rest, 'SAN': 100000000 + idaccount, 'TCR Status': item.deleted === 0 ? 'Active' : 'Deactivate', 'Parent DCA': item.parent_dca };
					});
				}
				else {
					dataToDownload = this.campaignsfilterCSV.map(item => {
						const { idaccount, ...rest } = item;
						return { ...rest, 'SAN': 100000000 + idaccount, 'TCR Status': item.deleted === 0 ? 'Active' : 'Deactivate' };
					});
				}
			}
			if (dataToDownload.length > 0) {
				let NewFilteredRes = dataToDownload.map(item => {
					const { iduser, deleted, status, parent_dca, ...rest } = item;
					Object.keys(rest).forEach(key => {
						if (key === 'brandId') {
							rest['Brand ID'] = rest[key];
							delete rest[key];
						}else if (key == 'parent_campaign_id' && (this.tabNm == "Pending for Profile Approval" || this.tabNm == "Shared" || this.tabNm == "Customer Action Required" || this.tabNm == "Failed" || this.tabNm == "Completed")) {
							delete rest[key]
						}
						else if (this.tabNm === "All"  && key == 'parent_campaign_id' || key == 'parent_sm_reference_no' ) {
							delete rest[key]
						}
						else if (this.tabNm === "AllCamp"  && key == 'parent_campaign_id' || key == 'parent_sm_reference_no' ) {
							delete rest[key]
						}	
                        else if (key === 'upstreamCnpId') {
							delete rest[key];
						}
						 else if (key === 'usecase') {
							rest['Use Case'] = rest[key];
							delete rest[key];
						} else if (key === 'sm_reference_no') {
							rest['SM Reference No.'] = rest[key];
							delete rest[key];
						} else if (key.includes('_')) {
							const newKey = key.replace(/_/g, ' ').replace(/\b\w/g, c => c.toUpperCase());
							rest[newKey] = rest[key];
							delete rest[key];
						}
					});
					if (rest['Start Date']) {
						rest['Start Date'] = new Date(rest['Start Date']).toLocaleDateString('en-GB');
					}
					return rest;
				});
				const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
				const workbook: XLSX.WorkBook = { Sheets: { 'Campaign': worksheet }, SheetNames: ['Campaign'] };
				const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
				this.saveAsExcelFile(excelBuffer, "Campaign");
				// this.ngOnInit();
			}
			else {
				this.errMessage = "No Record Available!";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, 5000);
	}

	getCampaignDetails(campaign_key, iduser, idaccount) {
		this.rejectForm.reset();
		this.campData = {
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
		};
	}

	campaignFailed(campaign_key, iduser, idaccount) {
		this.failedForm.reset();
		this.campData = {
			campId: campaign_key,
			iduser: iduser,
			idaccount: idaccount,
		};
	}
	// formSubmit() {
	// 	if (this.rejectForm.invalid) {
	// 		this.submitted = true;
	// 	}
	// 	else {
	// 		this.campData.desc_details=this.rejectForm.value.desc_details;
	// 		this.data.rejectFormByAdmin(this.campData).subscribe(res => {
	// 			  if (res.status == 201) {
	// 			this.responseMessage = res.message;
	// 			setTimeout(() => {
	// 			  this.responseMessage = "";
	// 			  document.getElementById("requestToEdit").click();
	//               window.location.reload();
	// 			}, 5000);
	// 		  }
	// 		  else {
	// 			this.errMessage = res.message;
	// 			setTimeout(() => {
	// 			  this.errMessage = "";
	// 			}, 5000);
	// 		  }
	// 		});
	// 	}
	// }
	saveForm() {
		if (this.failedForm.invalid) {
			this.submitted = true;
		}
		else {
			this.campData.desc_details = this.failedForm.value.desc_details;
			this.campData.mailCheck = this.failedForm.value.mailCheck;
			this.data.failedFormByAdmin(this.campData).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
						document.getElementById("requestToEditForFailed").click();
						window.location.reload();
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}
	resetRequest() {
		this.rejectForm.reset();
		this.submitted = false;
	}
	resetFailed() {
		this.failedForm.reset();
		this.submitted = false;
	}
	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}
	openApproveModal(data) {
		this.approvedCampaign = data;
	}
	modalApprove() {
		this.approveCamp(this.approvedCampaign.sm_reference_no, this.approvedCampaign.iduser , this.approvedCampaign.idaccount)
	}
	
	approveCamp(smKey, iduser , idaccount) {
		let payLoad = {
			campId: smKey,
			iduser: iduser,
			idaccount: idaccount
		}
		this.data.campApproveByAdmin(payLoad).subscribe((resApprove) => {
			if (resApprove.status == 200) {
				this.responseMessage = resApprove.message;
				this.disableReject = true;
				setTimeout(() => {
					this.responseMessage = "";
					this.approveCampaignModal.nativeElement.click();
					this.campaignsList();
					this.disableReject = false;
				}, 5000);
			}
			else {
				this.errMessage = resApprove.message;
				this.disableReject = false;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000)
			}
		})
	}
	getCampaign_Details(campId, iduser) {
		this.rejectForm.reset();
		this.campData = {
			campId: campId,
			iduser: iduser,
			idaccount: this.idaccount,
		};
	}
	formSubmit() {
		if (this.rejectForm.invalid) {
			this.submitted = true;
		}
		else {
			this.campData.desc_details = this.rejectForm.value.desc_details;
			this.data.rejectFormByAdmin(this.campData).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
						document.getElementById("requestToEdit").click();
						window.location.reload();
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}
	Resetrejectform() {
		this.rejectForm.reset();
		this.submitted = false;
	}
	goDetail(status,provstus, campKey, iduser, smCampKey, bId, Bname) {
		this.data.campaignId = campKey
		if (provstus == 'Save' && this.campaigntype == "edit_campaign") {
			this.router.navigate(['/new-campaign/redundant_campaign/', `${smCampKey}-${bId}-${iduser}-${Bname}-${campKey}-${this.brandtype}-${this.campaigntype}-${provstus}`]);
		}

		else if (provstus == 'Save'&& status !=2) {
			this.router.navigate(['/new-campaign/copy_campaign/', smCampKey + '-' + bId + '-' + iduser + '-' + Bname + '-' + provstus]);
		}
		else if (provstus == 'Save' && status ==2) {
			this.router.navigate(['/new-campaign/copy_campaign/', smCampKey + '-' + bId + '-' + iduser + '-' + Bname + '-' + provstus + '-' +'Redundant']);
		}
		else {
			this.router.navigate(['/new-campaign/campaign-details', smCampKey + '-' + iduser])
		}
	}
	tabNamed(name) {
		if (name == 'redundant') {
			this.campaigntype = 'edit_campaign';
			this.brandtype = 'same_brand';
		}

	}
	copyCampModal(data) {
		this.copyCampData = data;
	}
	setRedudantDetails(smc_Key, brandid, idUser, idaccount, brand_name, camp_key, upstream) {
		this.smcKey = smc_Key;
		this.oldbrandId = brandid;
		this.idUser = idUser;
		this.idaccount = idaccount;
		this.brandName = brand_name;
		this.c_key = camp_key;
		this.upStreamId = upstream;
		if (this.upStreamId) {
			this.selectedRedundent2 = [];
			let payLoad = JSON.stringify({
				iduser: this.idUser,
				idaccount: this.idaccount
			});

			let openModal = true;
			this.data.getDCAServices().subscribe(supplier => {
				this.smsSupplier = supplier.data;
				this.campaigns.forEach((element: any, index: any) => {
					if (element.parent_campaign_id == this.c_key) {
						this.selectedRedundent2.push(element);
					}
					if (this.campaigns.length - 1 == index) {
						if (this.smsSupplier.length - 1 == this.selectedRedundent2.length) {
							this.errMessage = "Redundant Campaign Creation limit Exceed!";
							openModal = false;
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}
						else {
							let openmodal = document.getElementById('redundantcampaign')
							if (openmodal) {
								$('#redundantcampaign').modal({
									backdrop: 'static',
									keyboard: false
								});
								$(openmodal).modal('show');
							}
						}
					}
				});
			});
		}
		else {
			this.errMessage = "Campaign Not Approved!";
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		}
	}
	openDCAModal(data) {
		this.selectedData = data;
		let payLoad = JSON.stringify({
			iduser: this.selectedData.iduser,
			idaccount: this.selectedData.idaccount
		});

		this.data.getDCAServices().subscribe(supplier => {
			this.smsSupplier = supplier.data;
			this.smsSupplier.forEach(item => {
				if (item.sms_provider === "SYNIV") {
					item.sms_provider = "SYNIVERSE";
				}
			});
			this.selectedOption = this.findSupplier(supplier.data);
			this.dcaSubForm.get('serviceName').setValue(this.selectedOption);

			if (this.selectedData.status == 2) {
				this.parent_campaign = this.all_campaign.filter(element =>
					element.campaign_key === this.selectedData.parent_campaign_id &&
					element.iduser === this.selectedData.iduser
				);
				this.selectedRedundent = this.all_campaign.filter(element =>
					element.parent_campaign_id === this.selectedData.parent_campaign_id &&
					element.iduser === this.selectedData.iduser
				);

				this.parent_campaign.forEach(element => {
					this.smsSupplier.forEach(ele => {
						let provider = ele.sms_provider;
						if (element.upstreamCnpId === "SYNIV") {
							element.upstreamCnpId = "SYNIVERSE";
						}
						if (provider == element.upstreamCnpId) {
							ele['disabled'] = true;
							this.dcaSubForm.get('serviceName').setValue('');
						}
					});
				});

				this.selectedRedundent.forEach(element => {
					this.smsSupplier.forEach(ele => {
						let provider = ele.sms_provider;
						if (provider == element.upstreamCnpId) {
							ele['disabled'] = true;
						}
					});
				});
			}
		});
	}
	findSupplier(data) {
		let supplierKey = null;
		data.forEach(item => {
			const idsupplier = item.idosr_nnid;
			supplierKey = idsupplier;
			// const foundItem = data.find(element => element.key === idsupplier);
			// if (foundItem) {
			// 	supplierKey = foundItem.key;
			// }
		});
		return supplierKey;
	}
	submitDCA() {
		if (this.dcaSubForm.get('serviceName').invalid) {
			this.submitted = true;
			return
		}
		else {
			const selectedService = this.dcaSubForm.get('serviceName').value;
			let selectedData = this.smsSupplier.find(element => element.idosr_nnid == selectedService)
			if (this.selectedData && this.dcaSubForm.valid) {
				this.dcaSubmit(this.selectedData.campaign_key, this.selectedData.iduser, this.selectedData.idaccount, selectedData);
			}
			this.disableDCA = true;
		}
	}
	resetDCA() {
		this.submitted = false;
		this.dcaSubForm.reset();
		this.dcaSubForm.get('serviceName').setValue('');
	}

	closeDCA() {
		this.selectedOption = "";
		this.smsSupplier = [];
		this.selectedData = [];
		this.dcaSubForm.reset();
	}
	navigateToCopy() {
		this.copyCampaign.nativeElement.click();
		this.router.navigate(['/new-campaign/copy_campaign/', this.copyCampData.sm_reference_no + '-' + this.copyCampData.brandId + '-' + this.copyCampData.iduser + '-' + this.copyCampData.brand_name])
	}
	sameRedundantCampaign() {
		this.finalClosebutton.nativeElement.click();
		this.campaigntype = this.onchecktypefinal;
		let campaigntype = this.onchecktypefinal;
		if (campaigntype == 'same_campaign') {
			const parts = this.copyRedundantCampId.split('-');
			const fetchedbrantype = parts[parts.length - 1];
			if (fetchedbrantype == "new_brand") {
				let newBrandId: any = this.redundantBrandRegister(this.copyRedundantCampId);
				if (newBrandId instanceof Promise) {
					newBrandId.then((resolvedBrandId: any) => {
						if (resolvedBrandId) {
							this.updatedCopyRedundantCampId = `${this.smcKey}-${resolvedBrandId}-${this.iduser}-${this.brandName}-${this.c_key}-${fetchedbrantype}-${campaigntype}-${this.oldbrandId}`;
							setTimeout(() => {
								this.router.navigate(['/new-campaign/redundant_campaign', this.updatedCopyRedundantCampId]);
							}, 150);
						}
						else {
							console.log('newBrandId was not returned from redundantBrandRegister');
						}
					}).catch((error: any) => {
						console.log('Error fetching newBrandId:', error);
					});
				} else {
					console.log('redundantBrandRegister did not return a Promise');
				}
			} else {
				this.updatedCopyRedundantCampId = `${this.copyRedundantCampId}-${campaigntype}`;
				setTimeout(() => {
					this.router.navigate(['/new-campaign/redundant_campaign', this.updatedCopyRedundantCampId]);
				}, 150);
			}
		}
		if (campaigntype == 'edit_campaign') {
			const parts = this.copyRedundantCampId.split('-');
			const fetchedbrantype = parts[parts.length - 1];
			if (fetchedbrantype == "new_brand") {
				let newBrandId: any = this.redundantBrandRegister(this.copyRedundantCampId);
				if (newBrandId instanceof Promise) {
					newBrandId.then((resolvedBrandId: any) => {
						if (resolvedBrandId) {
							this.updatedCopyRedundantCampId = `${this.smcKey}-${resolvedBrandId}-${this.iduser}-${this.brandName}-${this.c_key}-${fetchedbrantype}-${campaigntype}-${this.oldbrandId}`;
							setTimeout(() => {
								this.router.navigate(['/new-campaign/redundant_campaign', this.updatedCopyRedundantCampId]);
							}, 150);
						}
						else {
							console.log('newBrandId was not returned from redundantBrandRegister');
						}
					}).catch((error: any) => {
						console.log('Error fetching newBrandId:', error);
					});
				} else {
					console.log('redundantBrandRegister did not return a Promise');
				}
			}
			else {
				this.updatedCopyRedundantCampId = `${this.copyRedundantCampId}-${campaigntype}`;
				setTimeout(() => {
					this.router.navigate(['/new-campaign/redundant_campaign', this.updatedCopyRedundantCampId]);
				}, 150);
			}
		}
	}
	async redundantBrandRegister(copyRedundantCampId): Promise<any> {
		return new Promise((resolve, reject) => {
			this.submitted = true;
			if (!copyRedundantCampId) {
				reject('copyRedundantCampId is empty');
			} else {
				this.data.redundantBrandRegister(copyRedundantCampId).subscribe(response => {
					if (response.status == 201) {
						setTimeout(() => {
							this.responseMessage = "";
							resolve(response.brandId);
						}, 5000);
					} else {
						this.errMessage = response.message;
						setTimeout(() => {
							this.errMessage = "";
							reject(response.message); // Reject with error message
						}, 5000);
					}
				}, error => {
					reject(error); // Reject with error
				});
			}
		});
	}
	Back() {
		this.secondclosebutton.nativeElement.click();
		this.checkbox3Checked = false;
		this.checkbox4Checked = false;
		this.checkbox1Checked = false;
		this.checkbox2Checked = false;
	}
	alertCheck(type) {
		this.onchecktypefirst = type;
	}
	alertCheckfinal(type) {
		this.onchecktypefinal = type;
	}
	onSecondCloseButtonClick() {
		this.Back()
		this.resetCheckboxes();
		this.editmodalspending.nativeElement.click();
		let openModal = document.getElementById('redundantcampaign')
		$(openModal).modal('hide')
		$('#redundantcampaign').modal({
			backdrop: false
		});;
		let openmodal1 = document.getElementById('redundantmodal')
		$(openmodal1).modal('hide');
		$('#redundantmodal').modal({
			backdrop: false
		});
	}
	resetCheckboxes() {
		// Reset checkboxes in the brandSelectModal 
		if (this.brandSelectModal && this.brandSelectModal.nativeElement) {
			this.brandSelectModal.nativeElement.querySelectorAll('input[type="radio"]').forEach((el: HTMLInputElement) => {
				el.checked = false;
			});
		}

		// Reset checkboxes in the campaignSelectModal 
		if (this.campaignSelectModal && this.campaignSelectModal.nativeElement) {
			this.campaignSelectModal.nativeElement.querySelectorAll('input[type="radio"]').forEach((el: HTMLInputElement) => {
				el.checked = false;
			});
		}
	}
	oncheck() {
		this.brandtype = this.onchecktypefirst
		// this.verifyCloseBtn.nativeElement.click();
		if (this.brandtype == "same_brand") {
			this.copyRedundantCampId = `${this.smcKey}-${this.oldbrandId}-${this.iduser}-${this.brandName}-${this.c_key}-${this.brandtype}`;
		}
		else if (this.brandtype == "new_brand") {
			this.copyRedundantCampId = `${this.smcKey}-${this.oldbrandId}-${this.iduser}-${this.brandName}-${this.c_key}-${this.brandtype}`;
		}

	}

	onCloseButtonClick() {
		this.Back();
		this.resetCheckboxes();
		let openModal = document.getElementById('redundantcampaign')
		$(openModal).modal('hide')
		$('#redundantcampaign').modal({
			backdrop: false
		})
	}
	ngOnDestroy() {
		this.closeDCAModal.nativeElement.click();
		this.secondclosebutton.nativeElement.click();
		this.closebutton.nativeElement.click();
		this.closeDID.nativeElement.click();
		this.connection.nativeElement.click();
		this.brandSelectModal.nativeElement.click();
		this.campaignSelectModal.nativeElement.click();
		this.editpending.nativeElement.click();
		this.editprovisioning.nativeElement.click();
		this.dcasubmit.nativeElement.click();
		this.verifyCloseBtn.nativeElement.click();
		this.finalClosebutton.nativeElement.click();
		this.copyCampaign.nativeElement.click();
		this.approveCampaignModal.nativeElement.click();
		this.requestToRejectModal.nativeElement.click();
		this.onCloseButtonClick();
	    this.onSecondCloseButtonClick();
	}

	// Method to open the second modal and close the first one
	openSecondModal() {
		$('#redundantcampaign').modal('hide');
		$('#redundantmodal').modal({
			backdrop: 'static',
			keyboard: false
		});
		$('#redundantmodal').modal('show');
	}

	// Method to open the first modal and close the second one
	openFirstModal() {
		$('#redundantmodal').modal('hide');
		$('#redundantcampaign').modal({
			backdrop: 'static',
			keyboard: false
		});
		$('#redundantcampaign').modal('show');
	}

	@HostListener('window:keydown', ['$event'])
	handleKeyDown(event: KeyboardEvent) {
		if (event.altKey && event.key === 'ArrowLeft') {
			this.onCloseButtonClick();
			this.onSecondCloseButtonClick();
		}
	}
}
