import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, FormControl, Validators } from '@angular/forms';
// import {CapmaignserviceService } from '../capmaignservice.service';
import { Router } from '@angular/router';
import { MatDialog } from '@angular/material/dialog';
declare var $: any;
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { Alert } from 'selenium-webdriver';
import { NewCamapignService } from '../new-camapign.service';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';

declare var $: any;
@Component({
	selector: 'app-new-brand',
	templateUrl: './new-brand.component.html',
	styleUrls: ['./new-brand.component.css']
})
export class NewBrandComponent extends AppComponentClass<any, any> {
  	inputvalue = "";
	campaign_id: 0;
	public show: boolean = false;
	public buttonName: any = "Add Brand";
	public campaignForm: FormGroup;
	public brandForm: FormGroup;
	public filterBrand: FormGroup;
	public submitted: boolean = false;
	public collection: any;
	public heading = [];
	public main_heading = "";
	responseMessage = "";
	brands: any = [];
	brand: any = [];
	campaigns: any = [];
	brandRelationship: any = [];
	brandVertical: any = [];
	altBusinessIdType: any = [];
	brandType: any = [];
	errMessage: any = "";
	country: { value: string; name: string; }[];
	identityStatus: any;
	entityType: any;
	userType: any;
	messs: string ='';
	userlist: any = [];

	constructor(public data: CapmaignserviceService,
		public service: NewCamapignService,
		public dialog: MatDialog,
		public router: Router,
		public userService: UsermanagementService,
		public fb: FormBuilder) {
		super(data, router, fb);
	}

	ngOnInit(): void {
		let session$ = sessionStorage.getItem("isLoggedIn");
		let session = JSON.parse(session$);
		this.userType = session.type;
		this.brandList();


		this.data.brandRelationship().subscribe(res => {
			this.brandRelationship = res.data;
		})

		this.data.altBusinessIdType().subscribe(res => {
			this.altBusinessIdType = res.data.slice(1, 4);
		});

		this.data.brandVertical().subscribe(res => {
			let tmp: any = [];
			Object.entries(res.data).forEach((ele: any) => {
				let t = ele[1];
				t["name"] = ele[0];
				tmp.push(t);
			});
			this.brandVertical = tmp;
		});
		this.data.brandEntityType().subscribe(res => {
			this.brandType = res.data;
		});

		this.filterBrand = this.fb.group({
			brandId: [],
			brand_name: [],
			country: [''],
			entityType: [],
			ein: [],
			identityStatus: [],
			referenceId: [],
			idaccount: [],
		});

		this.brandForm = this.fb.group({
			companyName: ['', Validators.required],
			displayName: ['', Validators.required],
			entityType: ['', Validators.required],
			ein: ['', Validators.required],
			phone: ['', Validators.required],
			country: ['', Validators.required],
			email: ['', Validators.required],
			street: ['', Validators.required],
			city: ['', Validators.required],
			state: ['', Validators.required],
			postalCode: ['', Validators.required],
			website: ['', Validators.required],
			vertical: ['', Validators.required],
			brandRelationship: ['', Validators.required]
		});

		this.campaignForm = this.fb.group({
			idcampaign: ['', Validators.required],
			idbrand: [],
			brand_name: [],
			campaign_name: [],
			campaign_key: [],
			campaign_class: [],
			start_date: [],
			campaign_description: []
		});

		/* this.data.onGetCampaign().subscribe(res => {
			if (res.status == 200) {
				this.campaigns = res.data;
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		}); */
		// my function
		this.country = [
			{ value: "US", name: "US" },
			{ value: "CA", name: "Canada" }
		]
		this.service.getBrandIdentityStatus().subscribe(result => {
			if (result.status == 200) {
				this.identityStatus = result.data;
			}
		});
		this.service.getBrandEntityType().subscribe(result => {
			if (result.status == 200) {
				this.entityType = result.data;

			}
		})
		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
			this.userlist.sort((a, b) => {
				return a.san - b.san;
			  });	
		});
	}
	brandList() {
		this.service.getBrand().subscribe(result => {
			if (result.status == 200) {
				this.brands = result.data;
				$('#basic-datatablesRs').DataTable().clear();
				$('#basic-datatablesRs').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
			else {
				this.errMessage = result.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		}, err => {
			this.errMessage = err.message;
			setTimeout(() => {
				this.errMessage = "";
			}, 5000);
		});

	}
	resetFilter() {
		this.brandList();
		this.messs='';
	}

	onBrand() {
		this.submitted = true;
		if (this.brandForm.invalid) {
			return
		}
		else {
			this.data.onBrandRegister(this.brandForm.value).subscribe(response => {
				// this.ngOnInit();
				if (response.status == 201) {
					this.responseMessage = response.message;
					$('#basic-datatablesRs').DataTable().clear();
					$('#basic-datatablesRs').DataTable().destroy();
					$.getScript('./assets/table.js');
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	addCampaign(data) {
		this.campaignForm.patchValue({
			idbrand: data.idbrand,
			brand_name: data.brand_name
		});
	}

	onSaveCampaign() {
		if (this.campaignForm.invalid) {
			return;
		}
		else {
			this.data.onAddCampaign(this.campaignForm.value).subscribe(res => {
				if (res.status == 201) {
					this.ngOnInit();
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}


	/**
	 * It will delete a brand
	 */
	DeleteBrand(brandId: any): any {
		if (confirm("Are You Sure, You want delete this brand?")) {
			this.data.DeleteBrand(brandId).subscribe(res => {
				if (res.status == 201) {
					this.responseMessage = res.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
					location.reload();
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = err.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			});
		}
		else {
			return false
		}
	}
	showfilter() {
		if (this.show == false) {
			this.show = true;
		}
		else {
			this.show = false;
		}

	}
	applyFilter() {
		if(this.filterBrand.value.brandId || this.filterBrand.value.brand_name || 
			this.filterBrand.value.country || this.filterBrand.value.entityType || this.filterBrand.value.ein || this.filterBrand.value.referenceId
			|| this.filterBrand.value.identityStatus || this.filterBrand.value.idaccount)
			  {
					this.service.applyFilter(this.filterBrand.value).subscribe(res => {
						if (res.status == 200) {
							this.brands = [];
							this.brands = res.data;
							this.messs='';
							$('#basic-datatablesRs').DataTable().clear();
							$('#basic-datatablesRs').DataTable().destroy();
							$.getScript('./assets/table.js');
						}
						else {
							this.errMessage = res.message;
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}
					})
	         }
			else
			{
				this.messs="Please Enter atleast 1 field!";
			}
	}

	numberOnly(event): boolean {
		const charCode = (event.which) ? event.which : event.keyCode;
		if (charCode > 31 && (charCode < 48 || charCode > 57)) {
		  return false;
		}
		return true;
	}
}
