import { Injectable } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { Observable } from 'rxjs/Observable';
import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { BehaviorSubject } from 'rxjs';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})
export class NotificationService extends AppService<any>{
  private notificationCountSubject: BehaviorSubject<{ count: number, data: any }> = new BehaviorSubject<{ count: number, data: any }>({ count: 0, data: null });
  notificationCount$: Observable<{ count: number, data: any }> = this.notificationCountSubject.asObservable();
  updateNotificationCount(count: number, data: any): void {
    const newData = { count, data };
    this.notificationCountSubject.next(newData);
  }

  private notificationCount1: BehaviorSubject<{ count: number, data: any }> = new BehaviorSubject<{ count: number, data: any }>({ count: 0, data: null });
  email_notificationCount$: Observable<{ count: number, data: any }> = this.notificationCount1.asObservable();
  updateCount(count: number, data: any): void {
    const Data = { count, data };
    this.notificationCount1.next(Data);
  }

  httpHeaders: any = new HttpHeaders({
    "Content-Type": "application/json"
  });
  constructor(public http: HttpClient) {
    super(http)
   }

   get_system_notification(): Observable<any>{
    return this.http.get('./assets/systemnotification.json')
   }
 
  @LoaderEnabled()
  viewNotification(): Observable<any> {
    this.appmod = "viewNotification";
    let result = super.getService();
    this.appmod = "viewNotification";
    return result;
  }
  
   @LoaderEnabled()
   displayNotificationForCustomer(): Observable<any> {
    this.appmod = "displayNotificationForCustomer";
    let result = super.getService();
    this.appmod = "displayNotificationForCustomer";
    return result;
  }
  // @LoaderEnabled()
  NotificationCountForCustomer(): Observable<any> {
   this.appmod = "NotificationCountForCustomer";
   let result = super.getService();
   this.appmod = "NotificationCountForCustomer";
   return result;
 }
  
  // @LoaderEnabled()
  UpdateViewNotificationStatus(data: any): Observable<any> {
   this.appmod = "UpdateViewNotificationStatus";
   let result = super.updateService(data);
   this.appmod = "";
   return result;
 }
  
  // @LoaderEnabled()
  //  get_customerdetails(data: any): Observable<any> {
  //   this.appmod = "customerStatus";
  //   let result = super.getService(data);
  //   this.appmod = "notificationSystem";
  //   return result;
  // }

  @LoaderEnabled()
  getUsers(type: string): Observable<any> {
    this.appmod = "user";
    let tmp = this.getService(type);
    this.appmod = "usermanagement";
    return tmp;
  }
   
  @LoaderEnabled()
  sendNotification(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'sendNotification';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

   @LoaderEnabled()
   getStatus(): Observable<any> {
     this.appmod = 'getSystemNotificationStatus';
     let result = super.getService();
     this.appmod = "";
     return result;
   }

   getSuspendedService(): Observable<any> {
    this.appmod = "getSuspendedService";
    let result = this.getService();
    this.appmod = "usermanagement";
    return result;
  }

  get_systemnotification(): Observable<any>{
    return this.http.get('./assets/notification.json')
   }

   @LoaderEnabled()
   get_status(): Observable<any> {
     this.appmod = "getStatusList";
     let result = super.getService();
     this.appmod = "";
     return result;
   }

   @LoaderEnabled()
   get_category(): Observable<any> {
     this.appmod = "getcategoryList";
     let result = super.getService();
     this.appmod = "";
     return result;
   }
   @LoaderEnabled()
   get_categoryCust(): Observable<any> {
     this.appmod = "getcategoryListCust";
     let result = super.getService();
     this.appmod = "";
     return result;
   }
   @LoaderEnabled()
   submitNotify(payLoad: any, file: File | any): Observable<any> {
    const formData = new FormData();
    for (let i = 0; i < file.length; i++) {
      formData.append("ATTACHMENTS", file[i], file[i].name);
    }
    formData.append("ATTACHMENTS", file);
    formData.append("data", payLoad);
    const apiURL = environment.SERVER + 'savenotifyemail';
    let httpHeaders = new HttpHeaders({
    });
    return this.http.post(apiURL, formData, { headers: httpHeaders });
  }

  @LoaderEnabled()
  getemail_notification(): Observable<any> {
    this.appmod = "get_EmailNotification";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getemail_notify(key:any): Observable<any> {
    this.appmod = "get_singleEmailNotify";
    let result = super.getService(key);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  NotifyCustomerLIst(key:any): Observable<any> {
    this.appmod = "NotifyCustomerList";
    let result = super.getService(key);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  sendmaildata(payLoad:any): Observable<any> {
    this.appmod = "saveCustMail";
    let result = super.saveService(payLoad);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  subscribe_email(): Observable<any> {
    this.appmod = "emailsubscriber";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  update_status(payLoad:any): Observable<any> {
    this.appmod = "updatestatus_view";
    let result = super.updateService(payLoad);
    this.appmod = "";
    return result;
  }
  @LoaderEnabled()
  getEmail_subscription(): Observable<any> {
    this.appmod = "get_Emailsubscription";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  Update_CustMail(data: any) {
    this.appmod = "UpdateCustMail";
    let result = super.updateService(data);
    this.appmod = "";
    return result;
  }

    NotificationCount(): Observable<any> {
    this.appmod = "NotificationCountList";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  Cust_MailSubsc(): Observable<any> {
    this.appmod = 'CustomerEmailSubscrip';
    let result = super.getService();
    this.appmod = "";
    return result;
  }
}
