import { Component, OnInit } from '@angular/core';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { OutboundService } from '../outbound.service';

import { Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';

@Component({
	selector: 'app-testcall',
	templateUrl: './testcall.component.html',
	styleUrls: ['./testcall.component.css']
})

export class TestcallComponent extends AppComponentClass<any, any> {

	fieldform: any;
	public testCallForm: FormGroup;
	public submitted: boolean = false;
	responseMessage = "";
	errMessage: any = "";
	featureServiceData: any;
	isDisabledServiceStatus: boolean;
	userType: any;
	serviceMessage: any = 'Call service has been suspended. More information please contact support';

	// fieldform: Observable<any>;
	constructor(public data: OutboundService, private userService: UsermanagementService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);


		this.testCallForm = this.fb.group({
			FROM: new FormControl(""),
			CALLEE: new FormControl(""),
			CALLER: new FormControl("")

		});
	}


	ngOnInit(): void {
		this.userService.getfeatureServiceStatus().subscribe(res => {
			this.featureServiceData = res.data.find(x => x.fs_id == '3');
			if (this.featureServiceData !== undefined && this.featureServiceData.as_status == 1) {
				this.isDisabledServiceStatus = false;
			}
			else {
				this.isDisabledServiceStatus = true;
				this.showMsg();
			}
		});
		this.data.gettestcall().subscribe((result) => {
			this.fieldform = result;
		})
	}
	// @to save/update form data
	onTestCall() {
		this.submitted = true;

		if (this.testCallForm.invalid) {
			return false;
		} else {
			this.data.testCall(this.testCallForm.value).subscribe(response => {
				if (response.status == 201) {
					this.responseMessage = response.message;
					setTimeout(() => {
						this.responseMessage = "";
					}, 5000);
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			}, err => {
				this.errMessage = "Something went wrong with calling. Please call again.";
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			})
		}
	}

	onReset() {
		this.submitted = false;
		this.testCallForm.reset();
	}

	allowNumbersOnly(e) {
		var code = (e.which) ? e.which : e.keyCode;
		if (code > 31 && (code < 48 || code > 57)) {
			e.preventDefault();
		}
	}
	showMsg() {
		this.errMessage = this.serviceMessage;
		setTimeout(() => {
			this.errMessage = "";
		}, 5000);
	}
}
