import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControlName, FormGroup, Validators } from '@angular/forms';

@Component({
  selector: 'app-changepassword',
  templateUrl: './changepassword.component.html',
  styleUrls: ['./changepassword.component.css']
})
export class ChangepasswordComponent implements OnInit {
  
  changepasswordForm : FormGroup;
  submitted:boolean = false;
  responseMessage: string;

  constructor(private FormBuilder:FormBuilder) { 
    this.changepasswordForm = this.FormBuilder.group({
      old_password: ['', [Validators.required]],
      new_password: ['', [Validators.required]],
      confirm_password: ['', [Validators.required]]
    })
  }

  onSubmit(){
    this.submitted = true;
    if(this.changepasswordForm.invalid){
      return false;
    }
    else{
      let retrieve_value = this.changepasswordForm.value;
      console.log(retrieve_value);
    }
  }

  ngOnInit(): void {
  }

}
