import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ShortcodesmsService } from '../shortcodesms.service';
import { ActivatedRoute, Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { environment } from 'src/environments/environment';
import { HttpClient, HttpRequest } from '@angular/common/http';
declare var $: any;

@Component({
  selector: 'app-shortcodesms',
  templateUrl: './shortcodesms.component.html',
  styleUrls: ['./shortcodesms.component.css'],
})
export class ShortcodesmsComponent implements OnInit {
  @ViewChild('closeModal') closeModal: ElementRef;
  @ViewChild('reject') reject: ElementRef;
  show_filter: boolean = false;
  public filterForm: FormGroup;
  Campaign: any;
  responseMessage: any = '';
  errMessage: any = '';
  isSubmit: boolean = false;
  isEdit: boolean = false;
  selected_id: any;
  userType: any;
  public userInfo: any;
  tabheader1: any;
  tabheader2: any;
  tabheader3: any;
  tabheader4: any;
  tabheader5: any;
  tabheader6: any;
  tabheader7: any;
  CustomerCampaign: any[];
  approved: any[];
  pending: any[];
  rejected: any[];
  numbermapped: any[];
  process_started: any[];
  process_rejected: any[];
  process_approved: any[];
  Filter: string = 'Pending Review'
  selectedTab: string = '';
  users: any[];
  selectedUser: any;
  submitted: boolean = false;
  SCfilter: any;
  SCfilterCSV: any;
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  status: any;
  batchdata: any[];

  iselectAll: Boolean = false;
  selectedAwait: any = [];
  selectedAwaitCount: any;
  isSelected: Boolean = false;
  isChecked: Boolean = false;

  reviewId: any;
  user_id: any;
  user_acc: any;
  unique_id: any;
  scNumber: any;
  scContact: any;
  profileID: any;
  pID: any;
  public rejectForm: FormGroup
  idaccount1: any;
  iduser1: any;
  idprofile1: any;

  constructor(private fb: FormBuilder, public data: ShortcodesmsService, public router: Router, private route: ActivatedRoute, private userService: UsermanagementService, private http: HttpClient) { }

  ngOnInit(): void {
    this.selectedAwaitCount = '';
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.filterForm = this.fb.group({
      from: [''],
      to: [''],
      campaignname: [''],
      requestid: [''],
      status: [''],
      filter_type: [''],
      user: ['']
    });

    this.filterForm.patchValue({
      filter_type: this.userType == 1 ? "Pending Review" : ''
    })
    this.batchData();
    this.GetSCampaign();


    this.data.get_Carrier().subscribe((result) => {
      this.userInfo = result[3].tabheader;
      this.tabheader1 = this.userInfo[0].tableheaders
      this.tabheader2 = this.userInfo[1].tableheaders
      this.tabheader3 = this.userInfo[2].tableheaders
      this.tabheader4 = this.userInfo[3].tableheaders
      this.tabheader5 = this.userInfo[4].tableheaders
      this.tabheader6 = this.userInfo[5].tableheaders
      this.tabheader7 = this.userInfo[6].tableheaders
      this.tabheader7 = this.userInfo[6].tableheaders
      this.status = result[6]
    });
    $.getScript('./assets/tollfree.js');

    this.userService.getUsers("main").subscribe(res => {
      if (res.status == 200) {
        this.users = res.data[0];
        this.users.sort((a, b) => {
          return a.san - b.san;
        });
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

    this.rejectForm = this.fb.group({
      reject_text: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
    });

  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    } else {
      this.show_filter = false;
    }
  }

  setStatus(list) {
    list.forEach(element => {
      if (element.status == 0) {
        element.status = 'Number Mapped Process Start'
      }
      if (element.status == 1) {
        element.status = 'Pending Review'
      }
      if (element.status == 2) {
        element.status = 'Rejected'
      }
      if (element.status == 3) {
        element.status = 'Approved'
      }
      if (element.status == 4) {
        element.status = 'Number Mapped'
      }
      if (element.status == 5) {
        element.status = 'SC Campaign Profile Process Started'
      }
      if (element.status == 6) {
        element.status = 'SC Campaign Profile Approved'
      }
      if (element.status == 7) {
        element.status = 'SC Campaign Profile Rejected'
      }
    })
  }

  batchData() {
    this.data.get_scBatch().subscribe(res => {
      if (res.status == 200) {
        this.batchdata = res.data;
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  GetSCampaign() {
    this.data.get_scBatch().subscribe(res1 => {
      this.data.GetCamp().subscribe((res) => {
        if (res.status === 201) {
          this.Campaign = res.data;
          for (const itemScCampaign of this.Campaign) {
            const sc_campaign_unique_id = itemScCampaign.sc_campaign_unique_id;
            const matchingBatchData = res1.data.find(
              batchItem => batchItem.sc_campaign_unique_id === sc_campaign_unique_id
            );
            if (matchingBatchData) {
              itemScCampaign.batch_id = matchingBatchData.batch_id_unique;
            }
          }
          this.CustomerCampaign = res.data;
          this.pending = [];
          this.rejected = [];
          this.approved = []
          this.numbermapped = [];
          this.process_started = [];
          this.process_rejected = [];
          this.process_approved = [];

          if (this.userType == 1) {
            this.CustomerCampaign.forEach((element) => {
              if (element.status == 1) {
                element.status = 'Pending Review';
                this.pending.push(element);
              }
              if (element.status == 2) {
                element.status = 'Rejected';
                this.rejected.push(element);
              }
              if (element.status == 3) {
                element.status = 'Approved';
                this.approved.push(element);
              }
              if (element.status == 4) {
                element.status = 'Number Mapped';
                this.numbermapped.push(element);
              }
              if (element.status == 5) {
                element.status = 'SC Campaign Profile Process Started';
                this.process_started.push(element);
              }
              if (element.status == 6) {
                element.status = 'SC Campaign Profile Approved';
                this.process_approved.push(element);
              }
              if (element.status == 7) {
                element.status = 'SC Campaign Profile Rejected';
                this.process_rejected.push(element);
              }
            });
          } else {
            this.CustomerCampaign = res.data;
            this.setStatus(this.CustomerCampaign);
            $('#basic-datatables7').dataTable().fnClearTable();
            $('#basic-datatables7').dataTable().fnDraw();
            $('#basic-datatables7').dataTable().fnDestroy();
          }


          $('#basic-datatables2').dataTable().fnClearTable();
          $('#basic-datatables2').dataTable().fnDraw();
          $('#basic-datatables2').dataTable().fnDestroy();

          $('#basic-datatables4').dataTable().fnClearTable();
          $('#basic-datatables4').dataTable().fnDraw();
          $('#basic-datatables4').dataTable().fnDestroy();

          $('#basic-datatables5').dataTable().fnClearTable();
          $('#basic-datatables5').dataTable().fnDraw();
          $('#basic-datatables5').dataTable().fnDestroy();

          $('#basic-datatables11').dataTable().fnClearTable();
          $('#basic-datatables11').dataTable().fnDraw();
          $('#basic-datatables11').dataTable().fnDestroy();

          $('#basic-datatables12').dataTable().fnClearTable();
          $('#basic-datatables12').dataTable().fnDraw();
          $('#basic-datatables12').dataTable().fnDestroy();

          $('#basic-datatables13').dataTable().fnClearTable();
          $('#basic-datatables13').dataTable().fnDraw();
          $('#basic-datatables13').dataTable().fnDestroy();

          $('#basic-datatables14').dataTable().fnClearTable();
          $('#basic-datatables14').dataTable().fnDraw();
          $('#basic-datatables14').dataTable().fnDestroy();

          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    })
  }

  CopyButton(id: any) {
    this.selected_id = id;
  }

  onRadioChange(option: string) {
    if (option === 'edit') {
      this.isSubmit = false;
      this.isEdit = true;
    } else if (option === 'copy') {
      this.isSubmit = true;
      this.isEdit = false;
    }
  }

  Resetradio() {
    this.isEdit = false;
    this.isSubmit = false;
    const editCheck = document.getElementById("editCheck") as HTMLInputElement;
    const copyCheck = document.getElementById("copyCheck") as HTMLInputElement;

    if (editCheck && copyCheck) {
      editCheck.checked = false;
      copyCheck.checked = false;
    }
  }

  copySC() {
    this.data.copySCDAta(this.selected_id).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message
        this.closeModal.nativeElement.click();
        this.GetSCampaign()
        setTimeout(() => {
          this.responseMessage = ''
        }, 5000);
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ""
        }, 5000);
      }
    })
  }

  EditSc() {
    const id = this.selected_id
    this.router.navigateByUrl(`/create-profile/copy/${this.selected_id}`);
  }

  submit1() {
    let myid = this.selected_id;
  }


  showbtn1(data: any) {
    if (data === 'Approved') {
      this.Filter = 'Approved';
    } else if ((data === 'Rejected')) {
      this.Filter = 'Rejected';
    } else if (data === 'Number Mapped') {
      this.Filter = 'Number Mapped';
    } else if (data === 'SC Campaign Profile Process Started') {
      this.Filter = 'SC Campaign Profile Process Started';
    } else if (data === 'SC Campaign Profile Approved') {
      this.Filter = 'SC Campaign Profile Approved';
    } else if (data === 'SC Campaign Profile Rejected') {
      this.Filter = 'SC Campaign Profile Rejected';
    }
    else {
      this.Filter = 'Pending Review';
    }
    this.filterForm.reset();
    this.filterForm.get('user').setValue('')
    this.filterForm.patchValue({
      filter_type: this.userType == 1 ? data : '',
    })
  }

  filterByUser(ev: any) {
    this.selectedUser = ev.target.value;
  }

  messageshow() {
    const fromDate = this.filterForm.get('from').value;
    const toDate = this.filterForm.get('to').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterForm.get('from').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterForm.get('to').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterForm.get('to').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterForm.get('to').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterForm.get('from').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterForm.get('from').setErrors(null);
      this.filterForm.get('to').setErrors(null);
    }

  }

  Submitfilter() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return false;
    } else {
      this.data.appllyFilter(this.filterForm.value).subscribe((res) => {
        if (res.status == 201) {
          this.SCfilter = res.data;
          this.SCfilterCSV = res.data;
          for (const itemScCampaign of this.SCfilter) {
            const sc_campaign_unique_id = itemScCampaign.sc_campaign_unique_id;
            const matchingBatchData = this.batchdata.find(
              batchItem => batchItem.sc_campaign_unique_id && batchItem.sc_campaign_unique_id.includes(sc_campaign_unique_id)
            );
            if (matchingBatchData) {
              itemScCampaign.batch_id = matchingBatchData.batch_id_unique;
            }
          }
          if (this.userType == 1) {
            if (this.Filter == 'Pending Review') {
              $('#basic-datatables2').DataTable().clear();
              $('#basic-datatables2').DataTable().destroy();
              this.pending = this.SCfilter;
              this.setStatus(this.pending);
            }
            if (this.Filter == 'Rejected') {
              $('#basic-datatables4').DataTable().clear();
              $('#basic-datatables4').DataTable().destroy();
              this.rejected = this.SCfilter;
              this.setStatus(this.rejected);
            }
            if (this.Filter == 'Approved') {
              $('#basic-datatables5').DataTable().clear();
              $('#basic-datatables5').DataTable().destroy();
              this.approved = this.SCfilter;
              this.setStatus(this.approved);
            }
            if (this.Filter == 'Number Mapped') {
              $('#basic-datatables11').DataTable().clear();
              $('#basic-datatables11').DataTable().destroy();
              this.numbermapped = this.SCfilter;
              this.setStatus(this.numbermapped);
            }
            if (this.Filter == 'SC Campaign Profile Process Started') {
              $('#basic-datatables12').DataTable().clear();
              $('#basic-datatables12').DataTable().destroy();
              this.process_started = this.SCfilter;
              this.setStatus(this.process_started);
            }
            if (this.Filter == 'SC Campaign Profile Approved') {
              $('#basic-datatables13').DataTable().clear();
              $('#basic-datatables13').DataTable().destroy();
              this.process_approved = this.SCfilter;
              this.setStatus(this.process_approved);
            }
            if (this.Filter == 'SC Campaign Profile Rejected') {
              $('#basic-datatables14').DataTable().clear();
              $('#basic-datatables14').DataTable().destroy();
              this.process_rejected = this.SCfilter;
              this.setStatus(this.process_rejected);
            }
          } else {
            $('#basic-datatables7').DataTable().clear();
            $('#basic-datatables7').DataTable().destroy();
            this.CustomerCampaign = this.SCfilter;
            this.setStatus(this.CustomerCampaign);
          }
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = ''
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterForm.reset();
    this.filterForm.patchValue({
      filter_type: this.userType === 1 ? this.Filter : ''
    });
    this.filterForm.get('status').setValue('')
    this.filterForm.get('user').setValue('')
    this.GetSCampaign()
    this.Filter = this.Filter;
  }


  downloadCSV() {
    this.Submitfilter();
    setTimeout(() => {
      if (this.SCfilterCSV.length > 0) {
        let NewFilteredRes = this.SCfilterCSV.map((item) => {
          if (this.userType === 1) {
            const { idaccount, customer_name, campaign_name, created_at, status, sc_campaign_unique_id, reject_date, approved_date, number_mapped_date, process_approved_date, process_rejected_date, process_started_date, batch_id, shortcode_number } = item;
            const SAN = 100000000 + idaccount;
            const Customer_Name = customer_name;
            const Status = status;
            const Request_ID = sc_campaign_unique_id;
            const Campaign = campaign_name;
            const reject = new Date(reject_date).toLocaleDateString('en-US');
            const approve = new Date(approved_date).toLocaleDateString('en-US');
            const process_start = new Date(process_started_date).toLocaleDateString('en-US');
            const process_approv = new Date(process_approved_date).toLocaleDateString('en-US');
            const process_reject = new Date(process_rejected_date).toLocaleDateString('en-US');
            const number_mapped = new Date(number_mapped_date).toLocaleDateString('en-US');
            const batch = batch_id
            const shortcode = shortcode_number
            const formattedDate = new Date(created_at).toLocaleDateString('en-US');
            if (this.Filter == 'Pending Review')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, Date: formattedDate };
            if (this.Filter == 'Rejected')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, 'Created Date': formattedDate, 'Updated Date': reject };
            if (this.Filter == 'Approved')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, 'Created Date': formattedDate, 'Updated Date': approve };
            if (this.Filter == 'Number Mapped')
              return { SAN, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, 'Short Code Number': shortcode_number, Status, 'Created Date': formattedDate, 'Updated Date': number_mapped };
            if (this.Filter == 'SC Campaign Profile Process Started')
              return { SAN, 'Batch ID': batch, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, 'Created Date': formattedDate, 'Updated Date': process_start };
            if (this.Filter == 'SC Campaign Profile Rejected')
              return { SAN, 'Batch ID': batch, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, 'Created Date': formattedDate, 'Updated Date': process_reject };
            if (this.Filter == 'SC Campaign Profile Approved')
              return { SAN, 'Batch ID': batch, 'SC Campaign ID': Request_ID, 'Customer Name': Customer_Name, 'Campaign Name': Campaign, Status, 'Created Date': formattedDate, 'Updated Date': process_approv };


          } else {
            const { created_at, status, campaign_name, sc_campaign_unique_id } = item;
            const Campaign = campaign_name;
            const Status = status;
            const Request_ID = sc_campaign_unique_id;
            const formattedDate = new Date(created_at).toLocaleDateString('en-US');
            return { 'SC Campaign ID': Request_ID, 'Campaign Name': Campaign, Status, Date: formattedDate };
          }
        });
        const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
        const workbook: XLSX.WorkBook = { Sheets: { 'ShortCode Campaign': worksheet }, SheetNames: ['ShortCode Campaign'] };
        const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
        this.saveAsExcelFile1(excelBuffer, 'ShortCode Campaign');
      } else {
        this.errMessage = 'No Record Available!';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    }, 2000);
  }

  private saveAsExcelFile1(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  onSelectAll(e) {
    if (e.target.checked) {
      this.selectedAwait = [];
      this.numbermapped.forEach((ele: any) => {
        ele.isChecked = true;
        this.selectedAwait.push(ele);
      });
    }
    else {
      this.iselectAll = false;
      this.selectedAwait = [];
      this.numbermapped.forEach((ele: any) => {
        ele.isChecked = false;
      });
    }
    if (this.selectedAwait.length == this.numbermapped.length) {
      this.iselectAll = true;
    }
    else {
      this.iselectAll = false;
    }
    this.selectedAwaitCount = this.selectedAwait.length;
  }

  onSelectAwait(e, data, idx) {
    if (e.target.checked) {
      this.selectedAwait.push(data);
    } else {
      this.selectedAwait = this.selectedAwait.filter(item => item.sc_campaign_unique_id !== data.sc_campaign_unique_id);
    }
    if (this.selectedAwait.length === this.numbermapped.length) {
      this.iselectAll = true;
    } else {
      this.iselectAll = false;
    }

    if (this.selectedAwait.length > 0) {
      this.isSelected = true;
    }
    else {
      this.isSelected = false;
    }
    // this.isSelected = this.selectedAwait.length > 0;
    this.selectedAwaitCount = this.selectedAwait.length;
  }

  sendmailid() {
    const selectedCheckboxIds = this.selectedAwait.map(item => item.sc_campaign_unique_id);
    let data = {
      requestId: selectedCheckboxIds
    }
    if (confirm("Please click on 'OK' to Submit ")) {
      this.data.sendcsvForNumberMap(data).subscribe((res) => {
        if (res.status == 200) {
          let manageDID = res.data;
          if (manageDID.length > 0) {
            const groupedData = this.groupfiles_and_did(manageDID,res.data1);
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(groupedData);
            const workbook: XLSX.WorkBook = { Sheets: { 'did': worksheet }, SheetNames: ['did'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer);
          } else {
            this.errMessage = "Data is not Available";
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      });
    } else {
      this.router.navigateByUrl['/shortcode-campaign']
    }
  }

  groupfiles_and_did(data, data2) {
    const groupedData = {};
  
    data.forEach((entry, index) => {
      const SC_Request_ID = entry.SC_Request_ID || ''; 
  
      const Campaign_name = entry.Campaign_Name || '';
      const ShortCode_number = entry.ShortCode_Number || '';
      const Migrated_campaign = entry.Migrated_Campaign || '';
      const Campaign_overview = entry.Campaign_Overview || '';
      const Optoutkeyword = entry.Opt_Out_Keyword || '';
      const OptOutMT = entry.Opt_Out_MT || '';
      const HelpMT = entry.Help_MT || '';
      const email = entry.Email || '';
      const WebURL = entry.Web_URL || '';
      const PhoneNumber = entry.Phone_Number || '';
      const T_Web_Url = entry['T&C_Web_Url'] || '';
      const TC_text = entry['T&C_Text'] || '';
      const Customer_name = entry.Customer_Name || '';
      const Subscription_types = entry.Subscription_Types || '';
  
      const trimmedMessageType = entry.Message_Types ? entry.Message_Types.toString().trim() : '';
      const trimmedContentType = entry.Content_Types ? entry.Content_Types.toString().trim() : '';
      const trimmedCallToAction = entry.Call_To_Action ? entry.Call_To_Action.trim() : '';
      const trimmedOptInMessage = entry.Opt_In_Message ? entry.Opt_In_Message.trim() : '';
      const trimmedExampleMessage = entry.Example_message ? entry.Example_message.trim() : '';
      const trimmedFilename = entry.Filenames ? entry.Filenames.trim() : '';
      const filePath = entry.Filepaths || '';
  
      const notes = entry.Notes || '';
  
      const carrierCoverage = (data2[index] && data2[index].sc_carrier_coverage) || '';
  
      if (!groupedData[SC_Request_ID]) {
        groupedData[SC_Request_ID] = {
          "Campaign Name": Campaign_name,
          "ShortCode Number": ShortCode_number,
          "Migrated Campaign": Migrated_campaign,
          "Campaign Overview": Campaign_overview,
          "Opt Out MT": OptOutMT,
          "Opt Out Keyword": Optoutkeyword,
          "Help MT": HelpMT,
          "Email": email,
          "Web URL": WebURL,
          "Phone Number": PhoneNumber,
          "T&C Web Url": T_Web_Url,
          "T&C Text": TC_text,
          "Customer Name": Customer_name,
          "Subscription Types": Subscription_types,
  
          "Carrier Coverage": carrierCoverage, 
          "Message Types": trimmedMessageType,
          "Content Types": trimmedContentType,
          "Call To Action": trimmedCallToAction,
          "Opt In Message": trimmedOptInMessage,
          "Example message": trimmedExampleMessage,
          "Filenames": trimmedFilename,
          "Filepaths": filePath,
          "Notes": notes,
        };
      } else {
        console.log("Data Already Present")
      }
    });
  
    return Object.values(groupedData);
  }


  saveAsExcelFile(csvFile: string): void {
    const selectedCheckboxIds = this.selectedAwait.map(item => item.sc_campaign_unique_id);
    var target = environment.SERVER + "sc_sendMail";
    let data = JSON.stringify({
      requestId: selectedCheckboxIds
    })

    const blob = new Blob([csvFile], { type: 'text/csv' });
    const formData = new FormData();
    formData.append('ATTACHMENTS', blob, "file.csv");
    formData.append('data', data)
    const token = sessionStorage.getItem('authkey');
    this.http.post(target, formData, { headers: { "Authorization": `${token}` } })
      .subscribe((res: any) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            this.selectedAwait = [];
            this.selectedAwaitCount = '';
            // window.location.reload()
            this.GetSCampaign();
            this.responseMessage = "";
            this.iselectAll = false;
          }, 3000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      }
      );
  }

  approveSC(id: any, number: any, id_profile: any) {
    this.reviewId = id;
    this.scNumber = number;
    this.profileID = id_profile;
    const user = this.Campaign.find(
      (user) => user.sc_campaign_unique_id === this.reviewId,
      (user) => user.shortcode_number === this.scNumber,
      (user) => user.id_profile === this.profileID
    );
    this.user_id = user.iduser;
    this.user_acc = user.idaccount;
    let data = {
      iduser: this.user_id,
      idaccount: this.user_acc,
      id: this.reviewId,
      number: this.scNumber,
      id_profile: this.profileID,

    };

    this.data.approveShortCode(data).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }

  rejectSC(id: any, number: any, idProfile: any) {
    this.unique_id = id;
    this.scContact = number;
    this.pID = idProfile;
    const user = this.Campaign.find(
      (user) => user.sc_campaign_unique_id === this.unique_id,
      (user) => user.shortcode_number === this.scContact,
      (user) => user.id_profile === this.pID
    );
    this.user_id = user.iduser;
    this.user_acc = user.idaccount;
    let data = {
      iduser: this.user_id,
      idaccount: this.user_acc,
      id: this.unique_id,
      number: this.scContact,
      idProfile: this.pID
    };
    this.data.rejectShortCode(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  verifiedSC(idacc: any, idu: any, idpro: any, rate: any) {
    const data = {
      idaccount: idacc,
      iduser: idu,
      id: idpro,
      rates: rate
    };

    this.data.approveSCampaign(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = '';
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  getdata(idacc: any, idu: any, idpro: any) {
    this.idaccount1 = idacc;
    this.iduser1 = idu;
    this.idprofile1 = idpro;
  }

  rejectedSC() {
    this.submitted = true;
    if (this.rejectForm.invalid) {
      return false;
    }
    const data = {
      idaccount: this.idaccount1,
      iduser: this.iduser1,
      id: this.idprofile1,
      reject_text: this.rejectForm.get('reject_text').value,
    };
    this.data.rejectSCampaign(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.reject.nativeElement.click();
        this.GetSCampaign();
        setTimeout(() => {
          this.responseMessage = '';
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  OnReset() {
    this.submitted = false;
    this.rejectForm.reset();
  }

  truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

  ngOnDestroy() {
    this.closeModal.nativeElement.click();
    this.reject.nativeElement.click();
  }

}