import { Component, OnInit } from '@angular/core';
import { ActivatedRoute, NavigationStart, Router } from '@angular/router';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { FormBuilder } from '@angular/forms';
import { SignuptemplateService } from '../signuptemplate.service';

@Component({
  selector: 'app-smstemplatedetails',
  templateUrl: './smstemplatedetails.component.html',
  styleUrls: ['./smstemplatedetails.component.css']
})
export class SmstemplatedetailsComponent extends AppComponentClass<any, any> {
  page = 1;
	field : any;
	header : any;
	count = 0;
	tableSize = 25;
	tableSizes = [ 25,50 , 100];
	searchText = { count: 0 };
	filtre: string;
  listdata :any; 
  errMessage : any = "";
  responseMessage: any;
  
  constructor(public data: SignuptemplateService, 
    
    public router: Router, public fb: FormBuilder, 
    private route: ActivatedRoute) {

    super(data, router, fb);

    }

  ngOnInit(): void {

    this.data.getSmsTemplates().subscribe(res =>{
      if(res.status == 200){
        this.listdata = res.data;
        $.getScript('./assets/table.js');
      }else{
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err =>{
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    })
  }
  onToggle(event, id) {
    this.data.updateStatusSMS(event.checked, id).subscribe(res => {
      console.log(res);
      
      if (res.status == 201) {
        this.ngOnInit();
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    })
  }



}
