import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { MatSnackBar } from '@angular/material/snack-bar'
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { SmsService } from '../sms.service';
import { Validators, FormBuilder, FormGroup, AbstractControl, ValidatorFn } from '@angular/forms';
import { BehaviorSubject, Observable } from 'rxjs';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { DatePipe, formatDate } from '@angular/common';
import { saveAs } from 'file-saver';
import * as XLSX from 'xlsx';
import { MdrsComponent } from '../mdrs/mdrs.component';
declare var $: any;

@Component({
	selector: 'app-mms-mdr',
	templateUrl: './mms-mdr.component.html',
	styleUrls: ['./mms-mdr.component.css']
})
export class MmsMDRComponent implements OnInit {
	@ViewChild('viewdetails') viewdetails: ElementRef;
	show_filter: boolean = false;
	show_daily: boolean = false;
	editData?: Observable<any>;
	searchText = { count: 0 };
	filtre: string;
	label: Observable<any>;
	header: any;
	rowdata: any;
	p: number = 1;
	page = 1;
	count = 0;
	tableSize = 50;
	tableSizes = [50, 100, 150];
	filterTerm: string
	snackBar: any;
	public mmdrsForm: FormGroup;
	public summerymmsForm: FormGroup;
	public submitted: boolean = false;
	filterMDR: any = [];
	singleMDR: any = [];
	isOutbound$ = new BehaviorSubject<Boolean>(false);
	isOutbound = this.isOutbound$.asObservable();
	username: any;
	userlist: any = [];
	isAdmin: Boolean = false;
	errMessage: any = "";
	EXCEL_TYPE = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet;charset=UTF-8';
	EXCEL_EXTENSION = '.xlsx';
	monthNameList: any = [];
	filterSummaryMms: any = [];
	currentDate: any;
	startdate: any;
	lastdate: any;
	exportfile: any = [];
	userType: any;
	
	constructor(public data: SmsService, public router: Router,
		public fb: FormBuilder, msg: MatSnackBar,
		private userService: UsermanagementService,
		private datePipe: DatePipe) {

	}

	ngOnInit(): void {
		this.currentDate = new Date();
		this.currentDate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 1));
		const sValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.startdate = sValue;

		this.lastdate = new Date(this.currentDate.setDate(this.currentDate.getDate() - 6));
		const lValue = formatDate(this.currentDate, 'yyyy-MM-dd', 'en-US');
		this.lastdate = lValue;

		this.userService.getUsers("main").subscribe(res => {
			this.userlist = res.data[0];
			// $.getScript('./assets/table.js');
		}, err => {
			console.log(err.message);
		});

		let isLoggedIn = sessionStorage.getItem("isLoggedIn");
		let user = JSON.parse(isLoggedIn);
		this.userType = user.type;
		this.username = user.username;
		if (user.type == '1') {
			this.isAdmin = true;
		}
		else {
			this.isAdmin = false;
		}

		this.mmdrsForm = this.fb.group({
			from_date: [this.startDate()],
			to_date: [this.current_datetime()],
			from_number: [''],
			to_number: [''],
			direction: [''],
			iduser: [''],
			fType: ['']
		});
		this.summerymmsForm = this.fb.group({
			to_date: ['', [Validators.required]],
			from_date: ['', [Validators.required]],
			directionSummery: ['Both'],
			fType: [''],
			iduser:['']
			// Status: [''],
		});

		this.summerymmsForm.patchValue({
			to_date: this.startdate,
			from_date: this.lastdate,
		});

		this.data.get_mdrs().subscribe((result) => {
			this.label = result[1];
			this.header = result[0].headers_details;
			// if (this.userType === 1) {
			// 	this.header = result[0].headers_details;
			// } else {
			// 	this.header = result[0].headers_details.filter(column => column !== 'SAN');
			// }
			this.rowdata = result[0].product_details;
		});

		this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
			if (response.data) {
				this.filterMDR = response.data;
				$('#basic-datatablesMess').DataTable().clear();
				$('#basic-datatablesMess').DataTable().destroy();
				$.getScript('./assets/table.js');
			}
		});
		this.summeryMms()
	}

	onMMdrsGet() {
		this.submitted = true;
		this.mmdrsForm.patchValue({
			fType:""
		})
		if (this.mmdrsForm.invalid) {
			$('#basic-datatablesMess').DataTable().destroy();
			return
		}
		else {
			this.filterMDR = [];
			this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterMDR = response.data;
					$('#basic-datatablesMess').DataTable().clear();
					$('#basic-datatablesMess').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	getFullMdr(idmdr) {
		this.singleMDR = this.filterMDR.find(element => element.idmdr == idmdr);
		if (this.singleMDR.direction == "outbound") {
			this.isOutbound$.next(true);
		}
		else {
			this.isOutbound$.next(false);
		}
	}

	exportFile(e: any) {
		let fType = "filter";
		this.mmdrsForm.patchValue({
			fType:fType
		})
		this.summerymmsForm.patchValue({
			fType:fType
		})
		if (e == 'message') {
			this.exportfile = [];
			this.data.getMMSMDR(JSON.stringify(this.mmdrsForm.value)).subscribe(response => {
				if (response.status == 200) {
					if(response.data.length > 0){
						this.exportfile = response.data.map(item => {
							delete item.idmdr;
							let transformedItem = {}
							if(this.userType == 1){
								 transformedItem = {
									"SAN":  100000000 + item.idaccount, 
									"Direction": item.direction ,
									"Msg Count": item.msg_count ,
									"From Number": item.from_number ,
									"To Number": item.to_number ,
									"MT rates": item.MT_rates ,
									"MO rates": item.MO_rates,
									"MT Surcharge": item.MT_surcharge,
									// "Status": item.status,
									"Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched': item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',									
									"Message Delivered To Operator": item.message_delivered_to_operator ,
									"Message Accepted By Signalmash": item.message_accepted_by_signalmash ,
									"Delivery Receipt Received By Signalmash": item.delivery_receipt_received_by_signalmash ,
									"Delivery Receipt Delivered": item.delivery_receipt_delivered ,
									"Mobility": item.mobility ,
									"Messsage Body": item.messsage_body ,
									"Ocn": item.ocn ,
									"Lata": item.lata ,
									"Created At": new Date(item.created_at).toLocaleDateString('en-US') ,
									"Cost": item.cost ,
								};
							}else{
								transformedItem = {
									"Direction": item.direction ,
									"Msg Count": item.msg_count ,
									"From Number": item.from_number ,
									"To Number": item.to_number ,
									"MT rates": item.MT_rates ,
									"MO rates": item.MO_rates,
									"MT Surcharge": item.MT_surcharge,
									// "Status": item.status ,
									"Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched': item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',									
									"Message Delivered To Operator": item.message_delivered_to_operator ,
									"Message Accepted By Signalmash": item.message_accepted_by_signalmash ,
									"Delivery Receipt Received By Signalmash": item.delivery_receipt_received_by_signalmash ,
									"Delivery Receipt Delivered": item.delivery_receipt_delivered ,
									"Mobility": item.mobility ,
									"Messsage Body": item.messsage_body ,
									"Ocn": item.ocn ,
									"Lata": item.lata ,
									"Created At": new Date(item.created_at).toLocaleDateString('en-US') ,
									"Cost": item.cost ,
								};
							}
							return transformedItem;
						});

						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "MMS-MDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
		if (e == 'summery') {
			this.exportfile = [];
			this.data.summeryCdrForm(JSON.stringify(this.summerymmsForm.value)).subscribe(response => {
				if (response.status == 200) {
					if(response.data.length > 0){
						this.exportfile = response.data.map(item => {
							delete item.idmdr;
							let transformedItem = {}
							if(this.userType == 1){
								 transformedItem = {
									"SAN":  100000000 + item.idaccount, 
									"Date": new Date(item.date).toLocaleDateString('en-US') || '',
									"Direction": item.direction,
									"Total Message": item.total_message ,
									"Total Cost": item.total_cost ,
									// "Status": item.status,
									"Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched': item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',
									
								};
							}else{
								transformedItem = {
									"Date": new Date(item.date).toLocaleDateString('en-US') || '',
									"Direction": item.direction,
									"Total Message": item.total_message,
									"Total Cost": item.total_cost,
									// "Status": item.status,
									"Status": item.status == 0 ? 'Not Dispatched' : item.status == 1 ? 'Delivered' : item.status == 2 ? 'Failed' : item.status == 3 ? 'Dispatched': item.status == 4 ? 'Dispatched to End User / Sent' : item.status == 5 ? 'Resend' : '',
									
								};
							}
							return transformedItem;
						});
						const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(this.exportfile);
						const workbook: XLSX.WorkBook = { Sheets: { 'MMS-MDR': worksheet }, SheetNames: ['MMS-MDR'] };
						const excelBuffer: any = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
						this.saveAsExcelFile(excelBuffer, "MMS-MDR");
					}
					else{
						this.errMessage = "Record Not Found !";
						setTimeout(() => {
							this.errMessage =""
						}, 5000);
					}
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	private saveAsExcelFile(buffer: any, fileName: string): void {
		const data: Blob = new Blob([buffer], {
			type: this.EXCEL_TYPE
		});
		saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
	}

	startDate() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + "01";
	}


	current_datetime() {
		let now = new Date();
		let year = "" + now.getFullYear();
		let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
		let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
		let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
		let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
		let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
		return year + '-' + month + "-" + day;
	}

	monthsList() {
		this.monthNameList = [
			{ name: "Jan", value: "1" },
			{ name: "Feb", value: "2" },
			{ name: "Mar", value: "3" },
			{ name: "Apr", value: "4" },
			{ name: "May", value: "5" },
			{ name: "Jun", value: "6" },
			{ name: "Jul", value: "7" },
			{ name: "Aug", value: "8" },
			{ name: "Sep", value: "9" },
			{ name: "Oct", value: "10" },
			{ name: "Nov", value: "11" },
			{ name: "Dec", value: "12" }
		];
	}


	// static dateLessThan(from_date: string, to_date: string, validatorField: { [key: string]: boolean }): ValidatorFn {
	// 	return (c: AbstractControl): { [key: string]: boolean } | null => {
	// 		const date1 = c.get(from_date).value;
	// 		const date2 = c.get(to_date).value;
	// 		if ((date1 !== null && date2 !== null) && date1 > date2) {
	// 			return validatorField;
	// 		}
	// 		return null;
	// 	};
	// }

	messageshow() {
		this.validateDateRange(this.mmdrsForm);
		this.validateDateRange(this.summerymmsForm);
	}
	
	validateDateRange(form: FormGroup) {
		const fromDate = form.get('from_date').value;
		const toDate = form.get('to_date').value;
		const currentDate = new Date();
	
		if ((!fromDate && !toDate)) {
			// No date range selected, do nothing
		} else if ((fromDate == null || !fromDate) && (toDate != null)) {
			form.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((fromDate != null) && (toDate == null || !toDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
			return;
		} else if (toDate && new Date(toDate) > currentDate) {
			form.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
			return;
		} else if (fromDate && new Date(fromDate) > currentDate) {
			form.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
			return;
		} else {
			form.get('from_date').setErrors(null);
			form.get('to_date').setErrors(null);
		}
	}


	showfilter() {
		if (this.show_filter == false) {
			this.show_filter = true;
		}
		else {
			this.show_filter = false;
		}

	}
	showdaily() {
		if (this.show_daily == false) {
			this.show_daily = true;
		}
		else {
			this.show_daily = false;
		}
	}


	summeryMms() {
		this.summerymmsForm.patchValue({
			fType:""
		})
		if (this.summerymmsForm.invalid) {
			return false
		}
		else {
			this.filterSummaryMms=[];
			this.data.summeryCdrForm(JSON.stringify(this.summerymmsForm.value)).subscribe(response => {
				if (response.status == 200) {
					this.filterSummaryMms = response.data;
					$('#basic-datatablesSum').DataTable().clear();
					$('#basic-datatablesSum').DataTable().destroy();
					$.getScript('./assets/table.js');
				}
				else {
					this.errMessage = response.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});
		}
	}

	resetMMdr() {
		this.submitted = false;
		// this.mmdrsForm.reset();
		this.ngOnInit();
		this.mmdrsForm.patchValue({
			from_date: this.startDate(),
			to_date: this.current_datetime(),
		})
		this.onMMdrsGet();
	}
	mmsSumry() {
		this.submitted = false;
		this.summerymmsForm.reset();
		this.summerymmsForm.get('directionSummery').setValue('Both');
		this.summerymmsForm.get('iduser').setValue('');
		this.summerymmsForm.patchValue({
			from_date: this.lastdate,
			to_date: this.startdate
		})
		this.summeryMms();
	}

	truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

	ngOnDestroy() {
		this.viewdetails.nativeElement.click();
	  }
}
