import { Component, Input, OnInit } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import { TariffService } from '../tariff.service';
import {MatDialog, MatDialogRef, MAT_DIALOG_DATA} from '@angular/material/dialog';
import { AdvanceratesComponent } from '../advancerates/advancerates.component';
import { SurchargeField } from './operator.model';

@Component({
  selector: 'app-tollfreerates',
  templateUrl: './tollfreerates.component.html',
  styleUrls: ['./tollfreerates.component.css']
})

export class TollfreeratesComponent implements OnInit {

  @Input() id_surcharge: any;
  @Input() tollfreeRates: any;

  headers: any;
  ratelists: any;
  public tollFreeForm: FormGroup;
	responseMessage = "";
  status: boolean = false;
  //fields: Map<number,any>=new Map<number,any>();
  fields: any = [];
  operator: any = [];
  maxOptions: any;
  listdata: any;
  headers1: any;
  isDisable: boolean = false;

  constructor(private data: UsermanagementService, private fb: FormBuilder, public dialog: MatDialog,
              private tariffService: TariffService,
  ) { }

  ngOnInit(): void {

    

    this.data.getTollFreeForm().subscribe((result) => {
      this.headers = result[0].headers_details;
      this.ratelists = result[0].rowdata;
      this.fields = result[0].Fields;
    });

    this.tariffService.searchByOperator("").subscribe(res => {
      this.operator = res.data;
      let tmpform:any={};
      this.operator.forEach(ele => {
        tmpform["idoperator_"+ele.id]=ele.id;
        tmpform["priority_"+ele.id]= [];
        tmpform["10dlc_sms_in_"+ele.id+"_none"]= [];
        tmpform["tollf_sms_in_"+ele.id]= [];
        tmpform["short_sms_in_"+ele.id]= [];
        tmpform["10dlc_mms_in_"+ele.id+"_none"]= [];
        tmpform["tollf_mms_in_"+ele.id]= [];
        tmpform["short_mms_in_"+ele.id]= [];
        tmpform["10dlc_sms_out_"+ele.id+"_none"]= [];
        tmpform["tollf_sms_out_"+ele.id]= [];
        tmpform["short_sms_out_"+ele.id]= [];
        tmpform["10dlc_mms_out_"+ele.id+"_none"]= [];
        tmpform["tollf_mms_out_"+ele.id]= [];
        tmpform["short_mms_out_"+ele.id]= [];
        tmpform["10dlc_none"+ele.id] = [];
        tmpform["tollf_none"+ele.id] = [];
        tmpform["short_none"+ele.id] = [];
      });

      this.tollFreeForm = this.fb.group(tmpform);

      }, err => {
            console.log(err);
      });

      this.data.getsmsrate().subscribe((result) => {
        this.headers = result[0].headers_details;
        this.listdata = result[0].rowdata;
      });
  }

  onSaveTollFree(){
    console.log(this.tollFreeForm.value);
      let response: any = [];
      /*response[0]=[];
      response[1]=[];
      response[2]=[];
      response[3]=[];
      response[4]=[];
      response[5]=[];
      response[6]=[];
      response[7]=[];
      response[8]=[];
      response[9]=[];
      response[10]=[];
      response[11]=[];
      response[12]=[];
      response[13]=[];
      response[14]=[];
      response[15]=[];
      response[16]=[];
      response[17]=[];
      response[18]=[];*/

      for(let key of Object.keys(this.tollFreeForm.value)){
        let tmp=key.split('_');
        console.log(tmp);
        response.push({type: tmp[0], direction: tmp[1], subtype: tmp[2], opt: tmp[4], value: this.tollFreeForm.value[key]});
      }
      let temp = response.slice(1, 7);
      console.log(temp);
  }

  openDialog(id, label, type): void {
    const dialogRef = this.dialog.open(AdvanceratesComponent, {
      width: 'auto',
      data: {id: id, label, type}
    });

    dialogRef.afterClosed().subscribe(result => {
      let tmpdata:any=[];
      Object.entries(result).forEach((ele:any)=>{
        let tmp=ele[0].split("_");
        tmpdata.push({"type":tmp[0], "subtype":tmp[1], "direction":tmp[2], "operator":tmp[3], "category":tmp[4], "rate":ele[1]})
      });

      console.log(tmpdata);
    });
  }
}
