import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { UsermanagementService } from '../usermanagement.service';

@Component({
  selector: 'app-account-action',
  templateUrl: './account-action.component.html',
  styleUrls: ['./account-action.component.css']
})
export class AccountActionComponent implements OnInit {
  userData: any;
  sesiduser: any;
  idaccount: any;
  iduser: any;
  userType: string;
  kyc_status: any;
  kyc_color: any;
  federal_status: any ="";
  federal_color: any ="";
  sessionType: any;
  newUserStatus: any;
  disabled: boolean = false;
  constructor(protected userSerive: UsermanagementService, private router: Router) { }

  ngOnInit(): void {
    let isLoggedIn = sessionStorage.getItem("isLoggedIn");
    this.sesiduser = JSON.parse(isLoggedIn);
    this.idaccount = this.sesiduser.idaccount;
    this.iduser = this.sesiduser.iduser;
    this.sessionType = this.sesiduser.type;
    this.newUserStatus = this.sesiduser.newUser_status; 
    if(this.sesiduser.newUser_status==0)
    {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    if(this.sesiduser.newUser_status==1)
    {
      if (this.sesiduser.isEmailVerify == "true" && this.sesiduser.isMobileVerify == "true" && this.sesiduser.isAddress == "true" && this.sesiduser.isPlan == "true" && this.sesiduser.isCard == "true") {
        this.disabled = true;
      }
      else {
        this.disabled = false;
      }
    }
    
    this.getUserDetail();
  }
  getUserDetail(){
    this.userSerive.getSingleUsers().subscribe(res => {
      // To KYC Status
      this.kyc_status = res.data1[0].kyc_verify_status;     
      switch(this.kyc_status){
        case 0 : this.kyc_status = "Unverified"; this.kyc_color ="rgb(236 41 52)"; break;
        case 1 : this.kyc_status = "Verified"; this.kyc_color ="#2aab5b"; break;
        case 2 : this.kyc_status = "Verification Pending"; this.kyc_color ="#e6b125"; break;
        case 3 : this.kyc_status = "Reject"; this.kyc_color ="rgb(236 41 52)"; break;
        case 4 : this.kyc_status = "Cancel"; this.kyc_color ="rgb(236 41 52)"; break;
      }

      // To Federal Status
      this.federal_status = res.data1[0].federal_status;
      switch(this.federal_status){
        case 0 : this.federal_status = "Inactive"; this.federal_color ="rgb(236 41 52)"; break;
        case 1 : this.federal_status = "Active"; this.federal_color ="#2aab5b"; break;
        case 2 : this.federal_status = "Pending to Active"; this.federal_color ="#e6b125"; break;
        case 3 : this.federal_status = "Reject"; this.federal_color ="rgb(236 41 52)"; break;
        case 4 : this.federal_status = "Cancel"; this.federal_color ="rgb(236 41 52)"; break;

      }
    })
  }
  kycForm(): void {
    this.router.navigate(['/kyc/kyc']); 
  }
  FederalForm(): void {
    this.router.navigate(['/federal/federal']); 
  }

}
