import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { UsermanagementService } from '../../usermanagement.service';
import 'rxjs/add/observable/timer';
import 'rxjs/add/operator/map';
import 'rxjs/add/operator/take';
import { Observable } from 'rxjs';
import { SmsService } from 'src/app/sms/sms.service';

@Component({
  selector: 'app-verifyprofile',
  templateUrl: './verifyprofile.component.html',
  styleUrls: ['./verifyprofile.component.css']
})

export class VerifyprofileComponent implements OnInit {
  billingaddressForm: FormGroup;
  responseMessage = "";
  companyForm: FormGroup;
  strategy: IDropdownSettings = {};
  token: any = "";
  country: any = [];
  isLoggedin: any;
  isEmailVerify: boolean = false;
  isMobileVerify: boolean = false;
  isAddress: boolean = false;
  isPlanVerify: boolean = false;
  username: any;
  email: any;
  otpForm: FormGroup;
  otpEnable: boolean = false;
  submitted: boolean = false;
  public submitted1: boolean = false;
  active = {
    style1: "",
    style2: "",
    style3: "",
    style4: "",
  }
  tariffForm: FormGroup;
  tariffSubbmitted: boolean = false;
  countDown;
  counter: any;
  tick = 1000;
  contact: any;
  selectedItems: any;
  errMessage: any = "";
  num: any;
  isVoice: Boolean = false;
  isSMS: Boolean = false;
  isEnable: Boolean = false;
  USA: boolean = false;
  Canada: boolean = false;
  countryVal: any;
  userType: any;
  zipLength: any;
  inputvalue: any = '';
  resellerUser: any;
  resellerIduser: any;
  signupLink: any;
  type: {};
  idTariff: any;
  tariff: any;
  fixedTrf: any = '';
  selectedType: any;
  billingaddressForm1: FormGroup;
  billingaddressForm2: FormGroup;
  userData: any = [];
  UsaState: any;
  Btndisable1: boolean = true;
  Btndisable2: boolean = true;
  Btndisable3: boolean = true;
  checkbox1: boolean = false;
  checkbox2: boolean;
  titleInput: any;
  userAddress: any = [];
  corporationLimitedCountry: any = [];
  solePropCountry: any[];
  internationalBusiCountry: any = [];
  noneProfitCountry: any = [];
  allCountry: any = [];
  Country: any;
  maxLength: number = 10;
  selectedVerificationType: string= 'US';
  Tovalue: any;
  countryF : boolean = false

  constructor(public data: UsermanagementService,
    public router: Router, public fb: FormBuilder,
    protected smsService: SmsService,
    private userSerive: UsermanagementService,
  ) {

    this.isLoggedin = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.data.currentSession(this.isLoggedin.authkey).subscribe(res => {
      if (res.status == 200) {
        sessionStorage.removeItem("isLoggedIn");
        sessionStorage.setItem("isLoggedIn", JSON.stringify(res.session[0]));
        this.router.navigate(['/user/verify-profile']);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

    this.isLoggedin = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.email = this.isLoggedin.email;

    if (this.isLoggedin.isEmailVerify == "true") {
      this.isEmailVerify = true;
    }
    else {
      this.isEmailVerify = false;
    }
    if (this.isLoggedin.isMobileVerify == "true") {
      this.isMobileVerify = true;
    }
    else {
      this.isMobileVerify = false;
    }
    if (this.isLoggedin.isAddress == "true") {
      this.isAddress = true;
    }
    else {
      this.isAddress = false;
    }
    if (this.isLoggedin.isPlan == "true") {
      this.isPlanVerify = true;
    }
    else {
      this.isPlanVerify = false;
    }

    if (this.isLoggedin.isEmailVerify == "true" && this.isLoggedin.isMobileVerify == "true" && this.isLoggedin.isAddress == "true" && this.isLoggedin.isPlanVerify == "true") {
      if (this.isLoggedin.newUser_status == 1 && this.isLoggedin.isCard != "true") {
        this.router.navigate(['/user/credit-card-authorization']).then(() => {
          location.reload();
        })
      }
      else {
        this.router.navigate(['/dashboards']).then(() => {
          location.reload();
        })
      }
    }

    this.strategy = {
      singleSelection: true,
      idField: 'id',
      textField: 'name',
      itemsShowLimit: 3,
      allowSearchFilter: true
    };

    // this.country = [
    //   { id: 1, name: "US" },
    //   { id: 2, name: "Canada" }
    // ]
  }

  ngOnInit(): void {
    this.tariffForm = this.fb.group({
      tariff1: new FormControl('', [Validators.required])
    });

    this.otpForm = this.fb.group({
      TO: new FormControl('', [Validators.required]),
      otp: new FormControl('')
    });

    this.otpForm.setValidators([Validators.required]);

    // this.authService.countryCodes().subscribe(res => {
    //   this.countryCodes = res;
    // });
    const urlRegex = /^(?:http(s)?:\/\/)?[\w.-]+(?:\.[\w\.-]+)+[\w\-\._~:/?#[\]@!\$&'\(\)\*\+,;=.]+$/;
    const emailPattern = /^[A-Za-z0-9._%+-]+@([A-Za-z0-9-]+\.[A-Za-z]{2,4})(\.[A-Za-z]{2,4})?$/;
    this.billingaddressForm = this.fb.group({
      customerType: new FormControl('', [Validators.required]),
      address1: new FormControl('', [Validators.required, Validators.minLength(4)]),
      address2: new FormControl(''),
      city: new FormControl('', [Validators.required, Validators.minLength(2)]),
      state: new FormControl('undefined', [Validators.required, Validators.minLength(2)]),
      postal_code: new FormControl('', [Validators.required]),
      country: new FormControl('', [Validators.required, Validators.minLength(2)]),
      first_name: new FormControl('', [Validators.pattern("^[a-zA-Z']*$")]),
      last_name: new FormControl('', [Validators.pattern("^[a-zA-Z']*$")]),
      email: new FormControl('', [Validators.pattern(emailPattern)]),
      title: new FormControl('', [Validators.required]),
      businessName: new FormControl('', [Validators.required]),
      ein: new FormControl('', [Validators.required, Validators.minLength(9), Validators.maxLength(9)]),
      website: new FormControl('', [Validators.required, Validators.pattern(urlRegex)])
    });

    this.billingaddressForm1 = this.fb.group({
      customerType: new FormControl('', [Validators.required]),
      address1: new FormControl('', [Validators.required, Validators.minLength(4)]),
      address2: new FormControl(''),
      city: new FormControl('', [Validators.required, Validators.minLength(2)]),
      state: new FormControl('', [Validators.required, Validators.minLength(2)]),
      postal_code: new FormControl('', [Validators.required]),
      country: new FormControl('', [Validators.required, Validators.minLength(2)]),
      first_name: new FormControl('', [Validators.required, Validators.pattern("^[a-zA-Z']*$")]),
      last_name: new FormControl('', [Validators.required, Validators.pattern("^[a-zA-Z']*$")]),
      businessName: new FormControl(''),
      website: new FormControl('', [Validators.required, Validators.pattern(urlRegex)])
    });

    this.billingaddressForm2 = this.fb.group({
      customerType: new FormControl('', [Validators.required]),
      address1: new FormControl('', [Validators.required, Validators.minLength(4)]),
      address2: new FormControl(''),
      city: new FormControl('', [Validators.required, Validators.minLength(2)]),
      state: new FormControl('', [Validators.required, Validators.minLength(2)]),
      postal_code: new FormControl('', [Validators.required]),
      country: new FormControl('', [Validators.required, Validators.minLength(2)]),
      first_name: new FormControl('', [Validators.pattern("^[a-zA-Z']*$")]),
      last_name: new FormControl('', [Validators.pattern("^[a-zA-Z']*$")]),
      email: new FormControl('', [Validators.pattern(emailPattern)]),
      title: new FormControl('', [Validators.required]),
      ein: new FormControl('', [Validators.required, Validators.minLength(9), Validators.maxLength(9)]),
      website: new FormControl('', [Validators.required, Validators.pattern(urlRegex)]),
      businessName: new FormControl('', [Validators.required]),
      groupExmpt_number: new FormControl('', [Validators.required])
    });
    this.getCountry();

    this.data.getResellerUsers().subscribe(result => {
      this.resellerUser = result.data;
      this.resellerIduser = this.resellerUser[0].reseller_iduser;
      this.signupLink = this.resellerUser[0].signup_link_id;
      this.type = JSON.stringify({
        key: this.signupLink,
        iduser: this.resellerIduser
      })
      this.data.getResellerTariff(this.type).subscribe(res => {
        if (res.status == 200) {
          this.idTariff = res.data;
          this.idTariff.forEach(ele => {
            this.tariff = ele.idtariff;
          });
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        } else {
          this.errMessage = "";
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    });

    this.selectedType = 'Corporation';

    this.data.US_State().subscribe(res => {
      this.UsaState = res[0].US_State;
    });

    this.billingaddressForm.patchValue({
      address: this.userData.address,
      address1: this.userData.address1,
      city: this.userData.city
    });


    this.checkbox1 = true;
    this.checkbox2 = true;


  }

  updateVerificationType(value:string){
    this.selectedVerificationType = value;
    this.maxLength = (this.selectedVerificationType === 'US') ? 10 : 15; 
    this.otpForm.get('TO').setValue('');
  }

  getCountry() {
    this.data.getCountry().subscribe(res => {
      this.corporationLimitedCountry = [];
      this.solePropCountry = [];
      this.internationalBusiCountry = [];
      this.noneProfitCountry = [];
      if (res.status == 200) {
        this.allCountry = res.data;
        this.allCountry.forEach(element => {
          // To get Corporation / Limited Liability Company (USA Only)
          if (element.corporation_or_limited_liability_company_only_us == '1')
            this.corporationLimitedCountry.push(element);

          // To get Sole Proprietor / Individual
          if (element.sole_proprietor_or_individual == '1')
            this.solePropCountry.push(element);

          // To get International Business (non-US)
          if (element.international_business_none_us == '1')
            this.internationalBusiCountry.push(element);

          // To get Non-Profit, 501C
          if (element.none_profit_501c == '1')
            this.noneProfitCountry.push(element);
        });
        this.getUserAddress();
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with country list!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  getUserAddress() {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.data.getSingleUsers().subscribe(res => {
      this.userData = res.data1[0];
      if (res.status == 200) {
        if (res.data[0] == undefined || res.data[0] == '') {
          this.Btndisable1 = false;
          this.billingaddressForm.patchValue({
            first_name: this.userData.firstname,
            last_name: this.userData.lastname,
            email: this.userData.email,
          });
          if (this.selectedType == 'Corporation') {
            this.Country = this.corporationLimitedCountry;
          }
          this.billingaddressForm.patchValue({
            country: 'US',
          })
          this.USA = true;
          this.billingaddressForm.get('state').setValue('undefined');
        }
        else {
          this.userAddress = res.data[0];
          if (res.data[0].customerType == "Corporation" || res.data[0].customerType == "International_business") {
            this.selectedType = res.data[0].customerType;
            this.Btndisable1 = false;
            this.billingaddressForm.patchValue({
              customerType: res.data[0].customerType,
              title: res.data[0].title,
              businessName: res.data[0].businessName,
              ein: res.data[0].ein,
              address1: res.data[0].address1,
              address2: res.data[0].address2,
              city: res.data[0].city,
              state: res.data[0].state,
              postal_code: res.data[0].postal_code,
              country: res.data[0].country,
              website: res.data[0].website
            });
            this.billingaddressForm.patchValue({
              first_name: this.userData.firstname,
              last_name: this.userData.lastname,
              email: this.userData.email
            });
            this.titleInput = res.data[0].title;
            this.inputvalue = res.data[0].postal_code;
            if (this.selectedType == "International_business") {
              let ein: any = this.billingaddressForm.get('ein');
              ein.setValidators([]);
              ein.updateValueAndValidity();
            }
            if (this.selectedType == 'Corporation') {
              this.Country = this.corporationLimitedCountry;
            }
            else {
              this.Country = this.internationalBusiCountry;
            }
          }
          else if (this.selectedType == "Corporation" && !res.data[0].city) {
            this.Btndisable1 = false
            this.USA = true
            this.Country = this.corporationLimitedCountry;
            this.billingaddressForm.patchValue({
              country: this.corporationLimitedCountry[0].code,
              first_name: this.userData.firstname,
              last_name: this.userData.lastname,
              email: this.userData.email
            })
          }
          else if (res.data[0].customerType == "Sole_Proprietor") {
            this.selectedType = res.data[0].customerType;
            this.inputvalue = res.data[0].postal_code;
            this.Btndisable2 = false;
            this.billingaddressForm1.patchValue({
              customerType: res.data[0].customerType,
              businessName: res.data[0].businessName,
              address1: res.data[0].address1,
              address2: res.data[0].address2,
              city: res.data[0].city,
              state: res.data[0].state,
              postal_code: res.data[0].postal_code,
              country: res.data[0].country,
              website: res.data[0].website,
              first_name: this.userData.firstname,
              last_name: this.userData.lastname,
            });
            this.Country = this.solePropCountry;
          }
          else if (res.data[0].customerType == "Non_Profit") {
            this.selectedType = res.data[0].customerType;
            this.Btndisable3 = false;
            this.billingaddressForm2.patchValue({
              customerType: res.data[0].customerType,
              title: res.data[0].title,
              businessName: res.data[0].businessName,
              ein: res.data[0].ein,
              groupExmpt_number: res.data[0].groupExmpt_number,
              address1: res.data[0].address1,
              address2: res.data[0].address2,
              city: res.data[0].city,
              state: res.data[0].state,
              postal_code: res.data[0].postal_code,
              country: res.data[0].country,
              website: res.data[0].website
            });
            this.billingaddressForm2.patchValue({
              first_name: this.userData.firstname,
              last_name: this.userData.lastname,
              email: this.userData.email,
            });
            this.titleInput = res.data[0].title;
            this.inputvalue = res.data[0].postal_code;
            // console.log(this.billingaddressForm2.value.country);
            this.Country = this.noneProfitCountry;
          }
          if(res.data[0].country == 'US'){
            this.USA = true;
          }
          else{
            this.Canada = true;
          }
          this.otpForm.patchValue({
            TO: this.num && this.num !== undefined ? this.num : res.data[0].contact
          });
          if(res.data[0].contact.length > 10){
            this.selectedVerificationType = 'Non-US';
          }
        }

      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }
  getUser(event: any) {
    if (this.selectedType == 'Corporation' || this.selectedType == 'International_business') {
      if (event.target.checked == true) {
        this.checkbox1 = true;
        this.billingaddressForm.patchValue({
          first_name: this.userData.firstname,
          last_name: this.userData.lastname,
          email: this.userData.email
        });
      }
      else {
        this.checkbox1 = false;
        this.billingaddressForm.patchValue({
          first_name: '',
          last_name: '',
          email: ''
        });
      }
    }
    if (this.selectedType == 'Non_Profit') {
      if (event.target.checked == true) {
        this.checkbox2 = true;
        this.billingaddressForm2.patchValue({
          first_name: this.userData.firstname,
          last_name: this.userData.lastname,
          email: this.userData.email
        });
      }
      else {
        this.checkbox2 = false;
        this.billingaddressForm2.patchValue({
          first_name: '',
          last_name: '',
          email: ''
        });
      }
    }
  }

  resendEmail() {
    this.submitted1 = false;
    this.data.emailResend().subscribe(res => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      }
      else {
        this.errMessage = res.errMessage;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 3000);
    });
  }

    sendOtp() {
    if (this.otpForm.invalid) {
      this.submitted1 = true;
      return
    }
    else {
      // let otp = Math.floor(100000 + Math.random() * 900000);
      // let body = `Your Signalmash verification code is: `;
      // this.data.saveOtp({otp: null, FROM: "2029808085", TO: this.otpForm.value.TO, BODY:body}).subscribe(response => {
      this.data.saveOtp({ otp: null, FROM: "2029808085", TO: this.otpForm.value.TO }).subscribe(response => {
        if (response.status == 201) {
          this.isEnable = true;
          this.isSMS = true;
          this.isVoice = false;
          this.submitted1 = false;
          sessionStorage.setItem("contact", this.otpForm.value.TO);
          this.num = this.otpForm.value.TO;
          this.counter = 120;
          this.otpEnable = true;
          this.Tovalue = this.otpForm.get("TO").value;
          let val: any = this.otpForm.get("TO");
          val.setValidators([]);
          val.updateValueAndValidity();
          let val2: any = this.otpForm.get("otp");
          val2.setValidators([Validators.required, Validators.minLength(6), Validators.maxLength(6)]);
          val2.updateValueAndValidity();
          this.countDown = Observable.timer(0, this.tick)
            .take(this.counter)
            .map(() => {
              if (this.counter <= 1) {
                this.isEnable = false;
                this.isSMS = false;
                this.otpEnable = false;
                if (this.Tovalue && this.otpForm.value.TO !== this.Tovalue) {
                  this.otpForm.patchValue({ TO: this.Tovalue });
                }
                this.otpForm.get("otp").reset();
                let valdata: any = this.otpForm.get("TO");
                valdata.setValidators([Validators.required]);
                valdata.updateValueAndValidity();
                let valdata2: any = this.otpForm.get("otp");
                valdata2.setValidators([]);
                valdata2.updateValueAndValidity();
              }
              return --this.counter
            });
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          // this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
          // this.ngOnInit();
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      });
    }
  }
  onTOInputChange(event: Event) {
    if (!this.otpEnable) {
      const inputValue = (event.target as HTMLInputElement).value;
      this.Tovalue = '';
    }
  }
  verifyOtp() {
    this.otpForm.patchValue({
      TO: sessionStorage.getItem("contact")
    });
    if (this.otpForm.invalid) {
      this.submitted1 = true;
      return
    }
    else {
      this.submitted1 = false;
      this.data.verifyOtp(this.otpForm.value).subscribe(res => {
        if (res.status == 200) {
          sessionStorage.clear();
          let newData = res.session[0];
          sessionStorage.setItem('isLoggedIn', JSON.stringify(newData));
          sessionStorage.setItem('authkey', newData.authkey);
          sessionStorage.setItem('type', newData.type);
          sessionStorage.setItem('iduser', newData.iduser);
          sessionStorage.setItem('email', newData.email);
          sessionStorage.setItem('username', newData.username);
          sessionStorage.setItem('idaccount', newData.idaccount);
          if (newData.newUser_status == 1) {
            if (newData.isEmailVerify == "true" && newData.isMobileVerify == "true" && newData.isAddress == "true" && newData.isPlan == "true" && newData.isCard == "true") {
              this.data.sendFinalMail(this.otpForm.value).subscribe(res => {
                this.router.navigate(['/dashboards']).then(() => {
                  location.reload();
                })
              });
            }
            else if (newData.isEmailVerify != "true" || newData.isMobileVerify != "true" || newData.isAddress != "true" || newData.isPlan != "true") {
              this.router.navigate(['/user/verify-profile']).then(() => {
                location.reload();
              });
            }
            else {
              this.router.navigate(['/user/credit-card-authorization']);
            }
          }
          if (newData.newUser_status == 0) {
            if (newData.isEmailVerify == "true" && newData.isMobileVerify == "true" && newData.isAddress == "true" && newData.isPlan == "true") {
              this.data.sendFinalMail(this.otpForm.value).subscribe(res => {
                this.router.navigate(['/dashboards']).then(() => {
                  location.reload();
                })
              });
            }
          }
          if (newData.isMobileVerify == 'true') {
            this.isMobileVerify = true;
          }
          else {
            this.isMobileVerify = false;
          }
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      });
    }
  }


  sendOtpVoice(country) {
    // this.submitted1 = true;
    if (this.otpForm.invalid) {
      this.submitted1 = true;
      return false;
    }
    else {
      // let otp = Math.floor(100000 + Math.random() * 900000);
      // let body = `Your Signalmash verification code is ${otp}`;
      //this.userSerive.saveOtpbyCall({ otp: otp, FROM: "7258001820", TO: this.otpForm.value.TO, BODY: body }).subscribe(response => {
      this.userSerive.saveOtpbyCall({ FROM: "7258001820", TO: this.otpForm.value.TO,Country:country }).subscribe(response => {
        if (response.status == 201) {
          this.isVoice = true;
          this.isSMS = false;
          this.isEnable = true;
          this.submitted1 = false;
          sessionStorage.setItem("contact", this.otpForm.value.TO);
          this.responseMessage = response.message;
          this.otpEnable = true;
          this.num = this.otpForm.value.TO;
          this.Tovalue = this.otpForm.get("TO").value;
          this.counter = 20;
          let val: any = this.otpForm.get("TO");
          val.setValidators([]);
          val.updateValueAndValidity();
          let val2: any = this.otpForm.get("otp");
          val2.setValidators([Validators.required, Validators.minLength(6), Validators.maxLength(6)]);
          val2.updateValueAndValidity();
          this.counter = 120;
          this.countDown = Observable.timer(0, this.tick)
            .take(this.counter)
            .map(() => {
              if (this.counter <= 1) {
                this.otpEnable = false;
                this.isEnable = false;
                this.isSMS = false;
                if (this.Tovalue && this.otpForm.value.TO !== this.Tovalue) {
                  this.otpForm.patchValue({ TO: this.Tovalue });
                }
                this.otpForm.get("otp").reset();
                let valdata: any = this.otpForm.get("TO");
                valdata.setValidators([Validators.required]);
                valdata.updateValueAndValidity();
                let valdata2: any = this.otpForm.get("otp");
                valdata2.setValidators([]);
                valdata2.updateValueAndValidity();
              }
              return --this.counter
            });
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
          // this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
  }

  verifyOtpVoice() {

    this.otpForm.patchValue({
      TO: sessionStorage.getItem("contact")
    });
    if (this.otpForm.invalid) {
      this.submitted1 = true;
      return
    } else {
      this.submitted1 = false;
      this.smsService.verifyOtp(this.otpForm.value).subscribe(res => {
        if (res.status == 200) {
          sessionStorage.clear();
          let newData = res.session[0];
          sessionStorage.setItem('isLoggedIn', JSON.stringify(newData));
          sessionStorage.setItem('authkey', newData.authkey);
          sessionStorage.setItem('type', newData.type);
          sessionStorage.setItem('iduser', newData.iduser);
          sessionStorage.setItem('email', newData.email);
          sessionStorage.setItem('username', newData.username);
          sessionStorage.setItem('idaccount', newData.idaccount);
          if (newData.isMobileVerify == 'true') {
            this.isMobileVerify = true;
          }
          else {
            this.isMobileVerify = false;
          }

          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);

          if (newData.newUser_status == 1) {
            if (newData.isEmailVerify == "true" && newData.isMobileVerify == "true" && newData.isAddress == "true" && newData.isPlan == "true" && newData.isCard == "true") {
              this.data.sendFinalMail(this.otpForm.value).subscribe(res => {
                this.router.navigate(['/dashboards'])
                  .then(() => {
                    location.reload();
                  })
              });
            } else if (newData.isEmailVerify != "true" || newData.isMobileVerify != "true" || newData.isAddress != "true" || newData.isPlan != "true") {
              this.router.navigate(['/user/verify-profile']).then(() => {
                location.reload();
              })
            }
            else {
              this.router.navigate(['/user/credit-card-authorization']);
            }
          }
          if (newData.newUser_status == 0) {
            if (newData.isEmailVerify == "true" && newData.isMobileVerify == "true" && newData.isAddress == "true" && newData.isPlan == "true") {
              this.data.sendFinalMail(this.otpForm.value).subscribe(res => {
                this.router.navigate(['/dashboards']).then(() => {
                  location.reload();
                })
              });
            }
          }
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      });
    }
  }
  trfId(trfId) {
    this.tariffForm.patchValue({
      tariff1: trfId
    });
    this.fixedTrf = trfId
  }

  addClick(plan) {
    if (this.resellerIduser != '0' && this.resellerIduser != null && this.resellerIduser != undefined) {
      this.active.style1 = "";
      this.active.style2 = "";
      this.active.style3 = "";
      this.active.style4 = "border: 3px solid #43ad5b; cursor: pointer;";
    } else {
      if (plan == "LAUNCH_PLAN") {
        this.active.style1 = "border: 3px solid #43ad5b; cursor: pointer;";
        this.active.style2 = "";
        this.active.style3 = "";
        this.active.style4 = "";
        this.tariffForm.patchValue({
          tariff1: 142
        });
      }
      else if (plan == "GROWTH_PLAN") {
        this.active.style1 = "";
        this.active.style2 = "border: 3px solid #43ad5b; cursor: pointer;";
        this.active.style3 = "";
        this.active.style4 = "";
        this.tariffForm.patchValue({
          tariff1: 143
        });
      }
      else if (plan == "SCALE_PLAN") {
        this.active.style1 = "";
        this.active.style2 = "";
        this.active.style3 = "border: 3px solid #43ad5b; cursor: pointer;";
        this.active.style4 = "";
        this.tariffForm.patchValue({
          tariff1: 145
        });
      }
    }
  }

  ResetPln() {
    this.active.style1 = "";
    this.active.style2 = "";
    this.active.style3 = "";
    this.active.style4 = "";
    this.tariffForm.reset();
    this.tariffSubbmitted=false;
  }
  onInputChange(event)
	{   
	  var k;  
	  k = event.charCode;  
	  const targetValue: string = (event.target as HTMLInputElement).value;
	  if ((k >= 33 && k <= 126) || k === 8 || (k === 32 && /[^\s]$/.test(targetValue))){
		return true;
	  }
	  return false
	}


  isAuth(Ftype) {
    if (Ftype == "billingaddressForm") {
      if (this.billingaddressForm.value.first_name && this.billingaddressForm.value.last_name && this.billingaddressForm.value.email && this.billingaddressForm.controls['email'].valid) {
        this.checkbox1 = false;
        this.Btndisable1 = false;
      }
      else {
        this.checkbox1 = false;
        this.Btndisable1 = true;
      }
    }
    else if (Ftype == "billingaddressForm2") {
      if (this.billingaddressForm2.value.first_name && this.billingaddressForm2.value.last_name && this.billingaddressForm2.value.email && this.billingaddressForm2.controls['email'].valid) {
        this.checkbox2 = false;
        this.Btndisable3 = false;
      }
      else {
        this.checkbox2 = false;
        this.Btndisable3 = true;
      }
    }
  }

  updatePlan() {
    this.tariffSubbmitted = true;
    if (this.tariffForm.invalid) {
      this.submitted1 = true;
      return
    }
    else {
      this.submitted1 = false;
      this.data.updateTariff(this.tariffForm.value).subscribe(res => {
        if (res.status == 201) {
          sessionStorage.clear();
          this.isPlanVerify = true;
          let newData = res.session[0];
          sessionStorage.setItem('isLoggedIn', JSON.stringify(newData));
          sessionStorage.setItem('authkey', newData.authkey);
          sessionStorage.setItem('type', newData.type);
          sessionStorage.setItem('iduser', newData.iduser);
          sessionStorage.setItem('email', newData.email);
          sessionStorage.setItem('username', newData.username);
          sessionStorage.setItem('idaccount', newData.idaccount);
          this.responseMessage = res.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
          if (newData.isEmailVerify == "true" && newData.isMobileVerify == "true" && newData.isAddress == "true" && newData.isPlan == "true") {
            if (newData.newUser_status == 1 && newData.isCard != "true") {
              this.router.navigate(['/user/credit-card-authorization']).then(() => {
                location.reload();
              })
            }
            else {
              this.data.sendFinalMail(this.tariffForm.value).subscribe(res => {
                this.router.navigate(['/dashboards']).then(() => {
                  location.reload();
                })
              });
            }
          }
        }
        else {
          this.errMessage = res.errMessage;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      }, err => {
        this.responseMessage = err.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      })
    }
  }
  onCountry(e: any, formType: any) {
    this.submitted = false;
    if (e.target.value == 'US') {
      this.USA = true;
      this.Canada = false;
      this.countryVal = 'US';
      this.zipLength = '';
    }
    else if (e.target.value == 'CA') {
      this.Canada = true;
      this.USA = false;
      this.countryVal = 'CA';
    }
    else {
      this.Canada = false;
      this.USA = false;
      this.countryVal = '';
    }

    if (formType == 'billingaddressForm') {
      this.billingaddressForm.get("state").setValue('');
      if (e.target.value == 'US') {
        let post = this.billingaddressForm.get('postal_code').value;
        if (post.length != 5) {
          this.billingaddressForm.get('postal_code').setValue('');
        }
      }
      else {
        this.billingaddressForm.get('postal_code').setValue('');
      }
      // button and checkbox enable
      this.Btndisable1 = false;
    }
    else if (formType == 'billingaddressForm1') {
      this.billingaddressForm1.get("state").setValue('');
      if (e.target.value == 'US') {
        let post = this.billingaddressForm1.get('postal_code').value;
        if (post.length != 5) {
          this.billingaddressForm1.get('postal_code').setValue('');
        }
      }
      else {
        this.billingaddressForm1.get('postal_code').setValue('');
      }
      // button  and checkbox enable
      this.Btndisable2 = false;
    }
    else {
      this.billingaddressForm2.get("state").setValue('');
      if (e.target.value == 'US') {
        let post = this.billingaddressForm2.get('postal_code').value;
        if (post.length != 5) {
          this.billingaddressForm2.get('postal_code').setValue('');
        }
      }
      else {
        this.billingaddressForm2.get('postal_code').setValue('');
      }
      // button  and checkbox enable
      this.Btndisable3 = false;
    }
    let patchData = {
      address1: this.userData.address1,
      address2: this.userData.address2,
      city: this.userData.city,
      state: this.userData.state,
      postal_code: this.userData.postal_code,
    };
    this.billingaddressForm.patchValue(patchData);
    this.billingaddressForm1.patchValue(patchData);
    this.billingaddressForm2.patchValue(patchData);

  }
  onSaveAddress(bullingForm: any) {
    this.data.addBillingAddress(bullingForm.value).subscribe(res => {
      if (res.status == 201) {
        sessionStorage.clear();
        let newData = res.session[0];
        sessionStorage.setItem('isLoggedIn', JSON.stringify(newData));
        sessionStorage.setItem('authkey', newData.authkey);
        sessionStorage.setItem('type', newData.type);
        sessionStorage.setItem('iduser', newData.iduser);
        sessionStorage.setItem('username', newData.username);
        sessionStorage.setItem('idaccount', newData.idaccount);
        if (newData.isEmailVerify == "true" && newData.isMobileVerify == "true" && newData.isAddress == "true" && newData.isPlan == "true") {
          if (newData.newUser_status == 1) {
            this.router.navigate(['/user/credit-card-authorization'])
              .then(() => {
                location.reload();
              })
          }
          else {
            this.data.sendFinalMail(bullingForm.value).subscribe(res => {
              // this.router.navigate(['/dashboards'])
              this.router.navigate(['/user/account-action'])
                .then(() => {
                  location.reload();
                })
            });
          }
        }
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 3000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 3000);
      }
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 3000);
    });
  }

  ValidateAddress(BullingForm: any) {
    this.countryF = true;
    this.countryVal = BullingForm.value.country
    const firstName = BullingForm.value.first_name;
    const lastName = BullingForm.value.last_name;
    const email = BullingForm.value.email;
    if(BullingForm.value.customerType !== 'Sole_Proprietor'){
      if(!firstName || !lastName || !email) {
        this.errMessage = "All Fields of Authorized Business Representative are Required"
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }
    if (BullingForm.invalid || BullingForm.value.country == '' || !firstName || !lastName) {
      if (BullingForm.value.customerType !== 'Corporation') {
        this.submitted = true;
      }
      else {
        if (BullingForm.value.country == '') {
          this.submitted = true;
        }
      }
      this.submitted1 = true;
      return false;
    }
    else {
      if (this.countryVal == 'US') {
        this.data.getGeoCodeAdd(BullingForm.value).subscribe(res => {
          if (res.status == 200) {
            this.onSaveAddress(BullingForm);
          }
          else {
            this.errMessage = "Address Validation Failed!";
            setTimeout(() => {
              this.errMessage = "";
            }, 3000);
          }
        }, err => {
          this.responseMessage = err.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        });
      }
      else {
        this.onSaveAddress(BullingForm);
      }
    }
  }


  Restrictpaste() {
    return false;
  }

  specialNumber(event: any, Formname: any) {
    this.inputvalue = event.target.value.toUpperCase();
    if (this.Canada == true) {
        this.zipLength = 10;
      if (Formname == 'billingaddressForm') {
        let Post: any = this.billingaddressForm.get("postal_code");
        Post.setValidators([Validators.required,Validators.maxLength(this.zipLength)]);
        Post.updateValueAndValidity();
      }
      else if (Formname == 'billingaddressForm1') {
        let Post: any = this.billingaddressForm1.get("postal_code");
        Post.setValidators([Validators.required,Validators.maxLength(this.zipLength)]);
        Post.updateValueAndValidity();
      }
      else if (Formname == 'billingaddressForm2') {
        let Post: any = this.billingaddressForm2.get("postal_code");
        Post.setValidators([Validators.required,Validators.maxLength(this.zipLength)]);
        Post.updateValueAndValidity();
      }
    }
    if (this.USA == true) {
      this.zipLength = 5;
      if (Formname == 'billingaddressForm') {
        let Post: any = this.billingaddressForm.get("postal_code");
        Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
        Post.updateValueAndValidity();
      }
      else if (Formname == 'billingaddressForm1') {
        let Post: any = this.billingaddressForm1.get("postal_code");
        Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
        Post.updateValueAndValidity();
      }
      else if (Formname == 'billingaddressForm2') {
        let Post: any = this.billingaddressForm2.get("postal_code");
        Post.setValidators([Validators.required, Validators.minLength(this.zipLength), Validators.maxLength(this.zipLength)]);
        Post.updateValueAndValidity();
      }
      // const charCode = (event.which) ? event.which : event.keyCode;
      // if (charCode > 31 && (charCode < 48 || charCode > 57)) {
      //   return false;
      // }
      // return true;
    }
  }

  taxeinID(evt: any) {
    if (this.selectedType == 'International_business') {
      // var regex = new RegExp("^[0-9a-zA-Z \b]+$");
      // var key = String.fromCharCode(!evt.charCode ? evt.which : evt.charCode);
      // if (!regex.test(key)) {
      // 	evt.preventDefault();
      // 	return false;
      // }
      return true;
    }
    else {
      var charCode = (evt.which) ? evt.which : evt.keyCode;
      if (charCode != 45 && charCode > 31 && (charCode < 48 || charCode > 57))
        return false;
      return true;
    }
  }

  
  resetform1(formType: any) {
    this.submitted = false;
    this.submitted1 = false;
    if (formType == 'billingaddressForm') {
      this.checkbox1 = false;
      this.billingaddressForm.markAsUntouched();
      for (const controlName in this.billingaddressForm.controls) {
        if (this.billingaddressForm.controls.hasOwnProperty(controlName)) {
          if (controlName !== 'customerType') {
            this.billingaddressForm.get(controlName).setValue('');
          }
          if (controlName == 'country') {
            this.billingaddressForm.get(controlName).setValue('');
            this.countryF = false
          }
          if(this.USA== true){
            this.billingaddressForm.get('state').setValue('undefined');
          }else{
            this.billingaddressForm.get('state').setValue('');
          }
        }
      }
    }
    else if (formType == 'billingaddressForm1') {
      this.billingaddressForm1.markAsUntouched();
      for (const controlName in this.billingaddressForm1.controls) {
        if (this.billingaddressForm1.controls.hasOwnProperty(controlName)) {
          if (controlName !== 'customerType') {
            this.billingaddressForm1.get(controlName).setValue('');
          }
          if (controlName == 'country') {
            this.billingaddressForm1.get(controlName).setValue('');
            this.countryF = false
          }
          if(this.USA== true){
            this.billingaddressForm1.get('state').setValue('undefined');
          }else{
            this.billingaddressForm1.get('state').setValue('');
          }
        }
      }
    }
    else {
      this.checkbox2 = false;
      this.billingaddressForm2.markAsUntouched();
      for (const controlName in this.billingaddressForm2.controls) {
        if (this.billingaddressForm2.controls.hasOwnProperty(controlName)) {
          if (controlName !== 'customerType') {
            this.billingaddressForm2.get(controlName).setValue('');
          }
          if (controlName == 'country') {
            this.billingaddressForm2.get(controlName).setValue('');
            this.countryF = false
          }
          if(this.USA== true){
            this.billingaddressForm2.get('state').setValue('undefined');
          }else{
            this.billingaddressForm2.get('state').setValue('');
          }
        }
      }
    }
  }
  onCustomer(event: any) {
    if (this.submitted1 == true) {
      this.submitted1 = false;
    }
    if (this.selectedType == "Corporation" || this.selectedType == "International_business") {
      this.billingaddressForm.get('country').setValue('');
      this.billingaddressForm.patchValue({
        customerType: this.selectedType,
        first_name: this.userData.firstname,
        last_name: this.userData.lastname,
        email: this.userData.email
      })
      this.checkbox1 = true;
      this.Btndisable1 = false;
      if (this.selectedType == "International_business") {
        this.billingaddressForm.get('ein').setValue('');
        let ein: any = this.billingaddressForm.get('ein');
        ein.setValidators([]);
        ein.updateValueAndValidity();
      }
      else {
        this.billingaddressForm.get('ein').setValue('');
        let ein: any = this.billingaddressForm.get('ein');
        ein.setValidators([Validators.minLength(9)]);
        ein.updateValueAndValidity();
      }
      if (this.selectedType == 'Corporation') {
        this.Country = this.corporationLimitedCountry;
      }
      else {
        this.Country = this.internationalBusiCountry;
      }
    }
    else if (this.selectedType == "Sole_Proprietor") {
      this.billingaddressForm1.reset();
      this.billingaddressForm1.get('country').setValue('');
      this.inputvalue = '';
      this.Btndisable2 = false;
      setTimeout(() => {
        this.billingaddressForm1.patchValue({
          customerType: this.selectedType,
          first_name: this.userData.firstname,
          last_name: this.userData.lastname
        });
      }, 1000);
      this.Country = this.solePropCountry;
    }
    else if (this.selectedType == "Non_Profit") {
      this.checkbox2 = true;
      this.Btndisable3 = false;
      this.billingaddressForm2.reset();
      this.billingaddressForm2.get('country').setValue('');
      this.inputvalue = '';
      setTimeout(() => {
        this.billingaddressForm2.patchValue({
          customerType: this.selectedType,
          first_name: this.userData.firstname,
          last_name: this.userData.lastname,
          email: this.userData.email
        });
      }, 1000);
      this.Country = this.noneProfitCountry;
    }
    if (this.selectedType == "Corporation") {
      this.billingaddressForm.patchValue({
        country: 'US',
      })
      this.Btndisable1 = false;
      this.USA = true;
    }
    else {
      this.USA = false;
    }
  }
}
