import { Component, OnInit } from '@angular/core';
import { SuspendedServicesComponent } from '../suspended-services/suspended-services.component';
import { MatDialog } from '@angular/material/dialog';
import { UsermanagementService } from '../usermanagement.service';
import { Subscription } from 'rxjs';
import { AbstractControl, FormBuilder, FormGroup, ValidatorFn, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { TariffService } from 'src/app/tariff/tariff.service';
declare var $: any;

@Component({
  selector: 'app-suspended-user',
  templateUrl: './suspended-user.component.html',
  styleUrls: ['./suspended-user.component.css']
})
export class SuspendedUserComponent implements OnInit {
  featureServiceData : any;
  suspendedUserList: any;
  userlist: any;
  countUser: any;
  suspendedUsers: any = [];
  responseMessage: any ="";
  errMessage: any ="";
  private subscriptionName: Subscription
  filterUser: FormGroup;
  showFilter: boolean = false;
  preferenceServices: any = [];
  regTariffs: any = [];
  public submitted: boolean = false;
  public buttonName: any = "Add";
  constructor(public data: UsermanagementService,public dialog: MatDialog , public fb: FormBuilder ,  public router: Router , private tariffService: TariffService) {
      this.subscriptionName= this.data.getUpdate().subscribe
      (message => {
        if(message.text){
          this.ngOnInit();
        }
      });
   }

  ngOnInit(): void {
    this.data.getfeatureService().subscribe((res) => {
			this.featureServiceData = res.data;
		});
    this.getUsers();
    this.data.getSuspendedService().subscribe((res) => {
      this.suspendedUserList = res.data;
    });
    this.filterUser = this.fb.group({
			to_date: [''],
			from_date: [''],
			service: [''],
			regTariff: [''],
			idaccount: [null],
			onboarding :['']
		});
    this.tariffService.getPreferenceService().subscribe(res => {
			this.preferenceServices = res.data;
		}, err => {
			console.log(err.message);
		});

		// Get tariffs
		this.tariffService.getTariffs().subscribe(res => {
			this.regTariffs = res.data;
		}, err => {
			console.log(err.message);
		});
  }
  
  getUsers(): void {
    this.data.getUsers('main').subscribe((res) => {
      this.userlist = res.data[0].filter((user)=> user.is_deleted == 0);
      this.countUser = res.data[0];
      $('#basic-datatablessSus').dataTable().fnClearTable();
			$('#basic-datatablessSus').dataTable().fnDraw();
			$('#basic-datatablessSus').dataTable().fnDestroy();
      $.getScript('./assets/table.js');
      this.suspendedUserList.forEach((suspendedUser) => {
        const suspendSame = this.userlist.find((user) => user.idaccount === suspendedUser.idaccount);
        if (suspendSame) {
          this.suspendedUsers.push(suspendSame);
        }
      });
    });
  }
  
  suspendedDialog(featureServiceData,idaccount): void {
		const dialogRef = this.dialog.open(SuspendedServicesComponent, {
      width: '50px',
      data: {serviceData:featureServiceData,idaccount:idaccount}
	  });

    dialogRef.afterClosed().subscribe(res => {
			if (res.status == 200) {
				this.responseMessage = res.message;
				setTimeout(() => {
					this.responseMessage = "";
				}, 5000);
			}
			else{
				this.errMessage = res.message;
				setTimeout(() => {
					this.errMessage = "";
				}, 5000);
			}
		});
	}
  showfilter() {
		if (this.showFilter == false) {
			this.showFilter = true;
		}
		else {
			this.showFilter = false;
		}
	}

	applyUserFilter(){
		if(this.filterUser.invalid){
			return
		}
		else {
			const filterValues = Object.values(this.filterUser.value);
			const allFieldsEmpty = filterValues.every(value => value === "");
			this.data.UserFilter(JSON.stringify(this.filterUser.value)).subscribe((res) => {
				if (res.status == 201) {
					$('#basic-datatablessSus').dataTable().fnClearTable();
					$('#basic-datatablessSus').dataTable().fnDraw();
					$('#basic-datatablessSus').dataTable().fnDestroy();
					this.userlist = res.data;
					// this.suspendedUsers = [];
					this.suspendedUserList.forEach((suspendedUser) => {
            const suspendSame = this.userlist.find((user) => user.idaccount === suspendedUser.idaccount);
            if (suspendSame && suspendSame.is_deleted == 0) {
              this.suspendedUsers.push(suspendSame);
            }
          });		
					$.getScript('./assets/table.js');
					if(allFieldsEmpty){
						this.responseMessage = "";
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
					else {
						this.responseMessage = res.message;
						setTimeout(() => {
							this.responseMessage = "";
						}, 5000);
					}
				}
				else {
					this.errMessage = res.message;
					setTimeout(() => {
						this.errMessage = "";
					}, 5000);
				}
			});	
		}
	}
  messageshow() {
		const from_date = this.filterUser.get('from_date').value;
		const to_date = this.filterUser.get('to_date').value;
		const currentDate = new Date();
		if ((!from_date && !to_date)) {
		} else if ((from_date == null || !from_date) && (to_date != null)) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
		} else if ((from_date != null) && (to_date == null || !to_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
		} else if (from_date && to_date && new Date(to_date) < new Date(from_date)) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
		  return;
		} else if (to_date && new Date(to_date) > currentDate) {
		  this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
		  return;
		} else if (from_date && new Date(from_date) > currentDate) {
		  this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
		  return;
		} else {
		  this.filterUser.get('from_date').setErrors(null);
		  this.filterUser.get('to_date').setErrors(null);
		}
	}

	// truncatenotification(subject: string, maxLength: number): string {
	// 	return subject.length > maxLength ? subject.substring(0, maxLength) + '...' : subject;
	//   }

	truncatenotification(subject: string, maxLength: number): string {
		if (subject && subject.length > maxLength) {
			return subject.substring(0, maxLength) + '...';
		} else {
			return subject;
		}
	}

	resetUserFilter() {
		this.filterUser.reset();
		this.router.navigate(['/user/user-details']);
		this.getUsers();
	}

}
