import { Component, Inject, Input } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { UsermanagementService } from '../../usermanagement.service';
import { MatDialogRef, MAT_DIALOG_DATA } from '@angular/material/dialog';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { BehaviorSubject, Observable } from 'rxjs';
import { TariffService } from 'src/app/tariff/tariff.service';

@Component({
	selector: 'app-adddialog',
	templateUrl: './adddialog.component.html',
	styleUrls: ['./adddialog.component.css']
})

export class AdddialogComponent extends AppComponentClass<any, any> {
	@Input() usertype: Observable<boolean>;
	@Input() curuserid?: number = -1;
	public show: boolean = false;
	reg_status$ = new BehaviorSubject<string>("Un-Register");
	reg_status = this.reg_status$.asObservable();
	listdata: any;
	public boxtype: any;
	private savetype = 0;

	public usermanagementForm: FormGroup;
	public submitted: boolean = false;
	regTariffs: any;
	unregTariffs: any;
	@Input() responseMessage: any;
	field: any;
	errMessage: any = "";
	Password: any = '';
	savePlan :any = 'Submit';

	constructor(private tariffService: TariffService, public dialogRef: MatDialogRef<AdddialogComponent>,
		@Inject(MAT_DIALOG_DATA) public ddata: any, public data: UsermanagementService,
		public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

	ngOnInit(): void {

		// this.tariffService.getTariffs("registered").subscribe(res => {
		// 	this.regTariffs = res.data;
		// });

		// this.tariffService.getTariffs("unregistered").subscribe(res => {
		// 	this.unregTariffs = res.data;
		// });

		this.data.getsuppiler().subscribe((result) => {
			this.listdata = result[1];
			this.field = result[2];
			this.listdata.forEach(element => {
				element.disabled = false;
			});

			let fields = {};
			this.boxtype = this.ddata.dialogtype;
			if (this.ddata.savetype)
				this.savetype = this.ddata.savetype;
			if (this.boxtype == 1) {
				this.savePlan='Submit';
				fields["iduser"] = [-1];
				fields["idaccount"] = [this.ddata.idaccount];
				fields["newUser_status"] = [this.ddata.newUser_status];
				fields["type"] = [this.ddata.type + "2"];
				this.listdata.forEach(element => {
					fields[element.formControl] = new FormControl('');
				});

				this.usermanagementForm = this.fb.group(fields);

				this.usermanagementForm.patchValue({
					status: false
				});

				this.show = true;
			}
			else {
				this.savePlan='Update';
				fields["iduser"] = [this.ddata.iduser];
				fields["idaccount"] = [this.ddata.idaccount];
				fields["type"] = [this.ddata.type];
				this.savetype = 0;
				this.listdata.forEach(element => {
					fields[element.formControl] = [this.ddata[element.formControl]];
				});
				this.usermanagementForm = this.fb.group(fields);

				this.show = true;
			}
		});

		

	}

	
	checkPassword(e) {
		if (e.target.value.length < 8) {
			this.Password = "Password must be minimum 8 characters long";
		}
		// if (e.target.value.length >= 20) {
		// 	this.Password = "Password must be maximum 20 characters long";
		// }
		if (e.target.value.length <= 0) {
			this.Password = "Password is required";
		}
		if(e.target.value.length >= 8)
		{
			this.Password ="";
		}
	}
	onAddUser() {
		this.submitted = true;
		if (this.usermanagementForm.value.iduser !== -1) {
			this.usermanagementForm.patchValue({
				password: ''
			});
		}
		if (this.usermanagementForm.invalid) {
			if (!this.usermanagementForm.value.password && this.usermanagementForm.value.iduser == -1) {
				this.Password = 'Password is required';
			}
			return false;
			// this.submitted = true;
		}
		else {
			this.Password = '';
			if (this.savetype == 0) {
				if (!this.usermanagementForm.value.password && this.usermanagementForm.value.iduser == -1) {
					this.Password = 'Password is required';
					return;
				}
				this.savePlan='Submit';
				this.data.SaveUserData(JSON.stringify(this.usermanagementForm.value)).subscribe(res => {
						if (res.status == 201) {
							this.dialogRef.close(1);
							this.submitted = false;						
							this.ngOnInit();
						}
						else {
							this.errMessage = res.message;
							setTimeout(() => {
								this.errMessage = "";
							}, 5000);
						}
					});
			}
			if (this.savetype == 1) {
				this.data.SaveAdminData(JSON.stringify(this.usermanagementForm.value)).subscribe(res => {
					if (res.status == 201) {
						this.responseMessage = res.message;
						this.submitted = false;
							setTimeout(() => {
								this.responseMessage = "";
								this.dialogRef.close(1);
							}, 3000);						
						this.ngOnInit();
					}
					else {
						this.errMessage = res.message;
						setTimeout(() => {
							this.errMessage = "";
						}, 5000);
					}
				});
			}
		}
	}

	close() {
		this.dialogRef.close(-1);
	}

	onCheck(e) {
		if (e.target.checked) {
			this.reg_status$.next("Register");
		}
		else {
			this.reg_status$.next("Un-Register")
		}
	}
	reset() {
		let data :any= {}
		data = this.usermanagementForm.value;
		console.log("data",data);
		this.submitted = false;
		this.Password = '';
		this.usermanagementForm.reset({
			credit_limit: data.credit_limit,
            idaccount: data.idaccount,
            iduser: data.iduser,
            is_sms: data.is_sms,
			is_voice: data.is_voice,
			newUser_status: data.newUser_status,
			service: data.service,
			status: data.status,
			tariff1: data.tariff1,
			type: data.type
		});
      }
	
	  reset1() {
		let data :any= {}
		data = this.usermanagementForm.value;
		this.submitted = false;
		this.Password = '';
		this.usermanagementForm.reset({
			credit_limit: data.credit_limit,
            idaccount: data.idaccount,
            iduser: data.iduser,
            is_sms: data.is_sms,
			is_voice: data.is_voice,
			newUser_status: data.newUser_status,
			service: data.service,
			status: data.status,
			tariff1: data.tariff1,
			type: data.type,
			user_name : data.user_name
		});
      }
}
