import { Component, ElementRef, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, NavigationExtras, ParamMap, Router } from '@angular/router';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { InboundService } from 'src/app/inbound/inbound.service';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { AgentserviceService } from '../agentservice.service';
declare var $: any;

@Component({
  selector: 'app-addagent',
  templateUrl: './addagent.component.html',
  styleUrls: ['./addagent.component.css']
})

export class AddagentComponent extends AppComponentClass<any, any> {
  @ViewChild('createmodal') createmodal: ElementRef;
  addagentForm: FormGroup;
  submitted: boolean = false;
  responseMessage = "";
  id: any;
  agent: any;
  navigationExtras: NavigationExtras = {};
  errMessage = "";
  dids: any = [];
  strategy: IDropdownSettings = {};
  selectedItems = [];
  groupKey: any;
  filterForm: FormGroup;
  closeDropdownSelection = true;
  titleText: string = '';
  saveButton: any = 'Submit';
  Urldata: string;

  constructor(public data: AgentserviceService,
    private inboundService: InboundService,
    public router: Router, public fb: FormBuilder,
    private route: ActivatedRoute) {
    super(data, router, fb);

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.groupKey = params.get('id');
      this.Urldata = this.router.url.split("/")[2];
      if (this.Urldata == 'edit-agent') {
        this.titleText = "Edit Agent",
          this.saveButton = 'Update';
      }
      else {
        this.titleText = "Add Agent",
          this.saveButton = 'Submit';
      }
    });
  }

  ngOnInit(): void {
    this.addagentForm = this.fb.group({
      IdAgent: [''],
      FullName: ['', [Validators.required,Validators.maxLength(255) ,Validators.pattern(/^(?!\s*$).+$/)]],
      UserName: ['', [Validators.required, Validators.pattern(/^\S+$/)]],
      CallerId: ['', [Validators.required]],
      Password: ['', [Validators.required, Validators.minLength(5),Validators.maxLength(50)]],
      Group: [this.groupKey],
      VmPin: ['', [Validators.required, Validators.minLength(4), Validators.maxLength(4), Validators.pattern("[0-9]+")]]
    });
    this.filterForm = this.fb.group({
      // fromDate: new FormControl(this.startDate()),
      // toDate: new FormControl(this.current_datetime()),
      selectedUser: new FormControl(''),
      didnumber: new FormControl('', [Validators.minLength(3), Validators.maxLength(10)]),
      didnpa: new FormControl('', [Validators.minLength(3)]),
      selectState: new FormControl(''),
      selectSMS: new FormControl('')
    });

    this.strategy = {
      singleSelection: true,
      idField: 'did',
      textField: 'did',
      itemsShowLimit: 3,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

    this.dids = [];
    this.inboundService.onGetBuyDids(this.filterForm.value).subscribe(res => {
      this.dids = res.data;
    }, err => {
      this.responseMessage = "Connection Loss";
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });




    this.route.paramMap.subscribe((params: ParamMap) => {
      this.id = params.get('id');
      this.Urldata = this.router.url.split("/")[2];
      if (this.id && this.Urldata == 'edit-agent') {
        this.data.getSingleAgent(this.id).subscribe(result => {
          if (result.status == 200) {
            this.agent = result.data[0];
            this.addagentForm.patchValue({
              IdAgent: this.agent.idagent,
              FullName: this.agent.full_name,
              UserName: this.agent.username,
              Password: this.agent.password,
              Group: this.agent.group,
              VmPin: this.agent.vm_pin
            });
            this.selectedItems = [this.agent.callerid];
          }
          else {
            this.errMessage = result.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        });
      }
    });
  }

  getCallerId(event) {
    this.addagentForm.patchValue({
      Strategy: event.did
    });
    this.selectedItems = [event.did];
  }

  // @to save/update form data
  onSubmit() {
    this.submitted = true;
    if (this.addagentForm.invalid) {
      return;
    }
    else {
      // this.addagentForm.patchValue({
      //   CallerId: this.addagentForm.value.CallerId[0].did
      // });
      if (this.addagentForm.value.IdAgent == undefined || this.addagentForm.value.IdAgent == '') {
        this.data.saveAgent(this.addagentForm.value).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            this.onReset();
            const compModal = document.getElementById('createmodal');
            $(compModal).modal({ backdrop: 'static', keyboard: false });
            $(compModal).modal('show');
            setTimeout(() => {
              this.responseMessage = "";
            }, 5000);
            //this.router.navigateByUrl('/agents/agent-details/' + this.groupKey);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.responseMessage = err.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        })
      }
      else {
        this.data.updateAgent(this.addagentForm.value).subscribe(res => {
          if (res.status == 201) {
            this.responseMessage = res.message;
            setTimeout(() => {
              this.responseMessage = "";
              this.router.navigateByUrl('/agents/agent-details/' + this.agent.group);
            }, 5000);
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          this.responseMessage = err.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        })
      }
    }
  }

  onReset() {
    this.submitted = false;
    this.addagentForm.reset();
    Object.keys(this.addagentForm.controls).forEach(key=>{
      this.addagentForm.get(key).setValue('');
    })
  }

  onReset1() {
    this.submitted = false;
    this.addagentForm.reset();
    Object.keys(this.addagentForm.controls).forEach(key=>{
      this.addagentForm.get(key).setValue('');
    })
    this.addagentForm.patchValue({
        IdAgent: this.id,
        Group: this.groupKey
    })
  }



  ModalOPen() {
    const modal = document.getElementById('createmodal');
    if (modal) {
      $(modal).modal('hide');
      $('.modal-backdrop').remove();
    }
    // location.reload();
  }

  ngOnDestroy() {
    this.createmodal.nativeElement.click();
  }

}
