import { Routes } from '@angular/router';
import { NotfoundComponent } from './authentication/404/not-found.component';
import { BlankComponent } from './layouts/blank/blank.component';
import { FullComponent } from './layouts/full/full.component';
import { AuthGuard } from './authentication/guard/auth.guard';
import { environment } from 'src/environments/environment';


var appuri, logouturi, leadupload, voiceupload, dncupload, profileUpload,
  fileupload, gallerydir, recordingdir, appurl: string;
if (environment.production) {
  appuri = environment.SERVER;
  logouturi = environment.SERVER + 'logout';
  leadupload = environment.SERVER + 'uploads';
  voiceupload = environment.SERVER + 'uploads';
  profileUpload = environment.SERVER + 'uploads';
  dncupload = environment.SERVER + 'dnc';
  fileupload = environment.SERVER + 'fileupload';
  appurl = environment.SERVERURL;
  gallerydir = environment.SERVERURL + "assets/voicemail/";
  recordingdir = environment.RECORDRURL;
}
else {
  appuri = environment.SERVER;
  logouturi = environment.SERVER + 'logout';
  leadupload = environment.SERVER + 'uploads';
  voiceupload = environment.SERVER + 'uploads';
  profileUpload = environment.SERVER + 'uploads';
  dncupload = environment.SERVER + 'dnc';
  fileupload = environment.SERVER + 'fileupload';
  appurl = environment.SERVERURL;
  gallerydir = environment.SERVERURL + "assets/voicemail/";
  recordingdir = environment.RECORDRURL;
}

export const APIURL = appuri;
export const LogoutURL = logouturi;
export const LeadsUpload = leadupload;
export const VoiceUpload = voiceupload;
export const ProfileUpload = profileUpload;
export const DncUpload = dncupload;
export const FileUpload = fileupload;
export const AUDIOURL = appurl;
export const RecordingUrl = recordingdir;
export const GalleryPath = gallerydir;
//export const TiffPath= tiffdir;
//export const PngPath= pngdir;
//export const DownloadPath= downloaddir;


export const Approutes: Routes = [

  {
    path: '',
    component: BlankComponent,
    children: [
      {
        path: '',
        redirectTo: 'login',
        pathMatch: 'full'
      },
      {
        path: '',
        loadChildren: () => import('./authentication/authentication.module').then(m => m.AuthenticationModule)
      },
      {
        path: '404',
        component: NotfoundComponent
      }
    ]
  },



  {
    path: '',
    component: FullComponent,
    canActivate: [AuthGuard],

    children: [

      {
        path: 'dashboards',
        // data: {
        //   permissions: dataGuard.getAllPermissions()
        // },
        loadChildren: () => import('./dashboards/dashboard.module').then(m => m.DashboardModule)
      },

      {
        path: 'inbound',
        loadChildren: () => import('./inbound/inbound.module').then(m => m.InboundModule)
      },

      {
        path: 'billing',
        loadChildren: () => import('./billing/billing.module').then(m => m.BillingModule)
      },

      {
        path: 'campaigns',
        loadChildren: () => import('./campaigns/campaigns.module').then(m => m.CampaignsModule)
      },

      {
        path: 'api',
        loadChildren: () => import('./api/api.module').then(m => m.ApiModule)
      },

      {
        path: 'sms',
        loadChildren: () => import('./sms/sms.module').then(m => m.SmsModule)
      },

      {
        path: 'outbound',
        loadChildren: () => import('./outbound/outbound.module').then(m => m.OutboundModule)
      },

      {
        path: 'user',
        loadChildren: () => import('./usermanagement/usermanagement.module').then(m => m.UsermanagementModule)
      },

      {
        path: 'tariff',
        loadChildren: () => import('./tariff/tariff.module').then(m => m.TariffModule)
      },

      {
        path: 'connections',
        loadChildren: () => import('./connections/connections.module').then(m => m.ConnectionsModule)
      },

      {
        path: 'programmble',
        loadChildren: () => import('./programmable/programmable.module').then(m => m.ProgrammableModule)
      },

      {
        path: 'campaign',
        loadChildren: () => import('./campaign/campaign.module').then(m => m.CampaignModule)
      },

      {
        path: 'new-campaign',
        loadChildren: () => import('./new-campaign/new-campaign.module').then(m => m.NewCampaignModule)
      },
      {
        path: 'whitelabel',
        loadChildren: () => import('./whitelabel/whitelabel.module').then(m => m.WhitelabelModule)
      },

      {
        path: 'agents',
        loadChildren: () => import('./agents/agents.module').then(m => m.AgentsModule)
      },

      {
        path: 'reports',
        loadChildren: () => import('./reports/reports.module').then(m => m.ReportsModule)
      },

      {
        path: 'signup-template',
        loadChildren: () => import('./signuptemplate/signuptemplate.module').then(m => m.SignuptemplateModule)
      },
      {
        path: 'webhook',
        loadChildren: () => import('./webhook/webhook.module').then(m => m.WebhookModule)
      },
      {
        path: 'reseller',
        loadChildren: () => import('./reseller/reseller.module').then(m => m.ResellerModule)
      },
      {
        path: 'kyc',
        loadChildren: () => import('./kyc/kyc.module').then(m => m.KycModule)
      },
      {
        path: 'volt-login',
        loadChildren: () => import('./volt-login/volt-login.module').then(m => m.VoltLoginModule)
      },
      {
        path: 'federal',
        loadChildren: () => import('./federal/federal.module').then(m => m.FederalModule)
      },
      {
        path: '',
        loadChildren: () => import('./account-message/account-message.module').then(m => m.AccountMessageModule)
      },
      {
        path: '',
        loadChildren: () => import('./tollfreesms/tollfreesms.module').then(m => m.TollfreesmsModule)
      },
      {
        path: '',
        loadChildren: () => import('./shortcodesms/shortcodesms.module').then(m => m.ShortcodesmsModule)
      },
      {
        path: '',
        loadChildren: () => import('./notification/notification.module').then(m => m.NotificationModule)
      },
      {
        path: '',
        loadChildren: () => import('./group/group.module').then(m => m.GroupModule)
      },
      {
        path: 'obsiptrunking',
        loadChildren: () => import('./obsiptrunking/obsiptrunking.module').then(m => m.ObsiptrunkingModule)
      },
      {
        path: '',
        loadChildren: () => import('./downloadreport/downloadreport.module').then(m => m.DownloadreportModule)
      }
    ]
  },
  // {
  //   path: '',
  //   component: FullComponent,
  //   canActivate: [AuthGuard],

  //   children: [

  //   ]
  // },
];
