import { Routes } from '@angular/router';

import { ErrorComponent } from './error/error.component';
import { LockscreenComponent } from './lockscreen/lockscreen.component';
import { LoginComponent } from './login/login.component';
import { NotfoundComponent } from './404/not-found.component';
import { SignupComponent } from './signup/signup.component';
import { VerifyemailComponent } from './verifyemail/verifyemail.component';
import { ForgotComponent } from './forgot/forgot.component';
import { DeleteUserComponent } from './delete-user/delete-user.component';
import { DeleteProcessComponent } from './delete-process/delete-process.component';
import { RestoreAccountComponent } from './restore-account/restore-account.component';
import { ResetPasswordComponent } from './reset-password/reset-password.component';
import { UserloginComponent } from './userlogin/userlogin.component';
export const AuthenticationRoutes: Routes = [
  {
    path: '',
    children: [
      {
        path: 'login',
        component: LoginComponent,
        data: {
          title: "Signalmash Login"
        }
      },
      {
        path: 'delete-account',
        component: DeleteUserComponent,
        data: {
          title: "Signalmash Deleted Account"
        }
      },
      {
        path: 'delete-process',
        component: DeleteProcessComponent,
        data: {
          title: "Signalmash Deleted Process Account"
        }
      },
      {
        path: 'lockscreen',
        component: LockscreenComponent,
        data: {
          title: "Lock Screen"
        }
      },
      {
        path: 'signup',
        component: SignupComponent,
        data: {
          title: "Signup"
        }
      },
      {
        path: 'password/:id',
        component: ForgotComponent,
        data: {
          title: "Forgot"
        }
      },
      {
        path: 'password/reset-password/:id',
        component: ForgotComponent,
        data: {
          title: "Reset Password"
        }
      },
      {
        path: 'forgot',
        component: ForgotComponent,
        data: {
          title: "Forgot"
        }
      },
      {
        path: 'verify-email/:id',
        component: VerifyemailComponent,
        data: {
          title: "User Profile"
        }
      },
      {
        path: 'signup/:id',
        component: SignupComponent,
        data: {
          title: "Signup"
        }
      },
      {
        path: '404',
        component: NotfoundComponent,
        data: {
          title: "404 Error"
        }
      },
      {
        path: 'restore-account',
        component: RestoreAccountComponent,
        data: {
          title: "Restore Account"
        }
      },
      {
        path: 'reset-password',
        component: ResetPasswordComponent,
        data: {
          title: "Reset Password"
        }
      },
      {
        path: 'userlogin/:auth',
        component: UserloginComponent,
        data: {
          title: "User Login"
        }
      },
    ]
  }
];
