import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { HttpClient, HttpHeaders, HttpParams } from '@angular/common/http';

import { AppService } from '../shared/service/AppService.class';
import { LoaderEnabled } from '../shared/loader/loader.service';
import { environment } from 'src/environments/environment';

@Injectable({
  providedIn: 'root'
})

export class BillingService extends AppService<any> {

  constructor(public http: HttpClient) {
    super(http)
  }

  public getinvoice(): Observable<any> {
    return this.http.get('./assets/invoice.json');
  }

  public getinvoicetax(): Observable<any> {
    return this.http.get('/assets/invoice.json');
  }

  public getaccount(): Observable<any> {
    return this.http.get('./assets/account.json');
  }

  public getorder(): Observable<any> {
    return this.http.get('./assets/orderhistory.json');
  }

  public getratedeck(): Observable<any> {
    return this.http.get('./assets/ratedecks.json');
  }

  public getbillingaddress(): Observable<any> {
    return this.http.get('./assets/billingaddress.json');
  }

  get_stripecards(): Observable<any> {
    return this.http.get('./assets/stripecards.json')
  }

  @LoaderEnabled()
  getInv(): Observable<any> {
    this.appmod = "getInvoice";
    let result = super.getService();
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  stripe_data(id: any): Observable<any> {
    this.appmod = "get_card_data";
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  stripe_api_data(id: any): Observable<any> {
    this.appmod = "get_stripe_data";
    let result = super.getService(id);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  getUsers(type: string): Observable<any> {
    this.appmod = "user";
    let tmp = this.getService(type);
    this.appmod = "usermanagement";
    return tmp;
  }

  @LoaderEnabled()
  delete_card(payLoad: any): Observable<any> {
    this.appmod = "card_delete";
    let result = super.saveService(payLoad);
    this.appmod = "";
    return result;
  }

  @LoaderEnabled()
  stripeCards(): Observable<any> {
    const apiURL = environment.SERVER + 'stripe-cards';
    let httpHeaders = new HttpHeaders({
      "Content-Type": "application/json"
    });
    return this.http.get(apiURL, { headers: httpHeaders });
  }

  @LoaderEnabled()
  monthlyInvoice(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "monthly-invoice";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  invoiceBilling(idinvoice: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "invoice";
    return this.http.get(apiUrl, { headers: httpHeaders, params: { idinvoice: idinvoice } });
  }

  @LoaderEnabled()
  CsvInvoice(data): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "csvinvoice";
    return this.http.get(apiUrl, { headers: httpHeaders, params: data });
  }

  @LoaderEnabled()
  getInvoiceTax(data: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "get_invoice_tax";
    return this.http.get(apiUrl, { headers: httpHeaders, params: data });
  }

  // @LoaderEnabled()
  // paymentHistory(): Observable<any> {
  //   this.appmod = "paymenthistory";
  //   let result = super.getService();
  //   this.appmod = "";
  //   return result;
  // }

  @LoaderEnabled()
  paymentHistory(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "paymenthistory";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }

  @LoaderEnabled()
  addBillingAddress(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'add_billing_address';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getGeoCodeAdd(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = 'get_geo_code';
    let result = super.saveService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getBillingAddress(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "get_billing_address";
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getInvoiceAddress(idinvoice?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "invoice-address";
    return this.http.get(apiUrl, { headers: httpHeaders, params: { idinvoice: idinvoice } });
  }

  @LoaderEnabled()
  updateBillingAddress(data: any): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "update_billing_address";
    let result = super.updateService(data);
    this.appmod = tmp;
    return result;
  }

  @LoaderEnabled()
  getBalance(): Observable<any> {
    let tmp = this.appmod;
    this.appmod = "getbalance";
    let result = super.getService();
    this.appmod = tmp;
    return result;
  }

  // getBalance(): any {
  //   let apiURL = environment.SERVER+ "getbalance";
  //   let httpHeaders = new HttpHeaders({
  //     "Content-Type": "application/json"
  //   });
  //     this.http.get(apiURL, { headers: httpHeaders }).subscribe((res: any) => {
  //     this.balance.next(res.data[0].balance);
  //   });
  //   return this.balance;
  // }


  @LoaderEnabled()
  addBalance(bill: any): Observable<any> {
    this.appmod = "addbalance";
    let data = super.saveService(bill);
    this.appmod = "";
    return data;
  }

  @LoaderEnabled()
  updateBalance(bill: any): Observable<any> {
    this.appmod = "updatebalance";
    let data = super.updateService(bill);
    this.appmod = "";
    this.getBalance();
    return data;
  }

  @LoaderEnabled()
  generateInvoice(data: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "generate-invoice";
    return this.http.post(apiUrl, data, { headers: httpHeaders });
  }

  @LoaderEnabled()
  public getProfile(type: string): Observable<any> {
    this.appmod = "user";
    let tmp = this.getService(type);
    this.appmod = "";
    this.getBalance();
    return tmp;
  }

  @LoaderEnabled()
  closingInvoice(filter?: any): Observable<any> {
    let httpHeaders = new HttpHeaders({
      'Content-Type': 'application/json',
    });
    let apiUrl = environment.SERVER + "closing_invoice";
    return this.http.get(apiUrl, { headers: httpHeaders, params: filter });
  }
}
