import { HttpClient } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { BillingService } from '../billing.service';
import { ActivatedRoute, ParamMap } from '@angular/router';


@Component({
  selector: 'app-detailcustomercard',
  templateUrl: './detailcustomercard.component.html',
  styleUrls: ['./detailcustomercard.component.css'],
})
export class DetailcustomercardComponent implements OnInit {
  public userdata: any;
  cust_id: string;
  stripe_data: any = [];
  errMessage: any = '';
  responseMessage: any = '';
  stripes_data: any;
  preferredlocal: string;
  public userdata1: any;
  public userdata2: any;
  public userdata3: any;
  public userdata4: any;
  idstripe: string;
  constructor(
    public router: Router,
    private http: HttpClient,
    public data: BillingService,
    private route: ActivatedRoute
  ) {}

  ngOnInit(): void {
    this.data.get_stripecards().subscribe((result) => {
      this.userdata = result[1].accordion;
      this.userdata1 = this.userdata[0].heading
      this.userdata2 = this.userdata[1].accordionheader1;
      this.userdata3 = this.userdata[2].accordionheader2;
      this.userdata4 = this.userdata[3].accordionheader3;
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.cust_id = params.get('customer_id');
      this.idstripe =  params.get('idstripecard');

    });
    
    this.Stripe_signal_Details();
    this.Stripe_Details();

  }

  Stripe_signal_Details() {
    this.data.stripe_data(this.idstripe).subscribe((res) => {
      if (res.status == 200) {
        this.stripe_data = res.data;
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }


  Stripe_Details() {
    this.data.stripe_api_data(this.cust_id).subscribe((res) => {
      if (res.status == 201) {
        this.stripes_data =res.data;
        console.log("typeof res.datatypeof res.data",typeof res.data);
        
        if (this.stripes_data.preferred_locales.length === 0) {
          this.preferredlocal = 'N/A'
        } else {
          this.preferredlocal = this.stripes_data.preferred_locales;
        }
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });

  }
  formatMonth(month: number): string {
    return month < 10 ? '0' + month : month.toString();
  }
}
