import { Component } from '@angular/core';
import { BillingService } from '../billing.service';
import { FormBuilder, FormGroup, FormControl, Validators, AbstractControl, ValidatorFn } from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
import * as XLSX from 'xlsx';
import { saveAs } from 'file-saver';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
import { newArray } from '@angular/compiler/src/util';
declare var $: any;

@Component({
  selector: 'app-orderhistory',
  templateUrl: './orderhistory.component.html',
  styleUrls: ['./orderhistory.component.css']
})
export class OrderhistoryComponent extends AppComponentClass<any, any> {
  p: number = 1;
  searchText = { count: 0 };
  filtre: string;
  page = 1;
  count = 0;
  tableSize = 50;
  tableSizes = [50, 100, 150];
  filterTerm: string
  paymentList: any = [];
  paymentListLength: any = [];
  monthlyInvoice: any = [];
  errMessage: any = "";
  userType: any = "";
  isAdmin: boolean = false;
  filterForm: FormGroup;
  monthNameList: any = [];
  submitted: boolean = false;
  public show: boolean = false;
  users: any = [];
  EXCEL_TYPE = 'application/csv';
  EXCEL_EXTENSION = '.csv';
  responseMessage: any = "";
  //static filterForm: any;
  show_filter: boolean = false;
  // users = [];
  selectedUser: any;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  selectedItem: any = [];
  name_with_san: any = [];
  userss: any = [];

  constructor(public data: BillingService, public router: Router, public fb: FormBuilder, private userService: UsermanagementService) {
    super(data, router, fb);

    let session = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = session.type;
  }

  ngOnInit(): void {

    let isLoggedIn = JSON.parse(sessionStorage.getItem("isLoggedIn"));
    this.userType = isLoggedIn.type;
    if (this.userType == 1) {
      this.isAdmin = true;
    }
    else {
      this.isAdmin = false;
    }

    this.filterForm = this.fb.group({
      fromDate: new FormControl(this.startDate(), [Validators.required]),
      toDate: new FormControl(this.current_datetime(), [Validators.required]),
      from_amount: [''],
      to_amount: [''],
      payment_Status: [''],
      selectedUser: ['']
    });

    this.monthsList();

    this.paymentList = [];
    // this.data.paymentHistory(this.filterForm.value).subscribe(res => {
    //   if (res.status == 200) {
    //     $('#basic-datatables11a').DataTable().clear();
    //     $('#basic-datatables11a').DataTable().draw();
    //     $('#basic-datatables11a').DataTable().destroy();
    //     $.getScript('./assets/table.js');
    //     this.paymentList = res.data;
    //     // this.paymentListLength = this.paymentList.length;
    //   }
    // }, err => {
    //   console.log(err.message);
    // });



    // this.userService.getUsers("main").subscribe(res => {
    //   if (res.status == 200) {
    //     // this.users = res.data[0];
    //     this.users = res.data[0].map(user => ({
    //       idaccount: user.idaccount,
    //       newArray: `${user.san} - ${user.first_name} ${user.last_name}`
    //     }));
    //     // console.log("Formatted Users:", this.users);

    //   }
    //   else {
    //     this.errMessage = res.message;
    //     setTimeout(() => {
    //       this.errMessage = "";
    //     }, 5000);
    //   }
    // }, err => {
    //   this.errMessage = err.message;
    //   setTimeout(() => {
    //     this.errMessage = "";
    //   }, 5000);
    // });

    this.getlistusers();
    this.getpaymenthistory();

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'idaccount',
      textField: 'Name_san',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: this.closeDropdownSelection
    };

  }

  getlistusers() {
    this.userService.getUsers("main").subscribe(res => {
      if (res.status == 200) {
        this.users = res.data[0];
        this.users.sort((a, b) => {
          return a.idaccount - b.idaccount;
        });
        this.users.forEach(element => {
          const fullName = `${element.first_name} ${element.last_name}`
          this.name_with_san.push({ idaccount: element.idaccount, Name_san: fullName + '-' + element.san });
        })
        this.userss = this.name_with_san
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  getpaymenthistory() {
    this.data.paymentHistory(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        this.paymentList = res.data;
        $('#basic-datatables11a').DataTable().clear();
        $('#basic-datatables11a').DataTable().draw();
        $('#basic-datatables11a').DataTable().destroy();
        $.getScript('./assets/table.js');
        // this.paymentListLength = this.paymentList.length;
      }
    }, err => {
      console.log(err.message);
    });
  }

  onItemSelect(item: any) {
    console.log(item);
  }

  getMonths(startDate, endDate) {
    var resultList = [];
    var date = new Date(startDate);
    endDate = new Date(endDate);

    while (date <= endDate) {
      let month1 = date.getMonth();
      let month = month1 + 1;
      var stringDate = date.getFullYear() + "-" + month;

      //get first and last day of month
      var firstDay = new Date(date.getFullYear(), date.getMonth(), 1);
      var lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);

      resultList.push({
        str: stringDate,
        first: firstDay,
        last: lastDay,
      });
      date.setMonth(date.getMonth() + 1);
    }

    return resultList;
  };

  // selectedFromDate(e) {
  //   this.submitted = true;
  //   if (e.target.value) {
  //     this.filterForm.get("toDate").setValidators(Validators.required);
  //     this.filterForm.get("toDate").updateValueAndValidity();
  //   }
  // }

  // selectedToDate(e) {
  //   this.submitted = true;
  //   if (e.target.value) {
  //     this.filterForm.get("fromDate").setValidators(Validators.required);
  //     this.filterForm.get("fromDate").updateValueAndValidity();
  //   }
  // }

  filterByUser(e) {
    this.filterForm.patchValue({
      selectedUser: e.target.value
    });
  }

  filterSubmit() {
    this.submitted = true;
    if (this.filterForm.invalid) {
      return
    }
    else {
      
      if (this.selectedItem.length > 0) {
        this.filterForm.value.selectedUser = this.selectedItem[0].idaccount;
      }
      this.paymentList = [];
      this.data.paymentHistory(this.filterForm.value).subscribe(res => {
        if (res.status == 200) {
          this.paymentList = res.data;
          $('#basic-datatables11a').DataTable().clear();
          $('#basic-datatables11a').DataTable().destroy();
          $.getScript('./assets/table.js');
        }
        else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }

      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000)
      });
    }
    this.show = true;
  }


  // on click clear filter show start & current date of month.
  clearFilter() {
    // this.ngOnInit();
    this.submitted = false;
    this.filterForm.patchValue({
      fromDate: this.startDate(),
      toDate: this.current_datetime(),
      payment_Status: [''],
      from_amount: [''],
      to_amount: [''],
    })
    this.filterForm.get('selectedUser').setValue('')
    this.getlistusers();
    this.getpaymenthistory();
    this.name_with_san = [];
    this.selectedItem = []
  }


  downloadCSVFile() {
    this.data.paymentHistory(this.filterForm.value).subscribe(res => {
      if (res.status == 200) {
        let paymentHistory = res.data;
        setTimeout(() => {
          if (paymentHistory.length > 0) {
            let NewFilteredRes = paymentHistory.map((item) => {
              const { san, customer_name, email, timestamp, type, amount, balance_transaction, status, charge_id, description } = item;
              const Date = timestamp;
              const SAN = san;
              const Email = email;
              const Amount = amount;
              const Type = type;
              const customer_Name = customer_name;
              const Charge_id = charge_id;
              const Balance_transaction = balance_transaction;
              const Status = status;
              const Description = description;
              return {
                'SAN': SAN,
                'Customer Name': customer_Name,
                'Email': Email,
                'Amount': Amount,
                'Type': Type,
                'Date & Time': Date,
                'Charge Id': Charge_id,
                'Description': Description,
                'Balance Transaction': Balance_transaction,
                'Status': Status
              };
            });
            const worksheet: XLSX.WorkSheet = XLSX.utils.json_to_sheet(NewFilteredRes);
            const workbook: XLSX.WorkBook = { Sheets: { 'payment': worksheet }, SheetNames: ['payment'] };
            const excelBuffer: any = XLSX.write(workbook, { bookType: 'csv', type: 'array' });
            this.saveAsExcelFile(excelBuffer, "payment");
          } else {
            this.errMessage = 'No Record Available!';
            setTimeout(() => {
              this.errMessage = '';
            }, 5000);
          }
        }, 1000);
      }
    })
  }

  private saveAsExcelFile(buffer: any, fileName: string): void {
    const data: Blob = new Blob([buffer], {
      type: this.EXCEL_TYPE
    });
    saveAs(data, fileName + new Date().getTime() + this.EXCEL_EXTENSION);
  }

  // messageshow() {
  //   const fromDate = this.filterForm.get('fromDate').value;
  //   const toDate = this.filterForm.get('toDate').value;
  //   const currentDate = new Date();
  //   if ((!fromDate && !toDate)) {
  //   } else if ((fromDate == null || !fromDate) && (toDate != null)) {
  //     this.filterForm.get('fromDate').setErrors({ 'dateRange': 'Please select From Date' });
  //   } else if ((fromDate != null) && (toDate == null || !toDate)) {
  //     this.filterForm.get('toDate').setErrors({ 'dateRange': 'Please select To Date' });
  //   } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
  //     this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
  //     return;
  //   } else if (toDate && new Date(toDate) > currentDate) {
  //     this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
  //     return;
  //   } else if (fromDate && new Date(fromDate) > currentDate) {
  //     this.filterForm.get('fromDate').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
  //     return;
  //   } else {
  //     this.filterForm.get('fromDate').setErrors(null);
  //     this.filterForm.get('toDate').setErrors(null);
  //   }

  // }

  messageshow() {
    const fromDate = this.filterForm.get('fromDate').value;
    const toDate = this.filterForm.get('toDate').value;
    const fromAmount = this.filterForm.get('from_amount').value;
    const toAmount = this.filterForm.get('to_amount').value;
    const fromAmountNumeric = parseFloat(fromAmount);
    const toAmountNumeric = parseFloat(toAmount);

    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterForm.get('fromDate').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterForm.get('toDate').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterForm.get('toDate').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterForm.get('fromDate').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    }
    else if (fromAmount || toAmount) {
      if (isNaN(fromAmountNumeric) && !isNaN(toAmountNumeric)) {
        this.filterForm.get('from_amount').setErrors({ 'Range': 'Please select From Amount' });
        return;
      } else if (!isNaN(fromAmountNumeric) && isNaN(toAmountNumeric)) {
        this.filterForm.get('to_amount').setErrors({ 'Range': 'Please select To Amount' });
        return;
      } else if (!isNaN(fromAmountNumeric) && !isNaN(toAmountNumeric)) {
        if (fromAmountNumeric === toAmountNumeric) {
          this.filterForm.get('from_amount').setErrors({ 'Range': 'From and To amounts cannot be equal' });
          return;
        } else if (fromAmountNumeric > toAmountNumeric) {
          this.filterForm.get('from_amount').setErrors({ 'Range': 'From amount cannot be greater than to amount' });
          return;
        } else {
          this.filterForm.get('from_amount').setErrors(null);
          this.filterForm.get('to_amount').setErrors(null);
        }
      }
    }
    else {
      this.filterForm.get('fromDate').setErrors(null);
      this.filterForm.get('toDate').setErrors(null);
    }

  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }

  }

  startDate() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + "01";
  }


  current_datetime() {
    let now = new Date();
    let year = "" + now.getFullYear();
    let month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    let day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    let hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    let minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    let second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }
    return year + '-' + month + "-" + day;
  }

  monthsList() {
    this.monthNameList = [
      { name: "Jan", value: "1" },
      { name: "Feb", value: "2" },
      { name: "Mar", value: "3" },
      { name: "Apr", value: "4" },
      { name: "May", value: "5" },
      { name: "Jun", value: "6" },
      { name: "Jul", value: "7" },
      { name: "Aug", value: "8" },
      { name: "Sep", value: "9" },
      { name: "Oct", value: "10" },
      { name: "Nov", value: "11" },
      { name: "Dec", value: "12" }
    ];
  }


  // static dateLessThan(fromDate: string, toDate: string, validatorField: { [key: string]: boolean }): ValidatorFn {
  //   return (c: AbstractControl): { [key: string]: boolean } | null => {
  //     const date1 = c.get(fromDate).value;
  //     const date2 = c.get(toDate).value;
  //     if ((date1 !== null && date2 !== null) && date1 > date2) {
  //       return validatorField;
  //     }
  //     return null;
  //   };
  // }
  truncatenotification(subject: string, maxLength: number): string {
    if (subject && subject.length > maxLength) {
      return subject.substring(0, maxLength) + '...';
    } else {
      return subject;
    }
  }

}
