import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ActivatedRoute, ParamMap } from '@angular/router';
import { element } from 'protractor';
import { BehaviorSubject } from 'rxjs';
import { CapmaignserviceService } from '../capmaignservice.service';

declare var $: any;

@Component({
  selector: 'app-registercampaign',
  templateUrl: './registercampaign.component.html',
  styleUrls: ['./registercampaign.component.css']
})
export class RegistercampaignComponent implements OnInit {

  public brandData: any;
  campaignCases: any = [];
  standardCampaign: any = [];
  specialCampaign: any = [];
  status: boolean = false;
  subUseCases: any = [];
  // subUseCases$  = new BehaviorSubject<any>("");
  // subUseCases = this.subUseCases$.asObservable();
  campaignForm: FormGroup;
  usecase: any = [];
  selectedSubCases: any = [];
  selectedVertical: any;
  isDisable: boolean = false;
  responseMessage = "";
  campaign_name: string;
  brand: any;
  brandId: any;
  brandVertical: any = [];
  brandName: any;
  campData: any = [];
  isDisabled: boolean = false;
  minSubUsecases: any;
  brandKey: string;
  errMessage: any = "";
  submitted:boolean= false;

  constructor(private campaignService: CapmaignserviceService, 
          public fb: FormBuilder, private route: ActivatedRoute ) {
   }

  ngOnInit() {

    this.campaignForm = this.fb.group({
      campaignName: ['', Validators.required],
      vertical: ['', Validators.required],
      description: ['', [Validators.required, Validators.minLength(40)]],
      messageFlow: ['', [Validators.required, Validators.minLength(40)]],
      optinMessage: ['', [Validators.required, Validators.minLength(20)]],
      optoutMessage: ['', [Validators.required, Validators.minLength(20)]],
      helpMessage: ['', [Validators.required, Validators.minLength(20)]],
      sample1: ['', [Validators.required, Validators.minLength(20)]],
      sample2: ['', [Validators.required, Validators.minLength(20)]],
      sample3: ['',[Validators.minLength(20)]],
      sample4: ['',[Validators.minLength(20)]],
      sample5: ['',[Validators.minLength(20)]],
      usecase: [],
      subUsecases: [],
      brandId: [],
      brandKey: [],
      rate: [],
      subscriberOptin: [true],
      subscriberOptout: [true],
      subscriberHelp: [true],
    });

    var navListItems = $('div.setup-panel div button'),
    allWells = $('.setup-content'),
    allNextBtn = $('.nextBtn');

    allWells.hide();

    navListItems.click(function (e) {
      e.preventDefault();
      var $target = $($(this).attr('href')),
      $item = $(this).closest('li');
        $item = $(this);

    if (!$item.hasClass('disabled')) {
        navListItems.removeClass('btn-success').addClass('btn-default');
        $item.addClass('btn-success');
        allWells.hide();
        $target.show();
        $target.find('input:eq(0)').focus();
    }
});

    allNextBtn.click(function () {
    var curStep = $(this).closest(".setup-content"),
        curStepBtn = curStep.attr("id"),
        nextStepWizard = $('div.setup-panel div button[href="#' + curStepBtn + '"]').parent().next().children("button"),
        curInputs = curStep.find("input[type='text'],input[type='url']"),
        isValid = true;

    $(".form-group").removeClass("has-error");
    for (var i = 0; i < curInputs.length; i++) {
        if (!curInputs[i].validity.valid) {
            isValid = false;
            $(curInputs[i]).closest(".form-group").addClass("has-error");
        }
    }

    if (isValid) nextStepWizard.removeAttr('disabled').trigger('click');
  });

  $('div.setup-panel div button.btn-success').trigger('click');

  
 
    this.campaignService.brandVertical().subscribe(res => {
      let tmp:any=[];
      Object.entries(res.data).forEach((ele:any)=>{
        let t=ele[1];
        t["name"]=ele[0];
        tmp.push(t);
      });
      this.brandVertical = tmp;
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.brandId = params.get('id');
      this.campaignService.getSinglebrand(this.brandId).subscribe(result => {
        this.brand = result.data[0];
        this.brandName = this.brand.company_name;
        this.brandKey = this.brand.brandId;
      });
    });
    

    this.campaignService.getCampaignCases().subscribe(res => {
      this.campaignCases = res.data;
      // let tmp:any=[];
      // Object.entries(res.data).forEach((ele:any)=>{
      //   let t=ele[1];
      //   t["isDisable"] = false;
      //   t["name"]=ele[0];
      //   tmp.push(t);
      // });
      // this.campaignCases = tmp;

      // console.log(this.campaignCases);
      this.campaignCases.forEach(element => {
          element.isDisable = false;  
          element.isDisabled;
      });

      this.campaignCases.forEach(element => {
        if(element.classification == "STANDARD"){
          this.standardCampaign.push(element);
        }
        if(element.classification == "SPECIAL"){
          this.specialCampaign.push(element);
        }
        if(element.validSubUsecase == "true"){
          element.isDisable = false;
          this.subUseCases.push(element);
        }
      });

      let temp:{[k:string]:any}=[];
      this.campaignCases.forEach(element => {
        if(element.validSubUsecase == "false"){
          let t=element;
          t["subUseCases"] = this.subUseCases;
          temp.push(t);
        }
        else
        {
          temp.push(element);
        }
      });
    })
  }

  onCampaign(){
    this.campData = {
      usecase: this.usecase,
      subUsecases: this.selectedSubCases,
      brandId: this.brandKey,
    }
    let price: number;
    this.campaignCases.find(el => {
      if(el.name == this.usecase){
          price = el.rate
      }
    });

    this.campaignForm.patchValue({
      usecase: this.usecase,
      subUsecases: this.selectedSubCases,
      brandKey: this.brandId,
      brandId: this.brandKey,
      rate: price
    });
  }

  registerCampaign(){
    this.submitted = true;
    if(this.campaignForm.invalid) {
			return false;
		} 
    else {
      this.campaignService.onRegisterCampaign(this.campaignForm.value).subscribe(res => {
        if(res.status == 201){
          this.responseMessage = res.message; 
          setTimeout(()=>{
            this.responseMessage= "";
            window.location.reload(); 
          }, 5000);
        }
        else{
          this.errMessage = res.message;
          setTimeout(()=>{
            this.errMessage= "";
          }, 5000);
        }
      });
    }
  }

  onVertical(e){
      this.selectedVertical = e.target.value;
  }

  changeStatus(e){
    this.selectedSubCases = [];
    this.isDisabled = false;
    this.isDisable = false;
    this.usecase = [];
    this.usecase = e.target.value;
    this.campaignCases.forEach(element => {
      element.status = false;
      if(this.usecase == element.name){
        if(element.minSubUsecases == 0){
          this.isDisabled = true;
        } 
      }
      if(e.target.value == element.name){
          if(element.maxSubUsecases > 0){
            element.status = true;
            this.minSubUsecases = element.minSubUsecases;
          }
          else{
            this.isDisabled = true;
          }
        }
    });
  }

  onSubCases(e){
    let mode = false;
    if(e.target.checked){
      this.selectedSubCases.push(e.target.value);
      let index = this.selectedSubCases.length - 1;
      this.campaignCases.forEach(element => {
          if(element.maxSubUsecases == this.selectedSubCases.length){
            this.isDisable = true;
            mode = true;
          }
      });
      if(mode){
        for(let i=0; i < this.selectedSubCases.length; i++){
          this.subUseCases.forEach(element => {
              element.isDisabled = true;
              this.subUseCases.find(el => {
                  if(el.name == this.selectedSubCases[i]){
                    el.isDisabled = false;
                  }
              });
          });
          // console.log(idx);
          //   if(idx){
          //     this.subUseCases["isDisabled"]=false;
          //   }
          //   else{
          //     this.subUseCases["isDisabled"]=true;
          //   }
        }
      }
      // this.subUseCases.forEach(element => {
      //     let i = 0;
      //     // element.isDisabled = false;
      //     if(mode && this.selectedSubCases[0] == element.name){
      //       element.isDisabled = false;
      //     }
      //     else if(mode && this.selectedSubCases[i] != element.name){
      //       element.isDisabled = true;
      //     }
      //     i++;
      // });

      if(this.minSubUsecases <= this.selectedSubCases.length){
        this.isDisabled = true;
      }
    }

    if(!e.target.checked){
      if(this.minSubUsecases >= this.selectedSubCases.length){
        this.isDisabled = false;
      }
      this.subUseCases.forEach(element => {
        element.isDisabled = false;
        // this.subUseCases.find(el => {
        //     if(el.name == this.selectedSubCases[i]){
        //       el.isDisabled = false;
        //     }
        // });
     });
      let i = this.selectedSubCases.findIndex(el => el == e.target.value);
      this.selectedSubCases.splice(i, 1);
    }
  }
}
