import { AfterViewInit, Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { Store } from '@ngrx/store';
import { BehaviorSubject } from 'rxjs';
import { CapmaignserviceService } from 'src/app/campaign/capmaignservice.service';
import { InboundService } from '../inbound.service';
import * as fromInbound from '../inbound.reducer';
import * as inboundAction from '../inbound.action';
import { ConnectionsService } from 'src/app/connections/connections.service';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { EditConnectionComponent } from 'src/app/connections/edit-connection/edit-connection.component';
import { Router } from '@angular/router';
import { UsermanagementService } from 'src/app/usermanagement/usermanagement.service';
// import { count } from 'node:console';
declare var $: any;

@Component({
  selector: 'app-addcart',
  templateUrl: './addcart.component.html',
  styleUrls: ['./addcart.component.css']
})
export class AddcartComponent implements OnInit, AfterViewInit {
  @ViewChild('didModal') didModal: ElementRef;
  cartItems$ = new BehaviorSubject<any>([]);
  carts = this.cartItems$.asObservable();
  cartItems: any = [];
  responseMessage = "";
  connectionLists: any;
  isDisable$ = new BehaviorSubject<Boolean>(false);
  isDisables = this.isDisable$.asObservable();
  iddid: any;
  connectionKey$ = new BehaviorSubject<any>("");
  connection = this.connectionKey$.asObservable();
  connectionValue = "";
  inboundKey$ = new BehaviorSubject<any>("");
  inbound = this.inboundKey$.asObservable();
  inboundValue = "";
  outboundKey$ = new BehaviorSubject("");
  outbound = this.outboundKey$.asObservable();
  outboundValue = "";
  campaign$ = new BehaviorSubject<string>("");
  campaign = this.campaign$.asObservable();
  campaignValue = "";
  errMessage = "";
  isLoaded: Boolean = false;
  isSubConnection: Boolean = false;
  selectedConnection: any;
  selectedDid: any = [];
  isSelected: Boolean = false;
  iselectAll: boolean;
  singleConnection: any;
  connectionKeyVal: any;
  selectedDIDCount: any;
  featureServiceData: any;
  isDisabledServiceStatus: boolean;
  serviceMessage: any = "Did Buy service has been suspended. More information please contact support";
  filteredItem: any;
  iduser: any;
  MatchedDID: any = [];
  modalChoice: boolean = false;
  modalClosedPromise: Promise<void>;
  didmodalClosedPromise: Promise<void>;
  countMatchDId: any;
  firstModal: boolean;
  closebuttonCheck: boolean;
  didMessage: any;
  nonMatchingNo: any = [];
  idtariff: any;
 
  constructor(private campService: CapmaignserviceService,
    private data: InboundService,
    private store: Store<fromInbound.inboundState>,
    private connectionService: ConnectionsService,
    private modalService: NgbModal,
    public userService: UsermanagementService,
    public router: Router) { }

  ngAfterViewInit(): void {
    this.selectedDIDCount = '';
    this.campService.onGetCampaign().subscribe(res => {
      if (res.status == 200) {
        this.campaign$.next(res.data);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });

    this.data.getconnection().subscribe(res => {
      this.connectionLists = res.data;
      this.connectionKey$.next(this.connectionLists);
    });
    this.data.singleConnections().subscribe(res => {
      this.singleConnection = res.data;
      this.filteredItem = this.singleConnection.filter(item => item.iduser === this.iduser).map(item => item.connection_key);
      this.connectionKeyVal = this.singleConnection[0].connection_key;
      this.connectionValue = this.connectionKeyVal;
      let connection = this.connectionLists.filter(item => {
        if (item.connection_key == this.connectionValue) {
          return item.idendpoint
        }
      });

      this.connectionService.getInbound(this.singleConnection[0].idendpoint).subscribe(res => {
        this.singleConnection[0].name = connection[0].name;
        this.inboundValue = res.data[0].inbound_key;
      });
      this.connectionService.getOutbound(this.singleConnection[0].idendpoint).subscribe(res => {
        this.singleConnection[0].name = connection[0].name;
        this.outboundValue = res.data[0].outbound_key;
      });
      this.campaignValue = '';
    });



    this.data.getCart().subscribe(response => {
      this.cartItems = response.data;
      $('#basic-datatables').DataTable().clear();
      $('#basic-datatables').DataTable().destroy();
      $.getScript('./assets/table.js');
      this.isLoaded = true;
      this.cartItems$.next(this.cartItems);
      if (this.cartItems.length > 0) {
        this.cartItems.forEach(item => {
          item.isChecked = false;
        });
        this.isDisable$.next(true);
      }
    });
  }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.iduser = session.iduser;
    this.idtariff = session.idtariff;
    this.selectedDIDCount = '';
    this.userService.getfeatureServiceStatus().subscribe(res => {
      this.featureServiceData = res.data.find(x => x.fs_id == '5');
      if (this.featureServiceData !== undefined && this.featureServiceData.as_status == 1) {
        this.isDisabledServiceStatus = false;

      } else {
        this.isDisabledServiceStatus = true;
        this.showMsg();
      }

    });
  }

  showConnection(event: any) {
    if (event.target.checked) {
      let mref = this.modalService.open(EditConnectionComponent, {
        ariaLabelledBy: 'modal-basic-title',
      });
      mref.componentInstance.connectionKey = this.connectionValue;
      mref.result.then((result) => {
        if (result.status) {
          event.target.checked = false;
        }
      }, (reason) => {
        if (reason.status) {
          event.target.checked = false;
        }
      });
    }
    else {
      this.modalService.dismissAll();
    }
  }

  onConnectionKey(e: any) {
    this.connectionValue = e.target.value;
    this.isSubConnection = true;
    let connection = this.connectionLists.filter(item => {
      if (item.connection_key == this.connectionValue) {
        return item.idendpoint
      }
    });

    this.connectionService.getInbound(connection[0].idendpoint).subscribe(res => {
      res.data[0].name = connection[0].name;
      this.inboundValue = res.data[0].inbound_key;
      this.inboundKey$.next(res.data);
    });
    this.connectionService.getOutbound(connection[0].idendpoint).subscribe(res => {
      res.data[0].name = connection[0].name;
      this.outboundValue = res.data[0].outbound_key;
      this.outboundKey$.next(res.data);
    });
    this.campaignValue = '';
  }
  // onInboundKey(e) {
  //   this.inboundValue = e.target.value;
  // }
  // onOutboundKey(e) {
  //   this.outboundValue = e.target.value;
  // }
  // onCampaignKey(e) {
  //   this.campaignValue = e.target.value;
  // }


  /**
  * To select a single DID
  */
  onSelectDid(e: any, did: any, idx: any) {
    if (e.target.checked) {
      this.selectedDid.push(did);
    }
    else {
      //let idx = this.selectedDid.indexOf(did.did);
      //this.selectedDid.splice(idx, 1);
      this.selectedDid.forEach((value, index) => {
        if (value.id_cart == did.id_cart) this.selectedDid.splice(index, 1);
      });
    }
    if (this.selectedDid.length == this.cartItems.length) {
      this.iselectAll = true;
    }
    else {
      this.iselectAll = false;
    }
    if (this.selectedDid.length > 0) {
      this.isSelected = true;
    }
    else {
      this.isSelected = false;
    }
    this.selectedDIDCount = this.selectedDid.length;
  }

  /**
   * To select the all DIDs
   */
  onSelectAll(event: any) {
    if (event.target.checked) {
      this.isSelected = true;
      // this.selectedDid = this.cartItems;
      this.selectedDid = [];
      this.cartItems.forEach(item => {
        item.isChecked = true;
        this.selectedDid.push(item);
      });
    }
    else {
      this.selectedDid = [];
      this.isSelected = false;
      this.cartItems.forEach(item => {
        item.isChecked = false;
      })
    }
    if (this.selectedDid.length == this.cartItems.length) {
      this.iselectAll = true;
    }
    else {
      this.iselectAll = false;
    }
    this.selectedDIDCount = this.selectedDid.length;
  }

  closebutton() {
    this.closebuttonCheck = false;
    $('#didModal').modal('hide');
    this.didModal.nativeElement.click();
  }
  // buy one by one
  buyDID(): any {
    let didNumbers: any = []
    this.selectedDid.forEach((ele: any) => {
      didNumbers.push(ele.did)
    })
    let filteredData: any;
    if (this.nonMatchingNo.length > 0) {
      filteredData = this.selectedDid.filter((item: any) => this.nonMatchingNo.includes(item.did));
    } else {
      filteredData = this.selectedDid
    }
    let __GOpayload: any = {
      name: this.generateUniqueOrder(),
      total_dids: (this.nonMatchingNo.length) ? this.nonMatchingNo.length : didNumbers.length,
      numbers: (this.nonMatchingNo.length) ? this.nonMatchingNo : didNumbers.join(),
      routing: this.connectionValue,
      in_routing: this.inboundValue,
      out_routing: this.outboundValue,
      campaign: this.campaignValue,
      }
    let PI: number = 0,
      DIDsL: number = (this.nonMatchingNo.length) ? this.nonMatchingNo.length : didNumbers.length
    this.data.CreateGroupOrder(__GOpayload).subscribe(res => {
      let id_grouporder: number = res.data.id_grouporder
      let ResAll: any = ""
      let ErrAll: any = ""
      let P = new Promise((resolve: any, reject: any) => {

        filteredData.forEach(element => {
          let dids = {
            DID: element.did,
            Connection: this.connectionValue,
            InboundVoice: this.inboundValue,
            OutboundVoice: this.outboundValue,
            CampaignId: this.campaignValue,
            id_grouporder: id_grouporder,
            via_panel: 1,
            iduser: this.iduser,
            idtariff: this.idtariff,

          };

          this.data.onBuyDID(JSON.stringify(dids)).subscribe(response => {

            if (response.error_code == '1') {
              ResAll += response.message + "\n"
            }
            else {
              ErrAll += response.message + "\n"
            }
            PI++
            if (PI == DIDsL) {
              resolve(1)
            }
          }, err => {
            ErrAll += err.message + "\n"
            PI++
            if (PI == DIDsL) {
              resolve(1)
            }
          });
        });

      })

      P.then((res: any) => {
        if (res == 1) {
          this.responseMessage = ResAll
          this.errMessage = ErrAll

          setTimeout(() => {
            window.location.reload()
          }, 2000)
        }
      }).catch((err: any) => {
        this.responseMessage = ResAll
        this.errMessage = ErrAll
      })
    });
  }

  //buy bulk order
  CreateGroupOrder(): any {
    let GOpayload: any = {
      name: this.generateUniqueOrder(),
      total_dids: this.nonMatchingNo.length,
      numbers: this.nonMatchingNo.join(),
      routing: this.connectionValue,
      in_routing: this.inboundValue,
      out_routing: this.outboundValue,
      campaign: this.campaignValue,
    }
    this.data.CreateGroupOrder(GOpayload).subscribe(res => {
      if (res.error == 0) {
        let id_grouporder: number = res.data.id_grouporder
        //maintain DID buy process from now.

        this.data.BuyAllDIDs(JSON.stringify({
          NonDID: this.MatchedDID,
          DID: this.nonMatchingNo,
          Connection: this.connectionValue,
          InboundVoice: this.inboundValue,
          OutboundVoice: this.outboundValue,
          CampaignId: this.campaignValue,
          name: this.generateUniqueOrder(),
          reOrder: 1,
          id_grouporder: id_grouporder
        })).subscribe(res => {
          if (res.status == 200) {
            this.responseMessage = res.message
            this.router.navigate(["/inbound/view-order/" + id_grouporder]).then(() => {
              location.reload()
            });
          }
          else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        }, err => {
          console.log("err::", err)
        })
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      console.log("err::", err)
    });
  }
  /**
   * To purchase the selected DIDs from cart
   */

  onBuyDID(): any {
    if (confirm("Please Confirm")) {
      if (this.cartItems.length > 0) {

        let PI: number = 0,
          DIDsL: number = this.selectedDid.length

        let didNumbers: any = []
        this.selectedDid.forEach((ele: any) => {
          didNumbers.push(ele.did)
        })

        if (DIDsL <= 10) {
          this.buyDID();
        }
        else {
          this.data.checkDidOrder(didNumbers).subscribe(response => {
            //maitain condition for matched or unmatched DID's
            this.modalClosedPromise = new Promise<void>((resolve) => {
              $('#renewalModalCenter').on('hidden.bs.modal', () => {
                resolve();
              });
            });

            this.didmodalClosedPromise = new Promise<void>((resolve) => {
              $('#didModal').on('hidden.bs.modal', () => {
                resolve();
              });
            });
            if (response.status == 409) {
              this.MatchedDID = response.data.matchNo;
              this.nonMatchingNo = response.data.nonMatchingNo;
              this.didMessage = response.message;
              $('#renewalModalCenter').modal('show');
              this.modalClosedPromise.then(() => {
                if (this.firstModal == true) {
                  if (this.MatchedDID.length > 0 || this.nonMatchingNo.length > 0) {
                    this.didmodalClosedPromise.then(() => {
                      if (this.closebuttonCheck == true) {
                        if (this.nonMatchingNo.length > 10) {
                          this.CreateGroupOrder();
                        } else {
                          this.buyDID();
                        }
                      }
                      else {
                        this.errMessage = "You have Cancelled your order";
                        window.location.reload()
                        setTimeout(() => {
                          this.errMessage = "";
                        }, 5000);
                      }
                    })
                  }
                } else {
                  this.errMessage = "You have Cancelled your order";
                  window.location.reload()
                  setTimeout(() => {
                    this.errMessage = "";
                  }, 5000);
                }
              })
            }
            else {
              this.MatchedDID = response.data.matchNo;
              this.nonMatchingNo = response.data.nonMatchingNo;
              this.didMessage = response.message;
              $('#renewalModalCenter').modal('show');
              this.modalClosedPromise.then(() => {
                if (this.firstModal == true) {
                  if (this.MatchedDID.length > 0 || this.nonMatchingNo.length > 0) {
                    this.didmodalClosedPromise.then(() => {
                      if (this.closebuttonCheck == true) {
                        if (this.nonMatchingNo.length > 10) {
                          this.CreateGroupOrder();
                        } else {
                          this.buyDID();
                        }
                      }
                      else {
                        this.errMessage = "You have Cancelled your order";
                        window.location.reload()
                        setTimeout(() => {
                          this.errMessage = "";
                        }, 5000);
                      }
                    })
                  }
                }
                else {
                  this.errMessage = "You have Cancelled your order";
                  window.location.reload()
                  setTimeout(() => {
                    this.errMessage = "";
                  }, 5000);
                }
              })
            }

          })
        }
      }
      else {
        this.errMessage = "Your Cart is Empty";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }
    else {
      return
    }
  }

  finalOk(): void {
    this.closebuttonCheck = true;
    $('#didModal').modal('hide');
  }

  handleOkClick(): void {
    $('#renewalModalCenter').modal('hide');
    this.firstModal = true;
    if (this.MatchedDID.length > 0 || this.nonMatchingNo.length > 0) {
      $('#didModal').modal('show');
    }
  }

  handleCancelClick(): void {
    this.firstModal = false
    $('#renewalModalCenter').modal('hide');

  }

  /**
   * To generate the unique order ID
   */
  generateUniqueOrder(): any {
    let iUD: any = "SOD" + String(new Date().getTime())
    return iUD
    // var ts: any = String(new Date().getTime()),
    //   i: any = 0,
    //   out: any = '';

    // for (i = 0; i < ts.length; i += 2) {
    //   out += Number(ts.substr(i, 2)).toString(36);
    // }
    // return ('ORD__' + out);
  }


  onCartDelete(did, idx) {
    if (confirm("Are you sure you want to delete item from cart?")) {
      this.data.onDeleteCart(did.id_cart).subscribe(response => {
        if (response.status == 201) {
          this.cartItems.splice(idx, 1);
          this.store.dispatch(new inboundAction.Remove(did));
          if (this.cartItems === undefined || this.cartItems.length == 0) {
            this.isDisable$.next(false);
          }
          this.ngAfterViewInit();
          this.iselectAll = false;
          this.selectedDid = [];
          this.isSelected = false;
          this.responseMessage = response.message;
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, error => {
        this.errMessage = error.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
    else {
      return
    }
  }

  deleteItems() {
    if (confirm("Are you sure you want to delete selected items")) {
      this.data.onDeleteItems(this.selectedDid).subscribe(response => {
        if (response.status == 201) {
          this.cartItems = this.cartItems.filter((val) => {
            return this.selectedDid.indexOf(val) == -1;
          });
          this.store.dispatch(new inboundAction.Set(this.cartItems));
          this.cartItems$.next(this.cartItems);
          if (this.cartItems.length == 0) {
            this.isDisable$.next(false);
          }
          //this.ngOnInit();
          window.location.reload();
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
    else {
      return
    }
  }

  onClearCart() {
    if (confirm("Are you sure you want to clear existing items from cart?")) {
      this.data.onClearCart().subscribe(response => {
        if (response.status == 201) {
          this.cartItems = [];
          $('#basic-datatables').DataTable().clear();
          $('#basic-datatables').DataTable().destroy();
          this.store.dispatch(new inboundAction.Reset([]));
          this.isDisable$.next(false);
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
  }
  showMsg() {
    this.errMessage = this.serviceMessage;
    setTimeout(() => {
      this.errMessage = "";
    }, 5000);
  }
}
