import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { Router } from '@angular/router';
import { HttpClient } from '@angular/common/http';
import { NotificationService } from '../notification.service';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { AngularEditorConfig } from '@kolkov/angular-editor';
import { IDropdownSettings } from 'ng-multiselect-dropdown';
declare var $: any;

@Component({
  selector: 'app-composemail',
  templateUrl: './composemail.component.html',
  styleUrls: ['./composemail.component.css'],
})
export class ComposemailComponent implements OnInit {
  @ViewChild('fileInput') fileInput: ElementRef;
  @ViewChild('composemodal') composemodal: ElementRef;
  @ViewChild("template") template: ElementRef;
  composeEmail: any;
  headings: any;
  backbtn: any;
  composeMailtext: any;
  htmlContent = '';
  inputfields: any;
  inputfields1: any;
  inputfields2: any;
  inputfields3: any;
  inputfields4: any;
  inputfields5: any;
  public composeEmailForm: FormGroup;
  submitted: boolean;
  dropdownSettings: IDropdownSettings = {};
  closeDropdownSelection = true;
  Status: any = [];
  Category: any = [];
  Email: any = [];
  userlist: any = [];
  responseMessage = '';
  errMessage = '';
  dropdownList = [];
  selectedItems = [];
  selectedItems1 = [];
  cc: boolean = false;
  bcc: boolean = false;
  selectedFile: File;
  selectedFiles: File[] = [];
  nec: any;
  cs: any;
  subscriberEmail: any = [];
  EmailData: any;
  isLoading: boolean[] = [];
  suspendedUserList: any = [];
  public filecount = 0;
  // isClassToggled: boolean = false;

  config: AngularEditorConfig = {
    editable: true,
    spellcheck: true,
    height: '13rem',
    minHeight: '5rem',
    placeholder: 'Enter text here...',
    translate: 'no',
    defaultParagraphSeparator: 'p',
    defaultFontName: 'Arial',
    toolbarHiddenButtons: [['bold'], ['insertImage', 'insertVideo']],
    customClasses: [
      {
        name: 'quote',
        class: 'quote',
      },
      {
        name: 'redText',
        class: 'redText',
      },
      {
        name: 'titleText',
        class: 'titleText',
        tag: 'h1',
      },
    ],
  };


  constructor(
    public router: Router,
    private http: HttpClient,
    public data: NotificationService,
    private fb: FormBuilder
  ) { }

  ngOnInit(): void {
    this.composeEmailForm = this.fb.group({
      // from: [
      //   '',
      //   [
      //     Validators.required,
      //     Validators.pattern(
      //       '^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,4}$'
      //     ),
      //   ],
      // ],
      from: ['notifications@signalmash.com'],
      status: ['', Validators.required],
      to: ['', Validators.required],
      cc: ['', Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(,[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")],
      bcc: ['', Validators.pattern("^[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10}(,[A-Za-z0-9._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,10})*$")],
      categories: ['', Validators.required],
      subject: ['', [Validators.required, Validators.pattern(/^[^\s].*$/)]],
      body: ['', Validators.required],
    });

    this.data.get_systemnotification().subscribe((result) => {
      this.composeEmail = result[1].composeMail;
      this.headings = this.composeEmail[0].heading;
      this.backbtn = this.composeEmail[0].back;
      this.inputfields = this.composeEmail[0].inputfield;
      this.inputfields1 = this.composeEmail[0].inputfield1;
      this.inputfields2 = this.composeEmail[0].inputfield2;
      this.inputfields3 = this.composeEmail[0].inputfield3;
      this.inputfields4 = this.composeEmail[0].inputfield4;
      this.inputfields5 = this.composeEmail[0].inputfield5;
    });

    this.data.getSuspendedService().subscribe((res) => {
      this.suspendedUserList = res.data;
    });

    this.dropdownSettings = {
      singleSelection: false,
      idField: 'idaccount1',
      textField: 'san',
      selectAllText: 'Select All',
      unSelectAllText: 'UnSelect All',
      itemsShowLimit: 3,
      searchPlaceholderText: 'Search SAN',
      allowSearchFilter: true,
      maxHeight: 130,
    };

    this.getStatus();
    this.getCategory();
    this.getSubscriberEmail();
  }

  // onItemSelect(item: any) {
  //   //console.log(item);
  // }
  onSelectAll(items: any) {
    this.selectedItems = items;
  }

  getStatus() {
    this.data.get_status().subscribe((res) => {
      if (res.status == 201) {
        this.Status = res.data;
        //this.Status.sort((a, b) => a.title.localeCompare(b.title));
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  onHtmlContentChange(html: string) {
    const regex = /<img[^>]+>/g;
    const text = html.replace(regex, '');
    const formattedText = text.replace(/<br\s*\/?>/gi, '\n').trim();

    if (html !== text) {
      this.composeEmailForm.controls['body'].setValue(formattedText);
      this.errMessage = "Please Attach Images/Files Through Attachments!";
      setTimeout(() => {
        this.errMessage = '';
      }, 5000);
    }

    const bodyContent = this.bodycontent(formattedText);
    if (/^\s+$/.test(bodyContent)) {
      this.composeEmailForm
        .get('body')
        .setErrors({ bodyE: 'Body is invalid' });
    } else if (!formattedText.trim()) {
      this.composeEmailForm
        .get('body')
        .setErrors({ bodyE: 'Body is required' });
    } else {
      this.composeEmailForm.get('body').setErrors(null);
    }
  }

  getCategory() {
    this.data.get_category().subscribe((res) => {
      if (res.status == 201) {
        this.Category = res.data;
        this.Category.sort((a, b) => a.title.localeCompare(b.title));
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  getCAtegoryEmail(id: any) {
    this.nec = id;
  }
  getStatusEmail(id: any) {
    this.cs = id;
  }

  getSubscriberEmail() {
    this.data.subscribe_email().subscribe((res) => {
      if (res.status == 201) {
        this.subscriberEmail = res.data;
        this.responseMessage = '';
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = "";
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  getCustomerEmail() {
    if (this.cs && this.nec) {
      this.Email = [];
      this.EmailData = [];
      this.data.getUsers('main').subscribe((res) => {
        this.userlist = res.data[0];
        this.selectedItems = [];
        // All Customers
        if (this.cs == 1) {
          this.Email = this.userlist.map((element) => ({
            email: element.email,
            san: element.san,
            idaccount: element.idaccount,
            iduser: element.iduser,
            username: element.user_name,
          }));
        }
        // Active customers
        if (this.cs == 2) {
          this.Email = this.userlist
            .filter((element) => element.is_deleted == 0)
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // Non-Active Customer
        if (this.cs == 3) {
          this.Email = this.userlist
            .filter((element) => element.is_deleted == 2)
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // KYC Not completed
        if (this.cs == 4) {
          this.Email = this.userlist
            .filter(
              (element) =>
                element.kyc_verify_status == 0 && element.newUser_status == 1
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // KYC Completed
        if (this.cs == 5) {
          this.Email = this.userlist
            .filter(
              (element) =>
                element.kyc_verify_status == 1 && element.newUser_status == 1
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // kYC Pending
        if (this.cs == 6) {
          this.Email = this.userlist
            .filter(
              (element) =>
                element.kyc_verify_status == 2 && element.newUser_status == 1
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // KYC Reject
        if (this.cs == 7) {
          this.Email = this.userlist
            .filter(
              (element) =>
                (element.kyc_verify_status == 3 || element.kyc_verify_status == 4) && element.newUser_status == 1
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // Federal DNC Not completed
        if (this.cs == 8) {
          this.Email = this.userlist
            .filter(
              (element) =>
                element.federal_status == 0 && element.newUser_status == 1
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // Federal DNC Completed
        if (this.cs == 9) {
          this.Email = this.userlist
            .filter(
              (element) =>
                element.federal_status == 1 && element.newUser_status == 1
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // Federal DNC pending
        if (this.cs == 10) {
          this.Email = this.userlist
            .filter(
              (element) =>
                element.federal_status == 2 && element.newUser_status == 1
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // Federal DNC Reject
        if (this.cs == 11) {
          this.Email = this.userlist
            .filter(
              (element) =>
                element.newUser_status == 1 &&
                (element.federal_status == 3 || element.federal_status == 4)
            )
            .map((element) => ({
              email: element.email,
              san: element.san,
              idaccount: element.idaccount,
              iduser: element.iduser,
              username: element.user_name,
            }));
        }
        // service suspended
        if (this.cs == 12) {
          this.suspendedUserList.forEach((suspendedUser) => {
            const suspendSame = this.userlist.find(
              (user) => user.idaccount === suspendedUser.idaccount
            );
            if (suspendSame) {
              this.Email.push({
                email: suspendSame.email,
                san: suspendSame.san,
                idaccount: suspendSame.idaccount,
                iduser: suspendSame.iduser,
                username: suspendSame.user_name,
              });
            }
          });
        }
        let EmailData = [];
        this.subscriberEmail.forEach((subscriber) => {
          this.Email.forEach((emailUser) => {
            if (
              subscriber.idaccount === emailUser.idaccount &&
              subscriber.iduser === emailUser.iduser
            ) {
              if (this.nec === subscriber.nec_id.toString()) {
                EmailData.push({
                  email: subscriber.email,
                  san: emailUser.san,
                  idaccount1: subscriber.idaccount,
                  iduser: subscriber.iduser,
                });
              }
            }
          });
        });
        this.EmailData = EmailData;
        this.EmailData.sort((a, b) => {
          return a.iduser - b.iduser;
        });
      });
    }
  }

  selectFile() {
    this.fileInput.nativeElement.value = '';
    this.fileInput.nativeElement.click();
  }

  onFilePicked(event: Event) {
    const inputElement = event.target as HTMLInputElement;
    const fileList = inputElement.files;

    if (fileList && fileList.length > 0) {
      const maxSizePerFile = 25 * 1024 * 1024;
      for (let i = 0; i < fileList.length; i++) {
        const file: File = fileList[i];
        const fileSize = file.size;
        if (fileSize > maxSizePerFile) {
          this.errMessage = 'Individual file size limit exceeded 25 MB';
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
          inputElement.value = '';
          return;
        }
        const allowedTypes = ['image/jpeg', 'image/png', 'application/pdf', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'video/mp4', 'text/plain','video/quicktime', 'application/vnd.ms-powerpoint', 'application/vnd.visio', 'application/rtf', 'image/tiff', 'image/gif', 'application/zip', 'application/x-zip-compressed', 'application/vnd.ms-excel', 'text/csv', 'application/vnd.oasis.opendocument.text', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'image/webp','audio/mpeg', 'audio/mp3', 'audio/wav', 'audio/weba', 'image/bmp', 'audio/qcelp', 'audio/QCELP', 'audio/x-wav', 'audio/midi', 'audio/mid', 'audio/amr', 'audio/aac', 'audio/aacp','audio/x-mp3','text/x-vcard', 'video/h263', 'video/h264', 'video/jpeg', 'video/3gpp', 'video/3gpp2', 'video/mp4v-es', 'video/mp4-es', 'application/gzip','application/x-gzip','audio/vnd.dlna.adts','image/svg+xml','image/gif; version="87a"','image/gif; version="89a"','image/avif','image/dib','image/x-icon','image/pjpeg','video/mpeg','video/webm','video/x-msvideo','video/x-flv','video/m1v','video/mpg','video/x-ms-wmv','audio/webm','audio/3gpp','audio/flac','audio/m2a','audio/x-m4a','audio/m4b','audio/x-ms-wma',"audio/ogg",'text/css','text/rtf','text/html','text/javascript','application/x-bzip2','application/calendar','application/javascript','application/json','application/xml','application/x-msdownload','application/octet-stream','application/x-freearc','application/java-archive','application/vnd.openxmlformats-officedocument.presentationml.presentation'];
        if (!allowedTypes.includes(file.type)) {
          this.errMessage = "Invalid file type!";
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
          inputElement.value = '';
          return;
        }
        this.isLoading.push(false);
        const currentIndex = this.selectedFiles.length;
        this.isLoading[currentIndex] = true;
        this.selectedFiles.push(file);
        setTimeout(() => {
          this.isLoading[currentIndex] = false;
        }, 2000);
      }
    }
    this.filecount += 1;
  }

  downloadFile(file: File) {
    if (file) {
      const a = document.createElement('a');
      a.href = URL.createObjectURL(file);
      a.download = file.name;
      a.click();
      let count = File.length

    }
  }

  removeFile(fileToRemove: File, index: number): void {
    this.selectedFiles.splice(index, 1);
    this.isLoading.splice(index, 1);
  }

  bodycontent(htmlString: string): string {
    const div = document.createElement("div");
    div.innerHTML = htmlString;
    return div.textContent || div.innerText || "";
  }

  onSubmit() {
    this.submitted = true;
    if (this.composeEmailForm.invalid) {
      return false;
    } else {
      let EmailData = [];
      this.selectedItems.forEach((subscriber) => {
        this.EmailData.forEach((emailUser) => {
          if (
            subscriber.idaccount1 === emailUser.idaccount1
          ) {
            EmailData.push({
              email: emailUser.email,
              idaccount: emailUser.idaccount1,
              iduser: emailUser.iduser,
            });
          }
        });
      });
      this.selectedItems1 = EmailData.reduce((result, currentItem) => {
        const emails = currentItem.email.split(';');
        result.push(
          ...emails.map((email) => ({
            email,
            idaccount: currentItem.idaccount,
            iduser: currentItem.iduser
          }))
        );
        return result;
      }, []);
      let payLoad: any = JSON.stringify({
        data: this.composeEmailForm.value,
        newdata: this.selectedItems1,
      });
      this.data.submitNotify(payLoad, this.selectedFiles).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.resetform();
          setTimeout(() => {
            this.responseMessage = '';
          }, 5000);
          const compModal = document.getElementById('composemodal');
          $(compModal).modal({ backdrop: 'static', keyboard: false });
          $(compModal).modal('show');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
    }
  }

  resetform() {
    this.submitted = false;
    this.selectedFiles = [];
    this.Email = [];
    this.EmailData = [];
    this.nec = '';
    this.cs = '';
    this.composeEmailForm.reset();
    this.composeEmailForm.get('status').setValue('');
    this.composeEmailForm.get('categories').setValue('');
    this.composeEmailForm.get('cc').setValue('');
    this.composeEmailForm.get('bcc').setValue('');
    this.composeEmailForm.get('from').setValue('notifications@signalmash.com');
  }

  onclickcc() {
    this.cc = !this.cc;
  }
  onclickbcc() {
    this.bcc = !this.bcc;
  }
  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength
      ? subject.substring(0, maxLength) + '..'
      : subject;
  }

  ModalClose() {
    const modal = document.getElementById('composemodal');
    if (modal) {
      $(modal).modal('hide');
      $('.modal-backdrop').remove();
    }
  }

  // addVariable(event: any) {
  //   const sel = window.getSelection();
  //   const range = sel.getRangeAt(0);
  //   const editor = document.querySelector('.angular-editor-textarea');

  //   const editorNode = editor as HTMLElement;
  //   if (!editorNode.contains(range.startContainer)) {
  //     return;
  //   }

  //   const newNode = document.createTextNode(event.target.value.toUpperCase());

  //   if (range.collapsed) {
  //     range.insertNode(newNode);
  //   } else {
  //     range.deleteContents();
  //     range.insertNode(newNode);
  //   }

  //   this.htmlContent = editor.innerHTML;

  //   const newRange = document.createRange();
  //   newRange.setStartAfter(newNode);
  //   newRange.collapse(true);
  //   sel.removeAllRanges();
  //   sel.addRange(newRange);
  // }

  addVariable(event: any) {
    const sel = window.getSelection();
    const range = sel.getRangeAt(0);
    const editor = document.querySelector('.angular-editor-textarea');

    const editorNode = editor as HTMLElement;
    if (!editorNode.contains(range.startContainer)) {
      return;
    }

    const variable = (event.target as HTMLButtonElement).getAttribute('value');
    const textNode = document.createTextNode(variable);

    if (range.collapsed) {
      range.insertNode(textNode);
    } else {
      range.deleteContents();
      range.insertNode(textNode);
    }

    this.htmlContent = editorNode.innerHTML;

    const newRange = document.createRange();

    range.setStartAfter(textNode);
    range.setEndAfter(textNode);
    newRange.collapse(true);
    sel.removeAllRanges();
    sel.addRange(newRange);
  }

  ngOnDestroy() {
    this.composemodal.nativeElement.click();
  }


  // toggleClass() {
  // this.isClassToggled = !this.isClassToggled;
  // }
}
