import { Component, OnInit, ElementRef, ViewChild} from '@angular/core';
import { Router } from '@angular/router';
import { HttpClient } from '@angular/common/http'
import {NotificationService} from '../notification.service'
import { DomSanitizer, SafeHtml } from '@angular/platform-browser';
import { FormBuilder } from '@angular/forms';
declare var $: any;

@Component({
  selector: 'app-email-notification',
  templateUrl: './email-notification.component.html',
  styleUrls: ['./email-notification.component.css']
})
export class EmailNotificationComponent implements OnInit {
  @ViewChild('closeModal') closeModal: ElementRef;
  systemtable: any;
  emailheading: any;
  btndata: any;
  tabledata: any;
  notifitedcustomer: any;
  modalheader: any;
  modaltables: any;
  userType: any;
  selectedAwaitCount: any;
  tabledatacustomer: any;
  emailnotify: any = [];
  Customernotify: any = [];
  CustomerList: any = [];
  responseMessage: any = "";
  errMessage: any = "";
  userlist: any = [];

  constructor(private sanitizer: DomSanitizer, public router: Router, private http: HttpClient, public data: NotificationService,private fb: FormBuilder) { }

  ngOnInit(): void {

    this.selectedAwaitCount = '';
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.data.get_systemnotification().subscribe((result) =>{
      this.systemtable = result[1].emailnotification
      this.emailheading = this.systemtable[0].heading
      this.btndata = this.systemtable[0].button
      this.tabledata = this.systemtable[0].tableheaders
      this.notifitedcustomer = result[1].notifiedcustomermodal
      this.modalheader = this.notifitedcustomer[0].heading
      this.modaltables = this.notifitedcustomer[0].modaltable
    })
    this.emailnotifydata();
    this.Customernotifydata();
    $.getScript('./assets/tollfree.js');
    $.getScript('./assets/table.js'); 
  }



  emailnotifydata() {
    this.data.getemail_notification().subscribe((res) => {
      if (res.status == 201) {
        this.emailnotify = this.groupData(res.data);
        this.responseMessage = res.message;
        $('#basic-datatables3').dataTable().fnClearTable();
        $('#basic-datatables3').dataTable().fnDraw();
        $('#basic-datatables3').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  groupData(data) {
    const uniqueData = Object.values(data.reduce((grouped, item) => {
      const groupKey = item.key; 
        if (!grouped[groupKey]) {
        grouped[groupKey] = item;
      }
      return grouped;
    }, {}));
    return uniqueData;
  }

  Customernotifydata() {
    this.data.getemail_notification().subscribe((res) => {
      if (res.status == 201) {
        this.Customernotify = res.data;
        this.responseMessage = res.message;
        $('#basic-datatables1').dataTable().fnClearTable();
        $('#basic-datatables1').dataTable().fnDraw();
        $('#basic-datatables1').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        setTimeout(() => {
          this.responseMessage = '';
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  NotifyCustomerLIst(key: any) {
    $('#basic-datatables').dataTable().fnDestroy();
    $.getScript('./assets/table.js'); 
    this.CustomerList =[]
      this.data.NotifyCustomerLIst(key).subscribe((res) => {
        if (res.status == 201) {
          this.CustomerList = res.data; 
          this.responseMessage =res.message;
          $('#basic-datatables').dataTable().fnClearTable();
          $('#basic-datatables').dataTable().fnDraw();
          $('#basic-datatables').dataTable().fnDestroy();
          $.getScript('./assets/table.js'); 

          setTimeout(() => {
            this.responseMessage = '';
          }, 5000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      });
  }

  truncateHTMLDescription(description: string): SafeHtml {
    const maxLength = 20;
    const truncatedText = (new DOMParser().parseFromString(description, 'text/html')).body.textContent || '';
    const truncatedDescription = truncatedText.length > maxLength ? truncatedText.substring(0, maxLength) + '..' : truncatedText;
    return this.sanitizer.bypassSecurityTrustHtml(truncatedDescription);
  }

  truncateSubject(subject: string, maxLength: number): string {
    return subject.length > maxLength ? subject.substring(0, maxLength) + '..' : subject;
  }

  ngOnDestroy() {
    this.closeModal.nativeElement.click();
  }
  
}
