import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ObsiptrunkingService } from '../obsiptrunking.service';
import { Router } from '@angular/router';
import { HttpClient } from '@angular/common/http';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { IDropdownSettings } from 'ng-multiselect-dropdown';

declare var $: any;
@Component({
  selector: 'app-siptrunkingprofile',
  templateUrl: './siptrunkingprofile.component.html',
  styleUrls: ['./siptrunkingprofile.component.css']
})
export class SiptrunkingprofileComponent implements OnInit {
  @ViewChild('closeIconn') closeIconn: ElementRef;
  show_filter: boolean = false;
  userInfo: any;
  public filterUser: FormGroup;
  public addprofile: FormGroup;
  SIPdetails: any = [];
  errMessage: any = "";
  responseMessage: any = "";
  dropdownSettings: IDropdownSettings = {};
  dropdownSettings1: IDropdownSettings = {};
  dropdownSettings2: IDropdownSettings = {};
  CSP: any = [];
  sanID: any = [];
  accountID: any = [];
  nameSIPsetting: any = [];
  selectedItem: any = [];
  selectedSIP: any = [];
  sipsettingname: any = [];
  nameSIP: any = [];
  submitted: boolean = false;
  viewdetails: any = [];
  idSIPoverride: any;
  id: any;

  constructor(public router: Router, private http: HttpClient, public data: ObsiptrunkingService, public fb: FormBuilder, public _http: HttpClient) { }

  ngOnInit(): void {

    this.data.get_obsiptrunking().subscribe((result) => {
      this.userInfo = result[0].siptruckingprofiletable;
    });

    this.filterUser = this.fb.group({
      from_date: [''],
      to_date: [''],
      sipname: [''],
      sipip: ['',[Validators.pattern('(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)')]],
      san: [''],
      sipoverrideprefix: ['',[Validators.pattern(/^\s*\S.*$/m)]]
    });

    this.addprofile = this.fb.group({
      selectuser: ['', Validators.required],
      sip_name: ['', Validators.required]

    })

    this.dropdownSettings = {
      singleSelection: true,
      idField: 'idaccount',
      textField: 'san',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };
    this.dropdownSettings1 = {
      singleSelection: true,
      idField: 'sipIP',
      textField: 'sipName',
      itemsShowLimit: 1,
      allowSearchFilter: true,
      closeDropDownOnSelection: true
    };

    this.getsiptabledata();

    this.getaccountID();
    this.getsipnamelist();
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
      this.filterUser.reset();
      Object.keys(this.filterUser.controls).forEach(key=>{
        this.filterUser.get(key).setValue('');
      })
    }
  }

  getsiptabledata() {
    this.data.getsiptrunkingdetails().subscribe((res) => {
      if (res.status == 201) {
        this.SIPdetails = res.data;
        $('#basic-datatables3').DataTable().clear();
        $('#basic-datatables3').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        // this.responseMessage = res.message;
        // setTimeout(() => {
        //   this.responseMessage = "";
        // }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    })
  }



  getaccountID() {
    this.data.getCPSData().subscribe((res) => {
      if (res.status == 201) {
        this.CSP = res.data;
        this.CSP = this.CSP.slice().reverse();
        this.CSP.forEach(element => {
          this.sanID.push({ idaccount: element.idaccount, san: element.san });
        })
        this.accountID = this.sanID;
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    })
  }

  SetValue(){
    if (this.selectedItem.length !== 0) {
      let idaccount = this.selectedItem[0].idaccount;
      let matched = this.SIPdetails.find(item => item.idaccount === idaccount);
      if (matched) {
        this.selectedSIP = [{ sipIP : matched.idsipts, sipName: matched.sip_name }];
        } else {
          this.selectedSIP = [];
      }
    }
  }

  getsipnamelist() {
    this.data.SIPTrunkingData().subscribe((res) => {
      if (res.status == 201) {
        this.sipsettingname = res.data;
        this.sipsettingname.forEach(ele => {
          this.nameSIP.push({ sipName: ele.sip_name, sipIP: ele.idsipts })
        })
        this.nameSIPsetting = this.nameSIP;
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    })
  }

  submitform() {
    this.submitted = true;
    if (this.addprofile.invalid) {
      return;
    }
    else {
      this.data.submitsipprofile(this.addprofile.value).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.closeIconn.nativeElement.click();
          this.getsiptabledata();
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }
      );
    }
  }

  getsipID(id: any, sipname: any, idSIP: any, idoveride: any) {
    this.idSIPoverride = idoveride;
    this.id=id;
    this.selectedItem = [{ idaccount: id, san: 100000000 + id }];
    this.selectedSIP = [{ sipIP: idSIP, sipName: sipname }];
  }

  Updateform() {
    this.submitted = true;
    if (this.addprofile.invalid) {
      return;
    }else {
      let payload: any = JSON.stringify({
        idaccount: this.selectedItem[0].idaccount,
        idsipIP: this.selectedSIP[0].sipIP,
        IDsip: this.idSIPoverride,
      })
      this.data.updateSipprofile(payload).subscribe((res) => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.closeIconn.nativeElement.click();
          setTimeout(() => {
            this.responseMessage = "";
            this.getsiptabledata();
          }, 3000);
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }
      );
    }
  }

  resetform() {
    this.submitted = false;
    this.addprofile.reset();
    this.selectedItem = [];
    this.selectedSIP = [];
    this.idSIPoverride = '';
  }

  resetform1() {
    this.submitted = false;
    this.addprofile.reset();
    this.selectedSIP = [];
    this.selectedItem = [{ idaccount: this.id, san: 100000000 + this.id }];
  }

  deleteprofile(id: any) {
    if (confirm("Are you sure you want delete SIP Trunking Profile!")) {
      this.data.deleteSipprofile(id).subscribe(res => {
        if (res.status == 201) {
          this.responseMessage = res.message;
          this.getsiptabledata();
          setTimeout(() => {
            this.responseMessage = "";
          }, 5000);
        }else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = "";
          });
        }
      });
    }else {
      return
    }
  }

  Submitfilter() {
    this.submitted = false;
    if (this.filterUser.invalid) {
      return;
    }else {
      this.data.applyFilter(this.filterUser.value).subscribe((res) => {
        if (res.status == 201) {
          this.SIPdetails = res.data;
          $('#basic-datatables3').DataTable().clear();
          $('#basic-datatables3').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterUser.reset();
    Object.keys(this.filterUser.controls).forEach(key=>{
      this.filterUser.get(key).setValue('');
    })
    this.getsiptabledata();
  }

  messageshow() {
    const fromDate = this.filterUser.get('from_date').value;
    const toDate = this.filterUser.get('to_date').value;
    const currentDate = new Date();  

    function checkForMidnight() {
      const now = new Date();
      
      if (now.getHours() === 0 && now.getMinutes() === 0) {
        currentDate.setDate(now.getDate()); 
        currentDate.setMonth(now.getMonth());
        currentDate.setFullYear(now.getFullYear());
      }
    }
  
    setInterval(checkForMidnight, 60 * 1000);
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterUser.get('from_date').setErrors(null);
      this.filterUser.get('to_date').setErrors(null);
    }
  }


  onSubmit(){
    this.Submitfilter();
  }

  ngOnDestroy() {
    this.closeIconn.nativeElement.click();
  }
}
