import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { CommissionPlanComponent } from './commission-plan/commission-plan.component';
import { CommissionTermComponent } from './commission-term/commission-term.component';
import { CommissionTierComponent } from './commission-tier/commission-tier.component';
import { ResellerComponent } from './reseller/reseller.component';
import { CustomerDetailsComponent } from './customer-details/customer-details.component';
import { CommissionDetailsComponent } from './commission-details/commission-details.component';
import { ResellerlinkComponent } from './resellerlink/resellerlink.component';

const routes: Routes = [
    {
        path: '',
        children: [
            {
                path: 'reseller',
                component: ResellerComponent,
                data: {
                    title: 'Reseller List',
                    urls: [
                        {
                            title: 'Reseller',

                        },
                        {
                            title: 'Reseller List'
                        }
                    ]
                }
            },
            {
                path: 'reseller link',
                component: ResellerlinkComponent,
                data: {
                    title: 'Reseller Link',
                    urls: [
                        {
                            title: 'Reseller',

                        },
                        {
                            title: 'Reseller Link'
                        }
                    ]
                }
            },
            {
                path: 'commission-summary',
                component: CommissionDetailsComponent,
                data: {
                    title: 'Commission Summary',
                    urls: [
                        {
                            title: 'Reseller'
                        },
                        {
                            title: 'Commission Summary'
                        }
                    ]
                }
            },
            {
                path: 'commission-plan',
                component: CommissionPlanComponent,
                data: {
                    title: 'Commission Plan',
                    urls: [
                        {
                            title: 'Reseller'
                        },
                        {
                            title: 'Commission Plan'
                        }
                    ]
                }
            },
            {
                path: 'commission-term',
                component: CommissionTermComponent,
                data: {
                    title: 'Commission Term',
                    urls: [
                        {
                            title: 'Reseller'
                        },
                        {
                            title: 'Commission Term'
                        }
                    ]
                }
            },
            {
                path: 'commission-tier/:id',
                component: CommissionTierComponent,
                data: {
                    title: 'Commission Tier',
                    urls: [
                        {
                            title: 'Reseller'
                        },
                        {
                            title: 'Commission Tier'
                        }
                    ]
                }
            },
            {
                path: 'commission-details',
                component: CustomerDetailsComponent,
                data: {
                    title: 'Commission Details',
                    urls: [
                        {
                            title: 'Reseller'
                        },
                        {
                            title: 'Commission Details'
                        }
                    ]
                }
            },
            {
                path: 'commission-details/:id/:date',
                component: CustomerDetailsComponent,
                data: {
                    title: 'Commission Details',
                    urls: [
                        {
                            title: 'Reseller'
                        },
                        {
                            title: 'Commission Details'
                        }
                    ]
                }
            }
        ]
    }
];

@NgModule({
    imports: [RouterModule.forChild(routes)],
    exports: [RouterModule]
})
export class ResellerRoutingModule { }
