import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DemoMaterialModule } from '../demo-material-module';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { ResellerRoutingModule } from './reseller-routing.module';
import { ResellerComponent } from './reseller/reseller.component';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { OrderPipe } from './orderPipe.pipe';
import { SharedModule } from '../shared/shared.module';
import { CommissionDetailsComponent } from './commission-details/commission-details.component';
import { CommissionPlanComponent } from './commission-plan/commission-plan.component';
import { CommissionTermComponent } from './commission-term/commission-term.component';
import { CommissionTierComponent } from './commission-tier/commission-tier.component';
import { CustomerDetailsComponent } from './customer-details/customer-details.component';
import { MatTooltipModule } from '@angular/material/tooltip';
import { ResellerlinkComponent } from './resellerlink/resellerlink.component';
@NgModule({
  declarations: [ResellerComponent, CommissionDetailsComponent, CommissionPlanComponent, CommissionTermComponent,CustomerDetailsComponent,CommissionTierComponent, ResellerlinkComponent],
  imports: [
    CommonModule,
    MatTooltipModule,
    ResellerRoutingModule,
    DemoMaterialModule,
        FormsModule,
        ReactiveFormsModule,
        NgMultiSelectDropDownModule,
        NgbModule,
        SharedModule
  ],
  providers: [OrderPipe]
})
export class ResellerModule { }
