import { Component, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { ResellerService } from '../reseller.service';
declare var $: any;

@Component({
  selector: 'app-resellerlink',
  templateUrl: './resellerlink.component.html',
  styleUrls: ['./resellerlink.component.css']
})

export class ResellerlinkComponent implements OnInit {
  Resellerlink: any = [];
  errMessage: any = "";
  responseMessage: any = "";
  show_filter: boolean = false;
  public filterUser: FormGroup;
  submitted: boolean = false;

  constructor(public data: ResellerService, public fb: FormBuilder) { }

  ngOnInit(): void {

    this.filterUser = this.fb.group({
      from_date: [''],
      to_date: [''],
      resellerID: ['']
    });

    $('#basic-datatables1').DataTable().clear();
    $('#basic-datatables1').DataTable().destroy();
    $.getScript('./assets/tollfree.js');
    
    this.getlinkdata();
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }

  getlinkdata() {
    this.data.getresellerlinkdetails().subscribe((res) => {
      if (res.status == 201) {
        this.Resellerlink = res.data;
        //this.responseMessage = res.message
        $('#basic-datatables1').DataTable().clear();
        $('#basic-datatables1').DataTable().destroy();
        $.getScript('./assets/tollfree.js');
        setTimeout(() => {
          this.responseMessage = '';
        }, 3000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }
  
  textMessageFunc(msgText) {
    this.responseMessage = "URL Copied!";
    setTimeout(() => {
      this.responseMessage = "";
    }, 5000);
  }
  
  Submitfilter() {
    this.submitted = false;
    if (this.filterUser.invalid) {
      return;
    }else {
      this.data.applyFilter(this.filterUser.value).subscribe((res) => {
        if (res.status == 201) {
          this.Resellerlink = res.data;
          $('#basic-datatables1').DataTable().clear();
          $('#basic-datatables1').DataTable().destroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = res.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    }
  }

  resetfilter() {
    this.submitted = false;
    this.filterUser.reset();
    Object.keys(this.filterUser.controls).forEach(key=>{
      this.filterUser.get(key).setValue('');
    })
    this.getlinkdata();
  }

  messageshow() {
    const fromDate = this.filterUser.get('from_date').value;
    const toDate = this.filterUser.get('to_date').value;
    const currentDate = new Date();
    if ((!fromDate && !toDate)) {
    } else if ((fromDate == null || !fromDate) && (toDate != null)) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'Please select From Date' });
    } else if ((fromDate != null) && (toDate == null || !toDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'Please select To Date' });
    } else if (fromDate && toDate && new Date(toDate) < new Date(fromDate)) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be smaller than from date' });
      return;
    } else if (toDate && new Date(toDate) > currentDate) {
      this.filterUser.get('to_date').setErrors({ 'dateRange': 'To date cannot be greater than current date' });
      return;
    } else if (fromDate && new Date(fromDate) > currentDate) {
      this.filterUser.get('from_date').setErrors({ 'dateRange': 'From date cannot be greater than current date' });
      return;
    } else {
      this.filterUser.get('from_date').setErrors(null);
      this.filterUser.get('to_date').setErrors(null);
    }
  }

  onSubmit(){
    this.Submitfilter();
  }

  truncatenotification(subject: string, maxLength: number): string {
    return subject.length > maxLength ? subject.substring(0, maxLength) + '..' : subject;
  }

}
