import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { FormGroup, FormBuilder, Validators } from '@angular/forms';
import { ActivatedRoute, Router, ParamMap } from '@angular/router';
import { ShortcodesmsService } from '../shortcodesms.service';
declare var $: any;

@Component({
  selector: 'app-shortcode-request',
  templateUrl: './shortcode-request.component.html',
  styleUrls: ['./shortcode-request.component.css']
})
export class ShortcodeRequestComponent implements OnInit {
  @ViewChild('closeIcon') closeIcon: ElementRef;
  @ViewChild('closeIconn') closeIconn: ElementRef;
  // @ViewChild('CloseIcn') CloseIcn: ElementRef;
  @ViewChild('viewclose') viewclose: ElementRef;
  @ViewChild('viewrandomVanity') viewrandomVanity: ElementRef;
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('totalcost') totalcost: ElementRef;
  @ViewChild('paycanc') paycanc: ElementRef;
  // @ViewChild('updateHook') updateHook: ElementRef;
  @ViewChild('Submitmodal') Submitmodal: ElementRef;
  userType: number;
  errMessage: any = "";
  responseMessage: any = "";
  submitted: boolean = false;
  shortcoderequestform: FormGroup
  myvalue: string;
  myreqID: string;
  myvalue1: string;
  // files: any;
  fileErr: string;
  file: File;
  files: File[] = [];
  SCtype: any = [];
  SC_option: any = [];
  iduser: any;
  idaccount: any;
  id: string;
  campID: string;
  user: any;
  user1: any = [];
  SCrequestID: any = [];
  SCrequest: any = [];
  migratedDID: number | null = null;
  rejectForm: FormGroup;
  previousfiles: any[] = [];
  randomVanityform: FormGroup
  sctye: any;
  myvaluee: string;
  showFileErrorMessage1 = false;
  showFileErrorMessage2 = false;
  rates: any[];
  userID: any;
  iduserID: any;
  IDuser: any;
  tariff: any;
  showrates: any[];
  User_ID: any;
  IDAccount: any;

  filterForm: FormGroup
  show_filter: boolean;
  SCrequestID1: any = [];
  id_profile: any;
  oldfile: boolean = false;
  connectionList: any[] = [];
  allconnection: any = [];
  key: any;
  checkedCarriers: any = [];
  totalRate: number = 0;
  carriers: any[]
  user2: any;
  idrequest: any;
  filtcarriers: any = [];
  getCarriers: any[];
  totalcarriercost: any;
  typeWiseCarriers: any[];
  shortcodeNumberCharges: any;
  messagetype: any;
  migrated_type_name: any;
  migrated_type_rate: any;
  carrier_status: string;
  camp_status: any;
  sc_status: any;
  campaignStatus: string;
  SCStatus: string;
  profileID: any;
  IDRequest: any;
  Cust_idaccount: any;
  note: any;
  notepoint: any;
  uncheckedcarrier: any[] = [];
  SC_campaignID: any;
  sctype: any;
  sc_camp_id: any;
  noteError: string | null = null
  type: any;
  noteValid: boolean = true;
  noteTouched: boolean = false;
  rate: any;
  // public webhookForm: FormGroup
  // webhook_messaging_key: string;
  // shortcodeWeb: any;
  // userWeb: any;

  constructor(public data: ShortcodesmsService, public router: Router, public fb: FormBuilder, private route: ActivatedRoute) { }

  ngOnInit(): void {
    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;
    this.iduser = session.iduser;
    this.idaccount = session.idaccount;

    // to get dropdown option from json
    this.data.get_shortcodetype().subscribe((res) => {
      this.SCtype = res;
      this.SC_option = this.SCtype[7].subheading1.options;
    })

    this.shortcoderequestform = this.fb.group({
      selectedRequesID: ['', [Validators.required]],
      shortcodetype: [2, [Validators.required]],
      connectionName: ['', [Validators.required]],
      SenderID: [''],
      MigratedSC: [''],
      SC_Proof: ['']
    })

    this.randomVanityform = this.fb.group({
      randomVanityFile: ['', [Validators.required]],
      randomVanityInput: ['', [Validators.required]],
      SCtype: [''],
      SCReqID: [''],
      DIDprovider: [''],
      connectionName1: [''],
      rates: [''],
      description: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]]
    });


    this.rejectForm = this.fb.group({
      reject_text: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],

    });

    this.filterForm = this.fb.group({
      from: [''],
      to: ['', [Validators.required]],
      campaignname: [''],
      requestid: [''],
      sctype: [''],
      status: ['']
    })

    this.SCRequestData();
    this.getIdResquest();
    this.connectionL()

    // this.data.getCarrier().subscribe(result => {
    //   this.carriers = result.data
    // });
    this.getCarrier();

    // this.webhookForm = this.fb.group({
    //   webhook_messaging_key: ['', [Validators.pattern(/^\s*[a-zA-Z0-9]+\s*$/)]],
    // });

    this.paycanc.nativeElement.click();
    this.Submitmodal.nativeElement.click();
  }

  getCarrier() {
    this.data.getCarrier().subscribe(result => {
      this.carriers = result.data
      this.carrierRate(2);
    });
  }
  carrierRate(priority: any) {
    this.filtcarriers = []
    this.carriers.forEach(carrier => {
      if (priority == carrier.sc_type) {
        this.filtcarriers.push({ ...carrier })
      }
    });
  }

  getAllCost(idRequest, idaccount, sctype, sc_camp_id) {
    this.IDRequest = idRequest;
    this.Cust_idaccount = idaccount
    this.sctype = sctype;
    this.sc_camp_id = sc_camp_id
    let payload: any = JSON.stringify({
      idaccount: idaccount,
      idrequest: idRequest,
      SCtype: sctype,
      sc_camp_id: sc_camp_id
    })
    this.data.getAllCost(payload).subscribe(result => {
      if (result.status == 200) {
        this.getCarriers = result.data
        this.typeWiseCarriers = result.data1
        if (this.getCarriers.every(c => c.payment_status === 0)) {
          this.carrier_status = 'Pending';
        } else if (this.getCarriers.every(c => c.payment_status === 1)) {
          this.carrier_status = 'Complete';
        }
        this.shortcodeNumberCharges = result.data2
        this.rate = result.data4;
        this.note = result.note
        this.messagetype = result.data3[0]
        this.migrated_type_name = this.messagetype.display_name
        this.migrated_type_rate = this.messagetype.rates
        this.totalcarriercost = this.getCarriers.reduce((total, carrier) => total + carrier.rate, 0);
      }
    });

  }

  getStatus(profile_id) {
    this.profileID = profile_id
    let payload: any = JSON.stringify({
      profile_id: profile_id
    })

    this.data.getStatus(payload).subscribe(result => {
      if (result.status == 200) {
        this.camp_status = result.camp_status
        this.sc_status = result.sc_status

        if (this.sc_status.payment_status == 0) {
          this.SCStatus = "Pending"
        }
        else if (this.sc_status.payment_status == 1) {
          this.SCStatus = "Complete"
        }
        if (this.camp_status.payment_status == 0) {
          this.campaignStatus = "Pending"
        }
        else if (this.camp_status.payment_status == 1) {
          this.campaignStatus = "Complete"
        }
      }

    });

  }

  checkedCarrier(carrierName: string): boolean {
    // console.log("checkedCarrier",carrierName)
    return this.getCarriers.some(carrier => carrier.sc_carrier_coverage === carrierName);
  }

  // isEditable(carrierName: string): boolean {
  //   // console.log("isEditable",carrierName)
  //   return this.userType == 1 && this.checkedCarrier(carrierName);
  // }

  closeCarrier() {
    this.uncheckedcarrier = []
  }

  handleCheckbox(event: any, carrier: any) {
    this.uncheckedcarrier.push(carrier)
    if (event.target.checked) {
      this.getCarriers.push(carrier);
      this.totalcarriercost += carrier.rate;
    } else {
      const index = this.getCarriers.findIndex((c: any) => c.sc_carrier_coverage === carrier.display_name);
      if (index !== -1) {
        // this.getCarriers.splice(index, 1);
        this.totalcarriercost -= carrier.rate;
      }
    }
  }

  GetType(id: any) {
    this.type = id
  }

  paySCRequest(totalcost: any, type: any) {
    let updated_cost: any;
    let profile_id = this.profileID
    let idaccount = this.Cust_idaccount
    let idRequest = this.IDRequest
    if (type == 3) {
      updated_cost = totalcost + this.migrated_type_rate + this.shortcodeNumberCharges;
    }    
    let payload: any = {
      carrier_cost: totalcost,
      rate:this.rate,
      profile_id: this.profileID,
      idrequest: this.IDRequest,
      type: type,
      idaccount: this.Cust_idaccount,
      updatedcost: updated_cost,
      carriers: this.uncheckedcarrier,
      sc_type: this.sctype,
      migrated_type_rate:this.migrated_type_rate
    }

    this.data.paySCRequest(payload).subscribe(
      (res) => {
        if (res.status == 200) {
          this.responseMessage = res.message;
          setTimeout(() => {
            //this.ngOnInit()
            // this.totalcost.nativeElement.click();
            this.paycanc.nativeElement.click();
            this.getStatus(profile_id);
            this.getAllCost(idRequest, idaccount, this.sctype, this.sc_camp_id);
            this.SCRequestData();
            this.responseMessage = "";
          }, 3000);
        }
        else {
          this.errMessage = res.message
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }
    )

  }
  sendNote() {
    if (this.carrier_status == 'Complete' && this.SCStatus == 'Complete' && this.campaignStatus == 'Complete' && this.note == '') {
      this.responseMessage = "All payment has been deducted! Please enter a note"
      setTimeout(() => {
        this.responseMessage = ""
      }, 5000);
    } else {
      let payload: any = {
        note: this.note,
        idrequest: this.IDRequest,
        carriers: this.uncheckedcarrier,
        sc_type: this.sctype,
        idaccount: this.Cust_idaccount,
        profile_id: this.profileID,
        idRequest: this.IDRequest,
        mo_rates:this.rate

      };

      if (this.carrier_status !== 'Complete') {
        payload.totalcarriercost = this.totalcarriercost;
      }

      if (this.SCStatus !== 'Complete') {
        payload.shortcodeNumberCharges = this.shortcodeNumberCharges;
      }

      if (this.campaignStatus !== 'Complete') {
        payload.migrated_type_rate = this.migrated_type_rate;
        payload.updated_cost = this.totalcarriercost + this.migrated_type_rate + this.shortcodeNumberCharges
      }
      this.data.sendNote(payload).subscribe(response => {
        if (response.status == 200) {
          this.responseMessage = response.message
          this.note = ""
          setTimeout(() => {
            this.responseMessage = "";
            this.Submitmodal.nativeElement.click();
            this.totalcost.nativeElement.click();
            this.SCRequestData()
          }, 3000);
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      })
    }

  }

  validateNote() {
    this.noteTouched = true;
    if (this.note && this.note.trim() !== '') {
      this.noteValid = true;
    } else {
      this.noteValid = false;
    }
  }

  saveNote() {
    this.noteTouched = true;

    if (!this.note || this.note.trim() === '') {
      this.noteValid = false;
      return;
    } else {
      this.noteValid = true;
    }

    let payload: any = {
      note: this.note,
      idrequest: this.IDRequest
    };

    this.data.saveNote(payload).subscribe(response => {
      if (response.status == 200) {
        this.responseMessage = response.message;
        this.note = "";
        this.noteTouched = false;
        setTimeout(() => {
          this.responseMessage = "";
          this.ngOnInit();
          this.totalcost.nativeElement.click();
        }, 3000);
      } else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }



  ResetNote() {
    this.noteValid = true
    this.noteTouched = false
    this.note = ""
  }
  
  onRnFileChange(value: string) {
    if (value) {
      this.randomVanityform.get('randomVanityFile').disable();
    } else {
      this.randomVanityform.get('randomVanityFile').enable();
    }
  }

  onRnInputChange(event: any) {
    const fileInput = event.target as HTMLInputElement;
    const file: File = fileInput.files[0];

    if (file) {
      this.randomVanityform.get('randomVanityInput').disable();
    } else {
      this.randomVanityform.get('randomVanityInput').enable();
      this.files = [];
      this.migratedDID = null;
    }
  }

  toggleDescription(data, property) {
    data[property] = !data[property];
  }

  connectionL() {
    let payload: any = JSON.stringify({
      iduser: this.iduser,
      idaccount: this.idaccount
    })

    this.data.getConnection(payload).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.connectionList = response.data;
          const defaultConnection = this.connectionList.find(item => item.isDefault === 'true');
          if (defaultConnection) {
            this.shortcoderequestform.get('connectionName').setValue(defaultConnection.connection_key);
          }
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with get Connection!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  getIdResquest() {
    this.checkedCarriers = [];
    this.totalRate = 0;
    this.oldfile = false;
    this.data.getIDRequest().subscribe((result) => {
      if (result.status == 200) {
        this.SCrequestID = result.data;
        this.SCrequestID = this.SCrequestID.filter((item, index, self) =>
          index === self.findIndex((t) => (
            t.sc_campaign_unique_id === item.sc_campaign_unique_id
          ))
        );
      }
    });
  }

  showfilter() {
    if (this.show_filter == false) {
      this.show_filter = true;
    }
    else {
      this.show_filter = false;
    }
  }

  getrandomvanity(id: any, userID: any, idacc: any, request: any) {
    this.totalRate = 0
    this.checkedCarriers = []
    let payload: any = JSON.stringify({
      iduser: userID,
      idaccount: idacc
    })
    this.data.getConnection(payload).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.connectionList = response.data;
          this.IDuser = userID;
          this.IDAccount = idacc;
          this.id_profile = id;

          const payLoad: any = JSON.stringify({
            idprofile: this.id_profile,
            iduser: this.IDuser,
            idrequest: request
          });

          this.data.getSCdata(payLoad).subscribe(result => {
            if (result.status === 200) {
              this.user = result.data[0];
              this.tariff = result.data1[0].idtariff;
              this.myvaluee = this.user.sc_type;

              let scTypeValue = '';
              if (this.user.sc_type === 2) {
                scTypeValue = 'Random Shortcode';
              } else if (this.user.sc_type === 3) {
                scTypeValue = 'Vanity Shortcode';
              }

              const key = this.user.connection.trim();
              const connection = this.connectionList.find(conn => conn.connection_key === key);
              if (connection) {
                const connectionName = connection.name;
                this.GetRatesID();
                this.randomVanityform.patchValue({
                  Random_vanity: '',
                  SCtype: scTypeValue,
                  SCReqID: this.user.sc_campaign_unique_id,
                  DIDprovider: 'Shortcode',
                  rates: '',
                  description: '',
                  connectionName1: connectionName.trim()
                });
              }
              const modifiedData = result.data3.map(item => {
                const { sc_carrier_coverage, ...rest } = item;
                return { display_name: sc_carrier_coverage, ...rest };
              });
              this.checkedCarriers = modifiedData
              this.totalRate = this.checkedCarriers.reduce((total, carrier) => total + carrier.rate, 0);
            } else {
              this.errMessage = result.message;
              setTimeout(() => {
                this.errMessage = '';
              }, 5000);
            }
          });
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with get Connection!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

  }

  SCRequestData() {
    this.data.allConnection().subscribe((res) => {
      this.allconnection = res.data;
      this.data.getSCRequest().subscribe((result) => {
        if (result.status == 200) {
          this.SCrequest = result.data;
          this.SCrequest.forEach(item => {
            const matchingConnection = this.allconnection.find(conn => conn.connection_key === item.connection);
            if (matchingConnection) {
              item.name = matchingConnection.name;
            }
          });
          $('#basic-datatables1').dataTable().fnClearTable();
          $('#basic-datatables1').dataTable().fnDraw();
          $('#basic-datatables1').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');

          $('#basic-datatables4').dataTable().fnClearTable();
          $('#basic-datatables4').dataTable().fnDraw();
          $('#basic-datatables4').dataTable().fnDestroy();
          $.getScript('./assets/tollfree.js');
        } else {
          this.errMessage = result.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      })
    })
  }

  updateValidators() {
    const controls = ['SenderID', 'MigratedSC', 'SC_Proof'];
    controls.forEach(controlName => {
      const control = this.shortcoderequestform.get(controlName);
      control.clearValidators();
      if (controlName === 'SenderID' && (this.myvalue === '1' || this.myvalue === '4')) {
        control.setValidators([Validators.required, Validators.pattern(/^\s*\S.*$/)]);
      } else {
        if (this.myvalue === '1' || this.myvalue === '4') {
          control.setValidators(Validators.required);
        }
      }
      control.updateValueAndValidity();
    });
  }


  onTypeChange(selectedType: string) {
    this.myvalue = selectedType;
    this.checkedCarriers = [];
    this.totalRate = 0;
    if (selectedType !== '1' && !this.id_profile) {
      this.shortcoderequestform.get("SenderID").reset();
      this.shortcoderequestform.get('SenderID').setValue('')
      this.shortcoderequestform.get("SC_Proof").reset();
      this.shortcoderequestform.get("MigratedSC").reset();
      this.files = []
      this.previousfiles = []
    }
    if (this.id_profile && (this.myvalue === '1' || this.myvalue === '4')) {
      this.getid(this.id_profile, this.idrequest);
    }
    this.carrierRate(selectedType)
    this.updateValidators();
  }


  getid(id: any, request: any) {
    this.totalRate = 0
    this.checkedCarriers = []
    this.id_profile = id;
    this.idrequest = request
    let payLoad: any = JSON.stringify({
      idprofile: this.id_profile,
      idrequest: request
    });
    this.data.getSCdata(payLoad).subscribe(result => {
      if (result.status == 200) {
        this.user = result.data[0];
        this.oldfile = true;
        this.myvalue = this.user.sc_type;
        this.myreqID = this.user.profile_id;
        const modifiedData = result.data3.map(item => {
          const { sc_carrier_coverage, ...rest } = item;
          return { display_name: sc_carrier_coverage, ...rest };
        });
        this.checkedCarriers = modifiedData
        this.totalRate = this.checkedCarriers.reduce((total, carrier) => total + carrier.rate, 0);
        const filePaths1 = this.user.migrated_file_path.split(',');
        const filePaths2 = this.user.sc_proof_doc_filepath.split(',');
        this.files = [];
        this.previousfiles = [];
        filePaths2.forEach((filePath, index) => {
          const fileName2 = filePath.substring(filePath.lastIndexOf('/') + 1);
          const fileObject2 = {
            file: filePath.trim(),
            name: fileName2,
          };
          this.previousfiles.push(fileObject2);
        });
        filePaths1.forEach((filePath, index) => {
          const fileName1 = filePath.substring(filePath.lastIndexOf('/') + 1);
          const fileObject1 = {
            file: filePath.trim(),
            name: fileName1,
          };
          this.previousfiles.push(fileObject1);
        });
        this.shortcoderequestform.patchValue({
          selectedRequesID: this.user.sc_campaign_unique_id,
          shortcodetype: this.user.sc_type,
          connectionName: this.user.connection,
          SenderID: this.user.sender_id,
          MigratedSC: this.user.migrated_filename,
          SC_Proof: this.user.sc_proof_filename
        })
      } else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }

  getviewdata(accID: any, user: any, request: any) {
    this.checkedCarriers = []
    this.totalRate = 0
    let data: any = JSON.stringify({
      idaccount: accID,
      iduser: user
    });
    this.data.getConnection(data).subscribe(response => {
      if (response.status == 200) {
        if (response.data.length > 0) {
          this.connectionList = response.data;
          let payLoad: any = JSON.stringify({
            idprofile: this.id_profile,
            iduser: this.User_ID,
            idrequest: request
          });
          this.data.getSCdata(payLoad).subscribe(result => {
            if (result.status == 200) {
              this.user1.push(result.data[0]);
              this.user2 = result.data1[0];
              this.key = this.user1[0].connection;
              const connection = this.connectionList.find(conn => conn.connection_key === this.key);
              if (connection) {
                const connectionName = connection.name;
                this.user1[0].connection = connectionName;
              }
              this.myvalue1 = this.user1[0].sc_type;
              const modifiedData = result.data3.map(item => {
                const { sc_carrier_coverage, ...rest } = item;
                return { display_name: sc_carrier_coverage, ...rest };
              });
              this.checkedCarriers = modifiedData
              this.totalRate = this.checkedCarriers.reduce((total, carrier) => total + carrier.rate, 0);
            } else {
              this.errMessage = result.message;
              setTimeout(() => {
                this.errMessage = '';
              }, 5000);
            }
          });
        }
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = "Something went wrong with get Connection!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });
  }

  getid1(id: any, SCty: any, ID_user: any, IDprf: any) {
    this.User_ID = ID_user;
    this.sctye = SCty;
    this.campID = id;
    this.id_profile = IDprf;
    this.carriers = this.carriers.filter(item => item.sc_type == SCty)
  }

  resetform() {
    this.submitted = false;
    this.myvalue = '';
    this.myreqID = '';
    this.files = []
    // this.reqid = ''
    this.shortcoderequestform.reset();
    this.shortcoderequestform.patchValue({
      selectedRequesID: this.id_profile ? this.user.sc_campaign_unique_id : '',
      shortcodetype: '',
      SenderID: '',
      MigratedSC: this.id_profile ? this.user.migrated_filename : '',
      SC_Proof: this.id_profile ? this.user.sc_proof_filename : '',
      connectionName: ''
    })
    this.oldfile = false;
    this.checkedCarriers = [];
    this.totalRate = 0;
  }

  submitform() {
    if (this.shortcoderequestform.invalid || (this.checkedCarriers.length === 0)) {
      this.submitted = true;
      return;
    }
    else {
      let payload: any = JSON.stringify({
        data: this.shortcoderequestform.value,
        didnumber: this.migratedDID,
        Carrier: this.checkedCarriers,
      })
      this.data.sendshortcoderequest(payload, this.files).subscribe(
        (res) => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.closeIconn.nativeElement.click();
            this.getIdResquest();
            this.SCRequestData();
            setTimeout(() => {
              this.responseMessage = "";
            }, 3000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        },
        (err) => {
          let errorMessage = 'An unknown error occurred';
          if (err.error && err.error.error) {
            errorMessage = err.error.error;
          }
          this.errMessage = errorMessage;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      );
    }
  }

  // onFilePicked(event: Event) {
  //   console.log("eventttttttttttttttttttttttt:::::",event);

  //   const fileInput = event.target as HTMLInputElement;
  //   const file: File = fileInput.files[0];

  //   if (!file) {
  //     return;
  //   }

  //   const allowedTypes = ['text/csv'];
  //   if (!allowedTypes.includes(file.type)) {
  //     this.errMessage = "Invalid file type!";
  //     setTimeout(() => {
  //       this.errMessage = "";
  //     }, 5000);
  //     fileInput.value = '';
  //     this.shortcoderequestform.get('MigratedSC').setValue('');
  //     this.randomVanityform.get('randomVanityInput').setValue('');
  //     this.randomVanityform.get('randomVanityFile').setValue('');
  //     this.randomVanityform.get('randomVanityInput').enable();
  //     this.shortcoderequestform.get('SC_Proof').setValue('');
  //     return;
  //   }

  //   const reader = new FileReader();
  //   reader.onload = () => {
  //     const fileContent = reader.result as string;
  //     const numbers = fileContent.match(/\b\d+\b/g);

  //     if (!numbers || numbers.length !== 1) {
  //       this.errMessage = "Please select a file with correct one SC number.";
  //       setTimeout(() => {
  //         this.errMessage = "";
  //       }, 5000);
  //       fileInput.value = '';
  //       this.shortcoderequestform.get('MigratedSC').setValue('');
  //       this.randomVanityform.get('randomVanityInput').setValue('');
  //       this.randomVanityform.get('randomVanityFile').setValue('');
  //       this.randomVanityform.get('randomVanityInput').enable();
  //       this.shortcoderequestform.get('SC_Proof').setValue('');
  //       return;
  //     }

  //     const validNumbers = numbers.filter(num => num.length === 5 || num.length === 6);

  //     if (validNumbers.length !== 1) {
  //       this.errMessage = "Please select a file with correct one SC number.";
  //       setTimeout(() => {
  //         this.errMessage = "";
  //       }, 5000);
  //       fileInput.value = '';
  //       this.shortcoderequestform.get('MigratedSC').setValue('');
  //       this.randomVanityform.get('randomVanityInput').setValue('');
  //       this.randomVanityform.get('randomVanityFile').setValue('');
  //       this.randomVanityform.get('randomVanityInput').enable();
  //       this.shortcoderequestform.get('SC_Proof').setValue('');
  //       return;
  //     }

  //     this.migratedDID = parseInt(validNumbers[0]);
  //     this.files.push(file);
  //     this.oldfile = false;
  //     this.fileErr = '';
  //   };

  //   reader.readAsText(file);
  // }

  onFilePicked(event: Event) {
    const fileInput = event.target as HTMLInputElement;
    const file: File = fileInput.files[0];

    if (!file) {
      return;
    }

    const allowedTypes = ['text/csv'];
    if (!allowedTypes.includes(file.type)) {
      this.errMessage = "Invalid file type!";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      fileInput.value = '';
      this.shortcoderequestform.get('MigratedSC').setValue('');
      return;
    }

    const reader = new FileReader();
    reader.onload = () => {
      const fileContent = reader.result as string;
      const numbers = fileContent.match(/\b\d+\b/g);

      if (!numbers || numbers.length !== 1) {
        this.errMessage = "Please select a file with correct one SC number.";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        this.shortcoderequestform.get('MigratedSC').setValue('');
        return;
      }

      const validNumbers = numbers.filter(num => num.length === 5 || num.length === 6);

      if (validNumbers.length !== 1) {
        this.errMessage = "Please select a file with correct one SC number.";
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
        fileInput.value = '';
        this.shortcoderequestform.get('MigratedSC').setValue('');
        return;
      }
      this.migratedDID = parseInt(validNumbers[0]);
      let payload: any = JSON.stringify({
        did: this.migratedDID
      })
      this.data.checkDid(payload).subscribe(
        (res: any) => {
          if (res.status === 200) {
            this.files.push(file);
            this.oldfile = false;
            this.fileErr = '';
          } else {
            this.errMessage = res.message || 'Invalid DID';
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
            fileInput.value = '';
            this.shortcoderequestform.get('MigratedSC').setValue('');
          }
        },
        (err) => {
          this.errMessage = 'You cannot upload the same Shortcode DID';
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
          fileInput.value = '';
          this.shortcoderequestform.get('MigratedSC').setValue('');
        }
      );
    };

    reader.readAsText(file);
  }



  onFilePicked1(event: Event) {
    const fileInput = event.target as HTMLInputElement;
    const file: File = fileInput.files[0];
    if (!file) {
      return;
    }
    const allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'application/pdf', 'image/webp', 'application/msword', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document'];
    if (!allowedTypes.includes(file.type)) {
      this.errMessage = "Invalid file type !";
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
      fileInput.value = '';
      this.shortcoderequestform.get('SC_Proof').setValue('');
      return;
    }
    this.files.push(file);
    this.oldfile = false;
    const reader = new FileReader();
    reader.readAsDataURL(file);
    this.fileErr = '';
  }


  viewFile(data: any) {
    const fileExtension = data.migrated_filename.split('.').pop();
    const docxModal = document.getElementById('modalDocxAppeal');
    if (data.migrated_file_path) {
      const a = document.createElement('a');
      a.href = data.migrated_file_path;
      a.download = data.migrated_filename;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      $(docxModal).modal('show');
    }
  }


  viewFile1(data: any) {
    const fileExtension = data.sc_proof_filename.split('.').pop().toLowerCase();
    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalPdf = document.getElementById('modalPdf') as HTMLIFrameElement;

    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg") {
      modalImage.src = data.sc_proof_doc_filepath;
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      modalPdf.src = data.sc_proof_doc_filepath;
      $(pdfModal).modal('show');
    } else {
      if (data.sc_proof_doc_filepath) {
        const a = document.createElement('a');
        a.href = data.sc_proof_doc_filepath;
        a.download = data.sc_proof_filename;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        // $(docxModal).modal('show');
      }
    }
  }


  downloadFile(data) {
    if (data.sc_proof_doc_filepath) {
      const a = document.createElement('a');
      a.href = data.sc_proof_doc_filepath;
      a.download = data.sc_proof_filename;
      a.click();
    }
  }

  downloadFile1(data) {
    if (data.migrated_file_path) {
      const a = document.createElement('a');
      a.href = data.migrated_file_path;
      a.download = data.migrated_filename;
      a.click();
    }
  }

  UpdateReqest() {
    if (this.shortcoderequestform.invalid || (this.checkedCarriers.length === 0)) {
      this.submitted = true;
      return;
    }
    if (this.files.length === 1) {
      this.errMessage = 'Please choose Both files'
      setTimeout(() => {
        this.errMessage = "";
      }, 3000);
    }
    else {
      let payload: any = JSON.stringify({
        data: this.shortcoderequestform.value,
        idprofile: this.id_profile,
        previosFile: this.previousfiles,
        didnumber: this.migratedDID ? this.migratedDID : this.user.shortocde_number,
        Carrier: this.checkedCarriers,
        idrequest: this.user.id_request
      })
      this.data.updaterequest(payload, this.files).subscribe(
        (res) => {
          if (res.status == 200) {
            this.responseMessage = res.message;
            this.closeIconn.nativeElement.click();
            this.getIdResquest();
            this.SCRequestData();
            setTimeout(() => {
              this.responseMessage = "";
              this.oldfile = false;
            }, 3000);
          } else {
            this.errMessage = res.message;
            setTimeout(() => {
              this.errMessage = "";
            }, 5000);
          }
        },
        (err) => {
          let errorMessage = 'An unknown error occurred';
          if (err.error && err.error.error) {
            errorMessage = err.error.error;
          }
          this.errMessage = errorMessage;
          setTimeout(() => {
            this.errMessage = "";
          }, 3000);
        }
      );
    }
  }

  OnReset() {
    this.submitted = false
    this.user1 = []
    // this.campID = '';
    this.id_profile = '';
    this.getCarrier();
  }

  Resetrejectform() {
    this.submitted = false
    this.rejectForm.reset()
  }

  rejectSender() {
    this.submitted = true;
    if (this.rejectForm.invalid) {
      return false;
    }
    const data = {
      idaccount: this.user1[0].idaccount,
      iduser: this.user1[0].iduser,
      idcamp: this.campID,
      reject_text: this.rejectForm.get('reject_text').value,
      sc_type: this.user1[0].sc_type,
      idprofile: this.id_profile
    };
    this.data.rejectstatus(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.closeIcon.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = '';
          this.SCRequestData();
        }, 5000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });
  }

  verifySCrequest() {
    let data = {
      idaccount: this.user1[0].idaccount,
      iduser: this.user1[0].iduser,
      idcamp: this.campID,
      SC_Number: this.user1[0].shortocde_number,
      sc_type: this.user1[0].sc_type,
      idprofile: this.id_profile,
      connection: this.key,
      total: this.totalRate,
      idtaiff: this.user2.idtariff
    }
    this.data.approveSC_req(data).subscribe((res) => {
      if (res.status == 201) {
        this.responseMessage = res.message;
        this.viewclose.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = "";
          this.router.navigate(['./shortcode-request']);
          this.SCRequestData();
        }, 5000);
      }
      else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }

    })
  }

  // SubmitrandomVanity() {
  //   if (this.randomVanityform.invalid) {
  //     this.submitted = true;
  //     return;
  //   } else {
  //     let scTypeValue = this.randomVanityform.get('SCtype').value === 'Random Shortcode' ? '2' : '3';
  //     let providerValue;
  //     if (this.randomVanityform.get('DIDprovider').value === 'Shortcode') {
  //       providerValue = 'shortcode';
  //     }
  //     this.randomVanityform.patchValue({
  //       SCtype: scTypeValue,
  //       DIDprovider: providerValue
  //     })

  //     if (this.randomVanityform.get('SCtype').value === '2') {
  //       const rate = this.showrates.find(rate => rate.category === 'short_code_lease');
  //       this.randomVanityform.get('rates').setValue(rate.rate);
  //     } else if (this.randomVanityform.get('SCtype').value === '3') {
  //       const rate = this.showrates.find(rate => rate.category === 'vanity_short_code');
  //       this.randomVanityform.get('rates').setValue(rate.rate);
  //     }

  //     let didnumberValue = this.migratedDID ? this.migratedDID : this.randomVanityform.value.randomVanityInput;

  //     let payload: any = JSON.stringify({
  //       data: this.randomVanityform.value,
  //       // didnumber: this.migratedDID,
  //       didnumber: didnumberValue,
  //       idcamp: this.campID,
  //       iduser: this.IDuser,
  //       idaccount: this.IDAccount,
  //       idprofile: this.id_profile,
  //       connectionname: this.user.connection,
  //       total: this.totalRate,
  //       idtariff: this.tariff
  //     })

  //     this.data.Saverandomvanity(payload, this.files).subscribe(
  //       (res) => {
  //         if (res.status == 200) {
  //           this.responseMessage = res.message;
  //           this.CloseIcn.nativeElement.click();
  //           this.SCRequestData();
  //           setTimeout(() => {
  //             this.responseMessage = "";
  //           }, 3000);
  //         } else {
  //           this.errMessage = res.message;
  //           let scTypeValue = this.randomVanityform.get('SCtype').value === '2' ? 'Random Shortcode' : 'Vanity Shortcode';
  //           let providerValue;
  //           if (this.randomVanityform.get('DIDprovider').value === 'shortcode') {
  //             providerValue = 'Shortcode';
  //           }
  //           this.randomVanityform.patchValue({
  //             SCtype: scTypeValue,
  //             DIDprovider: providerValue
  //           })
  //           setTimeout(() => {
  //             this.errMessage = "";
  //           }, 5000);
  //         }
  //       },
  //       (err) => {
  //         let errorMessage = 'An unknown error occurred';
  //         if (err.error && err.error.error) {
  //           errorMessage = err.error.error;
  //         }
  //         this.errMessage = errorMessage;
  //         let scTypeValue = this.randomVanityform.get('SCtype').value === '2' ? 'Random Shortcode' : 'Vanity Shortcode';
  //         let providerValue;
  //         if (this.randomVanityform.get('DIDprovider').value === 'shortcode') {
  //           providerValue = 'Shortcode';
  //         }
  //         this.randomVanityform.patchValue({
  //           SCtype: scTypeValue,
  //           DIDprovider: providerValue
  //         })
  //         setTimeout(() => {
  //           this.errMessage = "";
  //         }, 3000);
  //       }
  //     );

  //   }
  // }

  function1() {
    this.showrates = this.rates.filter(rate => rate.category === 'short_code_lease' || rate.category === 'vanity_short_code');
  }


  GetRatesID() {
    let idtariff = this.tariff;
    this.data.GetRates(idtariff).subscribe(result => {
      if (result.status == 200) {
        if (result.data.length > 0) {
          this.rates = result.data;
          this.function1()
        }
      }
      else {
        this.errMessage = result.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    });
  }


  isChecked(carrierName: string): boolean {
    return this.checkedCarriers.some(carrier => carrier.display_name === carrierName);
  }

  handleCheckboxChange(event: any, carrier: any) {
    if (event.target.checked) {
      this.checkedCarriers.push(carrier);
      this.totalRate += carrier.rate;
    } else {
      const index = this.checkedCarriers.findIndex((c: any) => c.display_name === carrier.display_name);
      if (index !== -1) {
        this.checkedCarriers.splice(index, 1);
        this.totalRate -= carrier.rate;
      }
    }

  }

  resetrandomvanity() {
    this.submitted = false;
    this.randomVanityform.reset();
    this.randomVanityform.get('randomVanityFile').enable();
    this.randomVanityform.get('randomVanityInput').enable();
    // this.user1 = [];
  }

  // view file for random and vanity
  viewFile2(data: any) {
    const fileExtension = data.filename.split('.').pop();
    // const docxModal = document.getElementById('modalDocxAppeal');
    if (data.file_path) {
      const a = document.createElement('a');
      a.href = data.file_path;
      a.download = data.filename;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      // $(docxModal).modal('show');
    }
  }

  migratedform() {
    this.submitted = false;
    this.myvalue = '';
    this.myreqID = '';
    this.files = []
    // this.campID = ''
    this.id_profile = ''
    this.shortcoderequestform.reset();
    this.shortcoderequestform.patchValue({
      selectedRequesID: '',
      shortcodetype: '',
      SenderID: '',
      MigratedSC: '',
      SC_Proof: '',
      connectionName: ''
    })
    const defaultConnection = this.connectionList.find(item => item.isDefault === 'true');
    if (defaultConnection) {
      this.shortcoderequestform.get('connectionName').setValue(defaultConnection.connection_key);
    }
  }

  truncatenotification(subject: string, maxLength: number): string {
    if (subject && subject.length > maxLength) {
      return subject.substring(0, maxLength) + '...';
    } else {
      return subject;
    }
  }
  // gethookshotcode(iduser: any, shortocde_number: any, sc_campaign_unique_id: any) {
  //   this.shortcodeWeb = shortocde_number;
  //   this.userWeb = iduser;
  //   this.SC_campaignID = sc_campaign_unique_id
  // }

  // webhookSubmit() {
  //   this.submitted = true;
  //   if (this.webhookForm.invalid) {
  //     return false;
  //   }

  //   let data: any = {
  //     shortocde_number: this.shortcodeWeb,
  //     iduser: this.userWeb,
  //     sc_campaign_unique_id: this.SC_campaignID,
  //     webhook_messaging_key: this.webhookForm.get('webhook_messaging_key').value,
  //   };

  //   this.data.updateSCWebkey(data).subscribe((res) => {
  //     if (res.status === 200) {
  //       this.responseMessage = res.message;
  //       this.webhook_messaging_key = res.webhook_messaging_key;
  //       // Patch the form control with the updated value
  //       this.webhookForm.patchValue({
  //         webhook_messaging_key: this.webhook_messaging_key
  //       });
  //       this.updateHook.nativeElement.click()
  //       this.ngOnInit();
  //       setTimeout(() => {
  //         this.responseMessage = '';
  //       }, 2000);
  //     } else {
  //       this.errMessage = res.message;
  //       setTimeout(() => {
  //         this.errMessage = '';
  //       }, 5000);
  //     }
  //   });
  // }

  // resetHook() {
  //   this.webhookForm.reset();
  //   this.submitted = false;
  //   this.webhook_messaging_key = '';
  // }


  ngOnDestroy() {
    this.modalPdfAppeal.nativeElement.click();
    this.modalImageAppeal.nativeElement.click();
    // this.CloseIcn.nativeElement.click();
    this.viewrandomVanity.nativeElement.click();
    this.closeIconn.nativeElement.click();
    this.viewclose.nativeElement.click();
    this.closeIcon.nativeElement.click();
    this.totalcost.nativeElement.click();
    this.paycanc.nativeElement.click();
  }

}
