import { Component, ElementRef, OnInit, ViewChild } from '@angular/core';
import { ActivatedRoute, ParamMap, Router } from '@angular/router';
import { ShortcodesmsService } from '../shortcodesms.service';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
declare var $: any;
@Component({
  selector: 'app-viewprofile',
  templateUrl: './viewprofile.component.html',
  styleUrls: ['./viewprofile.component.css']
})
export class ViewprofileComponent implements OnInit {
  @ViewChild('modalImageAppeal') modalImageAppeal: ElementRef;
  @ViewChild('modalPdfAppeal') modalPdfAppeal: ElementRef;
  @ViewChild('modalVideoForFile') modalVideoForFile: ElementRef;
  @ViewChild('reject') reject: ElementRef;

  sc_id: any;
  responseMessage: any = "";
  errMessage: any = "";
  selectFile: any;
  Viewdata: any;
  contentData: any;
  carriers: any;
  //checkedCarriers: any = [];
  userType: any;
  public rejectForm: FormGroup
  public submitted: boolean = false
  log: any;
  // totalRate: number = 0;

  constructor(private route: ActivatedRoute, public router: Router, public data: ShortcodesmsService, private fb: FormBuilder) { }

  ngOnInit(): void {

    let session$ = sessionStorage.getItem("isLoggedIn");
    let session = JSON.parse(session$);
    this.userType = session.type;

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.sc_id = params.get('id_profile');
      this.ViewData();
    });
    this.data.getCarrier().subscribe(result => {
      this.carriers = result.data
    })

    this.rejectForm = this.fb.group({
      reject_text: ['', [Validators.required, Validators.pattern(/^\s*\S.*$/m)]],
    });

  }


  ViewData() {
    this.data.ViewSCdata(this.sc_id).subscribe((res) => {
      if (res.status == 201) {
        this.Viewdata = res.data[0]
        this.contentData = res.data1
        this.selectFile = res.data2;
        // this.responseMessage = res.message
        //   const modifiedDataArray = res.data4.map(item => {
        //     const { sc_carrier_coverage, ...rest } = item;
        //     return { display_name: sc_carrier_coverage, ...rest };
        // });
        //   this.checkedCarriers = modifiedDataArray
        // this.totalRate = this.checkedCarriers.reduce((total, carrier) => total + carrier.rate, 0);       
        this.log = res.data3
        $('#basic-datatables1').dataTable().fnClearTable();
        $('#basic-datatables1').dataTable().fnDraw();
        $('#basic-datatables1').dataTable().fnDestroy();

        $('#basic-datatables').dataTable().fnClearTable();
        $('#basic-datatables').dataTable().fnDraw();
        $('#basic-datatables').dataTable().fnDestroy();
        $.getScript('./assets/tollfree.js');
        // setTimeout(() => {
        //   this.responseMessage = ""
        // },5000);
      } else {
        this.errMessage = res.message
        setTimeout(() => {
          this.errMessage = ''
        }, 5000);
      }
    });
  }

  // isChecked(carrierName: string): boolean {
  //   return this.checkedCarriers.some(carrier => carrier.display_name === carrierName);
  // }


  DownloadFile(data) {
    if (data.file_path) {
      const a = document.createElement('a');
      a.href = data.file_path;
      a.download = data.filename;
      a.click();
    }
  }

  ViewFile(data: any) {
    const fileExtension = data.file_path.split('.').pop();

    const pdfModal = document.getElementById('modalPdfAppeal');
    const imageModal = document.getElementById('modalImageAppeal');
    const docxModal = document.getElementById('modalDocxAppeal');
    const videoModal = document.getElementById('modalVideoForFile');
    const modalImage = document.getElementById('modalImage') as HTMLImageElement;
    const modalImage123 = document.getElementById('modalPdf') as HTMLIFrameElement;
    const videoModal12 = document.getElementById('videoModal') as HTMLVideoElement;
    if (fileExtension === "png" || fileExtension === "jpg" || fileExtension === "jpeg" || fileExtension === "gif") {
      modalImage.src = data.file_path
      // Open the modal for images
      $(imageModal).modal('show');
    } else if (fileExtension === 'pdf') {
      // const pdfData = data.file
      modalImage123.src = data.file_path
      // Open the modal for non-image files
      $(pdfModal).modal('show');
    } else if (fileExtension === 'mov') {
      // const videoData = data.file;
      videoModal12.src = data.file_path
      // Open Modal for Video
      $(videoModal).modal('show');
      $(videoModal).on('hidden.bs.modal', function () {
        videoModal12.pause();
      });
    }
    else {
      if (data.file_path) {
        const a = document.createElement('a');
        a.href = data.file_path;
        a.download = data.filename;
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
        $(docxModal).modal('show');
      }
    }
  }

  RejectCampaign() {
    this.submitted = true;
    if (this.rejectForm.invalid) {
      return false;
    }
    const data = {
      idaccount: this.Viewdata.idaccount,
      iduser: this.Viewdata.iduser,
      id: this.sc_id,
      reject_text: this.rejectForm.get('reject_text').value,
    };
    this.data.rejectSCampaign(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        this.reject.nativeElement.click();
        setTimeout(() => {
          this.responseMessage = '';
          this.router.navigateByUrl('/shortcode-campaign')
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });

  }

  AprroveCampaign() {
    const data = {
      idaccount: this.Viewdata.idaccount,
      iduser: this.Viewdata.iduser,
      id: this.sc_id,
      rates: this.Viewdata.rates
    };
    this.data.approveSCampaign(data).subscribe((res) => {
      if (res.status === 201) {
        this.responseMessage = res.message;
        setTimeout(() => {
          this.responseMessage = '';
          this.router.navigateByUrl('/shortcode-campaign')
        }, 2000);
      } else {
        this.errMessage = res.message;
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    });

  }

  OnReset() {
    this.submitted = false
    this.rejectForm.reset()
  }

  toggleDescription(data, property) {
    data[property] = !data[property];
  }

  ngOnDestroy() {
    this.modalVideoForFile.nativeElement.click();
    this.modalPdfAppeal.nativeElement.click();
    this.modalImageAppeal.nativeElement.click();
    this.reject.nativeElement.click();
  }
}


