import { Component, OnInit } from '@angular/core';
import {SupplierService} from '../supplier.service';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { didupload,  didForm } from '../supplier.class';
@Component({
  selector: 'app-didupload',
  templateUrl: './didupload.component.html',
  styleUrls: ['./didupload.component.css']
})
export class DiduploadComponent extends AppComponentClass<didupload, didForm> {
  p: number = 1;
	rowdata: any;
	listdata: any;
  modelform: any;
  public show: boolean = false;
  public package: any;
  public buttonName: any = "Add";
  public didForm: FormGroup;
  public submitted : boolean = false;
  filterTerm: string
  constructor(public data: SupplierService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  
  ngOnInit(): void {

    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new didForm(res);
				this.keyfield = res.id;
				this.didForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new didForm(null);
				this.keyfield = -1;
				this.didForm = this.cdata.makeform(this.fb);
			}
		});

    this.data.getdidupload().subscribe((result) => {
	  this.modelform = result ; 
      console.log(result)
    });

   
  }


 

	// @to save/update form data
	onSubmit() {
		console.log("event task save");
		this.submitted = true;

		if (this.didForm.invalid) {
			return false;
		} else {
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.didForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

	  
	 
}

