import { Component, OnInit } from '@angular/core';
import {SupplierService} from '../supplier.service';
import { Router } from '@angular/router';
import { FormBuilder, FormGroup, FormControl} from '@angular/forms';
import { AppComponentClass } from 'src/app/shared/service/AppComponent.class';
import { itegratedsolutions,  intgratedsolutionsForm } from '../supplier.class';
import { Base64 } from 'js-base64';

@Component({
  selector: 'app-itegratedsolutions',
  templateUrl: './itegratedsolutions.component.html',
  styleUrls: ['./itegratedsolutions.component.css']
})
export class ItegratedsolutionsComponent extends AppComponentClass<itegratedsolutions, intgratedsolutionsForm> {
	
  p: number = 1;
	rowdata: any;
	listdata: any;
  modelform: any;
  public show: boolean = false;
  public package: any;
  public buttonName: any = "Add";
  public intgratedsolutionsForm: FormGroup;
  public submitted : boolean = false;
  filterTerm: string
  gToken: string = "";

  constructor(public data: SupplierService, public router: Router, public fb: FormBuilder) {
		super(data, router, fb);
	}

  
  ngOnInit(): void {   

    // @subscribing form group
		this.data.solution.subscribe(res => {
			if (res != null) {
				console.log("Update data " + JSON.stringify(res));
				this.cdata = new intgratedsolutionsForm(res);
				this.keyfield = res.id;
				this.intgratedsolutionsForm = this.cdata.makeform(this.fb);
			} else {
				console.log("adding data " + JSON.stringify(res));
				this.cdata = new intgratedsolutionsForm(null);
				this.keyfield = -1;
				this.intgratedsolutionsForm = this.cdata.makeform(this.fb);
			}
		});

    this.data.getintegrated().subscribe((result) => {
	  this.modelform = result ; 
      console.log(result)
    });

   
  }

  getEncodedToken(token: string){
	  console.log(token);
	let utf8  = '小飼弾'
	let u8s   =  new Uint8Array([100,97,110,107,111,103,97,105]);
	console.log(Base64.encode(token)); 
	this.gToken = Base64.encode(token);     
  }

 

	// @to save/update form data
	onSubmit() {
		console.log("event task save");
		this.submitted = true;

		if (this.intgratedsolutionsForm.invalid) {
			return false;
		} else {
			console.log("submit data::", this.cdata);
			if (this.cdata.saveForm(this.intgratedsolutionsForm)) {
				console.log("Submitted data ::\n" + JSON.stringify(this.cdata));
				if (this.keyfield == -1) {
					this.data.saveData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				} else {
					this.data.updateData(JSON.stringify(this.cdata)).subscribe(res => {
						console.log("Response data::\n", res);
						this.ngOnInit();
					});
				}
			}
		}
	}

	
}