import { Component, OnInit, ViewChild } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, Validators } from '@angular/forms';
import { MatAccordion } from '@angular/material/expansion';
import { MatSlideToggleChange } from '@angular/material/slide-toggle';
import { ActivatedRoute, ParamMap } from '@angular/router';
//import { Validators } from 'ngx-editor';
import { TariffService } from '../../tariff.service';

@Component({
  selector: 'app-edittariff',
  templateUrl: './edittariff.component.html',
  styleUrls: ['./edittariff.component.css']
})

export class EdittariffComponent implements OnInit {

  @ViewChild(MatAccordion) accordion: MatAccordion;
  rowdata: any;
  filterTerm: string
  count = 0;
  tableSize: any;
  page: number;
  headerdetails: any;
  tariffForm: FormGroup;
  resAlertMessage = "";
  responseMessage: any = "";
  submitted: boolean = false;
  status: boolean = false;
  idtariff: any;
  voiceApiForm: FormGroup;
  headerApi: any;
  voiceApiFields: any;
  iVoiceHeader: any;
  iVoiceFields: any;
  iVoiceForm: any;
  numberPriceForm: FormGroup;
  numberFields: any;
  numberHeader: any;
  depthFields: any;
  depthHeader: any;
  depthForm: FormGroup;
  sipForm: FormGroup;
  sipFields: any;
  sipHeader: any;
  iSipHeader: any;
  iSipFields: any;
  iSipForm: FormGroup;
  sipNumberForm: FormGroup;
  sipNumberFields: any;
  sipNumberHeader: any;
  depthSipForm: FormGroup;
  depthSipHeader: any;
  depthSipFields: any;
  msgActForm: FormGroup;
  msgFields: any;
  msgHeader: any;
  smsHeader: any;
  smsFields: any;
  smsRateForm: FormGroup;
  tariffName: any;
  rateType: Boolean = false;
  tariffs: any;
  errMessage: any;
  day_num_val: string;
  tariffDayNum: number;
  dayUpdate: FormGroup;
  tariffData: any;
  proration: any;
  lookupHeader: any;
  lookupFields: any;
  lookupForm: FormGroup;
  campaignReviewForm: FormGroup;
  campaignReviewFields: any = [];
  campaignReviewHeader: any;
  activateheader: any;
  activateFields: any;
  activatemsgForm: FormGroup;
  numbertariff: any = [];
	isProrationDisabled: { [priority: number]: boolean } = { 3: false, 6: false, 7: false,1: false, 2: false, 4: false,5:false,8:false  };
  constructor(private fb: FormBuilder,
    private tariffService: TariffService, private route: ActivatedRoute) { }

  ngOnInit(): void {


    this.dayUpdate = this.fb.group({
      day_num: new FormControl("", [Validators.required, Validators.maxLength(5)]),
      idtariff: ['', [Validators.required]]
    });

    this.route.paramMap.subscribe((params: ParamMap) => {
      this.idtariff = params.get('id');
      this.tariffService.getTariff(this.idtariff).subscribe(res => {
        this.tariffData = res.data[0];
        this.tariffName = res.data[0].name;
        this.tariffDayNum = res.data[0].day_num;
        this.proration = res.data[0].proration;

        this.dayUpdate.patchValue({
          day_num: this.tariffDayNum,
          idtariff: this.idtariff,
        });

      });

    });


    this.tariffService.get_voiceapi().subscribe(res => {
      this.headerApi = res[0].header;
      this.voiceApiFields = res[0].fields;
      let voiceApiField = [];
      this.voiceApiFields.forEach(element => {
        voiceApiField["priority_" + element.priority] = [element.priority],
          voiceApiField["idtariff_" + element.priority] = [this.idtariff],
          voiceApiField["type_" + element.priority] = ["voice"],
          voiceApiField["subtype_" + element.priority] = ["voice_api"],
          voiceApiField["category_" + element.priority] = [element.categoryValue],
          voiceApiField["mo_" + element.priority] = [0],
          voiceApiField["mt_" + element.priority] = [0]
      });
      this.voiceApiForm = this.fb.group(voiceApiField);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "voice_api" }).subscribe(res => {
        // this.voiceApiFields = res.data;
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["mo_" + element.priority] = [element.mo],
            tmp["mt_" + element.priority] = [element.mt]
        });

        this.voiceApiForm = this.fb.group(tmp);
      });


      this.iVoiceHeader = res[1].header1;
      this.iVoiceFields = res[1].fields1;
      let iVoiceFields1$ = [];
      this.iVoiceFields.forEach(element => {
        iVoiceFields1$["priority_" + element.priority] = [element.priority],
          iVoiceFields1$["idtariff_" + element.priority] = [this.idtariff],
          iVoiceFields1$["type_" + element.priority] = ["voice"],
          iVoiceFields1$["subtype_" + element.priority] = ["inteligent"],
          iVoiceFields1$["category_" + element.priority] = [element.categoryValue],
          iVoiceFields1$["price_" + element.priority] = [0]
      });
      this.iVoiceForm = this.fb.group(iVoiceFields1$);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "inteligent" }).subscribe(res => {
        // this.voiceApiFields = res.data;
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["price_" + element.priority] = [element.rate]
          // tmp["mt_"+element.priority]=[element.mt]
        });

        this.iVoiceForm = this.fb.group(tmp);

      });

      this.numberHeader = res[2].header2;
      this.numberFields = res[2].fields2;
      let numberFields$ = [];
      this.numberFields.forEach(element => {
        numberFields$["priority_" + element.priority] = [element.priority],
          numberFields$["idtariff_" + element.priority] = [this.idtariff],
          numberFields$["type_" + element.priority] = ["voice"],
          numberFields$["subtype_" + element.priority] = ["number"],
          numberFields$["category_" + element.priority] = [element.categoryValue],
          numberFields$["price_" + element.priority] = [0]
      });
      this.numberPriceForm = this.fb.group(numberFields$);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "number" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["price_" + element.priority] = [element.rate]
        });

        this.numberPriceForm = this.fb.group(tmp);
      });

      this.depthHeader = res[3].header3;
      this.depthFields = res[3].fields3;
      let depthFields$ = [];
      this.depthFields.forEach(element => {
        depthFields$["priority_" + element.priority] = [element.priority],
          depthFields$["idtariff_" + element.priority] = [this.idtariff],
          depthFields$["type_" + element.priority] = ["voice"],
          depthFields$["subtype_" + element.priority] = ["depth_voice"],
          depthFields$["category_" + element.priority] = [element.categoryValue],
          depthFields$["mo_" + element.priority] = [0],
          depthFields$["mt_" + element.priority] = [0]
      });
      this.depthForm = this.fb.group(depthFields$);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "voice", subtype: "depth_voice" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["mo_" + element.priority] = [element.mo],
            tmp["mt_" + element.priority] = [element.mt]
        });

        this.depthForm = this.fb.group(tmp);
      });
    });

    this.tariffService.get_elasticSip().subscribe(res => {
      this.sipFields = res[0].fields;
      this.sipHeader = res[0].header;
      let sipFields$ = [];
      this.sipFields.forEach(element => {
        sipFields$["priority_" + element.priority] = [element.priority],
          sipFields$["idtariff_" + element.priority] = [this.idtariff],
          sipFields$["type_" + element.priority] = ["elastic"],
          sipFields$["subtype_" + element.priority] = ["sip_trunking"],
          sipFields$["category_" + element.priority] = [element.categoryValue],
          sipFields$["mo_" + element.priority] = [0],
          sipFields$["mt_" + element.priority] = [0]
      });
      this.sipForm = this.fb.group(sipFields$);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "sip_trunking" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["mo_" + element.priority] = [element.mo],
            tmp["mt_" + element.priority] = [element.mt]
        });

        this.sipForm = this.fb.group(tmp);
      });

      this.iSipFields = res[1].fields1;
      this.iSipHeader = res[1].header1;
      let iSipFields$ = [];
      this.iSipFields.forEach(element => {
        iSipFields$["priority_" + element.priority] = [element.priority],
          iSipFields$["idtariff_" + element.priority] = [this.idtariff],
          iSipFields$["type_" + element.priority] = ["elastic"],
          iSipFields$["subtype_" + element.priority] = ["inteligent"],
          iSipFields$["category_" + element.priority] = [element.categoryValue],
          iSipFields$["price_" + element.priority] = [0]
      });
      this.iSipForm = this.fb.group(iSipFields$);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "inteligent" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["price_" + element.priority] = [element.rate]
        });

        this.iSipForm = this.fb.group(tmp);
      });

      this.sipNumberFields = res[2].fields2;
      this.sipNumberHeader = res[2].header2;
      let sipNumberFields$ = [];
      this.sipNumberFields.forEach(element => {
        sipNumberFields$["priority_" + element.priority] = [element.priority],
          sipNumberFields$["idtariff_" + element.priority] = [this.idtariff],
          sipNumberFields$["type_" + element.priority] = ["elastic"],
          sipNumberFields$["subtype_" + element.priority] = ["number"],
          sipNumberFields$["category_" + element.priority] = [element.categoryValue],
          sipNumberFields$["price_" + element.priority] = [0]
      });
      this.sipNumberForm = this.fb.group(sipNumberFields$);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "number" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["price_" + element.priority] = [element.rate]
        });

        this.sipNumberForm = this.fb.group(tmp);
      });

      this.depthSipFields = res[3].fields3;
      this.depthSipHeader = res[3].header3;
      let depthSipFields$ = [];
      this.depthSipFields.forEach(element => {
        depthSipFields$["priority_" + element.priority] = [element.priority],
          depthSipFields$["idtariff_" + element.priority] = [this.idtariff],
          depthSipFields$["type_" + element.priority] = ["elastic"],
          depthSipFields$["subtype_" + element.priority] = ["depth_voice"],
          depthSipFields$["category_" + element.priority] = [element.categoryValue],
          depthSipFields$["mo_" + element.priority] = [0],
          depthSipFields$["mt_" + element.priority] = [0]
      });
      this.depthSipForm = this.fb.group(depthSipFields$);

      this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "elastic", subtype: "depth_voice" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["mo_" + element.priority] = [element.mo],
            tmp["mt_" + element.priority] = [element.mt]
        });

        this.depthSipForm = this.fb.group(tmp);
      });
    });

    this.tariffService.get_MessagePricing().subscribe(res => {

      this.smsHeader = res[5].header5;
      this.smsFields = res[5].fields5;

      let tmp = [];
      this.smsFields.forEach(element => {
        tmp["priority_" + element.priority] = [element.priority],
          tmp["idtariff_" + element.priority] = [this.idtariff],
          tmp["category_" + element.priority] = [element.categoryValue],
          tmp["categoryValue_" + element.priority] = [element.category],
          tmp["subCategory_" + element.priority] = [element.SubCategory],
          tmp["type_" + element.priority] = ["unregistered"],
          tmp["MO_" + element.priority] = [0],
          tmp["MT_" + element.priority] = [0]
      });
      this.smsRateForm = this.fb.group(tmp);

      this.tariffService.GetSmsRate({ idtariff: this.idtariff, type: "unregistered" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idsmsratenew_" + element.priority] = undefined,
            tmp["idsmsrate_" + element.priority] = [element.idsmsrate],
            tmp["category_" + element.priority] = [element.category],
            tmp["MO_" + element.priority] = [element.MO_rates],
            tmp["MT_" + element.priority] = [element.MT_rates]
        });
        this.smsRateForm = this.fb.group(tmp);
      });

      this.msgHeader = res[1].header1;
      this.msgFields = res[1].fields1;
      let msgFields$ = [];
      this.msgFields.forEach(element => {
        msgFields$["priority_" + element.priority] = [element.priority],
          msgFields$["idtariff_" + element.priority] = [this.idtariff],
          msgFields$["type_" + element.priority] = ["message"],
          msgFields$["subtype_" + element.priority] = ["message_activation"],
          msgFields$["category_" + element.priority] = [element.categoryValue],
          msgFields$["price_" + element.priority] = [0],
          //msgFields$["rateType_"+element.priority] = [this.rateType]
          msgFields$["mo_" + element.priority] = [0],
          msgFields$["mt_" + element.priority] = [0],
          // msgFields$["billingtype_" + element.priority] = [0],
          msgFields$["billingfrequency_" + element.priority] = [0]
        msgFields$["proration_" + element.priority] = [false]

      });
      this.msgActForm = this.fb.group(msgFields$);
    });

    /*FOR ACTIVATION MESSAGE PRICING */
    this.tariffService.get_activateMsg().subscribe(res => {
      this.activateheader = res[0].header;
      this.activateFields = res[0].fields;
      let activateField = [];
      this.activateFields.forEach(element => {
        activateField["priority_" + element.priority] = [element.priority],
          activateField["idtariff_" + element.priority] = [this.idtariff],
          activateField["type_" + element.priority] = ["message_activation"],
          activateField["category_" + element.priority] = [element.categoryValue],
          activateField["mrc_" + element.priority] = [0],
          activateField["nrc_" + element.priority] = [0]
      });
      this.activatemsgForm = this.fb.group(activateField);

      this.tariffService.getactivate_msg({ idtariff: this.idtariff, type: "message_activation" }).subscribe(res => {
        let tmp = [];
        res.data.forEach(element => {
          tmp["idratesnew_" + element.priority] = undefined,
            tmp["idrates_" + element.priority] = [element.idrates],
            tmp["category_" + element.priority] = [element.category],
            tmp["mrc_" + element.priority] = [element.mrc],
            tmp["nrc_" + element.priority] = [element.nrc]
        });
        this.activatemsgForm = this.fb.group(tmp);
      });

    });

    this.tariffService.getUnregisteredRate({ idtariff: this.idtariff, type: "message", subtype: "message_activation" }).subscribe(res => {
      // let tmp=[];	
      // res.data.forEach(element => {
      //     this.rateType = element.rateType;
      //     tmp["idratesnew_"+ element.priority] = undefined,
      //     tmp["idrates_"+ element.priority] = [element.idrates],
      //     tmp["category_"+ element.priority] = [element.category],
      //     tmp["price_"+element.priority] = [element.rate],
      //     //tmp["rateType_"+element.priority]= [element.rateType];
      //     tmp["mo_"+element.priority] = [element.mo],
      //     tmp["mt_"+element.priority] = [element.mt]
      // });
      // this.msgActForm = this.fb.group(tmp);

      let tmp = [];
      res.data.forEach(element => {
        this.rateType = element.rateType;
        tmp["idratesnew_" + element.priority] = undefined,
          tmp["idrates_" + element.priority] = [element.idrates],
          tmp["category_" + element.priority] = [element.category],
          tmp["price_" + element.priority] = [element.rate],
          //tmp["rateType_"+element.priority]= [element.rateType];
          tmp["mo_" + element.priority] = [element.mo],
          tmp["mt_" + element.priority] = [element.mt],
          // tmp["billingtype_" + element.priority] = [element.billing_type],
          tmp["billingfrequency_" + element.priority] = [element.billing_frequency],
          tmp["proration_" + element.priority] = [element.proration];
        // if (element.priority == 3 || element.priority == 6 || element.priority == 7) {
          // if (element.billing_type == '0' && element.billing_frequency == '0') {
          if (element.billing_frequency == '0') {
            this.msgActForm.get('proration_' + element.priority)?.enable();
            this.isProrationDisabled[element.priority] = false;
          } else {
            // this.msgActForm.get('proration_' + element.priority).setValue(false);
            this.msgActForm.get('proration_' + element.priority).disable();
            this.isProrationDisabled[element.priority] = true;
          }
        // }
      });
      if (res.data.length <= 4) {
        tmp["idratesnew_" + 5] = undefined,
          tmp["idrates_" + 5] = undefined,
          tmp["category_" + 5] = ['vanity_number'],
          tmp["price_" + 5] = [0],
          //tmp["rateType_"+element.priority]= [element.rateType];
          tmp["mo_" + 5] = [0],
          tmp["mt_" + 5] = [0]
      }
      this.msgActForm = this.fb.group(tmp);

    });



    /*  For getting days  */


    // this.tariffService.updateTariff(this.tariffForm.value).subscribe(res => {
    //   if(res.status == 201){
    //     $("#exampleModal").hide();
    //     $(".modal-backdrop").remove();
    //     this.responseMessage = res.message;
    //     this.tariffs = res.data;
    //     setTimeout(()=>{
    //       this.responseMessage= "";
    //     }, 5000);
    //     this.ngOnInit();
    //   }
    //   else{
    //       this.errMessage = res.message;
    //       setTimeout(() => {
    //         this.errMessage = "";
    //       }, 5000);
    //   }
    // }, err => {
    //   this.responseMessage = err.message;
    //   setTimeout(()=>{
    //     this.responseMessage= "";
    //   }, 5000);
    // });

    this.tariffService.get_lookuprates().subscribe(res => {
      this.lookupHeader = res[0].header;
      this.lookupFields = res[0].fields;
      let lookuptmp = [];
      this.lookupFields.forEach(element => {
        lookuptmp["priority_" + element.priority] = [element.priority],
          lookuptmp["idtariff_" + element.priority] = [this.idtariff],
          lookuptmp["category_" + element.priority] = [element.category],
          lookuptmp["categoryValue_" + element.priority] = [element.categoryValue],
          lookuptmp["type_" + element.priority] = ["lookup"],
          lookuptmp["price_" + element.priority] = [0]
      });
      this.lookupForm = this.fb.group(lookuptmp);
      // campaign review rates 
      this.campaignReviewHeader = res[1].headers1;
      this.campaignReviewFields = res[1].fields1;
      let campaignReviewtmp = [];
      this.campaignReviewFields.forEach(element => {
        campaignReviewtmp["priority_" + element.priority] = [element.priority],
          campaignReviewtmp["idtariff_" + element.priority] = [this.idtariff],
          campaignReviewtmp["category_" + element.priority] = [element.category],
          campaignReviewtmp["type_" + element.priority] = ["campaign"],
          campaignReviewtmp["mrc_" + element.priority] = [0],
          campaignReviewtmp["price_" + element.priority] = [0]
      });
      this.campaignReviewForm = this.fb.group(campaignReviewtmp);

    });

    this.tariffService.lookupRates({ idtariff: this.idtariff, type: "lookup" }).subscribe(res => {
      let tmp = [];
      res.data.forEach(element => {
        tmp["idrates_" + element.priority] = [element.idrates],
          tmp["category_" + element.priority] = [element.category],
          tmp["price_" + element.priority] = [element.rate]
      });
      this.lookupForm = this.fb.group(tmp);
    });

    this.tariffService.campaignReviewRates({ idtariff: this.idtariff, type: "campaign" }).subscribe(res => {
      let tmp = [];
      res.data.forEach(element => {
        tmp["idrates_" + element.priority] = [element.campaign_rate_id],
          tmp["category_" + element.priority] = [element.category],
          tmp["mrc_" + element.priority] = [element.mrc],
          tmp["price_" + element.priority] = [element.rate]
      });
      this.campaignReviewForm = this.fb.group(tmp);
    });


  }


  onRateTypes(e) {
    this.rateType = e.target.checked;
  }
  updateDays(value: any) {
    if (value.length > 5) {
      this.responseMessage = '';
      this.resAlertMessage = "Day Num cannot exceed More than 5 digits!";
      setTimeout(() => {
        this.resAlertMessage = "";
      }, 3000);
      return false;
    } else {
      this.tariffService.updateTariffDay({ day_num: value, idtariff: this.idtariff }).subscribe(response => {
        if (response.status == 201) {
          this.responseMessage = response.message;
          this.resAlertMessage = '';
          setTimeout(() => {
            this.responseMessage = "";
          }, 3000);
          this.dayUpdate.patchValue({
            day_num: value
          });
          //this.ngOnInit();
        }
        else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = "";
          }, 5000);
        }
      }, err => {
        this.errMessage = err.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      });
    }
  }
  onProRate(e: MatSlideToggleChange) {
    let proration: any;
    if (e.checked) {
      proration = 'true';
    }
    else {
      proration = 'false';
    }
    this.tariffService.updateProRate({ proration: proration, idtariff: this.idtariff }).subscribe(response => {
      if (response.status == 201) {
        this.responseMessage = response.message;
        setTimeout(() => {
          this.responseMessage = "";
        }, 5000);
        //this.ngOnInit();
      }
      else {
        this.errMessage = response.message;
        setTimeout(() => {
          this.errMessage = "";
        }, 5000);
      }
    }, err => {
      this.errMessage = err.message;
      setTimeout(() => {
        this.errMessage = "";
      }, 5000);
    });

  }

  prorateChange(e: MatSlideToggleChange, categoryValue: any, priority: any) {
    // let prorationValue: string = e.checked ? 'true' : 'false';
    this.msgActForm.get('proration_' + priority).setValue(e.checked); 
    if (e.checked || (!e.checked && this.msgActForm.get('proration_' + priority).value !== 'false')) {
      // this.updateProrate(prorationValue, categoryValue);
    }
  }
  
 /*  updateProrate(proration: string, categoryValue: any) {
    this.tariffService.updateProration({ proration, idtariff: this.idtariff, category: categoryValue }).subscribe(
      response => {
        if (response.status == 201) {
          this.responseMessage = 'Rates Updated Successfully!';
          setTimeout(() => {
            this.responseMessage = '';
          }, 5000);
        } else {
          this.errMessage = response.message;
          setTimeout(() => {
            this.errMessage = '';
          }, 5000);
        }
      },
      error => {
        this.errMessage = 'Error updating proration.';
        setTimeout(() => {
          this.errMessage = '';
        }, 5000);
      }
    );
  } */

 /*  onBillingTypeChange(event: any, priority: any, categoryValue: any) {
    const selectedValue = event.target.value;
    // if (priority == 3 || priority == 6 || priority == 7) {
      let billing_frequency: any = this.msgActForm.get('billingfrequency_' + priority).value;
  
      if (selectedValue == '0' && billing_frequency == '0') {
        this.msgActForm.get('proration_' + priority)?.enable();
        this.isProrationDisabled[priority] = false;
        this.msgActivationRates();
      } else {
        this.msgActForm.get('proration_' + priority).setValue(false);
        this.msgActForm.get('proration_' + priority).disable();
        this.isProrationDisabled[priority] = true;
        this.updateProrate('false', categoryValue);
        this.msgActivationRates();
      }
    // }
  } */
  
  onBillingFrequencyChange(event: any, priority: any, categoryValue: any) {
    const selectedValue = event.target.value;
    // if (priority == 3 || priority == 6 || priority == 7) {
      // let billing_type: any = this.msgActForm.get('billingtype_' + priority).value;
  
      if (selectedValue == '0') {
        this.msgActForm.get('proration_' + priority)?.enable();
        this.isProrationDisabled[priority] = false;
        // this.msgActivationRates();
      } else {
        this.msgActForm.get('proration_' + priority)?.setValue(false);
        this.msgActForm.get('proration_' + priority)?.disable();
        this.isProrationDisabled[priority] = true;
        // this.updateProrate('false', categoryValue);
        // this.msgActivationRates();
      }
    // }
  }

  onVoiceApi() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];

    for (let key of Object.keys(this.voiceApiForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.voiceApiForm.value[key] });
    }
    let temp = response.slice(1, 6);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }


  onlookup() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    for (let key of Object.keys(this.lookupForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.lookupForm.value[key] });
    }
    let temp = response.slice(1, 6);
    this.tariffService.updatelookupRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  oncampaignReviewForm() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    for (let key of Object.keys(this.campaignReviewForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.campaignReviewForm.value[key] });
    }
    let temp = response.slice(1, 3);
    console.log("this.campaignReviewForm=>", this.campaignReviewForm);

    console.log("temptemp review-=>", temp);
    this.tariffService.updateCampaignReviewRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }
  oniVoice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];

    for (let key of Object.keys(this.iVoiceForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.iVoiceForm.value[key] });
    }
    let temp = response.slice(1, 6);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }
  // oniVoice() {
  //   let response: any = [];
  // 	response[0]=[];
  // 	response[1]=[];
  // 	response[2]=[];
  // 	response[3]=[];
  //   response[4]=[];

  // 	for(let key of Object.keys(this.iVoiceForm.value)){
  // 	  let tmp=key.split('_');
  // 	  response[tmp[1]].push({field: tmp[0], value: this.iVoiceForm.value[key]});
  // 	}
  // 		let temp = response.slice(1, 4);
  //     console.log('oniVoice',temp);
  // 		this.tariffService.updateVoiceRate(temp).subscribe(resp => {
  // 		      this.responseMessage = resp.message;  
  //             setTimeout(()=>{
  //               this.responseMessage= "";
  //             }, 5000);
  // 		}, err => {
  //           this.responseMessage = err.message;
  //           setTimeout(()=>{
  //             this.responseMessage= "";
  //           }, 5000);
  //     });
  // }

  onNumberPrice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];

    for (let key of Object.keys(this.numberPriceForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.numberPriceForm.value[key] });
    }
    let temp = response.slice(1, 3);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onDepthRate() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];
    response[8] = [];

    for (let key of Object.keys(this.depthForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.depthForm.value[key] });
    }
    let temp = response.slice(1, 8);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onSipPrice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];

    for (let key of Object.keys(this.sipForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.sipForm.value[key] });
    }
    let temp = response.slice(1, 3);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  oniSipPrice() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];

    for (let key of Object.keys(this.iSipForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.iSipForm.value[key] });
    }
    let temp = response.slice(1, 7);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onSipNumber() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];

    for (let key of Object.keys(this.sipNumberForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.sipNumberForm.value[key] });
    }
    let temp = response.slice(1, 3);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onDepthSipRate() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];
    response[8] = [];

    for (let key of Object.keys(this.depthSipForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.depthSipForm.value[key] });
    }
    let temp = response.slice(1, 8);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  onSmsRates() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];
    response[8] = [];
    response[9] = [];

    for (let key of Object.keys(this.smsRateForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.smsRateForm.value[key] });
    }
    let temp = response.slice(1, 9);
    this.tariffService.updateSMSRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }


  msgActivationRates() {
    const formValues = this.msgActForm.getRawValue(); 
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    response[5] = [];
    response[6] = [];
    response[7] = [];
    response[8] = [];
    response[9] = [];

    for (let key of Object.keys(formValues)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: formValues[key] });
    }
    let temp = response.slice(1, 9);
    this.tariffService.updateVoiceRate(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }

  /*Activate Message Pricing*/
  activatemessage() {
    let response: any = [];
    response[0] = [];
    response[1] = [];
    response[2] = [];
    response[3] = [];
    response[4] = [];
    ;
    for (let key of Object.keys(this.activatemsgForm.value)) {
      let tmp = key.split('_');
      response[tmp[1]].push({ field: tmp[0], value: this.activatemsgForm.value[key] });
      console.log(this.activatemsgForm.value[key])
    }
    let temp = response.slice(1, 4);
    this.tariffService.updateactivatemessage(temp).subscribe(resp => {
      this.responseMessage = resp.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    }, err => {
      this.responseMessage = err.message;
      setTimeout(() => {
        this.responseMessage = "";
      }, 5000);
    });
  }


  resetMsgActForm() {
    for (let i of this.msgFields) {
      this.msgActForm.get('price_' + i.priority).setValue('');
      this.msgActForm.get('mo_' + i.priority).setValue('');
      this.msgActForm.get('mt_' + i.priority).setValue('');
      this.msgActForm.get('billingfrequency_' + i.priority).setValue('0');
      this.msgActForm.get('proration_' + i.priority).setValue('false');
      this.msgActForm.get('proration_' + i.priority)?.enable();
      this.isProrationDisabled[i.priority] = false;
    }
  }

  resetSmsRates() {
    for (let data of this.smsFields) {
      this.smsRateForm.get('MO_' + data.priority).setValue('');
      this.smsRateForm.get('MT_' + data.priority).setValue('');
    }
  }

  resetVoiceApi() {
    for (let data of this.voiceApiFields) {
      this.voiceApiForm.get('mo_' + data.priority).setValue('');
      this.voiceApiForm.get('mt_' + data.priority).setValue('');
    }
  }

  resetiVoiceForm() {
    for (let data of this.iVoiceFields) {
      this.iVoiceForm.get('price_' + data.priority).setValue('');
    }
  }

  resetdepthForm() {
    for (let data of this.depthFields) {
      this.depthForm.get('mo_' + data.priority).setValue('');
      this.depthForm.get('mt_' + data.priority).setValue('');
    }
  }

  resetiSipForm() {
    for (let data of this.iSipFields) {
      this.iSipForm.get('price_' + data.priority).setValue('');
    }
  }
  resetlookupForm() {
    for (let data of this.lookupFields) {
      this.lookupForm.get('price_' + data.priority).setValue('');
    }
  }
  resetCampReviewForm() {
    for (let data of this.campaignReviewFields) {
      this.campaignReviewForm.get('price_' + data.priority).setValue('');
      this.campaignReviewForm.get('mrc_' + data.priority).setValue('');
    }
  }

  resetdepthSipForm() {
    for (let data of this.depthSipFields) {
      this.depthSipForm.get('mo_' + data.priority).setValue('');
      this.depthSipForm.get('mt_' + data.priority).setValue('');
    }
  }

  // activation message 
  resetactivatemsgForm() {
    for (let data of this.activateFields) {
      this.activatemsgForm.get('mrc_' + data.priority).setValue('');
      this.activatemsgForm.get('nrc_' + data.priority).setValue('');
    }
  }
}
